/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.shape;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.math.Rectangle;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import com.jme3.util.clone.Cloner;
import java.io.IOException;

public class RectangleMesh
extends Mesh {
    private Rectangle rectangle;
    private Vector2f[] texCoords;
    private Vector3f normal;
    private boolean flipped;

    public RectangleMesh() {
        this(new Rectangle(new Vector3f(), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f)));
    }

    public RectangleMesh(Rectangle rectangle) {
        this.rectangle = rectangle;
        this.texCoords = new Vector2f[]{new Vector2f(0.0f, 0.0f), new Vector2f(1.0f, 0.0f), new Vector2f(1.0f, 1.0f), new Vector2f(0.0f, 1.0f)};
        this.flipped = false;
        this.updateMesh();
    }

    public RectangleMesh(Vector3f a, Vector3f b, Vector3f c) {
        this(new Rectangle(a, b, c));
    }

    public Rectangle getRectangle() {
        return this.rectangle;
    }

    public void setRectangle(Rectangle rectangle) {
        this.rectangle = rectangle;
        this.updateMesh();
    }

    public Vector2f[] getTexCoords() {
        return this.texCoords;
    }

    public void setTexCoords(Vector2f[] texCoords) throws IllegalArgumentException {
        if (texCoords.length != 4) {
            throw new IllegalArgumentException("Texture coordinates are 4 vertices, therefore a Vector2f array of length 4 must be provided.");
        }
        this.texCoords = texCoords;
        this.updateMesh();
    }

    public Vector3f getNormal() {
        return this.normal;
    }

    public void flip() {
        this.normal.negateLocal();
        this.flipped = !this.flipped;
        this.updateMesh();
    }

    protected void updateMesh() {
        Vector3f a = this.rectangle.getA();
        Vector3f b = this.rectangle.getB();
        Vector3f c = this.rectangle.getC();
        Vector3f d = this.rectangle.calculateD();
        this.setBuffer(VertexBuffer.Type.Position, 3, new float[]{a.x, a.y, a.z, b.x, b.y, b.z, d.x, d.y, d.z, c.x, c.y, c.z});
        this.setBuffer(VertexBuffer.Type.TexCoord, 2, BufferUtils.createFloatBuffer(this.texCoords));
        if (this.normal == null) {
            this.normal = this.rectangle.calculateNormal(null);
        }
        this.setBuffer(VertexBuffer.Type.Normal, 3, BufferUtils.createFloatBuffer(this.normal, this.normal, this.normal, this.normal));
        if (this.flipped) {
            this.setBuffer(VertexBuffer.Type.Index, 3, new short[]{1, 0, 3, 3, 2, 1});
        } else {
            this.setBuffer(VertexBuffer.Type.Index, 3, new short[]{3, 0, 1, 1, 2, 3});
        }
        this.updateBound();
        this.setStatic();
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.rectangle = cloner.clone(this.rectangle);
        this.texCoords = cloner.clone(this.texCoords);
        this.normal = cloner.clone(this.normal);
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule(this);
        this.rectangle = (Rectangle)capsule.readSavable("rectangle", new Rectangle(new Vector3f(), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f)));
        this.texCoords = (Vector2f[])capsule.readSavableArray("texCoords", new Vector2f[]{new Vector2f(0.0f, 0.0f), new Vector2f(1.0f, 0.0f), new Vector2f(1.0f, 1.0f), new Vector2f(0.0f, 1.0f)});
        this.normal = (Vector3f)capsule.readSavable("normal", null);
        this.flipped = capsule.readBoolean("flipped", false);
    }

    @Override
    public void write(JmeExporter e) throws IOException {
        super.write(e);
        OutputCapsule capsule = e.getCapsule(this);
        capsule.write(this.rectangle, "rectangle", new Rectangle(new Vector3f(), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f)));
        capsule.write(this.texCoords, "texCoords", new Vector2f[]{new Vector2f(0.0f, 0.0f), new Vector2f(1.0f, 0.0f), new Vector2f(1.0f, 1.0f), new Vector2f(0.0f, 1.0f)});
        capsule.write(this.normal, "normal", null);
        capsule.write(this.flipped, "flipped", false);
    }
}

