/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.debug.custom;

import com.jme3.anim.Armature;
import com.jme3.anim.Joint;
import com.jme3.asset.AssetManager;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResults;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.renderer.Camera;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.debug.custom.ArmatureInterJointsWire;
import com.jme3.scene.debug.custom.ArmatureNode;
import com.jme3.texture.Texture;
import java.util.List;

public class ArmatureDebugger
extends Node {
    private ArmatureNode armatureNode;
    private Armature armature;
    private Node joints;
    private Node outlines;
    private Node wires;
    private ArmatureInterJointsWire interJointWires;

    public ArmatureDebugger() {
    }

    public ArmatureDebugger(String name, Armature armature, List<Joint> deformingJoints) {
        super(name);
        this.armature = armature;
        armature.update();
        this.joints = new Node("joints");
        this.outlines = new Node("outlines");
        this.wires = new Node("bones");
        this.attachChild(this.joints);
        this.attachChild(this.outlines);
        this.attachChild(this.wires);
        Node ndJoints = new Node("non deforming Joints");
        Node ndOutlines = new Node("non deforming Joints outlines");
        Node ndWires = new Node("non deforming Joints wires");
        this.joints.attachChild(ndJoints);
        this.outlines.attachChild(ndOutlines);
        this.wires.attachChild(ndWires);
        Node outlineDashed = new Node("Outlines Dashed");
        Node wiresDashed = new Node("Wires Dashed");
        wiresDashed.attachChild(new Node("dashed non defrom"));
        outlineDashed.attachChild(new Node("dashed non defrom"));
        this.outlines.attachChild(outlineDashed);
        this.wires.attachChild(wiresDashed);
        this.armatureNode = new ArmatureNode(armature, this.joints, this.wires, this.outlines, deformingJoints);
        this.attachChild(this.armatureNode);
        this.displayNonDeformingJoint(false);
    }

    public void displayNonDeformingJoint(boolean display) {
        this.joints.getChild(0).setCullHint(display ? Spatial.CullHint.Dynamic : Spatial.CullHint.Always);
        this.outlines.getChild(0).setCullHint(display ? Spatial.CullHint.Dynamic : Spatial.CullHint.Always);
        this.wires.getChild(0).setCullHint(display ? Spatial.CullHint.Dynamic : Spatial.CullHint.Always);
        ((Node)this.outlines.getChild(1)).getChild(0).setCullHint(display ? Spatial.CullHint.Dynamic : Spatial.CullHint.Always);
        ((Node)this.wires.getChild(1)).getChild(0).setCullHint(display ? Spatial.CullHint.Dynamic : Spatial.CullHint.Always);
    }

    public void initialize(AssetManager assetManager, Camera camera) {
        this.armatureNode.setCamera(camera);
        Material matJoints = new Material(assetManager, "Common/MatDefs/Misc/Billboard.j3md");
        Texture t = assetManager.loadTexture("Common/Textures/dot.png");
        matJoints.setTexture("Texture", t);
        matJoints.getAdditionalRenderState().setDepthTest(false);
        matJoints.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        this.joints.setQueueBucket(RenderQueue.Bucket.Translucent);
        this.joints.setMaterial(matJoints);
        Material matWires = new Material(assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        matWires.setBoolean("VertexColor", true);
        matWires.getAdditionalRenderState().setLineWidth(1.0f);
        this.wires.setMaterial(matWires);
        Material matOutline = new Material(assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        matOutline.setBoolean("VertexColor", true);
        matOutline.getAdditionalRenderState().setLineWidth(1.0f);
        this.outlines.setMaterial(matOutline);
        Material matOutline2 = new Material(assetManager, "Common/MatDefs/Misc/DashedLine.j3md");
        matOutline2.getAdditionalRenderState().setLineWidth(1.0f);
        this.outlines.getChild(1).setMaterial(matOutline2);
        Material matWires2 = new Material(assetManager, "Common/MatDefs/Misc/DashedLine.j3md");
        matWires2.getAdditionalRenderState().setLineWidth(1.0f);
        this.wires.getChild(1).setMaterial(matWires2);
    }

    public Armature getArmature() {
        return this.armature;
    }

    @Override
    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        this.armatureNode.updateGeometry();
    }

    @Override
    public int collideWith(Collidable other, CollisionResults results) {
        return this.armatureNode.collideWith(other, results);
    }

    protected Joint select(Geometry g) {
        return this.armatureNode.select(g);
    }

    public ArmatureNode getBoneShapes() {
        return this.armatureNode;
    }

    public ArmatureInterJointsWire getInterJointWires() {
        return this.interJointWires;
    }
}

