/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class UserData
implements Savable {
    public static final String JME_PHYSICSIGNORE = "JmePhysicsIgnore";
    public static final String JME_SHAREDMESH = "JmeSharedMesh";
    private static final int TYPE_INTEGER = 0;
    private static final int TYPE_FLOAT = 1;
    private static final int TYPE_BOOLEAN = 2;
    private static final int TYPE_STRING = 3;
    private static final int TYPE_LONG = 4;
    private static final int TYPE_SAVABLE = 5;
    private static final int TYPE_LIST = 6;
    private static final int TYPE_MAP = 7;
    private static final int TYPE_ARRAY = 8;
    private static final int TYPE_DOUBLE = 9;
    private static final int TYPE_SHORT = 10;
    private static final int TYPE_BYTE = 11;
    protected byte type;
    protected Object value;

    public UserData() {
    }

    public UserData(byte type, Object value) {
        assert (type >= 0 && type <= 11);
        this.type = type;
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return this.value.toString();
    }

    public static byte getObjectType(Object type) {
        if (type instanceof Integer) {
            return 0;
        }
        if (type instanceof Float) {
            return 1;
        }
        if (type instanceof Boolean) {
            return 2;
        }
        if (type instanceof String) {
            return 3;
        }
        if (type instanceof Long) {
            return 4;
        }
        if (type instanceof Savable) {
            return 5;
        }
        if (type instanceof List) {
            return 6;
        }
        if (type instanceof Map) {
            return 7;
        }
        if (type instanceof Object[]) {
            return 8;
        }
        if (type instanceof Double) {
            return 9;
        }
        if (type instanceof Short) {
            return 10;
        }
        if (type instanceof Byte) {
            return 11;
        }
        throw new IllegalArgumentException("Unsupported type: " + type.getClass().getName());
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.type, "type", (byte)0);
        switch (this.type) {
            case 0: {
                int i = (Integer)this.value;
                oc.write(i, "intVal", 0);
                break;
            }
            case 1: {
                float f = ((Float)this.value).floatValue();
                oc.write(f, "floatVal", 0.0f);
                break;
            }
            case 2: {
                boolean b = (Boolean)this.value;
                oc.write(b, "boolVal", false);
                break;
            }
            case 3: {
                String s = (String)this.value;
                oc.write(s, "strVal", null);
                break;
            }
            case 4: {
                Long l = (Long)this.value;
                oc.write(l, "longVal", 0L);
                break;
            }
            case 5: {
                Savable sav = (Savable)this.value;
                oc.write(sav, "savableVal", null);
                break;
            }
            case 6: {
                this.writeList(oc, (List)this.value, "0");
                break;
            }
            case 7: {
                Map map = (Map)this.value;
                this.writeList(oc, map.keySet(), "0");
                this.writeList(oc, map.values(), "1");
                break;
            }
            case 8: {
                this.writeList(oc, Arrays.asList((Object[])this.value), "0");
                break;
            }
            case 9: {
                Double d = (Double)this.value;
                oc.write(d, "doubleVal", 0.0);
                break;
            }
            case 10: {
                Short sh = (Short)this.value;
                oc.write(sh, "shortVal", (short)0);
                break;
            }
            case 11: {
                Byte bh = (Byte)this.value;
                oc.write(bh, "byteVal", (byte)0);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported value type: " + this.value.getClass());
            }
        }
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.type = ic.readByte("type", (byte)0);
        switch (this.type) {
            case 0: {
                this.value = ic.readInt("intVal", 0);
                break;
            }
            case 1: {
                this.value = Float.valueOf(ic.readFloat("floatVal", 0.0f));
                break;
            }
            case 2: {
                this.value = ic.readBoolean("boolVal", false);
                break;
            }
            case 3: {
                this.value = ic.readString("strVal", null);
                break;
            }
            case 4: {
                this.value = ic.readLong("longVal", 0L);
                break;
            }
            case 5: {
                this.value = ic.readSavable("savableVal", null);
                break;
            }
            case 6: {
                this.value = this.readList(ic, "0");
                break;
            }
            case 7: {
                HashMap map = new HashMap();
                List<?> keys = this.readList(ic, "0");
                List<?> values = this.readList(ic, "1");
                for (int i = 0; i < keys.size(); ++i) {
                    map.put(keys.get(i), values.get(i));
                }
                this.value = map;
                break;
            }
            case 8: {
                this.value = this.readList(ic, "0").toArray();
                break;
            }
            case 9: {
                this.value = ic.readDouble("doubleVal", 0.0);
                break;
            }
            case 10: {
                this.value = ic.readShort("shortVal", (short)0);
                break;
            }
            case 11: {
                this.value = ic.readByte("byteVal", (byte)0);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown type of stored data: " + this.type);
            }
        }
    }

    private void writeList(OutputCapsule oc, Collection<?> list, String listName) throws IOException {
        if (list != null) {
            oc.write(list.size(), listName + "size", 0);
            int counter = 0;
            for (Object o : list) {
                if (o instanceof Integer) {
                    oc.write(0, listName + "t" + counter, 0);
                    oc.write((Integer)o, listName + "v" + counter, 0);
                } else if (o instanceof Float) {
                    oc.write(1, listName + "t" + counter, 0);
                    oc.write(((Float)o).floatValue(), listName + "v" + counter, 0.0f);
                } else if (o instanceof Boolean) {
                    oc.write(2, listName + "t" + counter, 0);
                    oc.write((Boolean)o, listName + "v" + counter, false);
                } else if (o instanceof String || o == null) {
                    oc.write(3, listName + "t" + counter, 0);
                    oc.write((String)o, listName + "v" + counter, null);
                } else if (o instanceof Long) {
                    oc.write(4, listName + "t" + counter, 0);
                    oc.write((Long)o, listName + "v" + counter, 0L);
                } else if (o instanceof Savable) {
                    oc.write(5, listName + "t" + counter, 0);
                    oc.write((Savable)o, listName + "v" + counter, null);
                } else if (o instanceof Object[]) {
                    oc.write(8, listName + "t" + counter, 0);
                    this.writeList(oc, Arrays.asList((Object[])o), listName + "v" + counter);
                } else if (o instanceof List) {
                    oc.write(6, listName + "t" + counter, 0);
                    this.writeList(oc, (List)o, listName + "v" + counter);
                } else if (o instanceof Map) {
                    oc.write(7, listName + "t" + counter, 0);
                    Map map = (Map)o;
                    this.writeList(oc, map.keySet(), listName + "v(keys)" + counter);
                    this.writeList(oc, map.values(), listName + "v(vals)" + counter);
                } else if (o instanceof Double) {
                    oc.write(9, listName + "t" + counter, 0);
                    oc.write((Double)o, listName + "v" + counter, 0.0);
                } else if (o instanceof Short) {
                    oc.write(10, listName + "t" + counter, 0);
                    oc.write((Short)o, listName + "v" + counter, (short)0);
                } else if (o instanceof Byte) {
                    oc.write(11, listName + "t" + counter, 0);
                    oc.write((Byte)o, listName + "v" + counter, (byte)0);
                } else {
                    throw new UnsupportedOperationException("Unsupported type stored in the list: " + o.getClass());
                }
                ++counter;
            }
        } else {
            oc.write(0, "size", 0);
        }
    }

    private List<?> readList(InputCapsule ic, String listName) throws IOException {
        int size = ic.readInt(listName + "size", 0);
        ArrayList<Object> list = new ArrayList<Object>(size);
        block11: for (int i = 0; i < size; ++i) {
            int type = ic.readInt(listName + "t" + i, 0);
            switch (type) {
                case 0: {
                    list.add(ic.readInt(listName + "v" + i, 0));
                    continue block11;
                }
                case 1: {
                    list.add(Float.valueOf(ic.readFloat(listName + "v" + i, 0.0f)));
                    continue block11;
                }
                case 2: {
                    list.add(ic.readBoolean(listName + "v" + i, false));
                    continue block11;
                }
                case 3: {
                    list.add(ic.readString(listName + "v" + i, null));
                    continue block11;
                }
                case 4: {
                    list.add(ic.readLong(listName + "v" + i, 0L));
                    continue block11;
                }
                case 5: {
                    list.add(ic.readSavable(listName + "v" + i, null));
                    continue block11;
                }
                case 8: {
                    list.add(this.readList(ic, listName + "v" + i).toArray());
                    continue block11;
                }
                case 6: {
                    list.add(this.readList(ic, listName + "v" + i));
                    continue block11;
                }
                case 7: {
                    HashMap map = new HashMap();
                    List<?> keys = this.readList(ic, listName + "v(keys)" + i);
                    List<?> values = this.readList(ic, listName + "v(vals)" + i);
                    for (int j = 0; j < keys.size(); ++j) {
                        map.put(keys.get(j), values.get(j));
                    }
                    list.add(map);
                    continue block11;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown type of stored data in a list: " + type);
                }
            }
        }
        return list;
    }
}

