/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.renderer.pipeline;

import com.jme3.post.SceneProcessor;
import com.jme3.profile.AppProfiler;
import com.jme3.profile.SpStep;
import com.jme3.profile.VpStep;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.pipeline.PipelineContext;
import com.jme3.renderer.pipeline.RenderPipeline;
import com.jme3.scene.Spatial;
import com.jme3.util.SafeArrayList;

public class ForwardPipeline
implements RenderPipeline {
    private boolean rendered = false;

    public PipelineContext fetchPipelineContext(RenderManager rm) {
        return rm.getDefaultContext();
    }

    @Override
    public boolean hasRenderedThisFrame() {
        return this.rendered;
    }

    @Override
    public void startRenderFrame(RenderManager rm) {
    }

    public void pipelineRender(RenderManager rm, PipelineContext context, ViewPort vp, float tpf) {
        AppProfiler prof = rm.getProfiler();
        SafeArrayList<SceneProcessor> processors = vp.getProcessors();
        if (processors.isEmpty()) {
            processors = null;
        }
        if (processors != null) {
            if (prof != null) {
                prof.vpStep(VpStep.PreFrame, vp, null);
            }
            for (SceneProcessor p : processors.getArray()) {
                if (!p.isInitialized()) {
                    p.initialize(rm, vp);
                }
                p.setProfiler(prof);
                if (prof != null) {
                    prof.spStep(SpStep.ProcPreFrame, p.getClass().getSimpleName());
                }
                p.preFrame(tpf);
            }
        }
        rm.applyViewPort(vp);
        if (prof != null) {
            prof.vpStep(VpStep.RenderScene, vp, null);
        }
        SafeArrayList<Spatial> scenes = vp.getScenes();
        for (int i = scenes.size() - 1; i >= 0; --i) {
            rm.renderScene((Spatial)scenes.get(i), vp);
        }
        if (processors != null) {
            if (prof != null) {
                prof.vpStep(VpStep.PostQueue, vp, null);
            }
            for (SceneProcessor p : processors.getArray()) {
                if (prof != null) {
                    prof.spStep(SpStep.ProcPostQueue, p.getClass().getSimpleName());
                }
                p.postQueue(vp.getQueue());
            }
        }
        if (prof != null) {
            prof.vpStep(VpStep.FlushQueue, vp, null);
        }
        rm.flushQueue(vp);
        if (processors != null) {
            if (prof != null) {
                prof.vpStep(VpStep.PostFrame, vp, null);
            }
            for (SceneProcessor proc : processors.getArray()) {
                if (prof != null) {
                    prof.spStep(SpStep.ProcPostFrame, proc.getClass().getSimpleName());
                }
                proc.postFrame(vp.getOutputFrameBuffer());
            }
            if (prof != null) {
                prof.vpStep(VpStep.ProcEndRender, vp, null);
            }
        }
        rm.renderTranslucentQueue(vp);
        rm.clearQueue(vp);
        this.rendered = true;
        rm.getRenderer().clearClipRect();
        if (prof != null) {
            prof.vpStep(VpStep.EndRender, vp, null);
        }
    }

    @Override
    public void endRenderFrame(RenderManager rm) {
        this.rendered = false;
    }
}

