/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.math;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import java.io.IOException;
import java.io.Serializable;

public final class Rectangle
implements Savable,
Cloneable,
Serializable {
    static final long serialVersionUID = 1L;
    private Vector3f a;
    private Vector3f b;
    private Vector3f c;

    public Rectangle() {
        this.a = new Vector3f();
        this.b = new Vector3f();
        this.c = new Vector3f();
    }

    public Rectangle(Vector3f a, Vector3f b, Vector3f c) {
        this.a = a;
        this.b = b;
        this.c = c;
    }

    public Vector3f getA() {
        return this.a;
    }

    public void setA(Vector3f a) {
        this.a = a;
    }

    public Vector3f getB() {
        return this.b;
    }

    public void setB(Vector3f b) {
        this.b = b;
    }

    public Vector3f getC() {
        return this.c;
    }

    public void setC(Vector3f c) {
        this.c = c;
    }

    public Vector3f calculateD() {
        float x = this.b.x + this.c.x - this.a.x;
        float y = this.b.y + this.c.y - this.a.y;
        float z = this.b.z + this.c.z - this.a.z;
        return new Vector3f(x, y, z);
    }

    public Vector3f calculateNormal(Vector3f normal) {
        if (normal == null) {
            normal = new Vector3f();
        }
        Vector3f v1 = this.c.subtract(this.b);
        Vector3f v2 = this.a.subtract(this.b);
        normal.set(v1.crossLocal(v2).normalizeLocal());
        return normal;
    }

    public Vector3f random() {
        return this.random(null);
    }

    public Vector3f random(Vector3f result) {
        if (result == null) {
            result = new Vector3f();
        }
        float s = FastMath.nextRandomFloat();
        float t = FastMath.nextRandomFloat();
        float aMod = 1.0f - s - t;
        result.set(this.a.mult(aMod).addLocal(this.b.mult(s).addLocal(this.c.mult(t))));
        return result;
    }

    @Override
    public void write(JmeExporter e) throws IOException {
        OutputCapsule capsule = e.getCapsule(this);
        capsule.write(this.a, "a", Vector3f.ZERO);
        capsule.write(this.b, "b", Vector3f.ZERO);
        capsule.write(this.c, "c", Vector3f.ZERO);
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        InputCapsule capsule = importer.getCapsule(this);
        this.a = (Vector3f)capsule.readSavable("a", Vector3f.ZERO.clone());
        this.b = (Vector3f)capsule.readSavable("b", Vector3f.ZERO.clone());
        this.c = (Vector3f)capsule.readSavable("c", Vector3f.ZERO.clone());
    }

    public Rectangle clone() {
        try {
            Rectangle r = (Rectangle)super.clone();
            r.a = this.a.clone();
            r.b = this.b.clone();
            r.c = this.c.clone();
            return r;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [A: " + this.a + "  B: " + this.b + "  C: " + this.c + "]";
    }
}

