/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.material;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.material.MatParam;
import com.jme3.shader.VarType;
import com.jme3.texture.Texture;
import com.jme3.texture.image.ColorSpace;
import java.io.IOException;

public class MatParamTexture
extends MatParam {
    private ColorSpace colorSpace;

    public MatParamTexture(VarType type, String name, Texture texture, ColorSpace colorSpace) {
        super(type, name, texture);
        this.colorSpace = colorSpace;
    }

    public MatParamTexture() {
    }

    public Texture getTextureValue() {
        return (Texture)this.getValue();
    }

    public void setTextureValue(Texture value) {
        this.setValue(value);
    }

    public ColorSpace getColorSpace() {
        return this.colorSpace;
    }

    public void setColorSpace(ColorSpace colorSpace) {
        this.colorSpace = colorSpace;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.colorSpace, "colorSpace", null);
        oc.write(0, "texture_unit", -1);
        oc.write((Texture)this.value, "texture", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.colorSpace = ic.readEnum("colorSpace", ColorSpace.class, null);
    }
}

