/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.environment.baker;

import com.jme3.asset.AssetManager;
import com.jme3.environment.baker.EnvBaker;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Geometry;
import com.jme3.scene.Spatial;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.TextureCubeMap;
import com.jme3.texture.image.ColorSpace;
import com.jme3.util.BufferUtils;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class GenericEnvBaker
implements EnvBaker {
    private static final Logger LOG = Logger.getLogger(GenericEnvBaker.class.getName());
    protected static Vector3f[] axisX = new Vector3f[6];
    protected static Vector3f[] axisY = new Vector3f[6];
    protected static Vector3f[] axisZ = new Vector3f[6];
    protected TextureCubeMap envMap;
    protected Image.Format depthFormat;
    protected final RenderManager renderManager;
    protected final AssetManager assetManager;
    protected final Camera cam;
    protected boolean texturePulling = false;
    protected List<ByteArrayOutputStream> bos = new ArrayList<ByteArrayOutputStream>();

    protected GenericEnvBaker(RenderManager rm, AssetManager am, Image.Format colorFormat, Image.Format depthFormat, int env_size) {
        this.depthFormat = depthFormat;
        this.renderManager = rm;
        this.assetManager = am;
        this.cam = new Camera(128, 128);
        this.envMap = new TextureCubeMap(env_size, env_size, colorFormat);
        this.envMap.setMagFilter(Texture.MagFilter.Bilinear);
        this.envMap.setMinFilter(Texture.MinFilter.BilinearNoMipMaps);
        this.envMap.setWrap(Texture.WrapMode.EdgeClamp);
        this.envMap.getImage().setColorSpace(ColorSpace.Linear);
    }

    @Override
    public void setTexturePulling(boolean v) {
        this.texturePulling = v;
    }

    @Override
    public boolean isTexturePulling() {
        return this.texturePulling;
    }

    @Override
    public TextureCubeMap getEnvMap() {
        return this.envMap;
    }

    protected Camera updateAndGetInternalCamera(int faceId, int w, int h, Vector3f position, float frustumNear, float frustumFar) {
        this.cam.resize(w, h, false);
        this.cam.setLocation(position);
        this.cam.setFrustumPerspective(90.0f, 1.0f, frustumNear, frustumFar);
        this.cam.setRotation(new Quaternion().fromAxes(axisX[faceId], axisY[faceId], axisZ[faceId]));
        return this.cam;
    }

    @Override
    public void clean() {
    }

    @Override
    public void bakeEnvironment(Spatial scene, Vector3f position, float frustumNear, float frustumFar, Predicate<Geometry> filter) {
        int i;
        FrameBuffer[] envbakers = new FrameBuffer[6];
        for (i = 0; i < 6; ++i) {
            envbakers[i] = new FrameBuffer(this.envMap.getImage().getWidth(), this.envMap.getImage().getHeight(), 1);
            envbakers[i].setDepthTarget(FrameBuffer.FrameBufferTarget.newTarget(this.depthFormat));
            envbakers[i].setSrgb(false);
            envbakers[i].addColorTarget(FrameBuffer.FrameBufferTarget.newTarget(this.envMap).face(TextureCubeMap.Face.values()[i]));
        }
        if (this.isTexturePulling()) {
            this.startPulling();
        }
        for (i = 0; i < 6; ++i) {
            FrameBuffer envbaker = envbakers[i];
            ViewPort viewPort = new ViewPort("EnvBaker", this.updateAndGetInternalCamera(i, envbaker.getWidth(), envbaker.getHeight(), position, frustumNear, frustumFar));
            viewPort.setClearFlags(true, true, true);
            viewPort.setBackgroundColor(ColorRGBA.Pink);
            viewPort.setOutputFrameBuffer(envbaker);
            viewPort.clearScenes();
            viewPort.attachScene(scene);
            scene.updateLogicalState(0.0f);
            scene.updateGeometricState();
            Predicate<Geometry> ofilter = this.renderManager.getRenderFilter();
            this.renderManager.setRenderFilter(filter);
            this.renderManager.renderViewPort(viewPort, 0.16f);
            this.renderManager.setRenderFilter(ofilter);
            if (!this.isTexturePulling()) continue;
            this.pull(envbaker, this.envMap, i);
        }
        if (this.isTexturePulling()) {
            this.endPulling(this.envMap);
        }
        this.envMap.getImage().clearUpdateNeeded();
        for (i = 0; i < 6; ++i) {
            envbakers[i].dispose();
        }
    }

    protected void startPulling() {
        this.bos.clear();
    }

    protected ByteBuffer pull(FrameBuffer fb, Texture env, int faceId) {
        if (fb.getColorTarget().getFormat() != env.getImage().getFormat()) {
            throw new IllegalArgumentException("Format mismatch: " + (Object)((Object)fb.getColorTarget().getFormat()) + "!=" + (Object)((Object)env.getImage().getFormat()));
        }
        ByteBuffer face = BufferUtils.createByteBuffer(fb.getWidth() * fb.getHeight() * (fb.getColorTarget().getFormat().getBitsPerPixel() / 8));
        this.renderManager.getRenderer().readFrameBufferWithFormat(fb, face, fb.getColorTarget().getFormat());
        face.rewind();
        while (this.bos.size() <= faceId) {
            this.bos.add(null);
        }
        ByteArrayOutputStream bo = this.bos.get(faceId);
        if (bo == null) {
            bo = new ByteArrayOutputStream();
            this.bos.set(faceId, bo);
        }
        try {
            byte[] array = new byte[face.limit()];
            face.get(array);
            bo.write(array);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        return face;
    }

    protected void endPulling(Texture tx) {
        for (int i = 0; i < this.bos.size(); ++i) {
            ByteArrayOutputStream bo = this.bos.get(i);
            if (bo != null) {
                ByteBuffer faceMip = ByteBuffer.wrap(bo.toByteArray());
                tx.getImage().setData(i, faceMip);
                continue;
            }
            LOG.log(Level.SEVERE, "Missing face {0}. Pulling incomplete!", i);
        }
        this.bos.clear();
        tx.getImage().clearUpdateNeeded();
    }

    protected int limitMips(int nbMipMaps, int baseW, int baseH, RenderManager rm) {
        if (nbMipMaps > 6) {
            nbMipMaps = 6;
        }
        return nbMipMaps;
    }

    static {
        GenericEnvBaker.axisX[0] = Vector3f.UNIT_Z.mult(1.0f);
        GenericEnvBaker.axisY[0] = Vector3f.UNIT_Y.mult(-1.0f);
        GenericEnvBaker.axisZ[0] = Vector3f.UNIT_X.mult(1.0f);
        GenericEnvBaker.axisX[1] = Vector3f.UNIT_Z.mult(-1.0f);
        GenericEnvBaker.axisY[1] = Vector3f.UNIT_Y.mult(-1.0f);
        GenericEnvBaker.axisZ[1] = Vector3f.UNIT_X.mult(-1.0f);
        GenericEnvBaker.axisX[2] = Vector3f.UNIT_X.mult(-1.0f);
        GenericEnvBaker.axisY[2] = Vector3f.UNIT_Z.mult(1.0f);
        GenericEnvBaker.axisZ[2] = Vector3f.UNIT_Y.mult(1.0f);
        GenericEnvBaker.axisX[3] = Vector3f.UNIT_X.mult(-1.0f);
        GenericEnvBaker.axisY[3] = Vector3f.UNIT_Z.mult(-1.0f);
        GenericEnvBaker.axisZ[3] = Vector3f.UNIT_Y.mult(-1.0f);
        GenericEnvBaker.axisX[4] = Vector3f.UNIT_X.mult(-1.0f);
        GenericEnvBaker.axisY[4] = Vector3f.UNIT_Y.mult(-1.0f);
        GenericEnvBaker.axisZ[4] = Vector3f.UNIT_Z;
        GenericEnvBaker.axisX[5] = Vector3f.UNIT_X.mult(1.0f);
        GenericEnvBaker.axisY[5] = Vector3f.UNIT_Y.mult(-1.0f);
        GenericEnvBaker.axisZ[5] = Vector3f.UNIT_Z.mult(-1.0f);
    }
}

