/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.anim;

import com.jme3.anim.AnimClip;
import com.jme3.anim.AnimLayer;
import com.jme3.anim.AnimationMask;
import com.jme3.anim.tween.Tween;
import com.jme3.anim.tween.Tweens;
import com.jme3.anim.tween.action.Action;
import com.jme3.anim.tween.action.BaseAction;
import com.jme3.anim.tween.action.BlendAction;
import com.jme3.anim.tween.action.BlendSpace;
import com.jme3.anim.tween.action.BlendableAction;
import com.jme3.anim.tween.action.ClipAction;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.control.AbstractControl;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class AnimComposer
extends AbstractControl {
    public static final String DEFAULT_LAYER = "Default";
    private Map<String, AnimClip> animClipMap = new HashMap<String, AnimClip>();
    private Map<String, Action> actions = new HashMap<String, Action>();
    private float globalSpeed = 1.0f;
    private Map<String, AnimLayer> layers = new LinkedHashMap<String, AnimLayer>(4);

    public AnimComposer() {
        this.layers.put(DEFAULT_LAYER, new AnimLayer(DEFAULT_LAYER, null));
    }

    public boolean hasAnimClip(String name) {
        return this.animClipMap.containsKey(name);
    }

    public AnimClip getAnimClip(String name) {
        return this.animClipMap.get(name);
    }

    public void addAnimClip(AnimClip anim) {
        this.animClipMap.put(anim.getName(), anim);
    }

    public void removeAnimClip(AnimClip anim) {
        if (!this.animClipMap.containsKey(anim.getName())) {
            throw new IllegalArgumentException("Given animation does not exist in this AnimControl");
        }
        this.animClipMap.remove(anim.getName());
    }

    public Action setCurrentAction(String name) {
        return this.setCurrentAction(name, DEFAULT_LAYER, true);
    }

    public Action setCurrentAction(String actionName, String layerName) {
        return this.setCurrentAction(actionName, layerName, true);
    }

    public Action setCurrentAction(String actionName, String layerName, boolean loop) {
        AnimLayer layer = this.getLayer(layerName);
        Action currentAction = this.action(actionName);
        layer.setCurrentAction(actionName, currentAction, loop);
        return currentAction;
    }

    public Action getCurrentAction() {
        return this.getCurrentAction(DEFAULT_LAYER);
    }

    public Action getCurrentAction(String layerName) {
        AnimLayer l = this.getLayer(layerName);
        Action result = l.getCurrentAction();
        return result;
    }

    public void removeCurrentAction() {
        this.removeCurrentAction(DEFAULT_LAYER);
    }

    public void removeCurrentAction(String layerName) {
        AnimLayer l = this.getLayer(layerName);
        l.setCurrentAction(null);
    }

    public double getTime() {
        return this.getTime(DEFAULT_LAYER);
    }

    public double getTime(String layerName) {
        AnimLayer l = this.getLayer(layerName);
        double result = l.getTime();
        return result;
    }

    public void setTime(double time) {
        this.setTime(DEFAULT_LAYER, time);
    }

    public void setTime(String layerName, double time) {
        AnimLayer l = this.getLayer(layerName);
        if (l.getCurrentAction() == null) {
            throw new RuntimeException("There is no action running in layer " + layerName);
        }
        l.setTime(time);
    }

    public Action action(String name) {
        Action action = this.actions.get(name);
        if (action == null) {
            action = this.makeAction(name);
            this.actions.put(name, action);
        }
        return action;
    }

    public Action getAction(String name) {
        return this.actions.get(name);
    }

    public void addAction(String name, Action action) {
        this.actions.put(name, action);
    }

    public Action makeAction(String name) {
        AnimClip clip = this.animClipMap.get(name);
        if (clip == null) {
            throw new IllegalArgumentException("Cannot find clip named " + name);
        }
        ClipAction action = new ClipAction(clip);
        return action;
    }

    public boolean hasAction(String name) {
        return this.actions.containsKey(name);
    }

    public Action removeAction(String name) {
        return this.actions.remove(name);
    }

    public void makeLayer(String name, AnimationMask mask) {
        AnimLayer l = new AnimLayer(name, mask);
        this.layers.put(name, l);
    }

    public void removeLayer(String name) {
        this.layers.remove(name);
    }

    public BaseAction actionSequence(String name, Tween ... tweens) {
        BaseAction action = new BaseAction(Tweens.sequence(tweens));
        this.actions.put(name, action);
        return action;
    }

    public BlendAction actionBlended(String name, BlendSpace blendSpace, String ... clips) {
        BlendableAction[] acts = new BlendableAction[clips.length];
        for (int i = 0; i < acts.length; ++i) {
            BlendableAction ba;
            acts[i] = ba = (BlendableAction)this.makeAction(clips[i]);
        }
        BlendAction action = new BlendAction(blendSpace, acts);
        this.actions.put(name, action);
        return action;
    }

    public void reset() {
        for (AnimLayer layer : this.layers.values()) {
            layer.setCurrentAction(null);
        }
    }

    public Collection<AnimClip> getAnimClips() {
        return Collections.unmodifiableCollection(this.animClipMap.values());
    }

    public Set<String> getAnimClipsNames() {
        return Collections.unmodifiableSet(this.animClipMap.keySet());
    }

    @Override
    protected void controlUpdate(float tpf) {
        for (AnimLayer layer : this.layers.values()) {
            layer.update(tpf, this.globalSpeed);
        }
    }

    @Override
    protected void controlRender(RenderManager rm, ViewPort vp) {
    }

    public float getGlobalSpeed() {
        return this.globalSpeed;
    }

    public void setGlobalSpeed(float globalSpeed) {
        this.globalSpeed = globalSpeed;
    }

    public AnimLayer getLayer(String layerName) {
        AnimLayer result = this.layers.get(layerName);
        if (result == null) {
            throw new IllegalArgumentException("Unknown layer " + layerName);
        }
        return result;
    }

    public Object getLayerManager(String layerName) {
        AnimLayer layer = this.getLayer(layerName);
        Object result = layer.getManager();
        return result;
    }

    public Set<String> getLayerNames() {
        Set<String> result = Collections.unmodifiableSet(this.layers.keySet());
        return result;
    }

    public void setLayerManager(String layerName, Object manager) {
        AnimLayer layer = this.getLayer(layerName);
        layer.setManager(manager);
    }

    @Override
    public Object jmeClone() {
        try {
            AnimComposer clone = (AnimComposer)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        HashMap<String, AnimClip> clips = new HashMap<String, AnimClip>();
        for (String string : this.animClipMap.keySet()) {
            clips.put(string, cloner.clone(this.animClipMap.get(string)));
        }
        HashMap<String, Action> act = new HashMap<String, Action>();
        for (String key : this.actions.keySet()) {
            act.put(key, cloner.clone(this.actions.get(key)));
        }
        this.actions = act;
        this.animClipMap = clips;
        LinkedHashMap<String, AnimLayer> linkedHashMap = new LinkedHashMap<String, AnimLayer>();
        for (String key : this.layers.keySet()) {
            linkedHashMap.put(key, cloner.clone(this.layers.get(key)));
        }
        linkedHashMap.putIfAbsent(DEFAULT_LAYER, new AnimLayer(DEFAULT_LAYER, null));
        this.layers = linkedHashMap;
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.animClipMap = ic.readStringSavableMap("animClipMap", new HashMap());
        this.globalSpeed = ic.readFloat("globalSpeed", 1.0f);
        this.layers = ic.readStringSavableMap("layers", new HashMap());
        this.layers.putIfAbsent(DEFAULT_LAYER, new AnimLayer(DEFAULT_LAYER, null));
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.writeStringSavableMap(this.animClipMap, "animClipMap", new HashMap());
        oc.write(this.globalSpeed, "globalSpeed", 1.0f);
        oc.writeStringSavableMap(this.layers, "layers", new HashMap());
    }
}

