/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.startup;

import java.io.IOException;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.expectations.transformation.ExpectationsTransformer;
import mockit.internal.startup.AgentLoader;
import mockit.internal.startup.JMockitInitialization;
import mockit.internal.startup.MockingBridgeFields;
import mockit.internal.state.CachedClassfiles;
import mockit.internal.util.ClassLoad;
import mockit.internal.util.FieldReflection;
import mockit.internal.util.MethodReflection;
import mockit.internal.util.StackTrace;

public final class Startup {
    public static boolean initializing;
    @Nullable
    private static Instrumentation instrumentation;
    private static boolean initializedOnDemand;

    private Startup() {
    }

    public static void premain(String agentArgs, @Nonnull Instrumentation inst) throws IOException {
        Startup.initialize(true, inst);
    }

    private static void initialize(boolean applyStartupMocks, @Nonnull Instrumentation inst) throws IOException {
        if (instrumentation == null) {
            instrumentation = inst;
            MockingBridgeFields.createSyntheticFieldsInJREClassToHoldMockingBridges((Instrumentation)inst);
            inst.addTransformer((ClassFileTransformer)CachedClassfiles.INSTANCE, true);
            if (applyStartupMocks) {
                Startup.applyStartupMocks();
            }
            inst.addTransformer((ClassFileTransformer)new ExpectationsTransformer(inst));
        }
    }

    private static void applyStartupMocks() throws IOException {
        initializing = true;
        try {
            new JMockitInitialization().initialize();
        }
        finally {
            initializing = false;
        }
    }

    public static void agentmain(String agentArgs, @Nonnull Instrumentation inst) throws IOException {
        if (!inst.isRedefineClassesSupported()) {
            throw new UnsupportedOperationException("This JRE must be started in debug mode, or with -javaagent:<proper path>/jmockit.jar");
        }
        Startup.initialize(false, inst);
        ClassLoader customCL = (ClassLoader)System.getProperties().remove("jmockit-customCL");
        if (customCL != null) {
            Startup.reinitializeJMockitUnderCustomClassLoader(customCL);
        }
    }

    private static void reinitializeJMockitUnderCustomClassLoader(@Nonnull ClassLoader customLoader) {
        Class<?> startupClass;
        try {
            startupClass = customLoader.loadClass(Startup.class.getName());
        }
        catch (ClassNotFoundException ignore) {
            return;
        }
        System.out.println("JMockit: Reinitializing under custom class loader " + customLoader);
        FieldReflection.setField(startupClass, null, "instrumentation", instrumentation);
        MethodReflection.invoke(startupClass, null, (String)"reapplyStartupMocks", (Object[])new Object[0]);
    }

    private static void reapplyStartupMocks() {
        MockingBridgeFields.setMockingBridgeFields();
        try {
            Startup.applyStartupMocks();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public static Instrumentation instrumentation() {
        Startup.verifyInitialization();
        assert (instrumentation != null);
        return instrumentation;
    }

    public static void initialize(@Nonnull Instrumentation inst) throws IOException {
        boolean fullJMockit = false;
        try {
            Class.forName("mockit.internal.expectations.transformation.ExpectationsTransformer");
            fullJMockit = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        instrumentation = inst;
        if (fullJMockit) {
            MockingBridgeFields.createSyntheticFieldsInJREClassToHoldMockingBridges((Instrumentation)inst);
            initializing = true;
            try {
                new JMockitInitialization().initialize();
            }
            finally {
                initializing = false;
            }
            inst.addTransformer((ClassFileTransformer)CachedClassfiles.INSTANCE, true);
            inst.addTransformer((ClassFileTransformer)new ExpectationsTransformer(inst));
        }
    }

    public static boolean wasInitializedOnDemand() {
        return initializedOnDemand;
    }

    public static void verifyInitialization() {
        if (Startup.getInstrumentation() == null) {
            new AgentLoader().loadAgent();
            initializedOnDemand = true;
        }
    }

    @Nullable
    private static Instrumentation getInstrumentation() {
        ClassLoader systemCL;
        Class<?> initialStartupClass;
        if (instrumentation == null && (initialStartupClass = ClassLoad.loadClass(systemCL = ClassLoader.getSystemClassLoader(), Startup.class.getName())) != null && (instrumentation = (Instrumentation)FieldReflection.getField(initialStartupClass, "instrumentation", null)) != null) {
            Startup.reapplyStartupMocks();
        }
        return instrumentation;
    }

    public static boolean initializeIfPossible() {
        if (Startup.getInstrumentation() == null) {
            boolean usingCustomCL;
            ClassLoader currentCL = Startup.class.getClassLoader();
            boolean bl = usingCustomCL = currentCL != ClassLoader.getSystemClassLoader();
            if (usingCustomCL) {
                System.getProperties().put("jmockit-customCL", currentCL);
            }
            try {
                new AgentLoader().loadAgent();
                if (!usingCustomCL) {
                    Startup.applyStartupMocks();
                }
                return true;
            }
            catch (IllegalStateException e) {
                StackTrace.filterStackTrace(e);
                e.printStackTrace();
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return false;
        }
        return true;
    }

    public static void retransformClass(@Nonnull Class<?> aClass) {
        try {
            Startup.instrumentation().retransformClasses(aClass);
        }
        catch (UnmodifiableClassException unmodifiableClassException) {
            // empty catch block
        }
    }

    public static void redefineMethods(@Nonnull Class<?> classToRedefine, @Nonnull byte[] modifiedClassfile) {
        Startup.redefineMethods(new ClassDefinition(classToRedefine, modifiedClassfile));
    }

    public static void redefineMethods(ClassDefinition ... classDefs) {
        try {
            Startup.instrumentation().redefineClasses(classDefs);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (UnmodifiableClassException e) {
            throw new RuntimeException(e);
        }
        catch (InternalError ignore) {
            for (ClassDefinition classDef : classDefs) {
                Startup.detectMissingDependenciesIfAny(classDef.getDefinitionClass());
            }
        }
    }

    private static void detectMissingDependenciesIfAny(@Nonnull Class<?> mockedClass) {
        try {
            Class.forName(mockedClass.getName(), false, mockedClass.getClassLoader());
        }
        catch (NoClassDefFoundError e) {
            throw new RuntimeException("Unable to mock " + mockedClass + " due to a missing dependency", e);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

