/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.standalone;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.instrument.Instrumentation;
import javax.annotation.Nonnull;
import mockit.coverage.CodeCoverage;
import mockit.coverage.standalone.CoverageControl;

public final class Startup {
    private static Instrumentation instrumentation;
    private static boolean inATestRun;
    private static boolean jmockitAvailable;

    private Startup() {
    }

    public static void premain(String agentArgs, @Nonnull Instrumentation inst) throws IOException {
        instrumentation = inst;
        Startup.discoverOptionalDependenciesThatAreAvailableInClassPath();
        if (!inATestRun) {
            CoverageControl.create();
        }
        CodeCoverage coverageTransformer = CodeCoverage.create(inATestRun);
        inst.addTransformer(coverageTransformer);
        if (jmockitAvailable) {
            mockit.internal.startup.Startup.initialize(inst);
        }
    }

    public static void agentmain(String agentArgs, @Nonnull Instrumentation inst) throws IOException {
        instrumentation = inst;
        inATestRun = false;
        jmockitAvailable = false;
        try {
            CoverageControl.create();
            inst.addTransformer(CodeCoverage.create(false));
        }
        catch (Throwable t) {
            PrintWriter out = new PrintWriter("coverage-failure.txt");
            t.printStackTrace(out);
            out.close();
        }
    }

    private static void discoverOptionalDependenciesThatAreAvailableInClassPath() {
        inATestRun = Startup.isAvailableInClassPath("org.junit.Assert") || Startup.isAvailableInClassPath("org.testng.Assert");
        jmockitAvailable = Startup.isAvailableInClassPath("mockit.Invocations");
    }

    private static boolean isAvailableInClassPath(@Nonnull String className) {
        ClassLoader currentLoader = Startup.class.getClassLoader();
        try {
            Class.forName(className, false, currentLoader);
            return true;
        }
        catch (ClassNotFoundException ignore) {
            return false;
        }
    }

    @Nonnull
    public static Instrumentation instrumentation() {
        if (instrumentation == null) {
            instrumentation = mockit.internal.startup.Startup.instrumentation();
        }
        return instrumentation;
    }

    public static boolean isTestRun() {
        return inATestRun;
    }

    public static boolean isJMockitAvailable() {
        return jmockitAvailable;
    }

    public static boolean isInitialized() {
        return instrumentation != null;
    }

    static {
        inATestRun = true;
        jmockitAvailable = true;
    }
}

