/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting.packages;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.coverage.CoveragePercentage;
import mockit.coverage.Metrics;
import mockit.coverage.data.FileCoverageData;
import mockit.coverage.reporting.OutputFile;
import mockit.coverage.reporting.packages.ListWithFilesAndPercentages;
import mockit.coverage.reporting.packages.PackageCoverageReport;
import mockit.coverage.testRedundancy.TestCoverage;

public final class IndexPage
extends ListWithFilesAndPercentages {
    @Nullable
    private final List<File> sourceDirs;
    @Nonnull
    private final Map<String, List<String>> packageToFiles;
    @Nonnull
    private final Map<String, int[]> packageToPackagePercentages;
    @Nonnull
    private final PackageCoverageReport packageReport;
    private final int totalFileCount;

    public IndexPage(@Nonnull File outputFile, @Nullable List<File> sourceDirs, @Nullable Collection<String> sourceFilesNotFound, @Nonnull Map<String, List<String>> packageToFiles, @Nonnull Map<String, FileCoverageData> fileToFileData) throws IOException {
        super(new OutputFile(outputFile), "    ");
        this.sourceDirs = sourceDirs;
        this.packageToFiles = packageToFiles;
        this.packageToPackagePercentages = new HashMap<String, int[]>();
        this.packageReport = new PackageCoverageReport(this.output, sourceFilesNotFound, fileToFileData, packageToFiles.values());
        this.totalFileCount = IndexPage.totalNumberOfSourceFilesWithCoverageData(fileToFileData.values());
    }

    private static int totalNumberOfSourceFilesWithCoverageData(@Nonnull Collection<FileCoverageData> fileData) {
        return fileData.size() - Collections.frequency(fileData, null);
    }

    public void generate() {
        try {
            this.writeHeader();
            ArrayList<String> packages = new ArrayList<String>(this.packageToFiles.keySet());
            this.writeMetricsForEachFile(null, packages);
            this.writeLineWithCoverageTotals();
            this.output.println("  </table>");
            this.writeListOfRedundantTestsIfAny();
            this.writeFooter();
        }
        finally {
            this.output.close();
        }
    }

    private void writeHeader() {
        ((OutputFile)this.output).writeCommonHeader("Code Coverage Report");
        this.output.println("  <table id='packages'>");
        this.writeTableCaption();
        this.writeTableFirstRowWithColumnTitles();
    }

    private void writeTableCaption() {
        if (this.sourceDirs == null) {
            this.output.println("    <caption>All Packages and Files</caption>");
        } else {
            this.output.write("    <caption>All Packages and Files<div style='font-size: smaller'>");
            this.output.write(this.getCommaSeparatedListOfSourceDirs());
            this.output.println("</div></caption>");
        }
    }

    @Nonnull
    private String getCommaSeparatedListOfSourceDirs() {
        List<File> dirs = this.sourceDirs;
        assert (dirs != null);
        this.removeRedundantSourceDirectories(dirs);
        String concatenatedSourceDirs = dirs.toString();
        String prefixToRemove = ".." + File.separatorChar;
        String commaSepDirs = concatenatedSourceDirs.replace(prefixToRemove, "");
        return commaSepDirs.substring(1, commaSepDirs.length() - 1);
    }

    private void removeRedundantSourceDirectories(@Nonnull List<File> dirs) {
        block0: for (int i = 0; i < dirs.size(); ++i) {
            String dir1 = dirs.get(i).getPath();
            int j = i + 1;
            while (j < dirs.size()) {
                String dir2 = dirs.get(j).getPath();
                if (dir1.startsWith(dir2)) {
                    dirs.remove(j);
                    continue;
                }
                if (dir2.startsWith(dir1)) {
                    dirs.remove(i);
                    --i;
                    continue block0;
                }
                ++j;
            }
        }
    }

    private void writeTableFirstRowWithColumnTitles() {
        this.output.println("    <tr>");
        this.output.write("      <th style='cursor: col-resize' onclick='showHideAllFiles()'>Packages: ");
        this.output.print(this.packageToFiles.keySet().size());
        this.output.println("</th>");
        this.output.write("      <th onclick='location.reload()' style='cursor: n-resize' title='Click on the title for each metric to sort by size (total number of line segments, paths, or fields).'>Files: ");
        this.output.print(this.totalFileCount);
        this.output.println("</th>");
        Metrics.performAction(new Metrics.Action(){
            int tableColumn = 1;

            @Override
            public void perform(@Nonnull Metrics metric) {
                this.writeHeaderCellWithMetricNameAndDescription(metric);
                ++this.tableColumn;
            }

            private void writeHeaderCellWithMetricNameAndDescription(@Nonnull Metrics metric) {
                IndexPage.this.output.write("      <th onclick='sortTables(");
                IndexPage.this.output.print(this.tableColumn);
                IndexPage.this.output.write(")' style='cursor: n-resize' title='");
                IndexPage.this.output.write(metric.htmlDescription);
                IndexPage.this.output.write("'>");
                IndexPage.this.output.write(metric.toString());
                IndexPage.this.output.println("</th>");
            }
        });
        this.output.println("    </tr>");
    }

    private void writeLineWithCoverageTotals() {
        this.output.println("    <tr class='total'>");
        this.output.println("      <td>Total</td><td>&nbsp;</td>");
        Metrics.performAction(new Metrics.Action(){

            @Override
            public void perform(@Nonnull Metrics metric) {
                IndexPage.this.writeLineWithCoverageTotals(metric);
            }
        });
        this.output.println("    </tr>");
    }

    private void writeLineWithCoverageTotals(@Nonnull Metrics metric) {
        int covered = this.coveredItems[metric.ordinal()];
        int total = this.totalItems[metric.ordinal()];
        int percentage = CoveragePercentage.calculate(covered, total);
        this.printCoveragePercentage(metric, covered, total, percentage);
    }

    @Override
    protected void writeMetricsForFile(String unused, final @Nonnull String packageName) {
        this.writeRowStart();
        this.writeTableCellWithPackageName(packageName);
        this.writeInternalTableForSourceFiles(packageName);
        Metrics.performAction(new Metrics.Action(){

            @Override
            public void perform(@Nonnull Metrics metric) {
                IndexPage.this.writeCoveragePercentageForPackage(packageName, metric);
            }
        });
        this.writeRowClose();
    }

    private void writeTableCellWithPackageName(@Nonnull String packageName) {
        this.printIndent();
        this.output.write("  <td class='package");
        List<String> filesInPackage = this.packageToFiles.get(packageName);
        if (filesInPackage.size() > 1) {
            this.output.write(" click' onclick='showHideFiles(this)");
        }
        this.output.write("'>");
        this.output.write(packageName.replace('/', '.'));
        this.output.println("</td>");
    }

    private void writeInternalTableForSourceFiles(final @Nonnull String packageName) {
        this.printIndent();
        this.output.println("  <td>");
        this.printIndent();
        this.output.println("    <table width='100%'>");
        List<String> fileNames = this.packageToFiles.get(packageName);
        this.packageReport.writeMetricsForEachFile(packageName, fileNames);
        Metrics.performAction(new Metrics.Action(){

            @Override
            public void perform(@Nonnull Metrics metric) {
                IndexPage.this.recordCoverageInformationForPackage(packageName, metric);
            }
        });
        this.printIndent();
        this.output.println("    </table>");
        this.printIndent();
        this.writeInitiallyHiddenSourceFileCount(fileNames.size());
        this.output.println("  </td>");
    }

    private void recordCoverageInformationForPackage(@Nonnull String packageName, @Nonnull Metrics metric) {
        int coveredInPackage = this.packageReport.coveredItems[metric.ordinal()];
        int totalInPackage = this.packageReport.totalItems[metric.ordinal()];
        int packagePercentage = CoveragePercentage.calculate(coveredInPackage, totalInPackage);
        this.setPackageCoveragePercentage(packageName, metric, packagePercentage);
        int n = metric.ordinal();
        this.totalItems[n] = this.totalItems[n] + totalInPackage;
        int n2 = metric.ordinal();
        this.coveredItems[n2] = this.coveredItems[n2] + coveredInPackage;
    }

    private void setPackageCoveragePercentage(@Nonnull String packageName, @Nonnull Metrics metric, int percentage) {
        int[] percentages = this.packageToPackagePercentages.get(packageName);
        if (percentages == null) {
            percentages = new int[Metrics.values().length];
            this.packageToPackagePercentages.put(packageName, percentages);
        }
        percentages[metric.ordinal()] = percentage;
    }

    private void writeInitiallyHiddenSourceFileCount(int fileCount) {
        this.output.write("    <span>(");
        this.output.print(fileCount);
        this.output.println(" source files)</span>");
    }

    private void writeCoveragePercentageForPackage(@Nonnull String packageName, @Nonnull Metrics metric) {
        int coveredInPackage = this.packageReport.coveredItems[metric.ordinal()];
        int totalInPackage = this.packageReport.totalItems[metric.ordinal()];
        int filePercentage = this.packageToPackagePercentages.get(packageName)[metric.ordinal()];
        this.printCoveragePercentage(metric, coveredInPackage, totalInPackage, filePercentage);
    }

    @Override
    protected void writeClassAttributeForCoveragePercentageCell() {
        this.output.write("class='pt' ");
    }

    private void writeListOfRedundantTestsIfAny() {
        List<Method> redundantTests = TestCoverage.INSTANCE.getRedundantTests();
        if (!redundantTests.isEmpty()) {
            this.output.println("  <br/>Redundant tests:");
            this.output.println("  <ol title=\"Tests are regarded as redundant when they don't cover any additional line segments or paths that haven't already been covered by a previous test.\nNote this means the list of redundant tests depends on the order of test execution.\nSuch a test can be removed without weakening the test suite, as long as another test for the same scenario performs its assertions.\">");
            for (Method testMethod : redundantTests) {
                String testDescription = testMethod.getDeclaringClass().getSimpleName() + '.' + testMethod.getName();
                this.output.append("");
                this.output.write("    <li>");
                this.output.write(testDescription);
                this.output.println("</li>");
            }
            this.output.println("  </ol>");
        }
    }

    private void writeFooter() {
        this.output.println("  <p>");
        this.output.println("    <a href='http://jmockit.org'><img src='logo.png'></a>");
        this.output.write("    Generated on ");
        this.output.println(new Date());
        this.output.println("  </p>");
        ((OutputFile)this.output).writeCommonFooter();
    }
}

