/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.coverage.data.CoverageData;
import mockit.coverage.data.FileCoverageData;
import mockit.coverage.reporting.OutputFile;
import mockit.coverage.reporting.SourceFiles;
import mockit.coverage.reporting.StaticFiles;
import mockit.coverage.reporting.packages.IndexPage;
import mockit.coverage.reporting.sourceFiles.FileCoverageReport;
import mockit.coverage.reporting.sourceFiles.InputFile;

class CoverageReport {
    @Nonnull
    private final String outputDir;
    private boolean outputDirCreated;
    @Nullable
    private final List<File> sourceDirs;
    @Nonnull
    private final Map<String, FileCoverageData> fileToFileData;
    @Nonnull
    private final Map<String, List<String>> packageToFiles;
    private final boolean withCallPoints;
    @Nullable
    private final Collection<String> sourceFilesNotFound;

    protected CoverageReport(@Nonnull String outputDir, boolean outputDirCreated, @Nullable String[] srcDirs, @Nonnull CoverageData coverageData, boolean withCallPoints) {
        this.outputDir = CoverageReport.getOrChooseOutputDirectory(outputDir);
        this.outputDirCreated = outputDirCreated;
        this.sourceDirs = srcDirs == null ? null : new SourceFiles().buildListOfSourceDirectories(srcDirs);
        this.fileToFileData = coverageData.getFileToFileDataMap();
        this.packageToFiles = new HashMap<String, List<String>>();
        this.withCallPoints = withCallPoints;
        this.sourceFilesNotFound = srcDirs == null ? null : new ArrayList();
    }

    @Nonnull
    private static String getOrChooseOutputDirectory(@Nonnull String outputDir) {
        if (!outputDir.isEmpty()) {
            return outputDir;
        }
        String mavenBaseDir = System.getProperty("basedir");
        return mavenBaseDir == null ? "coverage-report" : "target/coverage-report";
    }

    public final void generate() throws IOException {
        boolean withSourceFilePages;
        this.createReportOutputDirIfNotExists();
        File outputFile = this.createOutputFileForIndexPage();
        if (outputFile == null) {
            return;
        }
        boolean bl = withSourceFilePages = this.sourceDirs != null;
        if (withSourceFilePages && this.sourceDirs.size() > 1) {
            System.out.println("JMockit: Coverage source dirs: " + this.sourceDirs);
        }
        this.generateFileCoverageReportsWhileBuildingPackageLists();
        new IndexPage(outputFile, this.sourceDirs, this.sourceFilesNotFound, this.packageToFiles, this.fileToFileData).generate();
        new StaticFiles(this.outputDir).copyToOutputDir(withSourceFilePages);
        System.out.println("JMockit: Coverage report written to " + outputFile.getParentFile().getCanonicalPath());
    }

    private void createReportOutputDirIfNotExists() {
        if (!this.outputDirCreated) {
            File outDir = new File(this.outputDir);
            this.outputDirCreated = outDir.mkdirs();
        }
    }

    @Nullable
    private File createOutputFileForIndexPage() throws IOException {
        File outputFile = new File(this.outputDir, "index.html");
        if (outputFile.exists() && !outputFile.canWrite()) {
            System.out.println("JMockit: " + outputFile.getCanonicalPath() + " is read-only; report generation canceled");
            return null;
        }
        return outputFile;
    }

    private void generateFileCoverageReportsWhileBuildingPackageLists() throws IOException {
        Set<Map.Entry<String, FileCoverageData>> files = this.fileToFileData.entrySet();
        for (Map.Entry<String, FileCoverageData> fileAndFileData : files) {
            this.generateFileCoverageReport(fileAndFileData.getKey(), fileAndFileData.getValue());
        }
    }

    private void generateFileCoverageReport(@Nonnull String sourceFile, @Nonnull FileCoverageData fileData) throws IOException {
        if (this.sourceDirs == null) {
            this.addFileToPackageFileList(sourceFile);
        } else {
            InputFile inputFile = InputFile.createIfFileExists(this.sourceDirs, sourceFile);
            if (inputFile != null) {
                new FileCoverageReport(this.outputDir, inputFile, fileData, this.withCallPoints).generate();
            } else {
                this.deleteOutdatedHTMLFileIfExists(sourceFile);
                if (this.sourceFilesNotFound != null) {
                    this.sourceFilesNotFound.add(sourceFile);
                }
            }
            this.addFileToPackageFileList(sourceFile);
        }
    }

    private void addFileToPackageFileList(@Nonnull String file) {
        int p = file.lastIndexOf(47);
        String filePackage = p < 0 ? "" : file.substring(0, p);
        List<String> filesInPackage = this.packageToFiles.get(filePackage);
        if (filesInPackage == null) {
            filesInPackage = new ArrayList<String>();
            this.packageToFiles.put(filePackage, filesInPackage);
        }
        filesInPackage.add(file.substring(p + 1));
    }

    private void deleteOutdatedHTMLFileIfExists(@Nonnull String filePath) {
        if (!this.outputDirCreated) {
            File outputFile = OutputFile.getOutputFile(this.outputDir, filePath);
            outputFile.delete();
        }
    }
}

