/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.modification;

import java.io.File;
import java.security.ProtectionDomain;
import java.util.HashSet;
import javax.annotation.Nonnull;
import mockit.coverage.modification.ClassModification;

public final class ClassesNotLoaded {
    @Nonnull
    private final ClassModification classModification;
    private int firstPosAfterParentDir;

    public ClassesNotLoaded(@Nonnull ClassModification classModification) {
        this.classModification = classModification;
    }

    public void gatherCoverageData() {
        HashSet<ProtectionDomain> protectionDomainsSoFar = new HashSet<ProtectionDomain>(this.classModification.protectionDomainsWithUniqueLocations);
        for (ProtectionDomain pd : protectionDomainsSoFar) {
            File classPathEntry = new File(pd.getCodeSource().getLocation().getPath());
            if (classPathEntry.getPath().endsWith(".jar")) continue;
            this.firstPosAfterParentDir = classPathEntry.getPath().length() + 1;
            this.loadAdditionalClasses(classPathEntry, pd);
        }
    }

    private void loadAdditionalClasses(@Nonnull File classPathEntry, @Nonnull ProtectionDomain protectionDomain) {
        File[] filesInDir = classPathEntry.listFiles();
        if (filesInDir != null) {
            for (File fileInDir : filesInDir) {
                if (fileInDir.isDirectory()) {
                    this.loadAdditionalClasses(fileInDir, protectionDomain);
                    continue;
                }
                this.loadAdditionalClass(fileInDir.getPath(), protectionDomain);
            }
        }
    }

    private void loadAdditionalClass(@Nonnull String filePath, @Nonnull ProtectionDomain protectionDomain) {
        String relativePath;
        String className;
        int p = filePath.lastIndexOf(".class");
        if (p > 0 && this.classModification.isToBeConsideredForCoverageAsNotLoaded(className = (relativePath = filePath.substring(this.firstPosAfterParentDir, p)).replace(File.separatorChar, '.'), protectionDomain)) {
            ClassesNotLoaded.loadClass(className, protectionDomain);
        }
    }

    private static void loadClass(@Nonnull String className, @Nonnull ProtectionDomain protectionDomain) {
        try {
            Class.forName(className, false, protectionDomain.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }
}

