/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.data;

import java.io.Serializable;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.coverage.Metrics;
import mockit.coverage.TestRun;
import mockit.coverage.data.PerFileCoverage;
import mockit.coverage.dataItems.PerFileDataCoverage;
import mockit.coverage.lines.PerFileLineCoverage;
import mockit.coverage.paths.MethodCoverageData;
import mockit.coverage.paths.PerFilePathCoverage;

public final class FileCoverageData
implements Serializable {
    private static final long serialVersionUID = 3508572808457541012L;
    @Nonnull
    private static final PerFileLineCoverage NO_LINE_INFO = new PerFileLineCoverage();
    @Nonnull
    private static final PerFilePathCoverage NO_PATH_INFO = new PerFilePathCoverage();
    @Nonnull
    private static final PerFileDataCoverage NO_DATA_INFO = new PerFileDataCoverage();
    @Nonnull
    public PerFileLineCoverage lineCoverageInfo;
    @Nonnull
    public PerFilePathCoverage pathCoverageInfo;
    @Nonnull
    public PerFileDataCoverage dataCoverageInfo;
    public final int index;
    @Nullable
    public String kindOfTopLevelType;
    long lastModified;
    private final boolean loadedAfterTestCompletion;

    public FileCoverageData(int index, @Nullable String kindOfTopLevelType) {
        this.index = index;
        this.kindOfTopLevelType = kindOfTopLevelType;
        this.lineCoverageInfo = Metrics.LineCoverage.active ? new PerFileLineCoverage() : NO_LINE_INFO;
        this.pathCoverageInfo = Metrics.PathCoverage.active ? new PerFilePathCoverage() : NO_PATH_INFO;
        this.dataCoverageInfo = Metrics.DataCoverage.active ? new PerFileDataCoverage() : NO_DATA_INFO;
        this.loadedAfterTestCompletion = TestRun.isTerminated();
    }

    public boolean wasLoadedAfterTestCompletion() {
        return this.loadedAfterTestCompletion;
    }

    @Nonnull
    public PerFileLineCoverage getLineCoverageData() {
        return this.lineCoverageInfo;
    }

    public void addMethod(@Nonnull MethodCoverageData methodData) {
        this.pathCoverageInfo.addMethod(methodData);
    }

    @Nonnull
    public Collection<MethodCoverageData> getMethods() {
        return this.pathCoverageInfo.firstLineToMethodData.values();
    }

    @Nonnull
    public PerFileCoverage getPerFileCoverage(@Nonnull Metrics metric) {
        switch (metric) {
            case LineCoverage: {
                return this.lineCoverageInfo;
            }
            case PathCoverage: {
                return this.pathCoverageInfo;
            }
        }
        return this.dataCoverageInfo;
    }

    public int getTotalItemsForAllMetrics() {
        int totalItems = 0;
        if (this.lineCoverageInfo != NO_LINE_INFO) {
            totalItems += this.lineCoverageInfo.getTotalItems();
        }
        if (this.pathCoverageInfo != NO_PATH_INFO) {
            totalItems += this.pathCoverageInfo.getTotalItems();
        }
        if (this.dataCoverageInfo != NO_DATA_INFO) {
            totalItems += this.dataCoverageInfo.getTotalItems();
        }
        return totalItems;
    }

    void mergeWithDataFromPreviousTestRun(@Nonnull FileCoverageData previousInfo) {
        if (this.lineCoverageInfo == NO_LINE_INFO) {
            this.lineCoverageInfo = previousInfo.lineCoverageInfo;
        } else if (previousInfo.lineCoverageInfo != NO_LINE_INFO) {
            this.lineCoverageInfo.mergeInformation(previousInfo.lineCoverageInfo);
        }
        if (this.pathCoverageInfo == NO_PATH_INFO) {
            this.pathCoverageInfo = previousInfo.pathCoverageInfo;
        } else if (previousInfo.pathCoverageInfo != NO_PATH_INFO) {
            this.pathCoverageInfo.mergeInformation(previousInfo.pathCoverageInfo);
        }
        if (this.dataCoverageInfo == NO_DATA_INFO) {
            this.dataCoverageInfo = previousInfo.dataCoverageInfo;
        } else if (previousInfo.dataCoverageInfo != NO_DATA_INFO) {
            this.dataCoverageInfo.mergeInformation(previousInfo.dataCoverageInfo);
        }
    }

    void reset() {
        this.lineCoverageInfo.reset();
        this.pathCoverageInfo.reset();
    }
}

