/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage;

import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.coverage.AccretionFile;
import mockit.coverage.CodeCoverage;
import mockit.coverage.Configuration;
import mockit.coverage.DataFileMerging;
import mockit.coverage.data.CoverageData;
import mockit.coverage.modification.ClassModification;
import mockit.coverage.modification.ClassesNotLoaded;
import mockit.coverage.reporting.BasicCoverageReport;
import mockit.coverage.reporting.FullCoverageReport;
import mockit.coverage.standalone.Startup;

final class OutputFileGenerator {
    private static final String[] ALL_SOURCE_DIRS = new String[0];
    @Nullable
    private final ClassModification classModification;
    @Nonnull
    private final String[] outputFormats;
    @Nonnull
    private final String outputDir;
    @Nullable
    private final String[] sourceDirs;

    OutputFileGenerator(@Nullable ClassModification classModification) {
        this.classModification = classModification;
        this.outputFormats = OutputFileGenerator.getOutputFormat();
        this.outputDir = Configuration.getProperty("outputDir", "");
        String commaSeparatedDirs = Configuration.getProperty("srcDirs");
        this.sourceDirs = commaSeparatedDirs == null ? (Startup.isTestRun() ? ALL_SOURCE_DIRS : null) : (commaSeparatedDirs.isEmpty() ? null : commaSeparatedDirs.split("\\s*,\\s*"));
    }

    @Nonnull
    private static String[] getOutputFormat() {
        String[] stringArray;
        String format = Configuration.getProperty("output", "");
        if (format.isEmpty()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "html-nocp";
        } else {
            stringArray = format.trim().split("\\s*,\\s*|\\s+");
        }
        return stringArray;
    }

    boolean isOutputToBeGenerated() {
        return this.isOutputWithCallPointsToBeGenerated() || this.hasOutputFormat("html-nocp");
    }

    private boolean isOutputWithCallPointsToBeGenerated() {
        return this.hasOutputFormat("html") || this.hasOutputFormat("serial") || this.hasOutputFormat("serial-append");
    }

    boolean isWithCallPoints() {
        return Startup.isTestRun() && Startup.isJMockitAvailable() && this.isOutputWithCallPointsToBeGenerated() && !this.hasOutputFormat("html-nocp");
    }

    private boolean hasOutputFormat(@Nonnull String format) {
        for (String outputFormat : this.outputFormats) {
            if (!format.equals(outputFormat)) continue;
            return true;
        }
        return false;
    }

    void generate(@Nullable CodeCoverage codeCoverage) {
        CoverageData coverageData;
        if (this.classModification != null && this.classModification.shouldConsiderClassesNotLoaded()) {
            new ClassesNotLoaded(this.classModification).gatherCoverageData();
        }
        if (codeCoverage != null) {
            codeCoverage.deactivate();
        }
        if ((coverageData = CoverageData.instance()).isEmpty()) {
            System.out.print("JMockit: No classes were instrumented for coverage; please make sure that ");
            String classesRegexp = Configuration.getProperty("classes");
            if (classesRegexp == null) {
                System.out.print("classes exercised by tests are in a directory included in the runtime classpath");
            } else {
                System.out.print("classes selected for coverage through the regular expression \"" + classesRegexp + "\" are available from the runtime classpath");
            }
            System.out.println(", and that they have been compiled with debug information.");
            return;
        }
        boolean outputDirCreated = this.createOutputDirIfSpecifiedButNotExists();
        try {
            this.generateAccretionDataFileIfRequested(coverageData);
            this.generateHTMLReportIfRequested(coverageData, outputDirCreated);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void generateAggregateReportFromInputFiles(@Nonnull String[] inputPaths) {
        boolean outputDirCreated = this.createOutputDirIfSpecifiedButNotExists();
        try {
            CoverageData coverageData = new DataFileMerging(inputPaths).merge();
            this.generateHTMLReportIfRequested(coverageData, outputDirCreated);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean createOutputDirIfSpecifiedButNotExists() {
        if (this.outputDir.isEmpty()) {
            return false;
        }
        File outDir = new File(this.outputDir);
        boolean dirCreated = outDir.mkdirs();
        return dirCreated;
    }

    private void generateAccretionDataFileIfRequested(@Nonnull CoverageData newData) throws IOException {
        if (this.hasOutputFormat("serial")) {
            new AccretionFile(this.outputDir, newData).generate();
        } else if (this.hasOutputFormat("serial-append")) {
            AccretionFile accretionFile = new AccretionFile(this.outputDir, newData);
            accretionFile.mergeDataFromExistingFileIfAny();
            accretionFile.generate();
        }
    }

    private void generateHTMLReportIfRequested(@Nonnull CoverageData coverageData, boolean outputDirCreated) throws IOException {
        if (this.hasOutputFormat("html-nocp")) {
            new BasicCoverageReport(this.outputDir, outputDirCreated, this.sourceDirs, coverageData).generate();
        } else if (this.hasOutputFormat("html")) {
            new FullCoverageReport(this.outputDir, outputDirCreated, this.sourceDirs, coverageData).generate();
        }
    }
}

