/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting.packages;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mockit.coverage.CoveragePercentage;
import mockit.coverage.Metrics;
import mockit.coverage.data.FileCoverageData;
import mockit.coverage.reporting.OutputFile;
import mockit.coverage.reporting.packages.ListWithFilesAndPercentages;
import mockit.coverage.reporting.packages.PackageCoverageReport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IndexPage
extends ListWithFilesAndPercentages {
    @Nullable
    private final List<File> sourceDirs;
    @NotNull
    private final Map<String, List<String>> packageToFiles;
    @NotNull
    private final Map<String, int[]> packageToPackagePercentages;
    @NotNull
    private final PackageCoverageReport packageReport;
    private final int totalFileCount;

    public IndexPage(@NotNull File outputFile, @Nullable List<File> sourceDirs, @Nullable Collection<String> sourceFilesNotFound, @NotNull Map<String, List<String>> packageToFiles, @NotNull Map<String, FileCoverageData> fileToFileData) throws IOException {
        super(new OutputFile(outputFile), "    ");
        this.sourceDirs = sourceDirs;
        this.packageToFiles = packageToFiles;
        this.packageToPackagePercentages = new HashMap<String, int[]>();
        this.packageReport = new PackageCoverageReport(this.output, sourceFilesNotFound, fileToFileData, packageToFiles.values());
        this.totalFileCount = IndexPage.totalNumberOfSourceFilesWithCoverageData(fileToFileData.values());
    }

    private static int totalNumberOfSourceFilesWithCoverageData(@NotNull Collection<FileCoverageData> fileData) {
        return fileData.size() - Collections.frequency(fileData, null);
    }

    public void generate() {
        try {
            this.writeHeader();
            ArrayList<String> packages = new ArrayList<String>(this.packageToFiles.keySet());
            this.writeMetricsForEachFile(null, packages);
            this.writeLineWithCoverageTotals();
            this.writeFooter();
        }
        finally {
            this.output.close();
        }
    }

    private void writeHeader() {
        ((OutputFile)this.output).writeCommonHeader(null);
        this.output.println("  <h1>JMockit Coverage Report</h1>");
        this.output.println("  <table id='packages'>");
        this.writeTableCaption();
        this.writeTableFirstRowWithColumnTitles();
    }

    private void writeTableCaption() {
        if (this.sourceDirs == null) {
            this.output.println("    <caption>All Packages and Files</caption>");
        } else {
            this.output.write("    <caption>All Packages and Files<div style='font-size: smaller'>");
            this.output.write(IndexPage.getCommaSeparatedListOfSourceDirs(this.sourceDirs.toString()));
            this.output.println("</div></caption>");
        }
    }

    @NotNull
    private static String getCommaSeparatedListOfSourceDirs(@NotNull String concatenatedSourceDirs) {
        String prefixToRemove = ".." + File.separatorChar;
        String commaSepDirs = concatenatedSourceDirs.replace(prefixToRemove, "");
        return commaSepDirs.substring(1, commaSepDirs.length() - 1);
    }

    private void writeTableFirstRowWithColumnTitles() {
        this.output.println("    <tr>");
        this.output.write("      <th style='cursor: col-resize' onclick='showHideAllFiles()'>Packages: ");
        this.output.print(this.packageToFiles.keySet().size());
        this.output.println("</th>");
        this.output.write("      <th onclick='location.reload()' style='cursor: n-resize' title='Click on the title for each metric to sort by size (total number of line segments, paths, or fields).'>Files: ");
        this.output.print(this.totalFileCount);
        this.output.println("</th>");
        Metrics.performAction(new Metrics.Action(){
            int tableColumn = 1;

            @Override
            public void perform(@NotNull Metrics metric) {
                this.writeHeaderCellWithMetricNameAndDescription(metric);
                ++this.tableColumn;
            }

            private void writeHeaderCellWithMetricNameAndDescription(@NotNull Metrics metric) {
                IndexPage.this.output.write("      <th onclick='sortTables(");
                IndexPage.this.output.print(this.tableColumn);
                IndexPage.this.output.write(")' style='cursor: n-resize' title='");
                IndexPage.this.output.write(metric.htmlDescription);
                IndexPage.this.output.write("'>");
                IndexPage.this.output.write(metric.toString());
                IndexPage.this.output.println("</th>");
            }
        });
        this.output.println("    </tr>");
    }

    private void writeLineWithCoverageTotals() {
        this.output.println("    <tr class='total'>");
        this.output.println("      <td>Total</td><td>&nbsp;</td>");
        Metrics.performAction(new Metrics.Action(){

            @Override
            public void perform(@NotNull Metrics metric) {
                IndexPage.this.writeLineWithCoverageTotals(metric);
            }
        });
        this.output.println("    </tr>");
    }

    private void writeLineWithCoverageTotals(@NotNull Metrics metric) {
        int covered = this.coveredItems[metric.ordinal()];
        int total = this.totalItems[metric.ordinal()];
        int percentage = CoveragePercentage.calculate(covered, total);
        this.printCoveragePercentage(metric, covered, total, percentage);
    }

    private void writeFooter() {
        this.output.println("  </table>");
        this.output.println("  <p>");
        this.output.println("    <a href='http://jmockit.org'><img src='logo.png'></a>");
        this.output.write("    Generated on ");
        this.output.println(new Date());
        this.output.println("  </p>");
        ((OutputFile)this.output).writeCommonFooter();
    }

    @Override
    protected void writeMetricsForFile(String unused, final @NotNull String packageName) {
        this.writeRowStart();
        this.writeTableCellWithPackageName(packageName);
        this.writeInternalTableForSourceFiles(packageName);
        Metrics.performAction(new Metrics.Action(){

            @Override
            public void perform(@NotNull Metrics metric) {
                IndexPage.this.writeCoveragePercentageForPackage(packageName, metric);
            }
        });
        this.writeRowClose();
    }

    private void writeTableCellWithPackageName(@NotNull String packageName) {
        this.printIndent();
        this.output.write("  <td class='package");
        List<String> filesInPackage = this.packageToFiles.get(packageName);
        if (filesInPackage.size() > 1) {
            this.output.write(" click' onclick='showHideFiles(this)");
        }
        this.output.write("'>");
        this.output.write(packageName.replace('/', '.'));
        this.output.println("</td>");
    }

    private void writeInternalTableForSourceFiles(final @NotNull String packageName) {
        this.printIndent();
        this.output.println("  <td>");
        this.printIndent();
        this.output.println("    <table width='100%'>");
        List<String> fileNames = this.packageToFiles.get(packageName);
        this.packageReport.writeMetricsForEachFile(packageName, fileNames);
        Metrics.performAction(new Metrics.Action(){

            @Override
            public void perform(@NotNull Metrics metric) {
                IndexPage.this.recordCoverageInformationForPackage(packageName, metric);
            }
        });
        this.printIndent();
        this.output.println("    </table>");
        this.printIndent();
        this.writeInitiallyHiddenSourceFileCount(fileNames.size());
        this.output.println("  </td>");
    }

    private void recordCoverageInformationForPackage(@NotNull String packageName, @NotNull Metrics metric) {
        int coveredInPackage = this.packageReport.coveredItems[metric.ordinal()];
        int totalInPackage = this.packageReport.totalItems[metric.ordinal()];
        int packagePercentage = CoveragePercentage.calculate(coveredInPackage, totalInPackage);
        this.setPackageCoveragePercentage(packageName, metric, packagePercentage);
        int n = metric.ordinal();
        this.totalItems[n] = this.totalItems[n] + totalInPackage;
        int n2 = metric.ordinal();
        this.coveredItems[n2] = this.coveredItems[n2] + coveredInPackage;
    }

    private void setPackageCoveragePercentage(@NotNull String packageName, @NotNull Metrics metric, int percentage) {
        int[] percentages = this.packageToPackagePercentages.get(packageName);
        if (percentages == null) {
            percentages = new int[Metrics.values().length];
            this.packageToPackagePercentages.put(packageName, percentages);
        }
        percentages[metric.ordinal()] = percentage;
    }

    private void writeInitiallyHiddenSourceFileCount(int fileCount) {
        this.output.write("    <span>(");
        this.output.print(fileCount);
        this.output.println(" source files)</span>");
    }

    private void writeCoveragePercentageForPackage(@NotNull String packageName, @NotNull Metrics metric) {
        int coveredInPackage = this.packageReport.coveredItems[metric.ordinal()];
        int totalInPackage = this.packageReport.totalItems[metric.ordinal()];
        int filePercentage = this.packageToPackagePercentages.get(packageName)[metric.ordinal()];
        this.printCoveragePercentage(metric, coveredInPackage, totalInPackage, filePercentage);
    }

    @Override
    protected void writeClassAttributeForCoveragePercentageCell() {
        this.output.write("class='pt' ");
    }
}

