/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.modification;

import java.io.File;
import java.security.ProtectionDomain;
import java.util.HashSet;
import mockit.coverage.modification.ClassModification;
import org.jetbrains.annotations.NotNull;

public final class ClassesNotLoaded {
    @NotNull
    private final ClassModification classModification;
    private int firstPosAfterParentDir;

    public ClassesNotLoaded(@NotNull ClassModification classModification) {
        this.classModification = classModification;
    }

    public void gatherCoverageData() {
        HashSet<ProtectionDomain> protectionDomainsSoFar = new HashSet<ProtectionDomain>(this.classModification.protectionDomains);
        for (ProtectionDomain pd : protectionDomainsSoFar) {
            File classPathEntry = new File(pd.getCodeSource().getLocation().getPath());
            if (classPathEntry.getPath().endsWith(".jar")) continue;
            this.firstPosAfterParentDir = classPathEntry.getPath().length() + 1;
            this.loadAdditionalClasses(classPathEntry, pd);
        }
    }

    private void loadAdditionalClasses(@NotNull File classPathEntry, @NotNull ProtectionDomain protectionDomain) {
        File[] filesInDir = classPathEntry.listFiles();
        if (filesInDir != null) {
            for (File fileInDir : filesInDir) {
                if (fileInDir.isDirectory()) {
                    this.loadAdditionalClasses(fileInDir, protectionDomain);
                    continue;
                }
                this.loadAdditionalClass(fileInDir.getPath(), protectionDomain);
            }
        }
    }

    private void loadAdditionalClass(@NotNull String filePath, @NotNull ProtectionDomain protectionDomain) {
        String relativePath;
        String className;
        int p = filePath.lastIndexOf(".class");
        if (p > 0 && this.classModification.isToBeConsideredForCoverage(className = (relativePath = filePath.substring(this.firstPosAfterParentDir, p)).replace(File.separatorChar, '.'), protectionDomain)) {
            ClassesNotLoaded.loadClass(className, protectionDomain);
        }
    }

    private static void loadClass(@NotNull String className, @NotNull ProtectionDomain protectionDomain) {
        try {
            Class.forName(className, false, protectionDomain.getClassLoader());
        }
        catch (ClassNotFoundException ignore) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }
}

