/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.example.qcon;

import org.jmock.example.qcon.LocationAware;
import org.jmock.example.qcon.MediaControl;
import org.jmock.example.qcon.MediaTracker;
import org.jmock.example.qcon.Playlist;

public class DJ
implements LocationAware,
MediaTracker {
    private final MediaControl mediaControl;
    private final Playlist playlist;
    private String currentLocationName = null;
    private boolean trackFinished = true;
    private boolean locationChanged = false;

    public DJ(Playlist playlist, MediaControl mediaControl) {
        this.playlist = playlist;
        this.mediaControl = mediaControl;
    }

    @Override
    public void locationChangedTo(String newLocationName) {
        this.currentLocationName = newLocationName;
        if (this.trackFinished) {
            this.startPlaying();
            this.trackFinished = false;
        } else {
            this.locationChanged = true;
        }
    }

    @Override
    public void mediaFinished() {
        if (this.locationChanged) {
            this.startPlaying();
            this.locationChanged = false;
        } else {
            this.trackFinished = true;
        }
    }

    private void startPlaying() {
        this.mediaControl.play(this.playlist.trackFor(this.currentLocationName));
    }
}

