/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.example.timedcache;

import java.util.Calendar;
import java.util.Date;
import junit.framework.TestCase;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.api.ExpectationErrorTranslator;
import org.jmock.example.timedcache.Clock;
import org.jmock.example.timedcache.ObjectLoader;
import org.jmock.example.timedcache.ReloadPolicy;
import org.jmock.example.timedcache.TimedCache;
import org.jmock.integration.junit3.JUnit3ErrorTranslator;
import org.jmock.internal.ExpectationBuilder;

public class TimedCacheTests
extends TestCase {
    private final Object KEY = "key";
    private final Object VALUE = "value";
    private final Object NEW_VALUE = "newValue";
    private Mockery context = new Mockery(){
        {
            this.setExpectationErrorTranslator((ExpectationErrorTranslator)JUnit3ErrorTranslator.INSTANCE);
        }
    };
    private Clock clock = (Clock)this.context.mock(Clock.class);
    private ObjectLoader loader = (ObjectLoader)this.context.mock(ObjectLoader.class, "loader");
    private ReloadPolicy reloadPolicy = (ReloadPolicy)this.context.mock(ReloadPolicy.class);
    private TimedCache cache = new TimedCache(this.loader, this.clock, this.reloadPolicy);
    private Date loadTime = this.time(1);
    private Date fetchTime = this.time(2);

    public void testLoadsObjectThatIsNotCached() {
        final String VALUE1 = "value1";
        final String VALUE2 = "value2";
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Clock)this.allowing(TimedCacheTests.this.clock)).time();
                this.will(2.returnValue((Object)TimedCacheTests.this.loadTime));
                ((ObjectLoader)this.oneOf(TimedCacheTests.this.loader)).load("key1");
                this.will(2.returnValue((Object)VALUE1));
                ((ObjectLoader)this.oneOf(TimedCacheTests.this.loader)).load("key2");
                this.will(2.returnValue((Object)VALUE2));
            }
        });
        Object actualValue1 = this.cache.lookup("key1");
        Object actualValue2 = this.cache.lookup("key2");
        this.context.assertIsSatisfied();
        TimedCacheTests.assertEquals((String)"lookup with key1", (Object)VALUE1, (Object)actualValue1);
        TimedCacheTests.assertEquals((String)"lookup with key2", (Object)VALUE2, (Object)actualValue2);
    }

    public void testReturnsCachedObjectWithinTimeout() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Clock)this.oneOf(TimedCacheTests.this.clock)).time();
                this.will(3.returnValue((Object)TimedCacheTests.this.loadTime));
                ((Clock)this.oneOf(TimedCacheTests.this.clock)).time();
                this.will(3.returnValue((Object)TimedCacheTests.this.fetchTime));
                ((ReloadPolicy)this.allowing(TimedCacheTests.this.reloadPolicy)).shouldReload(TimedCacheTests.this.loadTime, TimedCacheTests.this.fetchTime);
                this.will(3.returnValue((Object)false));
                ((ObjectLoader)this.oneOf(TimedCacheTests.this.loader)).load(TimedCacheTests.this.KEY);
                this.will(3.returnValue((Object)TimedCacheTests.this.VALUE));
            }
        });
        Object actualValueFromFirstLookup = this.cache.lookup(this.KEY);
        Object actualValueFromSecondLookup = this.cache.lookup(this.KEY);
        this.context.assertIsSatisfied();
        TimedCacheTests.assertSame((String)"should be loaded object", (Object)this.VALUE, (Object)actualValueFromFirstLookup);
        TimedCacheTests.assertSame((String)"should be cached object", (Object)this.VALUE, (Object)actualValueFromSecondLookup);
    }

    public void testReloadsCachedObjectAfterTimeout() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ReloadPolicy)this.allowing(TimedCacheTests.this.reloadPolicy)).shouldReload(TimedCacheTests.this.loadTime, TimedCacheTests.this.fetchTime);
                this.will(4.returnValue((Object)true));
                ((Clock)this.oneOf(TimedCacheTests.this.clock)).time();
                this.will(4.returnValue((Object)TimedCacheTests.this.loadTime));
                ((ObjectLoader)this.oneOf(TimedCacheTests.this.loader)).load(TimedCacheTests.this.KEY);
                this.will(4.returnValue((Object)TimedCacheTests.this.VALUE));
                ((Clock)this.oneOf(TimedCacheTests.this.clock)).time();
                this.will(4.returnValue((Object)TimedCacheTests.this.fetchTime));
                ((ObjectLoader)this.oneOf(TimedCacheTests.this.loader)).load(TimedCacheTests.this.KEY);
                this.will(4.returnValue((Object)TimedCacheTests.this.NEW_VALUE));
            }
        });
        Object actualValueFromFirstLookup = this.cache.lookup(this.KEY);
        Object actualValueFromSecondLookup = this.cache.lookup(this.KEY);
        this.context.assertIsSatisfied();
        TimedCacheTests.assertSame((String)"should be loaded object", (Object)this.VALUE, (Object)actualValueFromFirstLookup);
        TimedCacheTests.assertSame((String)"should be reloaded object", (Object)this.NEW_VALUE, (Object)actualValueFromSecondLookup);
    }

    private Date time(int i) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(6, i);
        return calendar.getTime();
    }
}

