/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.example.sniper;

import org.jmock.Expectations;
import org.jmock.example.sniper.Auction;
import org.jmock.example.sniper.AuctionException;
import org.jmock.example.sniper.AuctionSniper;
import org.jmock.example.sniper.AuctionSniperListener;
import org.jmock.example.sniper.Money;
import org.jmock.integration.junit3.MockObjectTestCase;
import org.jmock.internal.ExpectationBuilder;

public class AuctionSniperTests
extends MockObjectTestCase {
    Money increment = new Money(2);
    Money maximumBid = new Money(20);
    Money beatableBid = new Money(10);
    Money unbeatableBid = this.maximumBid.add(new Money(1));
    Auction auction = (Auction)this.mock(Auction.class);
    AuctionSniperListener listener = (AuctionSniperListener)this.mock(AuctionSniperListener.class, "listener");
    AuctionSniper sniper = new AuctionSniper(this.auction, this.increment, this.maximumBid, this.listener);

    public void testTriesToBeatTheLatestHighestBid() throws Exception {
        final Money expectedBid = this.beatableBid.add(this.increment);
        this.checking((ExpectationBuilder)new Expectations(){
            {
                ((Auction)this.oneOf(AuctionSniperTests.this.auction)).bid(expectedBid);
            }
        });
        this.sniper.bidAccepted(this.auction, this.beatableBid);
    }

    public void testWillNotBidPriceGreaterThanMaximum() throws Exception {
        this.checking((ExpectationBuilder)new Expectations(){
            {
                this.ignoring(AuctionSniperTests.this.listener);
                ((Auction)this.never(AuctionSniperTests.this.auction)).bid((Money)this.with(2.any(Money.class)));
            }
        });
        this.sniper.bidAccepted(this.auction, this.unbeatableBid);
    }

    public void testWillLimitBidToMaximum() throws Throwable {
        this.checking((ExpectationBuilder)new Expectations(){
            {
                ((Auction)this.exactly(1).of((Object)AuctionSniperTests.this.auction)).bid(AuctionSniperTests.this.maximumBid);
            }
        });
        this.sniper.bidAccepted(this.auction, this.maximumBid.subtract(new Money(1)));
    }

    public void testWillNotBidWhenToldAboutBidsOnOtherItems() throws Throwable {
        final Auction otherLot = (Auction)this.mock(Auction.class, "otherLot");
        this.checking((ExpectationBuilder)new Expectations(){
            {
                ((Auction)this.never(otherLot)).bid(new Money(10));
            }
        });
        this.sniper.bidAccepted(otherLot, this.beatableBid);
    }

    public void testWillAnnounceItHasFinishedIfPriceGoesAboveMaximum() {
        this.checking((ExpectationBuilder)new Expectations(){
            {
                ((AuctionSniperListener)this.exactly(1).of((Object)AuctionSniperTests.this.listener)).sniperFinished(AuctionSniperTests.this.sniper);
            }
        });
        this.sniper.bidAccepted(this.auction, this.unbeatableBid);
    }

    public void testCatchesExceptionsAndReportsThemToErrorListener() throws Exception {
        final AuctionException exception = new AuctionException("test");
        this.checking((ExpectationBuilder)new Expectations(){
            {
                ((Auction)this.allowing(AuctionSniperTests.this.auction)).bid((Money)this.with(6.any(Money.class)));
                this.will(6.throwException((Throwable)exception));
                ((AuctionSniperListener)this.exactly(1).of((Object)AuctionSniperTests.this.listener)).sniperBidFailed(AuctionSniperTests.this.sniper, exception);
            }
        });
        this.sniper.bidAccepted(this.auction, this.beatableBid);
    }
}

