/*
 * Decompiled with CFR 0.152.
 */
package org.jmailen.gradle.kotlinter.tasks;

import java.io.File;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jmailen.gradle.kotlinter.support.VersionProperties;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0007R\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\t\u001a\u00020\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u00038gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000bR\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000bR\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\b\u00a8\u0006\u001a"}, d2={"Lorg/jmailen/gradle/kotlinter/tasks/InstallHookTask;", "Lorg/gradle/api/DefaultTask;", "hookFileName", "", "(Ljava/lang/String;)V", "gitDirPath", "Lorg/gradle/api/provider/Property;", "getGitDirPath", "()Lorg/gradle/api/provider/Property;", "gradleCommand", "getGradleCommand", "()Ljava/lang/String;", "gradleCommand$delegate", "Lkotlin/Lazy;", "hookContent", "getHookContent", "getHookFileName", "rootProjectDir", "Ljava/io/File;", "getRootProjectDir", "getHookFile", "warn", "", "run", "", "Companion", "kotlinter-gradle"})
public abstract class InstallHookTask
extends DefaultTask {
    @Input
    @NotNull
    private final Property<String> gitDirPath;
    @Input
    @NotNull
    private final Property<File> rootProjectDir;
    private final Lazy gradleCommand$delegate;
    @NotNull
    private final String hookFileName;
    private static final String version;
    @NotNull
    public static final String startHook = "\n##### KOTLINTER HOOK START #####";
    @NotNull
    private static final String hookVersion;
    @NotNull
    public static final String endHook = "##### KOTLINTER HOOK END #####\n";
    @NotNull
    private static final String shebang;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final Property<String> getGitDirPath() {
        return this.gitDirPath;
    }

    @NotNull
    public final Property<File> getRootProjectDir() {
        return this.rootProjectDir;
    }

    @Internal
    @NotNull
    public abstract String getHookContent();

    @TaskAction
    public final void run() {
        File file = this.getHookFile(true);
        if (file == null) {
            return;
        }
        File hookFile = file;
        String hookFileContent = FilesKt.readText$default((File)hookFile, null, (int)1, null);
        CharSequence charSequence = hookFileContent;
        if (charSequence.length() == 0) {
            this.getLogger().info("creating hook file: " + hookFile);
            FilesKt.writeText$default((File)hookFile, (String)org.jmailen.gradle.kotlinter.tasks.InstallHookTask$Companion.generateHook$kotlinter_gradle$default(Companion, this.getGradleCommand(), this.getHookContent(), true, false, 8, null), null, (int)2, null);
        } else {
            int startIndex = StringsKt.indexOf$default((CharSequence)hookFileContent, (String)startHook, (int)0, (boolean)false, (int)6, null);
            if (startIndex == -1) {
                this.getLogger().info("adding hook to file: " + hookFile);
                FilesKt.appendText$default((File)hookFile, (String)org.jmailen.gradle.kotlinter.tasks.InstallHookTask$Companion.generateHook$kotlinter_gradle$default(Companion, this.getGradleCommand(), this.getHookContent(), false, false, 12, null), null, (int)2, null);
            } else {
                this.getLogger().info("replacing hook in file: " + hookFile);
                int endIndex = StringsKt.indexOf$default((CharSequence)hookFileContent, (String)endHook, (int)0, (boolean)false, (int)6, null);
                String string = hookFileContent;
                CharSequence charSequence2 = org.jmailen.gradle.kotlinter.tasks.InstallHookTask$Companion.generateHook$kotlinter_gradle$default(Companion, this.getGradleCommand(), this.getHookContent(), false, false, 4, null);
                String newHookFileContent = ((Object)StringsKt.replaceRange((CharSequence)string, (int)startIndex, (int)endIndex, (CharSequence)charSequence2)).toString();
                FilesKt.writeText$default((File)hookFile, (String)newHookFileContent, null, (int)2, null);
            }
        }
        this.getLogger().quiet("Wrote hook to " + hookFile);
    }

    private final File getHookFile(boolean warn) {
        File file;
        File gitDir = new File((File)this.rootProjectDir.get(), (String)this.gitDirPath.get());
        if (!gitDir.isDirectory()) {
            if (warn) {
                this.getLogger().warn("skipping hook creation because " + gitDir + " is not a directory");
            }
            return null;
        }
        try {
            File file2;
            File $this$apply = file2 = new File(gitDir, "hooks");
            boolean bl = false;
            $this$apply.mkdirs();
            File hooksDir = file2;
            $this$apply = file2 = new File(hooksDir, this.hookFileName);
            boolean bl2 = false;
            boolean cfr_ignored_0 = $this$apply.createNewFile() & $this$apply.setExecutable(true);
            file = file2;
        }
        catch (Exception e) {
            if (warn) {
                this.getLogger().warn("skipping hook creation because could not create hook under " + gitDir + ": " + e.getMessage());
            }
            file = null;
        }
        return file;
    }

    static /* synthetic */ File getHookFile$default(InstallHookTask installHookTask, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getHookFile");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        return installHookTask.getHookFile(bl);
    }

    private final String getGradleCommand() {
        Lazy lazy = this.gradleCommand$delegate;
        InstallHookTask installHookTask = this;
        Object var3_3 = null;
        return (String)lazy.getValue();
    }

    @Internal
    @NotNull
    public final String getHookFileName() {
        return this.hookFileName;
    }

    public InstallHookTask(@NotNull String hookFileName) {
        ObjectFactory $this$property$iv;
        Property property;
        Intrinsics.checkNotNullParameter((Object)hookFileName, (String)"hookFileName");
        this.hookFileName = hookFileName;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        ObjectFactory objectFactory = project.getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"project.objects");
        ObjectFactory objectFactory2 = objectFactory;
        Object default$iv = ".git";
        boolean $i$f$property = false;
        Property $this$apply$iv = property = $this$property$iv.property(String.class);
        boolean bl = false;
        $this$apply$iv.set(default$iv);
        Property property2 = property;
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"property(T::class.java).\u2026       set(default)\n    }");
        this.gitDirPath = property2;
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        ObjectFactory objectFactory3 = project2.getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory3, (String)"project.objects");
        $this$property$iv = objectFactory3;
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
        Project project4 = project3.getRootProject();
        Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"project.rootProject");
        default$iv = project4.getRootDir();
        $i$f$property = false;
        $this$apply$iv = property = $this$property$iv.property(File.class);
        bl = false;
        $this$apply$iv.set(default$iv);
        Property property3 = property;
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"property(T::class.java).\u2026       set(default)\n    }");
        this.rootProjectDir = property3;
        this.getOutputs().upToDateWhen(new Spec(){

            public final boolean isSatisfiedBy(Task it) {
                Object object = InstallHookTask.getHookFile$default(this, false, 1, null);
                return object != null && (object = FilesKt.readText$default((File)object, null, (int)1, null)) != null ? StringsKt.contains$default((CharSequence)((CharSequence)object), (CharSequence)Companion.getHookVersion$kotlinter_gradle(), (boolean)false, (int)2, null) : false;
            }
        });
        this.gradleCommand$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ InstallHookTask this$0;

            @NotNull
            public final String invoke() {
                String string;
                String string2 = System.getProperty("os.name");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"System.getProperty(\"os.name\")");
                String gradlewFilename = StringsKt.contains((CharSequence)string2, (CharSequence)"win", (boolean)true) ? "gradlew.bat" : "gradlew";
                File gradlew = new File((File)this.this$0.getRootProjectDir().get(), gradlewFilename);
                if (gradlew.exists() && gradlew.isFile() && gradlew.canExecute()) {
                    this.this$0.getLogger().info("Using gradlew wrapper at " + FilesKt.getInvariantSeparatorsPath((File)gradlew));
                    string = FilesKt.getInvariantSeparatorsPath((File)gradlew);
                } else {
                    string = "gradle";
                }
                return string;
            }
            {
                this.this$0 = installHookTask;
                super(0);
            }
        }));
    }

    static {
        Companion = new Companion(null);
        version = new VersionProperties().version();
        hookVersion = "##### KOTLINTER " + version + " #####";
        shebang = "#!/bin/sh\nset -e";
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J1\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jmailen/gradle/kotlinter/tasks/InstallHookTask$Companion;", "", "()V", "endHook", "", "hookVersion", "getHookVersion$kotlinter_gradle", "()Ljava/lang/String;", "shebang", "getShebang$kotlinter_gradle", "startHook", "version", "generateHook", "gradlew", "hookContent", "addShebang", "", "includeEndHook", "generateHook$kotlinter_gradle", "kotlinter-gradle"})
    public static final class Companion {
        @NotNull
        public final String getHookVersion$kotlinter_gradle() {
            return hookVersion;
        }

        @NotNull
        public final String getShebang$kotlinter_gradle() {
            return shebang;
        }

        @NotNull
        public final String generateHook$kotlinter_gradle(@NotNull String gradlew, @NotNull String hookContent, boolean addShebang, boolean includeEndHook) {
            Intrinsics.checkNotNullParameter((Object)gradlew, (String)"gradlew");
            Intrinsics.checkNotNullParameter((Object)hookContent, (String)"hookContent");
            return (addShebang ? this.getShebang$kotlinter_gradle() : "") + StringsKt.trimMargin$default((String)("\n                |\n##### KOTLINTER HOOK START #####\n                |" + this.getHookVersion$kotlinter_gradle() + "\n                |GRADLEW=" + gradlew + "\n                |" + hookContent + "\n                |" + (includeEndHook ? InstallHookTask.endHook : "") + "\n            "), null, (int)1, null);
        }

        public static /* synthetic */ String generateHook$kotlinter_gradle$default(Companion companion, String string, String string2, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            if ((n & 8) != 0) {
                bl2 = true;
            }
            return companion.generateHook$kotlinter_gradle(string, string2, bl, bl2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

