/*
 * Decompiled with CFR 0.152.
 */
package org.jmailen.gradle.kotlinter.support;

import com.pinterest.ktlint.core.Reporter;
import com.pinterest.ktlint.reporter.checkstyle.CheckStyleReporter;
import com.pinterest.ktlint.reporter.html.HtmlReporter;
import com.pinterest.ktlint.reporter.json.JsonReporter;
import com.pinterest.ktlint.reporter.plain.PlainReporter;
import com.pinterest.ktlint.reporter.sarif.SarifReporter;
import java.io.File;
import java.io.PrintStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jmailen.gradle.kotlinter.support.ReporterType;
import org.jmailen.gradle.kotlinter.support.ReportersKt$WhenMappings;
import org.jmailen.gradle.kotlinter.support.SortedThreadSafeReporterWrapper;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006\u00a8\u0006\n"}, d2={"reporterFileExtension", "", "reporterName", "reporterFor", "Lcom/pinterest/ktlint/core/Reporter;", "output", "Ljava/io/File;", "reporterPathFor", "reporter", "projectDir", "kotlinter-gradle"})
public final class ReportersKt {
    @NotNull
    public static final Reporter reporterFor(@NotNull String reporterName, @NotNull File output) {
        Reporter reporter;
        Intrinsics.checkNotNullParameter((Object)reporterName, (String)"reporterName");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        PrintStream out = new PrintStream(output);
        switch (ReportersKt$WhenMappings.$EnumSwitchMapping$0[ReporterType.valueOf(reporterName).ordinal()]) {
            case 1: {
                reporter = (Reporter)new CheckStyleReporter(out);
                break;
            }
            case 2: {
                reporter = (Reporter)new HtmlReporter(out);
                break;
            }
            case 3: {
                reporter = (Reporter)new JsonReporter(out);
                break;
            }
            case 4: {
                reporter = (Reporter)new PlainReporter(out, false, false, false, null, false, 62, null);
                break;
            }
            case 5: {
                reporter = (Reporter)new SarifReporter(out);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return new SortedThreadSafeReporterWrapper(reporter);
    }

    @NotNull
    public static final String reporterPathFor(@NotNull Reporter reporter, @NotNull File output, @NotNull File projectDir) {
        String string;
        SortedThreadSafeReporterWrapper unwrappedReporter;
        SortedThreadSafeReporterWrapper sortedThreadSafeReporterWrapper;
        SortedThreadSafeReporterWrapper sortedThreadSafeReporterWrapper2;
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        Reporter reporter2 = reporter;
        if (!(reporter2 instanceof SortedThreadSafeReporterWrapper)) {
            reporter2 = null;
        }
        if ((sortedThreadSafeReporterWrapper2 = (SortedThreadSafeReporterWrapper)reporter2) == null || (sortedThreadSafeReporterWrapper2 = sortedThreadSafeReporterWrapper2.unwrap()) == null) {
            sortedThreadSafeReporterWrapper2 = reporter;
        }
        if ((sortedThreadSafeReporterWrapper = (unwrappedReporter = sortedThreadSafeReporterWrapper2)) instanceof SarifReporter) {
            String string2 = output.getAbsolutePath();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"output.absolutePath");
        } else {
            string = FilesKt.toRelativeString((File)output, (File)projectDir);
        }
        return string;
    }

    @NotNull
    public static final String reporterFileExtension(@NotNull String reporterName) {
        Intrinsics.checkNotNullParameter((Object)reporterName, (String)"reporterName");
        return ReporterType.valueOf(reporterName).getFileExtension();
    }
}

