/*
 * Decompiled with CFR 0.152.
 */
package org.jline.curses.impl;

import java.util.HashMap;
import java.util.Map;
import org.jline.curses.Curses;
import org.jline.curses.Screen;
import org.jline.curses.Theme;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.StyleResolver;

public class DefaultTheme
implements Theme {
    private final Map<String, String> styles = new HashMap<String, String>();
    private final StyleResolver resolver = new StyleResolver(this.styles::get);
    private final Map<Curses.Border, String> boxChars = new HashMap<Curses.Border, String>();
    private static final int TOP_LEFT = 0;
    private static final int TOP = 1;
    private static final int TOP_RIGHT = 2;
    private static final int LEFT = 3;
    private static final int CENTER = 4;
    private static final int RIGHT = 5;
    private static final int BOTTOM_LEFT = 6;
    private static final int BOTTOM = 7;
    private static final int BOTTOM_RIGHT = 8;

    public DefaultTheme() {
        this.styles.put("menu.text.normal", "fg:!white,bg:cyan");
        this.styles.put("menu.key.normal", "fg:!yellow,bg:cyan");
        this.styles.put("menu.text.selected", "fg:!white,bg:black");
        this.styles.put("menu.key.selected", "fg:!yellow,bg:black");
        this.styles.put("menu.border", "fg:!white,bg:cyan");
        this.styles.put("background", "bg:blue,fg:black");
        this.styles.put("window.border", "bg:white,fg:black");
        this.styles.put("window.border.back", "bg:white,fg:black");
        this.styles.put("window.border.light", "bg:white,fg:white");
        this.styles.put("window.title", "bg:white,fg:black");
        this.styles.put("window.shadow", "bg:black,fg:black");
        this.styles.put("window.close", "bg:white,fg:black");
        this.styles.put("box.chars.double", "\u2554\u2550\u2557\u2551 \u2551\u255a\u2550\u255d");
        this.styles.put("box.chars.single", "\u250c\u2500\u2510\u2502 \u2502\u2514\u2500\u2518");
        this.styles.put("sep.chars.horz.double.double", "\u2560\u2550\u2563");
        this.styles.put("sep.chars.horz.double.single", "\u255e\u2550\u2561");
        this.styles.put("sep.chars.horz.single.single", "\u251c\u2500\u2524");
        this.styles.put("sep.chars.horz.single.double", "\u255f\u2500\u2562");
    }

    @Override
    public AttributedStyle getStyle(String spec) {
        return this.resolver.resolve(spec);
    }

    @Override
    public void separatorH(Screen screen, int x, int y, int w, Curses.Border sepBorder, Curses.Border boxBorder, AttributedStyle style) {
        String chars = this.styles.get("sep.chars.horz." + this.sord(sepBorder) + "." + this.sord(boxBorder));
        AttributedString sb = this.createBoxString(chars, w, style, 0, style, 1, style, 2);
        screen.text(x, y, sb);
    }

    String sord(Curses.Border border) {
        switch (border) {
            case Double: 
            case DoubleBevel: {
                return "double";
            }
        }
        return "single";
    }

    @Override
    public void box(Screen screen, int x, int y, int w, int h, Curses.Border border, String style) {
        String chars;
        if (w <= 0 || h <= 0) {
            return;
        }
        AttributedStyle nst = this.getStyle(style);
        AttributedStyle bst = this.getStyle(style + ".back");
        AttributedStyle hst = nst;
        switch (border) {
            case DoubleBevel: {
                hst = this.getStyle(style + ".light");
            }
            case Double: {
                chars = this.styles.get("box.chars.double");
                break;
            }
            case SingleBevel: {
                hst = this.getStyle(style + ".light");
            }
            case Single: {
                chars = this.styles.get("box.chars.single");
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        AttributedString top = this.createBoxString(chars, w, hst, 0, hst, 1, nst, 2);
        AttributedString mid = this.createBoxString(chars, w, hst, 3, bst, 4, nst, 5);
        AttributedString bot = this.createBoxString(chars, w, hst, 6, nst, 7, nst, 8);
        screen.text(x, y, top);
        for (int j = y + 1; j < y + h - 1; ++j) {
            screen.text(x, j, mid);
        }
        screen.text(x, y + h - 1, bot);
    }

    private AttributedString createBoxString(String chars, int w, AttributedStyle s0, int c0, AttributedStyle s1, int c1, AttributedStyle s2, int c2) {
        AttributedStringBuilder sb = new AttributedStringBuilder(w);
        sb.style(s0);
        sb.append(chars.charAt(c0));
        sb.style(s1);
        for (int i = 0; i < w - 2; ++i) {
            sb.append(chars.charAt(c1));
        }
        sb.style(s2);
        sb.append(chars.charAt(c2));
        return sb.toAttributedString();
    }
}

