/*
 * Decompiled with CFR 0.152.
 */
package org.jline.curses.impl;

import java.util.EnumSet;
import org.jline.curses.Component;
import org.jline.curses.Curses;
import org.jline.curses.GUI;
import org.jline.curses.Position;
import org.jline.curses.Renderer;
import org.jline.curses.Screen;
import org.jline.curses.Size;
import org.jline.curses.Window;
import org.jline.curses.impl.AbstractComponent;
import org.jline.terminal.MouseEvent;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStyle;

public abstract class AbstractWindow
extends AbstractComponent
implements Window {
    private String title;
    private Component component;
    private GUI gui;
    private AbstractComponent focused;

    public AbstractWindow() {
        this(null, null);
    }

    public AbstractWindow(String title) {
        this(title, null);
    }

    public AbstractWindow(String title, Component component) {
        this.title = title;
        this.component = component;
        this.setBehaviors(EnumSet.of(Component.Behavior.CloseButton));
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public void setComponent(Component component) {
        ((AbstractComponent)component).setParent(this);
        this.component = component;
    }

    @Override
    public GUI getGUI() {
        return this.gui;
    }

    public void setGUI(GUI gui) {
        this.gui = gui;
    }

    @Override
    public void setSize(Size size) {
        super.setSize(size);
        if (this.component != null) {
            this.component.setPosition(this.getRenderer().getComponentOffset());
            this.component.setSize(this.getRenderer().getComponentSize(size));
        }
    }

    @Override
    public Size getPreferredSize() {
        return this.component != null ? this.component.getPreferredSize() : new Size(0, 0);
    }

    @Override
    public void focus(Component component) {
        AbstractComponent c = (AbstractComponent)component;
        if (c != null && c.getWindow() != this) {
            throw new IllegalStateException();
        }
        if (this.focused != c) {
            if (this.focused != null) {
                this.focused.focused(false);
            }
            this.focused = c;
            if (this.focused != null) {
                this.focused.focused(true);
            }
        }
    }

    @Override
    public WindowRenderer getRenderer() {
        return (WindowRenderer)super.getRenderer();
    }

    @Override
    public void setRenderer(Renderer renderer) {
        super.setRenderer((WindowRenderer)renderer);
    }

    @Override
    protected WindowRenderer getDefaultRenderer() {
        return new WindowRenderer(){

            @Override
            public void draw(Screen screen, Component window) {
                ((AbstractWindow)window).doDraw(screen);
            }

            @Override
            public Size getPreferredSize(Component window) {
                return ((AbstractWindow)window).doGetPreferredSize();
            }

            @Override
            public Position getComponentOffset() {
                return new Position(1, 1);
            }

            @Override
            public Size getComponentSize(Size box) {
                return new Size(Math.max(0, box.w() - 2), Math.max(0, box.h() - 2));
            }
        };
    }

    @Override
    public void handleInput(String input) {
        if (input.contains("q")) {
            this.close();
        }
    }

    @Override
    public void handleMouse(MouseEvent event) {
        if (this.component != null && this.component.isIn(event.getX(), event.getY())) {
            this.component.handleMouse(event);
            return;
        }
        if (this.getBehaviors().contains((Object)Component.Behavior.CloseButton) && !this.getBehaviors().contains((Object)Component.Behavior.NoDecoration)) {
            Position pos = this.getScreenPosition();
            if (event.getX() == pos.x() + this.getSize().w() - 2 && event.getY() == pos.y()) {
                this.close();
            }
        }
    }

    @Override
    public void close() {
        GUI gui = this.getGUI();
        if (gui != null) {
            gui.removeWindow(this);
        }
    }

    @Override
    protected void doDraw(Screen screen) {
        Position pos = this.getScreenPosition();
        if (this.getBehaviors().contains((Object)Component.Behavior.NoDecoration)) {
            AttributedStyle st = this.getTheme().getStyle(".window.border");
            screen.fill(pos.x(), pos.y(), this.getSize().w(), this.getSize().h(), st);
        } else {
            screen.fill(pos.x() + 2, pos.y() + 1, this.getSize().w(), this.getSize().h(), this.getTheme().getStyle(".window.shadow"));
            this.getTheme().box(screen, pos.x(), pos.y(), this.getSize().w(), this.getSize().h(), Curses.Border.Double, ".window.border");
            if (this.getBehaviors().contains((Object)Component.Behavior.CloseButton)) {
                screen.text(pos.x() + this.getSize().w() - 2, pos.y(), new AttributedString((CharSequence)"x", this.getTheme().getStyle(".window.close")));
            }
            if (this.title != null) {
                screen.text(pos.x() + 3, pos.y(), new AttributedString((CharSequence)this.title, this.getTheme().getStyle(".window.title")));
            }
            if (this.component != null) {
                this.component.draw(screen);
            }
        }
    }

    @Override
    protected Size doGetPreferredSize() {
        Size sz = this.getComponent().getPreferredSize();
        if (this.getBehaviors().contains((Object)Component.Behavior.NoDecoration)) {
            return sz;
        }
        return new Size(sz.w() + 2, sz.h() + 2);
    }

    public static interface WindowRenderer
    extends Renderer {
        public Position getComponentOffset();

        public Size getComponentSize(Size var1);
    }
}

