/*
 * Decompiled with CFR 0.152.
 */
package net.java.otr4j.session;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.KeyPair;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.interfaces.DHPublicKey;
import net.java.otr4j.OtrException;
import net.java.otr4j.crypto.OtrCryptoEngineImpl;
import net.java.otr4j.io.SerializationUtils;
import net.java.otr4j.session.SessionKeys;

class SessionKeysImpl
implements SessionKeys {
    private static final Logger logger = Logger.getLogger(SessionKeysImpl.class.getName());
    private final String keyDescription;
    private final byte[] sendingCtr = new byte[16];
    private final byte[] receivingCtr = new byte[16];
    private int localKeyID;
    private int remoteKeyID;
    private DHPublicKey remoteKey;
    private KeyPair localPair;
    private byte[] sendingAESKey;
    private byte[] receivingAESKey;
    private byte[] sendingMACKey;
    private byte[] receivingMACKey;
    private Boolean isUsedReceivingMACKey;
    private BigInteger s;
    private Boolean isHigh;

    SessionKeysImpl(int localKeyIndex, int remoteKeyIndex) {
        String tmpKeyDescription = localKeyIndex == 0 ? "(Previous local, " : "(Most recent local, ";
        tmpKeyDescription = remoteKeyIndex == 0 ? tmpKeyDescription + "Previous remote)" : tmpKeyDescription + "Most recent remote)";
        this.keyDescription = tmpKeyDescription;
    }

    @Override
    public void setLocalPair(KeyPair keyPair, int localPairKeyID) {
        this.localPair = keyPair;
        this.setLocalKeyID(localPairKeyID);
        logger.log(Level.FINEST, "{0} current local key ID: {1}", new Object[]{this.keyDescription, this.getLocalKeyID()});
        this.reset();
    }

    @Override
    public void setRemoteDHPublicKey(DHPublicKey pubKey, int remoteKeyID) {
        this.setRemoteKey(pubKey);
        this.setRemoteKeyID(remoteKeyID);
        logger.log(Level.FINEST, "{0} current remote key ID: {1}", new Object[]{this.keyDescription, this.getRemoteKeyID()});
        this.reset();
    }

    @Override
    public void incrementSendingCtr() {
        logger.log(Level.FINEST, "Incrementing counter for (localkeyID, remoteKeyID) = ({0},{1})", new Object[]{this.getLocalKeyID(), this.getRemoteKeyID()});
        int i = 7;
        while (i >= 0) {
            int n = i--;
            this.sendingCtr[n] = (byte)(this.sendingCtr[n] + 1);
            if (this.sendingCtr[n] != 0) break;
        }
    }

    @Override
    public byte[] getSendingCtr() {
        return this.sendingCtr;
    }

    @Override
    public byte[] getReceivingCtr() {
        return this.receivingCtr;
    }

    @Override
    public void setReceivingCtr(byte[] ctr) {
        System.arraycopy(ctr, 0, this.receivingCtr, 0, ctr.length);
    }

    private void reset() {
        logger.log(Level.FINEST, "Resetting {0} session keys.", this.keyDescription);
        Arrays.fill(this.sendingCtr, (byte)0);
        Arrays.fill(this.receivingCtr, (byte)0);
        this.sendingAESKey = null;
        this.receivingAESKey = null;
        this.sendingMACKey = null;
        this.receivingMACKey = null;
        this.setIsUsedReceivingMACKey(false);
        this.s = null;
        if (this.getLocalPair() != null && this.getRemoteKey() != null) {
            this.isHigh = ((DHPublicKey)this.getLocalPair().getPublic()).getY().abs().compareTo(this.getRemoteKey().getY().abs()) == 1;
        }
    }

    private byte[] h1(byte b) throws OtrException {
        try {
            byte[] secbytes = SerializationUtils.writeMpi(this.getS());
            int len = secbytes.length + 1;
            ByteBuffer buff = ByteBuffer.allocate(len);
            buff.put(b);
            buff.put(secbytes);
            byte[] result = new OtrCryptoEngineImpl().sha1Hash(buff.array());
            return result;
        }
        catch (IOException e) {
            throw new OtrException(e);
        }
    }

    @Override
    public byte[] getSendingAESKey() throws OtrException {
        if (this.sendingAESKey != null) {
            return this.sendingAESKey;
        }
        byte sendbyte = 2;
        if (this.isHigh.booleanValue()) {
            sendbyte = 1;
        }
        byte[] h1 = this.h1(sendbyte);
        byte[] key = new byte[16];
        ByteBuffer buff = ByteBuffer.wrap(h1);
        buff.get(key);
        logger.finest("Calculated sending AES key.");
        this.sendingAESKey = key;
        return this.sendingAESKey;
    }

    @Override
    public byte[] getReceivingAESKey() throws OtrException {
        if (this.receivingAESKey != null) {
            return this.receivingAESKey;
        }
        byte receivebyte = 1;
        if (this.isHigh.booleanValue()) {
            receivebyte = 2;
        }
        byte[] h1 = this.h1(receivebyte);
        byte[] key = new byte[16];
        ByteBuffer buff = ByteBuffer.wrap(h1);
        buff.get(key);
        logger.finest("Calculated receiving AES key.");
        this.receivingAESKey = key;
        return this.receivingAESKey;
    }

    @Override
    public byte[] getSendingMACKey() throws OtrException {
        if (this.sendingMACKey != null) {
            return this.sendingMACKey;
        }
        this.sendingMACKey = new OtrCryptoEngineImpl().sha1Hash(this.getSendingAESKey());
        logger.finest("Calculated sending MAC key.");
        return this.sendingMACKey;
    }

    @Override
    public byte[] getReceivingMACKey() throws OtrException {
        if (this.receivingMACKey == null) {
            this.receivingMACKey = new OtrCryptoEngineImpl().sha1Hash(this.getReceivingAESKey());
            logger.finest("Calculated receiving AES key.");
        }
        return this.receivingMACKey;
    }

    private BigInteger getS() throws OtrException {
        if (this.s == null) {
            this.s = new OtrCryptoEngineImpl().generateSecret(this.getLocalPair().getPrivate(), this.getRemoteKey());
            logger.finest("Calculating shared secret S.");
        }
        return this.s;
    }

    @Override
    public void setS(BigInteger s) {
        this.s = s;
    }

    @Override
    public void setIsUsedReceivingMACKey(Boolean isUsedReceivingMACKey) {
        this.isUsedReceivingMACKey = isUsedReceivingMACKey;
    }

    @Override
    public Boolean getIsUsedReceivingMACKey() {
        return this.isUsedReceivingMACKey;
    }

    private void setLocalKeyID(int localKeyID) {
        this.localKeyID = localKeyID;
    }

    @Override
    public int getLocalKeyID() {
        return this.localKeyID;
    }

    private void setRemoteKeyID(int remoteKeyID) {
        this.remoteKeyID = remoteKeyID;
    }

    @Override
    public int getRemoteKeyID() {
        return this.remoteKeyID;
    }

    private void setRemoteKey(DHPublicKey remoteKey) {
        this.remoteKey = remoteKey;
    }

    @Override
    public DHPublicKey getRemoteKey() {
        return this.remoteKey;
    }

    @Override
    public KeyPair getLocalPair() {
        return this.localPair;
    }
}

