/*
 * Decompiled with CFR 0.152.
 */
package net.java.otr4j.session;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.ProtocolException;
import java.nio.ByteBuffer;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.interfaces.DHPublicKey;
import net.java.otr4j.OtrEngineHost;
import net.java.otr4j.OtrEngineListener;
import net.java.otr4j.OtrException;
import net.java.otr4j.OtrPolicy;
import net.java.otr4j.crypto.OtrCryptoEngineImpl;
import net.java.otr4j.io.OtrInputStream;
import net.java.otr4j.io.OtrOutputStream;
import net.java.otr4j.io.SerializationUtils;
import net.java.otr4j.io.messages.AbstractEncodedMessage;
import net.java.otr4j.io.messages.AbstractMessage;
import net.java.otr4j.io.messages.DHCommitMessage;
import net.java.otr4j.io.messages.DataMessage;
import net.java.otr4j.io.messages.ErrorMessage;
import net.java.otr4j.io.messages.MysteriousT;
import net.java.otr4j.io.messages.PlainTextMessage;
import net.java.otr4j.io.messages.QueryMessage;
import net.java.otr4j.session.AuthContext;
import net.java.otr4j.session.AuthContextImpl;
import net.java.otr4j.session.InstanceTag;
import net.java.otr4j.session.OfferStatus;
import net.java.otr4j.session.OtrAssembler;
import net.java.otr4j.session.OtrFragmenter;
import net.java.otr4j.session.OtrSm;
import net.java.otr4j.session.Session;
import net.java.otr4j.session.SessionID;
import net.java.otr4j.session.SessionKeys;
import net.java.otr4j.session.SessionKeysImpl;
import net.java.otr4j.session.SessionStatus;
import net.java.otr4j.session.TLV;
import net.java.otr4j.session.UnknownInstanceException;
import net.java.otr4j.util.SelectableMap;

public class SessionImpl
implements Session {
    private final SelectableMap<InstanceTag, SessionImpl> slaveSessions;
    private final boolean isMasterSession;
    private SessionID sessionID;
    private OtrEngineHost host;
    private SessionStatus sessionStatus;
    private AuthContext authContext;
    private SessionKeys[][] sessionKeys;
    private List<byte[]> oldMacKeys;
    private static final Logger logger = Logger.getLogger(SessionImpl.class.getName());
    private final OtrSm otrSm;
    private BigInteger ess;
    private OfferStatus offerStatus;
    private final InstanceTag senderTag;
    private InstanceTag receiverInstanceTag;
    private int protocolVersion;
    private final OtrAssembler assembler;
    private final OtrFragmenter fragmenter;
    private final List<OtrEngineListener> listeners = new ArrayList<OtrEngineListener>();
    private PublicKey remotePublicKey;

    public SessionImpl(SessionID sessionID, OtrEngineHost listener) {
        this.setSessionID(sessionID);
        this.setHost(listener);
        this.sessionStatus = SessionStatus.PLAINTEXT;
        this.offerStatus = OfferStatus.idle;
        this.otrSm = new OtrSm(this, listener);
        this.senderTag = new InstanceTag();
        this.receiverInstanceTag = InstanceTag.ZERO_TAG;
        this.slaveSessions = new SelectableMap(new HashMap());
        this.isMasterSession = true;
        this.assembler = new OtrAssembler(this.getSenderInstanceTag());
        this.fragmenter = new OtrFragmenter(this, listener);
    }

    private SessionImpl(SessionID sessionID, OtrEngineHost listener, InstanceTag senderTag, InstanceTag receiverInstanceTag) {
        this.setSessionID(sessionID);
        this.setHost(listener);
        this.sessionStatus = SessionStatus.PLAINTEXT;
        this.offerStatus = OfferStatus.idle;
        this.otrSm = new OtrSm(this, listener);
        this.senderTag = senderTag;
        this.receiverInstanceTag = receiverInstanceTag;
        this.slaveSessions = new SelectableMap(Collections.emptyMap());
        this.isMasterSession = false;
        this.protocolVersion = 3;
        this.assembler = new OtrAssembler(this.getSenderInstanceTag());
        this.fragmenter = new OtrFragmenter(this, listener);
    }

    @Override
    public BigInteger getS() {
        return this.ess;
    }

    private SessionKeys getEncryptionSessionKeys() {
        logger.finest("Getting encryption keys");
        return this.getSessionKeysByIndex(0, 1);
    }

    private SessionKeys getMostRecentSessionKeys() {
        logger.finest("Getting most recent keys.");
        return this.getSessionKeysByIndex(1, 1);
    }

    private SessionKeys getSessionKeysByID(int localKeyID, int remoteKeyID) {
        logger.log(Level.FINEST, "Searching for session keys with (localKeyID, remoteKeyID) = ({0},{1})", new Object[]{localKeyID, remoteKeyID});
        for (int i = 0; i < this.getSessionKeys().length; ++i) {
            for (int j = 0; j < this.getSessionKeys()[i].length; ++j) {
                SessionKeys current = this.getSessionKeysByIndex(i, j);
                if (current.getLocalKeyID() != localKeyID || current.getRemoteKeyID() != remoteKeyID) continue;
                logger.finest("Matching keys found.");
                return current;
            }
        }
        return null;
    }

    private SessionKeys getSessionKeysByIndex(int localKeyIndex, int remoteKeyIndex) {
        if (this.getSessionKeys()[localKeyIndex][remoteKeyIndex] == null) {
            this.getSessionKeys()[localKeyIndex][remoteKeyIndex] = new SessionKeysImpl(localKeyIndex, remoteKeyIndex);
        }
        return this.getSessionKeys()[localKeyIndex][remoteKeyIndex];
    }

    private void rotateRemoteSessionKeys(DHPublicKey pubKey) throws OtrException {
        SessionKeys sess2;
        logger.finest("Rotating remote keys.");
        SessionKeys sess1 = this.getSessionKeysByIndex(1, 0);
        if (sess1.getIsUsedReceivingMACKey().booleanValue()) {
            logger.finest("Detected used Receiving MAC key. Adding to old MAC keys to reveal it.");
            this.getOldMacKeys().add(sess1.getReceivingMACKey());
        }
        if ((sess2 = this.getSessionKeysByIndex(0, 0)).getIsUsedReceivingMACKey().booleanValue()) {
            logger.finest("Detected used Receiving MAC key. Adding to old MAC keys to reveal it.");
            this.getOldMacKeys().add(sess2.getReceivingMACKey());
        }
        SessionKeys sess3 = this.getSessionKeysByIndex(1, 1);
        sess1.setRemoteDHPublicKey(sess3.getRemoteKey(), sess3.getRemoteKeyID());
        SessionKeys sess4 = this.getSessionKeysByIndex(0, 1);
        sess2.setRemoteDHPublicKey(sess4.getRemoteKey(), sess4.getRemoteKeyID());
        sess3.setRemoteDHPublicKey(pubKey, sess3.getRemoteKeyID() + 1);
        sess4.setRemoteDHPublicKey(pubKey, sess4.getRemoteKeyID() + 1);
    }

    private void rotateLocalSessionKeys() throws OtrException {
        SessionKeys sess2;
        logger.finest("Rotating local keys.");
        SessionKeys sess1 = this.getSessionKeysByIndex(0, 1);
        if (sess1.getIsUsedReceivingMACKey().booleanValue()) {
            logger.finest("Detected used Receiving MAC key. Adding to old MAC keys to reveal it.");
            this.getOldMacKeys().add(sess1.getReceivingMACKey());
        }
        if ((sess2 = this.getSessionKeysByIndex(0, 0)).getIsUsedReceivingMACKey().booleanValue()) {
            logger.finest("Detected used Receiving MAC key. Adding to old MAC keys to reveal it.");
            this.getOldMacKeys().add(sess2.getReceivingMACKey());
        }
        SessionKeys sess3 = this.getSessionKeysByIndex(1, 1);
        sess1.setLocalPair(sess3.getLocalPair(), sess3.getLocalKeyID());
        SessionKeys sess4 = this.getSessionKeysByIndex(1, 0);
        sess2.setLocalPair(sess4.getLocalPair(), sess4.getLocalKeyID());
        KeyPair newPair = new OtrCryptoEngineImpl().generateDHKeyPair();
        sess3.setLocalPair(newPair, sess3.getLocalKeyID() + 1);
        sess4.setLocalPair(newPair, sess4.getLocalKeyID() + 1);
    }

    private byte[] collectOldMacKeys() {
        logger.finest("Collecting old MAC keys to be revealed.");
        int len = 0;
        for (int i = 0; i < this.getOldMacKeys().size(); ++i) {
            len += this.getOldMacKeys().get(i).length;
        }
        ByteBuffer buff = ByteBuffer.allocate(len);
        for (int i = 0; i < this.getOldMacKeys().size(); ++i) {
            buff.put(this.getOldMacKeys().get(i));
        }
        this.getOldMacKeys().clear();
        return buff.array();
    }

    private void setSessionStatus(SessionStatus sessionStatus) throws OtrException {
        switch (sessionStatus) {
            case ENCRYPTED: {
                AuthContext auth = this.getAuthContext();
                this.ess = auth.getS();
                logger.finest("Setting most recent session keys from auth.");
                for (int i = 0; i < this.getSessionKeys()[0].length; ++i) {
                    SessionKeys current = this.getSessionKeysByIndex(0, i);
                    current.setLocalPair(auth.getLocalDHKeyPair(), 1);
                    current.setRemoteDHPublicKey(auth.getRemoteDHPublicKey(), 1);
                    current.setS(auth.getS());
                }
                KeyPair nextDH = new OtrCryptoEngineImpl().generateDHKeyPair();
                for (int i = 0; i < this.getSessionKeys()[1].length; ++i) {
                    SessionKeys current = this.getSessionKeysByIndex(1, i);
                    current.setRemoteDHPublicKey(auth.getRemoteDHPublicKey(), 1);
                    current.setLocalPair(nextDH, 2);
                }
                this.setRemotePublicKey(auth.getRemoteLongTermPublicKey());
                auth.reset();
                this.otrSm.reset();
                break;
            }
            case FINISHED: 
            case PLAINTEXT: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("What to do for this state?");
            }
        }
        if (sessionStatus == this.sessionStatus) {
            return;
        }
        this.sessionStatus = sessionStatus;
        for (OtrEngineListener l : this.listeners) {
            l.sessionStatusChanged(this.getSessionID());
        }
    }

    @Override
    public SessionStatus getSessionStatus() {
        if (this.slaveSessions.isSelected() && this.getProtocolVersion() == 3) {
            return this.slaveSessions.getSelected().getSessionStatus();
        }
        return this.sessionStatus;
    }

    private void setSessionID(SessionID sessionID) {
        this.sessionID = sessionID;
    }

    @Override
    public SessionID getSessionID() {
        return this.sessionID;
    }

    private void setHost(OtrEngineHost host) {
        this.host = host;
    }

    private OtrEngineHost getHost() {
        return this.host;
    }

    private SessionKeys[][] getSessionKeys() {
        if (this.sessionKeys == null) {
            this.sessionKeys = new SessionKeys[2][2];
        }
        return this.sessionKeys;
    }

    private AuthContext getAuthContext() {
        if (this.authContext == null) {
            this.authContext = new AuthContextImpl(this);
        }
        return this.authContext;
    }

    private List<byte[]> getOldMacKeys() {
        if (this.oldMacKeys == null) {
            this.oldMacKeys = new ArrayList<byte[]>();
        }
        return this.oldMacKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String transformReceiving(String msgText) throws OtrException {
        AbstractMessage m;
        OtrPolicy policy = this.getSessionPolicy();
        if (!(policy.getAllowV1() || policy.getAllowV2() || policy.getAllowV3())) {
            logger.finest("Policy does not allow neither V1 nor V2 & V3, ignoring message.");
            return msgText;
        }
        try {
            msgText = this.assembler.accumulate(msgText);
        }
        catch (UnknownInstanceException e) {
            logger.finest(e.getMessage());
            this.getHost().messageFromAnotherInstanceReceived(this.getSessionID());
            return null;
        }
        catch (ProtocolException e) {
            logger.warning("An invalid message fragment was discarded.");
            return null;
        }
        if (msgText == null) {
            return null;
        }
        try {
            m = SerializationUtils.toMessage(msgText);
        }
        catch (IOException e) {
            throw new OtrException(e);
        }
        if (m == null) {
            return msgText;
        }
        if (m.messageType != 258) {
            this.offerStatus = OfferStatus.accepted;
        } else if (this.offerStatus == OfferStatus.sent) {
            this.offerStatus = OfferStatus.rejected;
        }
        if (m instanceof AbstractEncodedMessage && this.isMasterSession) {
            AbstractEncodedMessage encodedM = (AbstractEncodedMessage)m;
            if (encodedM.protocolVersion == 3) {
                if (encodedM.receiverInstanceTag != this.getSenderInstanceTag().getValue() && (encodedM.messageType != 2 || encodedM.receiverInstanceTag != 0)) {
                    logger.finest("Received an encoded message with receiver instance tag that is different from ours, ignore this message");
                    this.getHost().messageFromAnotherInstanceReceived(this.getSessionID());
                    return null;
                }
                if (encodedM.senderInstanceTag != this.getReceiverInstanceTag().getValue() && this.getReceiverInstanceTag().getValue() != 0) {
                    logger.finest("Received an encoded message from a different instance. Our buddymay be logged from multiple locations.");
                    InstanceTag newReceiverTag = new InstanceTag(encodedM.senderInstanceTag);
                    SelectableMap<InstanceTag, SessionImpl> selectableMap = this.slaveSessions;
                    synchronized (selectableMap) {
                        if (!this.slaveSessions.containsKey(newReceiverTag)) {
                            SessionImpl session = new SessionImpl(this.sessionID, this.getHost(), this.getSenderInstanceTag(), newReceiverTag);
                            if (encodedM.messageType == 10) {
                                session.getAuthContext().set(this.getAuthContext());
                            }
                            session.addOtrEngineListener(new OtrEngineListener(){

                                @Override
                                public void sessionStatusChanged(SessionID sessionID) {
                                    for (OtrEngineListener l : SessionImpl.this.listeners) {
                                        l.sessionStatusChanged(sessionID);
                                    }
                                }

                                @Override
                                public void multipleInstancesDetected(SessionID sessionID) {
                                }

                                @Override
                                public void outgoingSessionChanged(SessionID sessionID) {
                                }
                            });
                            this.slaveSessions.put(newReceiverTag, session);
                            this.getHost().multipleInstancesDetected(this.sessionID);
                            for (OtrEngineListener l : this.listeners) {
                                l.multipleInstancesDetected(this.sessionID);
                            }
                        }
                    }
                    return this.slaveSessions.get(newReceiverTag).transformReceiving(msgText);
                }
            }
        }
        switch (m.messageType) {
            case 3: {
                return this.handleDataMessage((DataMessage)m);
            }
            case 255: {
                this.handleErrorMessage((ErrorMessage)m);
                return null;
            }
            case 258: {
                return this.handlePlainTextMessage((PlainTextMessage)m);
            }
            case 256: {
                this.handleQueryMessage((QueryMessage)m);
                return null;
            }
            case 2: 
            case 10: 
            case 17: 
            case 18: {
                AuthContext auth = this.getAuthContext();
                auth.handleReceivingMessage(m);
                if (auth.getIsSecure()) {
                    this.setSessionStatus(SessionStatus.ENCRYPTED);
                    logger.finest("Gone Secure.");
                }
                return null;
            }
        }
        throw new UnsupportedOperationException("Received an uknown message type.");
    }

    private void sendingDHCommitMessage(QueryMessage queryMessage, boolean supportV1) throws OtrException {
        OtrPolicy policy = this.getSessionPolicy();
        if (queryMessage.versions.contains(3) && policy.getAllowV3()) {
            logger.finest("V3 message tag found and supported.");
            DHCommitMessage dhCommit = this.getAuthContext().respondAuth(3);
            if (this.isMasterSession) {
                for (SessionImpl session : this.slaveSessions.values()) {
                    session.getAuthContext().reset();
                    session.getAuthContext().set(this.getAuthContext());
                }
            }
            logger.finest("Sending D-H Commit Message");
            this.injectMessage(dhCommit);
        } else if (queryMessage.versions.contains(2) && policy.getAllowV2()) {
            logger.finest("V2 message tag found and supported.");
            DHCommitMessage dhCommit = this.getAuthContext().respondAuth(2);
            logger.finest("Sending D-H Commit Message");
            this.injectMessage(dhCommit);
        } else if (queryMessage.versions.contains(1) && policy.getAllowV1()) {
            if (supportV1) {
                logger.finest("V1 message tag found and supported. - ignoring.");
            } else {
                logger.finest("V1 message tag found but not supported.");
                throw new UnsupportedOperationException();
            }
        }
    }

    private void handleQueryMessage(QueryMessage queryMessage) throws OtrException {
        logger.log(Level.FINEST, "{0} received a query message from {1} through {2}.", new Object[]{this.getSessionID().getAccountID(), this.getSessionID().getUserID(), this.getSessionID().getProtocolName()});
        this.sendingDHCommitMessage(queryMessage, true);
    }

    private void handleErrorMessage(ErrorMessage errorMessage) throws OtrException {
        logger.log(Level.FINEST, "{0} received an error message from {1} through {2}.", new Object[]{this.getSessionID().getAccountID(), this.getSessionID().getUserID(), this.getSessionID().getProtocolName()});
        this.getHost().showError(this.getSessionID(), errorMessage.error);
        OtrPolicy policy = this.getSessionPolicy();
        if (policy.getErrorStartAKE()) {
            logger.finest("Error message starts AKE.");
            ArrayList<Integer> versions = new ArrayList<Integer>();
            if (policy.getAllowV1()) {
                versions.add(1);
            }
            if (policy.getAllowV2()) {
                versions.add(2);
            }
            if (policy.getAllowV3()) {
                versions.add(3);
            }
            logger.finest("Sending Query");
            this.injectMessage(new QueryMessage(versions));
        }
    }

    private String handleDataMessage(DataMessage data) throws OtrException {
        logger.log(Level.FINEST, "{0} received a data message from {1}.", new Object[]{this.getSessionID().getAccountID(), this.getSessionID().getUserID()});
        switch (this.getSessionStatus()) {
            case ENCRYPTED: {
                String decryptedMsgContent;
                byte[] serializedT;
                logger.finest("Message state is ENCRYPTED. Trying to decrypt message.");
                int senderKeyID = data.senderKeyID;
                int receipientKeyID = data.recipientKeyID;
                SessionKeys matchingKeys = this.getSessionKeysByID(receipientKeyID, senderKeyID);
                if (matchingKeys == null) {
                    logger.finest("No matching keys found.");
                    this.getHost().unreadableMessageReceived(this.getSessionID());
                    this.injectMessage(new ErrorMessage(255, this.getHost().getReplyForUnreadableMessage(this.getSessionID())));
                    return null;
                }
                logger.finest("Transforming T to byte[] to calculate it's HmacSHA1.");
                try {
                    serializedT = SerializationUtils.toByteArray(data.getT());
                }
                catch (IOException e) {
                    throw new OtrException(e);
                }
                OtrCryptoEngineImpl otrCryptoEngine = new OtrCryptoEngineImpl();
                byte[] computedMAC = otrCryptoEngine.sha1Hmac(serializedT, matchingKeys.getReceivingMACKey(), 20);
                if (!Arrays.equals(computedMAC, data.mac)) {
                    logger.finest("MAC verification failed, ignoring message");
                    this.getHost().unreadableMessageReceived(this.getSessionID());
                    this.injectMessage(new ErrorMessage(255, this.getHost().getReplyForUnreadableMessage(this.getSessionID())));
                    return null;
                }
                logger.finest("Computed HmacSHA1 value matches sent one.");
                matchingKeys.setIsUsedReceivingMACKey(true);
                matchingKeys.setReceivingCtr(data.ctr);
                byte[] dmc = otrCryptoEngine.aesDecrypt(matchingKeys.getReceivingAESKey(), matchingKeys.getReceivingCtr(), data.encryptedMessage);
                try {
                    decryptedMsgContent = new String(dmc, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new OtrException(e);
                }
                logger.log(Level.FINEST, "Decrypted message: \"{0}\"", decryptedMsgContent);
                SessionKeys mostRecent = this.getMostRecentSessionKeys();
                if (mostRecent.getLocalKeyID() == receipientKeyID) {
                    this.rotateLocalSessionKeys();
                }
                if (mostRecent.getRemoteKeyID() == senderKeyID) {
                    this.rotateRemoteSessionKeys(data.nextDH);
                }
                LinkedList<TLV> tlvs = null;
                int tlvIndex = decryptedMsgContent.indexOf(0);
                if (tlvIndex > -1) {
                    decryptedMsgContent = decryptedMsgContent.substring(0, tlvIndex);
                    byte[] tlvsb = new byte[dmc.length - ++tlvIndex];
                    System.arraycopy(dmc, tlvIndex, tlvsb, 0, tlvsb.length);
                    tlvs = new LinkedList<TLV>();
                    ByteArrayInputStream tin = new ByteArrayInputStream(tlvsb);
                    while (tin.available() > 0) {
                        byte[] tdata;
                        int type;
                        OtrInputStream eois = new OtrInputStream(tin);
                        try {
                            type = eois.readShort();
                            tdata = eois.readTlvData();
                            eois.close();
                        }
                        catch (IOException e) {
                            throw new OtrException(e);
                        }
                        tlvs.add(new TLV(type, tdata));
                    }
                }
                if (tlvs != null && tlvs.size() > 0) {
                    for (TLV tlv : tlvs) {
                        switch (tlv.getType()) {
                            case 1: {
                                this.setSessionStatus(SessionStatus.FINISHED);
                                return null;
                            }
                        }
                        if (!this.otrSm.doProcessTlv(tlv)) continue;
                        return null;
                    }
                }
                return decryptedMsgContent;
            }
            case FINISHED: 
            case PLAINTEXT: {
                this.getHost().unreadableMessageReceived(this.getSessionID());
                this.injectMessage(new ErrorMessage(255, this.getHost().getReplyForUnreadableMessage(this.getSessionID())));
                break;
            }
            default: {
                throw new UnsupportedOperationException("What to do for this state?");
            }
        }
        return null;
    }

    @Override
    public void injectMessage(AbstractMessage m) throws OtrException {
        String msg;
        try {
            msg = SerializationUtils.toString(m);
        }
        catch (IOException e) {
            throw new OtrException(e);
        }
        if (m instanceof QueryMessage) {
            msg = msg + this.getHost().getFallbackMessage(this.getSessionID());
        }
        if (SerializationUtils.otrEncoded(msg)) {
            try {
                String[] fragments;
                for (String fragment : fragments = this.fragmenter.fragment(msg)) {
                    this.getHost().injectMessage(this.getSessionID(), fragment);
                }
            }
            catch (IOException e) {
                logger.warning("Failed to fragment message according to provided instructions.");
                throw new OtrException(e);
            }
        } else {
            this.getHost().injectMessage(this.getSessionID(), msg);
        }
    }

    private String handlePlainTextMessage(PlainTextMessage plainTextMessage) throws OtrException {
        logger.log(Level.FINEST, "{0} received a plaintext message from {1} through {2}.", new Object[]{this.getSessionID().getAccountID(), this.getSessionID().getUserID(), this.getSessionID().getProtocolName()});
        OtrPolicy policy = this.getSessionPolicy();
        List versions = plainTextMessage.versions;
        if (versions == null || versions.size() < 1) {
            logger.finest("Received plaintext message without the whitespace tag.");
            switch (this.getSessionStatus()) {
                case ENCRYPTED: 
                case FINISHED: {
                    this.getHost().unencryptedMessageReceived(this.sessionID, plainTextMessage.cleanText);
                    return plainTextMessage.cleanText;
                }
                case PLAINTEXT: {
                    if (policy.getRequireEncryption()) {
                        this.getHost().unencryptedMessageReceived(this.sessionID, plainTextMessage.cleanText);
                    }
                    return plainTextMessage.cleanText;
                }
            }
            throw new UnsupportedOperationException("What to do for this state?");
        }
        logger.finest("Received plaintext message with the whitespace tag.");
        switch (this.getSessionStatus()) {
            case ENCRYPTED: 
            case FINISHED: {
                this.getHost().unencryptedMessageReceived(this.sessionID, plainTextMessage.cleanText);
                break;
            }
            case PLAINTEXT: {
                if (!policy.getRequireEncryption()) break;
                this.getHost().unencryptedMessageReceived(this.sessionID, plainTextMessage.cleanText);
                break;
            }
            default: {
                throw new UnsupportedOperationException("What to do for this state?");
            }
        }
        if (policy.getWhitespaceStartAKE()) {
            logger.finest("WHITESPACE_START_AKE is set");
            try {
                this.sendingDHCommitMessage(plainTextMessage, false);
            }
            catch (OtrException otrException) {
                // empty catch block
            }
        }
        return plainTextMessage.cleanText;
    }

    @Override
    public String[] transformSending(String msgText) throws OtrException {
        return this.transformSending(msgText, null);
    }

    @Override
    public String[] transformSending(String msgText, List<TLV> tlvs) throws OtrException {
        if (this.isMasterSession && this.slaveSessions.isSelected() && this.getProtocolVersion() == 3) {
            return this.slaveSessions.getSelected().transformSending(msgText, tlvs);
        }
        switch (this.getSessionStatus()) {
            case PLAINTEXT: {
                OtrPolicy otrPolicy = this.getSessionPolicy();
                if (otrPolicy.getRequireEncryption()) {
                    this.startSession();
                    this.getHost().requireEncryptedMessage(this.sessionID, msgText);
                    return null;
                }
                if (otrPolicy.getSendWhitespaceTag() && this.offerStatus != OfferStatus.rejected) {
                    this.offerStatus = OfferStatus.sent;
                    ArrayList<Integer> versions = new ArrayList<Integer>(3);
                    if (otrPolicy.getAllowV1()) {
                        versions.add(1);
                    }
                    if (otrPolicy.getAllowV2()) {
                        versions.add(2);
                    }
                    if (otrPolicy.getAllowV3()) {
                        versions.add(3);
                    }
                    if (versions.isEmpty()) {
                        versions = null;
                    }
                    PlainTextMessage abstractMessage = new PlainTextMessage(versions, msgText);
                    try {
                        return new String[]{SerializationUtils.toString(abstractMessage)};
                    }
                    catch (IOException e) {
                        throw new OtrException(e);
                    }
                }
                return new String[]{msgText};
            }
            case ENCRYPTED: {
                byte[] serializedT;
                logger.log(Level.FINEST, "{0} sends an encrypted message to {1} through {2}.", new Object[]{this.getSessionID().getAccountID(), this.getSessionID().getUserID(), this.getSessionID().getProtocolName()});
                SessionKeys encryptionKeys = this.getEncryptionSessionKeys();
                int senderKeyID = encryptionKeys.getLocalKeyID();
                int receipientKeyID = encryptionKeys.getRemoteKeyID();
                encryptionKeys.incrementSendingCtr();
                byte[] ctr = encryptionKeys.getSendingCtr();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                if (msgText != null && msgText.length() > 0) {
                    try {
                        out.write(msgText.getBytes("UTF8"));
                    }
                    catch (IOException e) {
                        throw new OtrException(e);
                    }
                }
                if (tlvs != null && tlvs.size() > 0) {
                    out.write(0);
                    OtrOutputStream eoos = new OtrOutputStream(out);
                    for (TLV tlv : tlvs) {
                        try {
                            eoos.writeShort(tlv.type);
                            eoos.writeTlvData(tlv.value);
                        }
                        catch (IOException e) {
                            throw new OtrException(e);
                        }
                    }
                }
                OtrCryptoEngineImpl otrCryptoEngine = new OtrCryptoEngineImpl();
                byte[] data = out.toByteArray();
                logger.log(Level.FINEST, "Encrypting message with keyids (localKeyID, remoteKeyID) = ({0}, {1})", new Object[]{senderKeyID, receipientKeyID});
                byte[] encryptedMsg = otrCryptoEngine.aesEncrypt(encryptionKeys.getSendingAESKey(), ctr, data);
                SessionKeys mostRecentKeys = this.getMostRecentSessionKeys();
                DHPublicKey nextDH = (DHPublicKey)mostRecentKeys.getLocalPair().getPublic();
                MysteriousT t = new MysteriousT(this.protocolVersion, this.getSenderInstanceTag().getValue(), this.getReceiverInstanceTag().getValue(), 0, senderKeyID, receipientKeyID, nextDH, ctr, encryptedMsg);
                byte[] sendingMACKey = encryptionKeys.getSendingMACKey();
                logger.finest("Transforming T to byte[] to calculate it's HmacSHA1.");
                try {
                    serializedT = SerializationUtils.toByteArray(t);
                }
                catch (IOException e) {
                    throw new OtrException(e);
                }
                byte[] mac = otrCryptoEngine.sha1Hmac(serializedT, sendingMACKey, 20);
                byte[] oldKeys = this.collectOldMacKeys();
                DataMessage m = new DataMessage(t, mac, oldKeys);
                m.senderInstanceTag = this.getSenderInstanceTag().getValue();
                m.receiverInstanceTag = this.getReceiverInstanceTag().getValue();
                try {
                    String completeMessage = SerializationUtils.toString(m);
                    return this.fragmenter.fragment(completeMessage);
                }
                catch (IOException e) {
                    throw new OtrException(e);
                }
            }
            case FINISHED: {
                this.getHost().finishedSessionMessage(this.sessionID, msgText);
                return null;
            }
        }
        logger.finest("Uknown message state, not processing.");
        return new String[]{msgText};
    }

    @Override
    public void startSession() throws OtrException {
        if (this.slaveSessions.isSelected() && this.getProtocolVersion() == 3) {
            this.slaveSessions.getSelected().startSession();
            return;
        }
        if (this.getSessionStatus() == SessionStatus.ENCRYPTED) {
            return;
        }
        if (!this.getSessionPolicy().getAllowV2() && !this.getSessionPolicy().getAllowV3()) {
            throw new UnsupportedOperationException();
        }
        this.getAuthContext().startAuth();
    }

    @Override
    public void endSession() throws OtrException {
        if (this.slaveSessions.isSelected() && this.getProtocolVersion() == 3) {
            this.slaveSessions.getSelected().endSession();
            return;
        }
        SessionStatus status = this.getSessionStatus();
        switch (status) {
            case ENCRYPTED: {
                String[] msg;
                ArrayList<TLV> tlvs = new ArrayList<TLV>(1);
                tlvs.add(new TLV(1, null));
                for (String part : msg = this.transformSending(null, tlvs)) {
                    this.getHost().injectMessage(this.getSessionID(), part);
                }
                this.setSessionStatus(SessionStatus.PLAINTEXT);
                break;
            }
            case FINISHED: {
                this.setSessionStatus(SessionStatus.PLAINTEXT);
                break;
            }
            case PLAINTEXT: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("What to do for this state?");
            }
        }
    }

    @Override
    public void refreshSession() throws OtrException {
        this.endSession();
        this.startSession();
    }

    private void setRemotePublicKey(PublicKey pubKey) {
        this.remotePublicKey = pubKey;
    }

    @Override
    public PublicKey getRemotePublicKey() {
        if (this.slaveSessions.isSelected() && this.getProtocolVersion() == 3) {
            return this.slaveSessions.getSelected().getRemotePublicKey();
        }
        return this.remotePublicKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOtrEngineListener(OtrEngineListener l) {
        List<OtrEngineListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(l)) {
                this.listeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeOtrEngineListener(OtrEngineListener l) {
        List<OtrEngineListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    @Override
    public OtrPolicy getSessionPolicy() {
        return this.getHost().getSessionPolicy(this.getSessionID());
    }

    @Override
    public KeyPair getLocalKeyPair() throws OtrException {
        return this.getHost().getLocalKeyPair(this.getSessionID());
    }

    @Override
    public void initSmp(String question, String secret) throws OtrException {
        String[] msg;
        if (this.slaveSessions.isSelected() && this.getProtocolVersion() == 3) {
            this.slaveSessions.getSelected().initSmp(question, secret);
            return;
        }
        if (this.getSessionStatus() != SessionStatus.ENCRYPTED) {
            return;
        }
        List<TLV> tlvs = this.otrSm.initRespondSmp(question, secret, true);
        for (String part : msg = this.transformSending("", tlvs)) {
            this.getHost().injectMessage(this.getSessionID(), part);
        }
    }

    @Override
    public void respondSmp(String question, String secret) throws OtrException {
        String[] msg;
        if (this.slaveSessions.isSelected() && this.getProtocolVersion() == 3) {
            this.slaveSessions.getSelected().respondSmp(question, secret);
            return;
        }
        if (this.getSessionStatus() != SessionStatus.ENCRYPTED) {
            return;
        }
        List<TLV> tlvs = this.otrSm.initRespondSmp(question, secret, false);
        for (String part : msg = this.transformSending("", tlvs)) {
            this.getHost().injectMessage(this.getSessionID(), part);
        }
    }

    @Override
    public void abortSmp() throws OtrException {
        String[] msg;
        if (this.slaveSessions.isSelected() && this.getProtocolVersion() == 3) {
            this.slaveSessions.getSelected().abortSmp();
            return;
        }
        if (this.getSessionStatus() != SessionStatus.ENCRYPTED) {
            return;
        }
        List<TLV> tlvs = this.otrSm.abortSmp();
        for (String part : msg = this.transformSending("", tlvs)) {
            this.getHost().injectMessage(this.getSessionID(), part);
        }
    }

    @Override
    public boolean isSmpInProgress() {
        if (this.slaveSessions.isSelected() && this.getProtocolVersion() == 3) {
            return this.slaveSessions.getSelected().isSmpInProgress();
        }
        return this.otrSm.isSmpInProgress();
    }

    @Override
    public InstanceTag getSenderInstanceTag() {
        return this.senderTag;
    }

    @Override
    public InstanceTag getReceiverInstanceTag() {
        return this.receiverInstanceTag;
    }

    @Override
    public void setReceiverInstanceTag(InstanceTag receiverInstanceTag) {
        if (!this.isMasterSession) {
            return;
        }
        this.receiverInstanceTag = receiverInstanceTag;
    }

    @Override
    public void setProtocolVersion(int protocolVersion) {
        if (!this.isMasterSession) {
            return;
        }
        this.protocolVersion = protocolVersion;
    }

    @Override
    public int getProtocolVersion() {
        return this.isMasterSession ? this.protocolVersion : 3;
    }

    @Override
    public List<Session> getInstances() {
        ArrayList<Session> result = new ArrayList<Session>();
        result.add(this);
        result.addAll(this.slaveSessions.values());
        return result;
    }

    @Override
    public boolean setOutgoingInstance(InstanceTag tag) {
        if (!this.isMasterSession) {
            return false;
        }
        if (tag.equals(this.getReceiverInstanceTag())) {
            this.slaveSessions.deselect();
            for (OtrEngineListener l : this.listeners) {
                l.outgoingSessionChanged(this.sessionID);
            }
            return true;
        }
        if (this.slaveSessions.containsKey(tag)) {
            this.slaveSessions.select(tag);
            for (OtrEngineListener l : this.listeners) {
                l.outgoingSessionChanged(this.sessionID);
            }
            return true;
        }
        this.slaveSessions.deselect();
        return false;
    }

    @Override
    public void respondSmp(InstanceTag receiverTag, String question, String secret) throws OtrException {
        if (receiverTag.equals(this.getReceiverInstanceTag())) {
            this.respondSmp(question, secret);
        } else {
            Session slave = this.slaveSessions.get(receiverTag);
            if (slave != null) {
                slave.respondSmp(question, secret);
            } else {
                this.respondSmp(question, secret);
            }
        }
    }

    @Override
    public SessionStatus getSessionStatus(InstanceTag tag) {
        if (tag.equals(this.getReceiverInstanceTag())) {
            return this.sessionStatus;
        }
        Session slave = this.slaveSessions.get(tag);
        return slave != null ? slave.getSessionStatus() : this.sessionStatus;
    }

    @Override
    public PublicKey getRemotePublicKey(InstanceTag tag) {
        if (tag.equals(this.getReceiverInstanceTag())) {
            return this.remotePublicKey;
        }
        Session slave = this.slaveSessions.get(tag);
        return slave != null ? slave.getRemotePublicKey() : this.remotePublicKey;
    }

    @Override
    public Session getOutgoingInstance() {
        if (this.slaveSessions.isSelected()) {
            return this.slaveSessions.getSelected();
        }
        return this;
    }
}

