/*
 * Decompiled with CFR 0.152.
 */
package net.java.otr4j.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.interfaces.DHPublicKey;
import net.java.otr4j.io.OtrInputStream;
import net.java.otr4j.io.OtrOutputStream;
import net.java.otr4j.io.messages.AbstractMessage;
import net.java.otr4j.io.messages.DHCommitMessage;
import net.java.otr4j.io.messages.DHKeyMessage;
import net.java.otr4j.io.messages.DataMessage;
import net.java.otr4j.io.messages.ErrorMessage;
import net.java.otr4j.io.messages.MysteriousT;
import net.java.otr4j.io.messages.PlainTextMessage;
import net.java.otr4j.io.messages.QueryMessage;
import net.java.otr4j.io.messages.RevealSignatureMessage;
import net.java.otr4j.io.messages.SignatureM;
import net.java.otr4j.io.messages.SignatureMessage;
import net.java.otr4j.io.messages.SignatureX;

public class SerializationUtils {
    private static final Pattern PATTERN_WHITESPACE = Pattern.compile("( \\t  \\t\\t\\t\\t \\t \\t \\t  )( \\t \\t  \\t )?(  \\t\\t  \\t )?(  \\t\\t  \\t\\t)?");
    private static final char[] HEX_ENCODER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String HEX_DECODER = "0123456789ABCDEF";

    private SerializationUtils() {
    }

    public static SignatureX toMysteriousX(byte[] b) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(b);
        OtrInputStream ois = new OtrInputStream(in);
        SignatureX x = ois.readMysteriousX();
        ois.close();
        return x;
    }

    public static byte[] toByteArray(SignatureX x) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OtrOutputStream oos = new OtrOutputStream(out);
        oos.writeMysteriousX(x);
        byte[] b = out.toByteArray();
        oos.close();
        return b;
    }

    public static byte[] toByteArray(SignatureM m) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OtrOutputStream oos = new OtrOutputStream(out);
        oos.writeMysteriousX(m);
        byte[] b = out.toByteArray();
        oos.close();
        return b;
    }

    public static byte[] toByteArray(MysteriousT t) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OtrOutputStream oos = new OtrOutputStream(out);
        oos.writeMysteriousT(t);
        byte[] b = out.toByteArray();
        oos.close();
        return b;
    }

    public static byte[] writeData(byte[] b) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OtrOutputStream oos = new OtrOutputStream(out);
        oos.writeData(b);
        byte[] otrb = out.toByteArray();
        oos.close();
        return otrb;
    }

    public static byte[] writeMpi(BigInteger bigInt) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OtrOutputStream oos = new OtrOutputStream(out);
        oos.writeBigInt(bigInt);
        byte[] b = out.toByteArray();
        oos.close();
        return b;
    }

    public static BigInteger readMpi(byte[] b) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(b);
        OtrInputStream ois = new OtrInputStream(in);
        BigInteger bigint = ois.readBigInt();
        ois.close();
        return bigint;
    }

    public static byte[] writePublicKey(PublicKey pubKey) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OtrOutputStream oos = new OtrOutputStream(out);
        oos.writePublicKey(pubKey);
        byte[] b = out.toByteArray();
        oos.close();
        return b;
    }

    public static String toString(AbstractMessage m) throws IOException {
        StringWriter writer = new StringWriter();
        if (m.messageType != 258) {
            writer.write("?OTR");
        }
        switch (m.messageType) {
            case 255: {
                ErrorMessage error = (ErrorMessage)m;
                writer.write(32);
                writer.write("Error:");
                writer.write(error.error);
                break;
            }
            case 258: {
                PlainTextMessage plaintxt = (PlainTextMessage)m;
                writer.write(plaintxt.cleanText);
                if (plaintxt.versions == null || plaintxt.versions.size() <= 0) break;
                writer.write(" \t  \t\t\t\t \t \t \t  ");
                Iterator iterator = plaintxt.versions.iterator();
                while (iterator.hasNext()) {
                    int version = (Integer)iterator.next();
                    if (version == 1) {
                        writer.write(" \t \t  \t ");
                    }
                    if (version == 2) {
                        writer.write("  \t\t  \t ");
                    }
                    if (version != 3) continue;
                    writer.write("  \t\t  \t\t");
                }
                break;
            }
            case 256: {
                QueryMessage query = (QueryMessage)m;
                if (query.versions.size() == 1 && query.versions.get(0) == 1) {
                    writer.write(63);
                    break;
                }
                writer.write(118);
                for (int version : query.versions) {
                    writer.write(String.valueOf(version));
                }
                writer.write(63);
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 17: 
            case 18: {
                ByteArrayOutputStream o = new ByteArrayOutputStream();
                OtrOutputStream s = new OtrOutputStream(o);
                switch (m.messageType) {
                    case 10: {
                        DHKeyMessage dhkey = (DHKeyMessage)m;
                        s.writeShort(dhkey.protocolVersion);
                        s.writeByte(dhkey.messageType);
                        if (dhkey.protocolVersion == 3) {
                            s.writeInt(dhkey.senderInstanceTag);
                            s.writeInt(dhkey.receiverInstanceTag);
                        }
                        s.writeDHPublicKey(dhkey.dhPublicKey);
                        break;
                    }
                    case 17: {
                        RevealSignatureMessage revealsig = (RevealSignatureMessage)m;
                        s.writeShort(revealsig.protocolVersion);
                        s.writeByte(revealsig.messageType);
                        if (revealsig.protocolVersion == 3) {
                            s.writeInt(revealsig.senderInstanceTag);
                            s.writeInt(revealsig.receiverInstanceTag);
                        }
                        s.writeData(revealsig.revealedKey);
                        s.writeData(revealsig.xEncrypted);
                        s.writeMac(revealsig.xEncryptedMAC);
                        break;
                    }
                    case 18: {
                        SignatureMessage sig = (SignatureMessage)m;
                        s.writeShort(sig.protocolVersion);
                        s.writeByte(sig.messageType);
                        if (sig.protocolVersion == 3) {
                            s.writeInt(sig.senderInstanceTag);
                            s.writeInt(sig.receiverInstanceTag);
                        }
                        s.writeData(sig.xEncrypted);
                        s.writeMac(sig.xEncryptedMAC);
                        break;
                    }
                    case 2: {
                        DHCommitMessage dhcommit = (DHCommitMessage)m;
                        s.writeShort(dhcommit.protocolVersion);
                        s.writeByte(dhcommit.messageType);
                        if (dhcommit.protocolVersion == 3) {
                            s.writeInt(dhcommit.senderInstanceTag);
                            s.writeInt(dhcommit.receiverInstanceTag);
                        }
                        s.writeData(dhcommit.dhPublicKeyEncrypted);
                        s.writeData(dhcommit.dhPublicKeyHash);
                        break;
                    }
                    case 3: {
                        DataMessage data = (DataMessage)m;
                        s.writeShort(data.protocolVersion);
                        s.writeByte(data.messageType);
                        if (data.protocolVersion == 3) {
                            s.writeInt(data.senderInstanceTag);
                            s.writeInt(data.receiverInstanceTag);
                        }
                        s.writeByte(data.flags);
                        s.writeInt(data.senderKeyID);
                        s.writeInt(data.recipientKeyID);
                        s.writeDHPublicKey(data.nextDH);
                        s.writeCtr(data.ctr);
                        s.writeData(data.encryptedMessage);
                        s.writeMac(data.mac);
                        s.writeData(data.oldMACKeys);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported message type: " + m.messageType);
                    }
                }
                writer.write(58);
                writer.write(Base64.getEncoder().encodeToString(o.toByteArray()));
                writer.write(".");
                break;
            }
            default: {
                throw new IOException("Illegal message type.");
            }
        }
        return writer.toString();
    }

    public static AbstractMessage toMessage(String s) throws IOException {
        if (s == null || s.length() == 0) {
            return null;
        }
        int idxHead = s.indexOf("?OTR");
        if (idxHead > -1) {
            char contentType = s.charAt(idxHead + "?OTR".length());
            String content = s.substring(idxHead + "?OTR".length() + 1);
            if (contentType == ' ' && content.startsWith("Error:")) {
                content = content.substring(idxHead + "Error:".length());
                return new ErrorMessage(255, content);
            }
            if (contentType == 'v' || contentType == '?') {
                ArrayList<Integer> versions = new ArrayList<Integer>();
                String versionString = null;
                if ('?' == contentType) {
                    versions.add(1);
                    if (content.charAt(0) == 'v') {
                        versionString = content.substring(1, content.indexOf(63));
                    }
                } else if ('v' == contentType) {
                    versionString = content.substring(0, content.indexOf(63));
                }
                if (versionString != null) {
                    int c;
                    StringReader sr = new StringReader(versionString);
                    while ((c = sr.read()) != -1) {
                        if (versions.contains(c)) continue;
                        versions.add(Integer.parseInt(String.valueOf((char)c)));
                    }
                }
                QueryMessage query = new QueryMessage(versions);
                return query;
            }
            if (idxHead == 0 && contentType == ':') {
                ByteArrayInputStream bin = new ByteArrayInputStream(Base64.getDecoder().decode(content.substring(0, content.length() - 1).getBytes()));
                OtrInputStream otr = new OtrInputStream(bin);
                int protocolVersion = otr.readShort();
                int messageType = otr.readByte();
                int senderInstanceTag = 0;
                int recipientInstanceTag = 0;
                if (protocolVersion == 3) {
                    senderInstanceTag = otr.readInt();
                    recipientInstanceTag = otr.readInt();
                }
                switch (messageType) {
                    case 3: {
                        int flags = otr.readByte();
                        int senderKeyID = otr.readInt();
                        int recipientKeyID = otr.readInt();
                        DHPublicKey nextDH = otr.readDHPublicKey();
                        byte[] ctr = otr.readCtr();
                        byte[] encryptedMessage = otr.readData();
                        byte[] mac = otr.readMac();
                        byte[] oldMacKeys = otr.readMac();
                        DataMessage dataMessage = new DataMessage(protocolVersion, flags, senderKeyID, recipientKeyID, nextDH, ctr, encryptedMessage, mac, oldMacKeys);
                        dataMessage.senderInstanceTag = senderInstanceTag;
                        dataMessage.receiverInstanceTag = recipientInstanceTag;
                        otr.close();
                        return dataMessage;
                    }
                    case 2: {
                        byte[] dhPublicKeyEncrypted = otr.readData();
                        byte[] dhPublicKeyHash = otr.readData();
                        DHCommitMessage dhCommitMessage = new DHCommitMessage(protocolVersion, dhPublicKeyHash, dhPublicKeyEncrypted);
                        dhCommitMessage.senderInstanceTag = senderInstanceTag;
                        dhCommitMessage.receiverInstanceTag = recipientInstanceTag;
                        otr.close();
                        return dhCommitMessage;
                    }
                    case 10: {
                        DHPublicKey dhPublicKey = otr.readDHPublicKey();
                        DHKeyMessage dhKeyMessage = new DHKeyMessage(protocolVersion, dhPublicKey);
                        dhKeyMessage.senderInstanceTag = senderInstanceTag;
                        dhKeyMessage.receiverInstanceTag = recipientInstanceTag;
                        otr.close();
                        return dhKeyMessage;
                    }
                    case 17: {
                        byte[] revealedKey = otr.readData();
                        byte[] xEncrypted = otr.readData();
                        byte[] xEncryptedMac = otr.readMac();
                        RevealSignatureMessage revealSignatureMessage = new RevealSignatureMessage(protocolVersion, xEncrypted, xEncryptedMac, revealedKey);
                        revealSignatureMessage.senderInstanceTag = senderInstanceTag;
                        revealSignatureMessage.receiverInstanceTag = recipientInstanceTag;
                        otr.close();
                        return revealSignatureMessage;
                    }
                    case 18: {
                        byte[] xEncryted = otr.readData();
                        byte[] xEncryptedMac = otr.readMac();
                        SignatureMessage signatureMessage = new SignatureMessage(protocolVersion, xEncryted, xEncryptedMac);
                        signatureMessage.senderInstanceTag = senderInstanceTag;
                        signatureMessage.receiverInstanceTag = recipientInstanceTag;
                        otr.close();
                        return signatureMessage;
                    }
                }
                otr.close();
                throw new IOException("Illegal message type.");
            }
        }
        Matcher matcher = PATTERN_WHITESPACE.matcher(s);
        boolean v1 = false;
        boolean v2 = false;
        boolean v3 = false;
        while (matcher.find()) {
            if (!v1 && matcher.start(2) > -1) {
                v1 = true;
            }
            if (!v2 && matcher.start(3) > -1) {
                v2 = true;
            }
            if (!v3 && matcher.start(3) > -1) {
                v3 = true;
            }
            if (!v1 || !v2 || !v3) continue;
        }
        String cleanText = matcher.replaceAll("");
        ArrayList<Integer> versions = null;
        if (v1 || v2 || v3) {
            versions = new ArrayList<Integer>();
            if (v1) {
                versions.add(1);
            }
            if (v2) {
                versions.add(2);
            }
            if (v3) {
                versions.add(3);
            }
        }
        return new PlainTextMessage(versions, cleanText);
    }

    public static String byteArrayToHexString(byte[] in) {
        if (in == null || in.length <= 0) {
            return null;
        }
        StringBuilder out = new StringBuilder(in.length * 2);
        for (int i = 0; i < in.length; ++i) {
            out.append(HEX_ENCODER[in[i] >>> 4 & 0xF]);
            out.append(HEX_ENCODER[in[i] & 0xF]);
        }
        return out.toString();
    }

    public static byte[] hexStringToByteArray(String value) {
        value = value.toUpperCase();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (int index = 0; index < value.length(); index += 2) {
            int high = HEX_DECODER.indexOf(value.charAt(index));
            int low = HEX_DECODER.indexOf(value.charAt(index + 1));
            out.write((high << 4) + low);
        }
        return out.toByteArray();
    }

    public static boolean otrEncoded(String content) {
        return content.startsWith("?OTR:");
    }
}

