/*
 * Decompiled with CFR 0.152.
 */
package net.java.otr4j.crypto;

import java.math.BigInteger;

public class Util {
    private Util() {
    }

    public static boolean arrayEquals(byte[] b1, byte[] b2) {
        if (b1 == null || b2 == null || b1.length != b2.length) {
            return false;
        }
        for (int i = 0; i < b1.length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    public static void checkBytes(String s, byte[] bytes) {
        StringBuilder hexString = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            hexString.append(Integer.toHexString(bytes[i] >>> 4 & 0xF)).append(Integer.toHexString(0xF & bytes[i]));
        }
        System.out.println(s + ": " + hexString.toString());
    }

    static void writeInt(byte[] dst, int index, int src) {
        dst[index] = (byte)(src >> 24 & 0xFF);
        dst[index + 1] = (byte)(src >> 16 & 0xFF);
        dst[index + 2] = (byte)(src >> 8 & 0xFF);
        dst[index + 3] = (byte)(src & 0xFF);
    }

    static int readInt(byte[] src, int index) {
        int ret = src[index] << 24 | src[index + 1] << 16 & 0xFF0000 | src[index + 2] << 8 & 0xFF00 | src[index + 3] & 0xFF;
        return ret;
    }

    static byte[] hexStringToBytes(String s) {
        byte[] sbytes = s.getBytes();
        if (sbytes.length % 2 != 0) {
            return null;
        }
        byte[] ret = new byte[sbytes.length / 2];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = sbytes[2 * i] >= 65 && sbytes[2 * i] <= 70 ? (byte)(sbytes[2 * i] - 55 << 4) : (sbytes[2 * i] >= 97 && sbytes[2 * i] <= 102 ? (byte)(sbytes[2 * i] - 87 << 4) : (byte)(sbytes[2 * i] - 48 << 4));
            if (sbytes[2 * i + 1] >= 65 && sbytes[2 * i + 1] <= 70) {
                int n = i;
                ret[n] = (byte)(ret[n] | (byte)(sbytes[2 * i + 1] - 55));
                continue;
            }
            if (sbytes[2 * i + 1] >= 97 && sbytes[2 * i + 1] <= 102) {
                int n = i;
                ret[n] = (byte)(ret[n] | (byte)(sbytes[2 * i + 1] - 87));
                continue;
            }
            int n = i;
            ret[n] = (byte)(ret[n] | (byte)(sbytes[2 * i + 1] - 48));
        }
        return ret;
    }

    static String bytesToHexString(byte[] mpi) {
        byte[] hex = new byte[2 * mpi.length];
        for (int i = 0; i < mpi.length; ++i) {
            int num = mpi[i] >> 4 & 0xF;
            hex[2 * i] = num <= 9 ? (byte)(48 + num) : (byte)(65 + num - 10);
            num = mpi[i] & 0xF;
            hex[2 * i + 1] = num <= 9 ? (byte)(48 + num) : (byte)(65 + num - 10);
        }
        return new String(hex);
    }

    public static byte[] asUnsignedByteArray(BigInteger value) {
        byte[] bytes = value.toByteArray();
        if (bytes[0] == 0) {
            byte[] tmp = new byte[bytes.length - 1];
            System.arraycopy(bytes, 1, tmp, 0, tmp.length);
            return tmp;
        }
        return bytes;
    }

    public static byte[] asUnsignedByteArray(int length, BigInteger value) {
        byte[] bytes = value.toByteArray();
        if (bytes.length == length) {
            return bytes;
        }
        int start = bytes[0] == 0 ? 1 : 0;
        int count = bytes.length - start;
        if (count > length) {
            throw new IllegalArgumentException("standard length exceeded for value");
        }
        byte[] tmp = new byte[length];
        System.arraycopy(bytes, start, tmp, tmp.length - count, count);
        return tmp;
    }

    public static void asUnsignedByteArray(BigInteger value, byte[] dst, int offset, int length) {
        byte[] bytes;
        if (length > dst.length - offset) {
            throw new IllegalArgumentException("length value is larger than dst array length");
        }
        int start = (bytes = value.toByteArray())[0] == 0 ? 1 : 0;
        int count = bytes.length - start;
        if (count > length) {
            throw new IllegalArgumentException("specified length exceeded for value");
        }
        System.arraycopy(bytes, start, dst, offset + length - count, count);
    }
}

