/*
 * Decompiled with CFR 0.152.
 */
package net.java.otr4j.crypto;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.ProtocolException;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.java.otr4j.crypto.OtrCryptoEngine;
import net.java.otr4j.crypto.OtrCryptoException;
import net.java.otr4j.crypto.Util;
import net.java.otr4j.io.SerializationUtils;

public class OtrCryptoEngineImpl
implements OtrCryptoEngine {
    private static final String DSA_SIGNATURE_ALGORITHM = "NONEwithDSA";
    private static final int DSA_RAW_DATA_LENGTH_BYTES = 20;

    @Override
    public KeyPair generateDSAKeyPair() {
        try {
            KeyPairGenerator kg = KeyPairGenerator.getInstance("DSA");
            kg.initialize(1024);
            return kg.genKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("DSA algorithm is not supported.", e);
        }
    }

    @Override
    public KeyPair generateDHKeyPair() {
        try {
            KeyPairGenerator gen = KeyPairGenerator.getInstance("DH");
            gen.initialize(new DHParameterSpec(MODULUS, GENERATOR, 320));
            return gen.generateKeyPair();
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new IllegalStateException("BUG: invalid algorithm parameter provided.", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("BUG: DH algorithm is unavailable (for keypair generation).", e);
        }
    }

    @Override
    public DHPublicKey getDHPublicKey(byte[] mpiBytes) throws OtrCryptoException {
        return this.getDHPublicKey(new BigInteger(mpiBytes));
    }

    @Override
    public DHPublicKey getDHPublicKey(BigInteger mpi) throws OtrCryptoException {
        DHPublicKeySpec pubKeySpecs = new DHPublicKeySpec(mpi, MODULUS, GENERATOR);
        try {
            KeyFactory keyFac = KeyFactory.getInstance("DH");
            return (DHPublicKey)keyFac.generatePublic(pubKeySpecs);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("DH algorithm is unavailable.", e);
        }
        catch (InvalidKeySpecException e) {
            throw new OtrCryptoException(e);
        }
    }

    @Override
    public byte[] sha256Hmac(byte[] b, byte[] key) throws OtrCryptoException {
        return this.sha256Hmac(b, key, 0);
    }

    @Override
    public byte[] sha256Hmac(byte[] b, byte[] key, int length) throws OtrCryptoException {
        Mac mac;
        SecretKeySpec keyspec = new SecretKeySpec(key, "HmacSHA256");
        try {
            mac = Mac.getInstance("HmacSHA256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("HmacSHA256 is unavailable.");
        }
        try {
            mac.init(keyspec);
        }
        catch (InvalidKeyException e) {
            throw new OtrCryptoException(e);
        }
        byte[] macBytes = mac.doFinal(b);
        if (length > 0) {
            byte[] bytes = new byte[length];
            ByteBuffer buff = ByteBuffer.wrap(macBytes);
            buff.get(bytes);
            return bytes;
        }
        return macBytes;
    }

    @Override
    public byte[] sha1Hmac(byte[] b, byte[] key, int length) throws OtrCryptoException {
        try {
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(new SecretKeySpec(key, "HmacSHA1"));
            byte[] macBytes = mac.doFinal(b);
            if (length > 0) {
                byte[] bytes = new byte[length];
                ByteBuffer buff = ByteBuffer.wrap(macBytes);
                buff.get(bytes);
                return bytes;
            }
            return macBytes;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("HmacSHA1 algorithm support is unavailable.", e);
        }
        catch (InvalidKeyException e) {
            throw new OtrCryptoException(e);
        }
    }

    @Override
    public byte[] sha256Hmac160(byte[] b, byte[] key) throws OtrCryptoException {
        return this.sha256Hmac(b, key, 20);
    }

    @Override
    public byte[] sha256Hash(byte[] b) {
        try {
            MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
            sha256.update(b, 0, b.length);
            return sha256.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("SHA-256 support is unavailable.", e);
        }
    }

    @Override
    public byte[] sha1Hash(byte[] b) {
        try {
            MessageDigest sha256 = MessageDigest.getInstance("SHA-1");
            sha256.update(b, 0, b.length);
            return sha256.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("SHA-1 support is unavailable.", e);
        }
    }

    @Override
    public byte[] aesDecrypt(byte[] key, byte[] ctr, byte[] b) throws OtrCryptoException {
        try {
            return this.aesCipher(2, key, ctr).doFinal(b);
        }
        catch (IllegalBlockSizeException e) {
            throw new IllegalStateException("BUG: invalid block size specified.", e);
        }
        catch (BadPaddingException e) {
            throw new IllegalStateException("BUG: no padding is supposed to be used.", e);
        }
    }

    @Override
    public byte[] aesEncrypt(byte[] key, byte[] ctr, byte[] b) throws OtrCryptoException {
        try {
            return this.aesCipher(1, key, ctr).doFinal(b);
        }
        catch (IllegalBlockSizeException e) {
            throw new IllegalStateException("BUG: invalid block size specified.", e);
        }
        catch (BadPaddingException e) {
            throw new IllegalStateException("BUG: no padding is supposed to be used.", e);
        }
    }

    private Cipher aesCipher(int mode, byte[] key, byte[] ctr) throws OtrCryptoException {
        try {
            Cipher cipher = Cipher.getInstance("AES/CTR/NoPadding");
            cipher.init(mode, (Key)new SecretKeySpec(key, "AES"), new IvParameterSpec(ctr == null ? new byte[16] : ctr));
            return cipher;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("BUG: AES cipher is not supported by Java run-time.", e);
        }
        catch (NoSuchPaddingException e) {
            throw new IllegalStateException("BUG: no padding is supposed to be used.", e);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
            throw new OtrCryptoException(e);
        }
    }

    @Override
    public BigInteger generateSecret(PrivateKey privKey, PublicKey pubKey) throws OtrCryptoException {
        try {
            KeyAgreement ka = KeyAgreement.getInstance("DH");
            ka.init(privKey);
            ka.doPhase(pubKey, true);
            byte[] sb = ka.generateSecret();
            return new BigInteger(1, sb);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("DH key agreement algorithm is unavailable.", e);
        }
        catch (InvalidKeyException e) {
            throw new OtrCryptoException(e);
        }
    }

    @Override
    public byte[] sign(byte[] b, PrivateKey privatekey) throws OtrCryptoException {
        if (!(privatekey instanceof DSAPrivateKey)) {
            throw new IllegalArgumentException("Illegal type of private key provided. Only DSA private keys are supported.");
        }
        try {
            Signature signer = Signature.getInstance(DSA_SIGNATURE_ALGORITHM);
            signer.initSign(privatekey);
            signer.update(this.bytesModQ(((DSAPrivateKey)privatekey).getParams().getQ(), b));
            return this.convertSignatureASN1ToP1363(signer.sign());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("DSA signature algorithm is not available.", e);
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new OtrCryptoException(e);
        }
    }

    @Override
    public boolean verify(byte[] b, PublicKey pubKey, byte[] rs) throws OtrCryptoException {
        if (!(pubKey instanceof DSAPublicKey)) {
            throw new IllegalArgumentException("Illegal type of public key provided. Only DSA public keys are supported.");
        }
        try {
            Signature signer = Signature.getInstance(DSA_SIGNATURE_ALGORITHM);
            signer.initVerify(pubKey);
            signer.update(this.bytesModQ(((DSAPublicKey)pubKey).getParams().getQ(), b));
            return signer.verify(this.convertSignatureP1363ToASN1(rs));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("DSA signature algorithm is not available.", e);
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new OtrCryptoException(e);
        }
    }

    byte[] convertSignatureASN1ToP1363(byte[] signature) throws OtrCryptoException {
        byte sLength;
        byte rLength;
        byte signatureLength;
        ByteBuffer in = ByteBuffer.wrap(signature);
        if (in.remaining() < 1 || in.get() != 48) {
            throw new OtrCryptoException(new ProtocolException("Invalid signature content: missing or unsupported type."));
        }
        byte by = signatureLength = in.remaining() > 0 ? in.get() : (byte)0;
        if (signatureLength < 0 || signatureLength != in.remaining()) {
            throw new OtrCryptoException(new ProtocolException("Invalid signature content: unexpected length for signature."));
        }
        if (in.remaining() < 1 || in.get() != 2) {
            throw new OtrCryptoException(new ProtocolException("Invalid signature content: missing or unexpected type for parameter r."));
        }
        byte by2 = rLength = in.remaining() > 0 ? in.get() : (byte)0;
        if (rLength <= 0 || rLength > in.remaining()) {
            throw new OtrCryptoException(new ProtocolException("Invalid signature content: unexpected length or missing bytes for parameter r."));
        }
        byte[] rBytes = new byte[rLength];
        in.get(rBytes);
        BigInteger r = new BigInteger(rBytes);
        if (in.remaining() < 1 || in.get() != 2) {
            throw new OtrCryptoException(new ProtocolException("Invalid signature content: missing or unexpected type for parameter s."));
        }
        byte by3 = sLength = in.remaining() > 0 ? in.get() : (byte)0;
        if (sLength <= 0 || sLength > in.remaining()) {
            throw new OtrCryptoException(new ProtocolException("Invalid signature content: unexpected length or missing bytes for parameter s."));
        }
        byte[] sBytes = new byte[sLength];
        in.get(sBytes);
        BigInteger s = new BigInteger(sBytes);
        byte[] result = new byte[40];
        Util.asUnsignedByteArray(r, result, 0, 20);
        Util.asUnsignedByteArray(s, result, 20, 20);
        return result;
    }

    byte[] convertSignatureP1363ToASN1(byte[] signature) {
        if (signature.length != 40) {
            throw new IllegalArgumentException("Expected signature length to be exactly 40 bytes.");
        }
        byte[] rBytes = new BigInteger(1, Arrays.copyOfRange(signature, 0, 20)).toByteArray();
        byte[] sBytes = new BigInteger(1, Arrays.copyOfRange(signature, 20, 40)).toByteArray();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(48);
        out.write(2 + rBytes.length + 2 + sBytes.length);
        out.write(2);
        out.write(rBytes.length);
        out.write(rBytes, 0, rBytes.length);
        out.write(2);
        out.write(sBytes.length);
        out.write(sBytes, 0, sBytes.length);
        return out.toByteArray();
    }

    private byte[] bytesModQ(BigInteger q, byte[] data) {
        return data.length == 20 ? data : Util.asUnsignedByteArray(20, new BigInteger(1, data).mod(q));
    }

    @Override
    public String getFingerprint(PublicKey pubKey) throws OtrCryptoException {
        byte[] b = this.getFingerprintRaw(pubKey);
        return SerializationUtils.byteArrayToHexString(b);
    }

    @Override
    public byte[] getFingerprintRaw(PublicKey pubKey) throws OtrCryptoException {
        byte[] b;
        try {
            byte[] bRemotePubKey = SerializationUtils.writePublicKey(pubKey);
            if (pubKey.getAlgorithm().equals("DSA")) {
                byte[] trimmed = new byte[bRemotePubKey.length - 2];
                System.arraycopy(bRemotePubKey, 2, trimmed, 0, trimmed.length);
                b = this.sha1Hash(trimmed);
            } else {
                b = this.sha1Hash(bRemotePubKey);
            }
        }
        catch (IOException e) {
            throw new OtrCryptoException(e);
        }
        return b;
    }
}

