/*
 * Decompiled with CFR 0.152.
 */
package net.java.otr4j;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Properties;
import net.java.otr4j.OtrKeyManager;
import net.java.otr4j.OtrKeyManagerListener;
import net.java.otr4j.OtrKeyManagerStore;
import net.java.otr4j.crypto.OtrCryptoEngineImpl;
import net.java.otr4j.crypto.OtrCryptoException;
import net.java.otr4j.session.SessionID;

public class OtrKeyManagerImpl
implements OtrKeyManager {
    private final OtrKeyManagerStore store;
    private final List<OtrKeyManagerListener> listeners = new ArrayList<OtrKeyManagerListener>();

    public OtrKeyManagerImpl(OtrKeyManagerStore store) {
        this.store = store;
    }

    public OtrKeyManagerImpl(String filepath) throws IOException {
        this.store = new DefaultPropertiesStore(filepath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(OtrKeyManagerListener l) {
        List<OtrKeyManagerListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(l)) {
                this.listeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(OtrKeyManagerListener l) {
        List<OtrKeyManagerListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    @Override
    public void generateLocalKeyPair(SessionID sessionID) {
        KeyPair keyPair;
        if (sessionID == null) {
            return;
        }
        String accountID = sessionID.getAccountID();
        try {
            keyPair = KeyPairGenerator.getInstance("DSA").genKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return;
        }
        PublicKey pubKey = keyPair.getPublic();
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(pubKey.getEncoded());
        this.store.setProperty(accountID + ".publicKey", x509EncodedKeySpec.getEncoded());
        PrivateKey privKey = keyPair.getPrivate();
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(privKey.getEncoded());
        this.store.setProperty(accountID + ".privateKey", pkcs8EncodedKeySpec.getEncoded());
    }

    @Override
    public String getLocalFingerprint(SessionID sessionID) {
        KeyPair keyPair = this.loadLocalKeyPair(sessionID);
        if (keyPair == null) {
            return null;
        }
        PublicKey pubKey = keyPair.getPublic();
        try {
            return new OtrCryptoEngineImpl().getFingerprint(pubKey);
        }
        catch (OtrCryptoException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public byte[] getLocalFingerprintRaw(SessionID sessionID) {
        KeyPair keyPair = this.loadLocalKeyPair(sessionID);
        if (keyPair == null) {
            return null;
        }
        PublicKey pubKey = keyPair.getPublic();
        try {
            return new OtrCryptoEngineImpl().getFingerprintRaw(pubKey);
        }
        catch (OtrCryptoException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getRemoteFingerprint(SessionID sessionID) {
        PublicKey remotePublicKey = this.loadRemotePublicKey(sessionID);
        if (remotePublicKey == null) {
            return null;
        }
        try {
            return new OtrCryptoEngineImpl().getFingerprint(remotePublicKey);
        }
        catch (OtrCryptoException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean isVerified(SessionID sessionID) {
        if (sessionID == null) {
            return false;
        }
        return this.store.getPropertyBoolean(sessionID.getUserID() + ".publicKey.verified", false);
    }

    @Override
    public KeyPair loadLocalKeyPair(SessionID sessionID) {
        PrivateKey privateKey;
        PublicKey publicKey;
        if (sessionID == null) {
            return null;
        }
        String accountID = sessionID.getAccountID();
        byte[] b64PrivKey = this.store.getPropertyBytes(accountID + ".privateKey");
        if (b64PrivKey == null) {
            return null;
        }
        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(b64PrivKey);
        byte[] b64PubKey = this.store.getPropertyBytes(accountID + ".publicKey");
        if (b64PubKey == null) {
            return null;
        }
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(b64PubKey);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            publicKey = keyFactory.generatePublic(publicKeySpec);
            privateKey = keyFactory.generatePrivate(privateKeySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            e.printStackTrace();
            return null;
        }
        return new KeyPair(publicKey, privateKey);
    }

    @Override
    public PublicKey loadRemotePublicKey(SessionID sessionID) {
        if (sessionID == null) {
            return null;
        }
        String userID = sessionID.getUserID();
        byte[] b64PubKey = this.store.getPropertyBytes(userID + ".publicKey");
        if (b64PubKey == null) {
            return null;
        }
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(b64PubKey);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            return keyFactory.generatePublic(publicKeySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void savePublicKey(SessionID sessionID, PublicKey pubKey) {
        if (sessionID == null) {
            return;
        }
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(pubKey.getEncoded());
        String userID = sessionID.getUserID();
        this.store.setProperty(userID + ".publicKey", x509EncodedKeySpec.getEncoded());
        this.store.removeProperty(userID + ".publicKey.verified");
    }

    @Override
    public void unverify(SessionID sessionID) {
        if (sessionID == null) {
            return;
        }
        if (!this.isVerified(sessionID)) {
            return;
        }
        this.store.removeProperty(sessionID.getUserID() + ".publicKey.verified");
        for (OtrKeyManagerListener l : this.listeners) {
            l.verificationStatusChanged(sessionID);
        }
    }

    @Override
    public void verify(SessionID sessionID) {
        if (sessionID == null) {
            return;
        }
        if (this.isVerified(sessionID)) {
            return;
        }
        this.store.setProperty(sessionID.getUserID() + ".publicKey.verified", true);
        for (OtrKeyManagerListener l : this.listeners) {
            l.verificationStatusChanged(sessionID);
        }
    }

    public static class DefaultPropertiesStore
    implements OtrKeyManagerStore {
        private final Properties properties = new Properties();
        private final String filepath;

        public DefaultPropertiesStore(String filepath) throws IOException {
            if (filepath == null || filepath.length() < 1) {
                throw new IllegalArgumentException();
            }
            this.filepath = filepath;
            this.properties.clear();
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.getConfigurationFile()));){
                this.properties.load(in);
            }
        }

        private File getConfigurationFile() throws IOException {
            File configFile = new File(this.filepath);
            if (!configFile.exists()) {
                configFile.createNewFile();
            }
            return configFile;
        }

        @Override
        public void setProperty(String id, boolean value) {
            this.properties.setProperty(id, "true");
            try {
                this.store();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void store() throws FileNotFoundException, IOException {
            try (FileOutputStream out = new FileOutputStream(this.getConfigurationFile());){
                this.properties.store(out, null);
            }
        }

        @Override
        public void setProperty(String id, byte[] value) {
            this.properties.setProperty(id, Base64.getEncoder().encodeToString(value));
            try {
                this.store();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void removeProperty(String id) {
            this.properties.remove(id);
        }

        @Override
        public byte[] getPropertyBytes(String id) {
            String value = this.properties.getProperty(id);
            if (value == null) {
                return null;
            }
            return Base64.getDecoder().decode(value);
        }

        @Override
        public boolean getPropertyBoolean(String id, boolean defaultValue) {
            try {
                return Boolean.parseBoolean(this.properties.get(id).toString());
            }
            catch (Exception e) {
                return defaultValue;
            }
        }
    }
}

