/*
 * Decompiled with CFR 0.152.
 */
package com.ircclouds.irc.api;

import com.ircclouds.irc.api.AbstractApiDaemon;
import com.ircclouds.irc.api.AbstractCommandServerImpl;
import com.ircclouds.irc.api.AbstractMessageReader;
import com.ircclouds.irc.api.Callback;
import com.ircclouds.irc.api.ICommandServer;
import com.ircclouds.irc.api.IIRCSession;
import com.ircclouds.irc.api.IMessageDispatcher;
import com.ircclouds.irc.api.IMessageReader;
import com.ircclouds.irc.api.MessageDispatcherImpl;
import com.ircclouds.irc.api.commands.ICommand;
import com.ircclouds.irc.api.comms.IConnection;
import com.ircclouds.irc.api.comms.SSLSocketChannelConnection;
import com.ircclouds.irc.api.comms.SocketChannelConnection;
import com.ircclouds.irc.api.domain.IRCServer;
import com.ircclouds.irc.api.domain.IRCServerOptions;
import com.ircclouds.irc.api.domain.SecureIRCServer;
import com.ircclouds.irc.api.domain.messages.ClientErrorMessage;
import com.ircclouds.irc.api.filters.IMessageFilter;
import com.ircclouds.irc.api.filters.TargetListeners;
import com.ircclouds.irc.api.listeners.IMessageListener;
import com.ircclouds.irc.api.listeners.MESSAGE_VISIBILITY;
import com.ircclouds.irc.api.state.IIRCState;
import java.io.IOException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;

public abstract class AbstractIRCSession
implements IIRCSession {
    private final IMessageDispatcher dispatcher = new MessageDispatcherImpl();
    private final ICommandServer cmdServ = new AbstractCommandServerImpl(){

        @Override
        public IConnection getConnection() {
            return AbstractIRCSession.this.conn;
        }
    };
    private final IMessageReader reader = new AbstractMessageReader(){

        @Override
        protected IRCServerOptions getIRCServerOptions() {
            return AbstractIRCSession.this.getIRCServerOptions();
        }

        @Override
        public IConnection getConnection() {
            return AbstractIRCSession.this.conn;
        }
    };
    private final AbstractApiDaemon daemon = new AbstractApiDaemon(this.reader, this.dispatcher){

        @Override
        protected void onExit() {
            try {
                AbstractIRCSession.this.close();
            }
            catch (IOException aExc) {
                throw new RuntimeException(aExc);
            }
        }

        @Override
        protected IMessageFilter getMessageFilter() {
            return AbstractIRCSession.this.getMessageFilter();
        }

        @Override
        protected void signalExceptionToApi(Exception aExc) {
            AbstractIRCSession.this.callback.onFailure(aExc);
        }
    };
    private IConnection conn;
    private Callback<IIRCState> callback;

    public void execute(ICommand aCommand) throws IOException {
        this.cmdServ.execute(aCommand);
    }

    @Override
    public void addListeners(MESSAGE_VISIBILITY aListenerLevel, IMessageListener ... aListeners) {
        for (IMessageListener _listener : aListeners) {
            this.dispatcher.register(_listener, aListenerLevel);
        }
    }

    @Override
    public ICommandServer getCommandServer() {
        return this.cmdServ;
    }

    @Override
    public void removeListener(IMessageListener aListener) {
        this.dispatcher.unregister(aListener);
    }

    @Override
    public boolean open(IRCServer aServer, Callback<IIRCState> aCallback) throws IOException {
        this.callback = aCallback;
        this.conn = aServer.isSSL() == false ? new SocketChannelConnection() : new SSLSocketChannelConnection();
        SSLContext _ctx = null;
        if (aServer instanceof SecureIRCServer) {
            _ctx = ((SecureIRCServer)aServer).getSSLContext();
        }
        if (this.conn.open(aServer.getHostname(), aServer.getPort(), _ctx, aServer.getProxy(), aServer.isResolveByProxy())) {
            if (!this.daemon.isAlive()) {
                this.daemon.start();
            }
            return true;
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        this.conn.close();
        this.reader.reset();
    }

    protected abstract IRCServerOptions getIRCServerOptions();

    @Override
    public void dispatchClientError(final Exception e) {
        final IMessageDispatcher currentDispatcher = this.dispatcher;
        new Thread(){

            @Override
            public void run() {
                ClientErrorMessage errorMsg = new ClientErrorMessage(e);
                currentDispatcher.dispatch(errorMsg, TargetListeners.ALL);
            }
        }.start();
    }

    @Override
    public void secureConnection(SSLContext aContext, String aHostname, int aPort) throws SSLException {
        if (!(this.conn instanceof SocketChannelConnection)) {
            throw new IllegalArgumentException("unsupported connection type in use");
        }
        this.conn = new SSLSocketChannelConnection((SocketChannelConnection)this.conn, aContext, aHostname, aPort);
    }
}

