/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import net.sf.fmj.media.rtp.SynchSource;
import net.sf.fmj.media.rtp.util.SSRCTable;

public class StreamSynch {
    private SSRCTable<SynchSource> sources;

    public StreamSynch() {
        if (this.sources == null) {
            this.sources = new SSRCTable();
        }
    }

    public long calcTimestamp(int ssrc, int pt, long rtpTimestamp) {
        long timestamp = -1L;
        SynchSource source = this.sources.get(ssrc);
        if (source != null) {
            long rate = 1L;
            if (pt >= 0 && pt <= 5) {
                rate = 8000L;
            } else if (pt == 5) {
                rate = 8000L;
            } else if (pt == 6) {
                rate = 16000L;
            } else if (pt >= 7 && pt <= 9) {
                rate = 8000L;
            } else if (pt >= 10 && pt <= 11) {
                rate = 44100L;
            } else if (pt == 14) {
                rate = 90000L;
            } else if (pt == 15) {
                rate = 8000L;
            } else if (pt == 16) {
                rate = 11025L;
            } else if (pt == 17) {
                rate = 22050L;
            } else if (pt >= 25 && pt <= 26) {
                rate = 90000L;
            } else if (pt == 28) {
                rate = 90000L;
            } else if (pt >= 31 && pt <= 34) {
                rate = 90000L;
            } else if (pt == 42) {
                rate = 90000L;
            }
            timestamp = source.ntpTimestamp + (rtpTimestamp - source.rtpTimestamp) * 1000L * 1000L * 1000L / rate;
        }
        return timestamp;
    }

    public void remove(int ssrc) {
        if (this.sources != null) {
            this.sources.remove(ssrc);
        }
    }

    public void update(int ssrc, long rtpTimestamp, long ntpTimestampMSW, long ntpTimestampLSW) {
        double fraction = (double)ntpTimestampLSW / 4.294967296E9;
        long ntpTimestamp = ntpTimestampMSW * 1000000000L + (long)(fraction * 1.0E9);
        SynchSource source = this.sources.get(ssrc);
        if (source == null) {
            this.sources.put(ssrc, new SynchSource(ssrc, rtpTimestamp, ntpTimestamp));
        } else {
            source.factor = (rtpTimestamp - source.rtpTimestamp) * (ntpTimestamp - source.ntpTimestamp);
            source.rtpTimestamp = rtpTimestamp;
            source.ntpTimestamp = ntpTimestamp;
        }
    }
}

