/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Format;
import javax.media.control.BufferControl;
import javax.media.format.AudioFormat;
import javax.media.format.UnsupportedFormatException;
import javax.media.format.VideoFormat;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import javax.media.rtp.EncryptionInfo;
import javax.media.rtp.GlobalReceptionStats;
import javax.media.rtp.GlobalTransmissionStats;
import javax.media.rtp.InvalidSessionAddressException;
import javax.media.rtp.LocalParticipant;
import javax.media.rtp.Participant;
import javax.media.rtp.RTPConnector;
import javax.media.rtp.RTPControl;
import javax.media.rtp.RTPManager;
import javax.media.rtp.RTPPushDataSource;
import javax.media.rtp.RTPSocket;
import javax.media.rtp.RTPStream;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.RemoteListener;
import javax.media.rtp.RemoteParticipant;
import javax.media.rtp.SSRCInUseException;
import javax.media.rtp.SendStream;
import javax.media.rtp.SendStreamListener;
import javax.media.rtp.SessionAddress;
import javax.media.rtp.SessionListener;
import javax.media.rtp.SessionManager;
import javax.media.rtp.SessionManagerException;
import javax.media.rtp.event.NewSendStreamEvent;
import javax.media.rtp.event.StreamClosedEvent;
import javax.media.rtp.rtcp.SourceDescription;
import net.sf.fmj.media.rtp.BufferControlImpl;
import net.sf.fmj.media.rtp.DefaultRTCPTransmitterFactory;
import net.sf.fmj.media.rtp.FormatInfo;
import net.sf.fmj.media.rtp.GenerateSSRCCause;
import net.sf.fmj.media.rtp.OverallStats;
import net.sf.fmj.media.rtp.OverallTransStats;
import net.sf.fmj.media.rtp.PassiveSSRCInfo;
import net.sf.fmj.media.rtp.RTCPRawReceiver;
import net.sf.fmj.media.rtp.RTCPRawSender;
import net.sf.fmj.media.rtp.RTCPReceiver;
import net.sf.fmj.media.rtp.RTCPReporter;
import net.sf.fmj.media.rtp.RTCPTransmitter;
import net.sf.fmj.media.rtp.RTCPTransmitterFactory;
import net.sf.fmj.media.rtp.RTPControlImpl;
import net.sf.fmj.media.rtp.RTPDemultiplexer;
import net.sf.fmj.media.rtp.RTPMediaLocator;
import net.sf.fmj.media.rtp.RTPRawReceiver;
import net.sf.fmj.media.rtp.RTPRawSender;
import net.sf.fmj.media.rtp.RTPReceiver;
import net.sf.fmj.media.rtp.RTPSourceInfo;
import net.sf.fmj.media.rtp.RTPSourceInfoCache;
import net.sf.fmj.media.rtp.RTPSourceStream;
import net.sf.fmj.media.rtp.RTPTransmitter;
import net.sf.fmj.media.rtp.SSRCCache;
import net.sf.fmj.media.rtp.SSRCCacheCleaner;
import net.sf.fmj.media.rtp.SSRCInfo;
import net.sf.fmj.media.rtp.SendSSRCInfo;
import net.sf.fmj.media.rtp.StreamSynch;
import net.sf.fmj.media.rtp.TrueRandom;
import net.sf.fmj.media.rtp.util.PacketForwarder;
import net.sf.fmj.media.rtp.util.RTPPacketSender;
import net.sf.fmj.media.rtp.util.SSRCTable;
import net.sf.fmj.media.rtp.util.UDPPacketSender;

public class RTPSessionMgr
extends RTPManager
implements SessionManager {
    private static final Logger logger = Logger.getLogger(RTPSessionMgr.class.getName());
    private static final String SOURCE_DESC_EMAIL = "fmj-devel@lists.sourceforge.net";
    private static final String SOURCE_DESC_TOOL = "FMJ RTP Player";
    private RTCPTransmitterFactory rtcpTransmitterFactory;
    boolean bindtome = false;
    private SSRCCache cache = null;
    int ttl = 0;
    int sendercount = 0;
    InetAddress localDataAddress = null;
    int localDataPort = 0;
    InetAddress localControlAddress = null;
    int localControlPort = 0;
    InetAddress dataaddress = null;
    InetAddress controladdress = null;
    int dataport = 0;
    int controlport = 0;
    RTPPushDataSource rtpsource = null;
    RTPPushDataSource rtcpsource = null;
    long defaultSSRC = 0L;
    SessionAddress localSenderAddress = null;
    private SessionAddress localReceiverAddress = null;
    UDPPacketSender udpsender = null;
    RTPPacketSender rtpsender = null;
    RTCPRawSender sender = null;
    SSRCCacheCleaner cleaner = null;
    private boolean unicast = false;
    private boolean startedparticipating = false;
    private boolean nonparticipating = false;
    private boolean nosockets = false;
    private boolean started = false;
    private boolean initialized = false;
    protected Vector sessionlistener = null;
    protected Vector remotelistener = null;
    protected Vector streamlistener = null;
    protected Vector sendstreamlistener = null;
    private static final int GET_ALL_PARTICIPANTS = -1;
    boolean encryption = false;
    final SSRCTable<net.sf.fmj.media.protocol.rtp.DataSource> dslist = new SSRCTable();
    StreamSynch streamSynch = null;
    FormatInfo formatinfo = null;
    net.sf.fmj.media.protocol.rtp.DataSource defaultsource = null;
    PushBufferStream defaultstream = null;
    Format defaultformat = null;
    BufferControl buffercontrol = null;
    public OverallStats defaultstats = null;
    public OverallTransStats transstats = null;
    int defaultsourceid = 0;
    Vector sendstreamlist = null;
    RTPTransmitter rtpTransmitter = null;
    boolean bds = false;
    Vector peerlist = null;
    boolean multi_unicast = false;
    Hashtable peerrtplist = null;
    Hashtable peerrtcplist = null;
    static FormatInfo supportedList = null;
    static Vector addedList = new Vector();
    private boolean newRtpInterface = false;
    private SessionAddress remoteAddress = null;
    private SessionAddress localAddress = null;
    private RTCPRawReceiver rtcpRawReceiver = null;
    private RTPRawReceiver rtpRawReceiver = null;
    private PacketForwarder rtpForwarder = null;
    private PacketForwarder rtcpForwarder = null;
    private RTPDemultiplexer rtpDemultiplexer = null;
    private OverallStats overallStats = null;
    private boolean participating = false;
    private UDPPacketSender udpPacketSender = null;
    private Vector remoteAddresses = null;
    private RTCPTransmitter rtcpTransmitter = null;
    private RTPConnector rtpConnector = null;
    private DatagramSocket dataSocket = null;
    private DatagramSocket controlSocket = null;
    private final int MAX_PORT = 65535;

    public RTCPTransmitterFactory getOrCreateRTCPTransmitterFactory() {
        if (this.rtcpTransmitterFactory == null) {
            this.rtcpTransmitterFactory = new DefaultRTCPTransmitterFactory();
        }
        return this.rtcpTransmitterFactory;
    }

    public void setRTCPTransmitterFactory(RTCPTransmitterFactory rtcpTransmitterFactory) {
        this.rtcpTransmitterFactory = rtcpTransmitterFactory;
    }

    public static boolean formatSupported(Format format) {
        if (supportedList == null) {
            supportedList = new FormatInfo();
        }
        if (supportedList.getPayload(format) != -1) {
            return true;
        }
        for (int i = 0; i < addedList.size(); ++i) {
            Format format1 = (Format)addedList.elementAt(i);
            if (!format1.matches(format)) continue;
            return true;
        }
        return false;
    }

    public RTPSessionMgr() {
        this.sessionlistener = new Vector();
        this.remotelistener = new Vector();
        this.streamlistener = new Vector();
        this.sendstreamlistener = new Vector();
        this.sendstreamlist = new Vector(1);
        this.peerlist = new Vector();
        this.peerrtplist = new Hashtable(5);
        this.peerrtcplist = new Hashtable(5);
        this.formatinfo = new FormatInfo();
        this.buffercontrol = new BufferControlImpl();
        this.defaultstats = new OverallStats();
        this.transstats = new OverallTransStats();
        this.streamSynch = new StreamSynch();
    }

    public RTPSessionMgr(net.sf.fmj.media.protocol.rtp.DataSource datasource) throws IOException {
        this.sessionlistener = new Vector();
        this.remotelistener = new Vector();
        this.streamlistener = new Vector();
        this.sendstreamlistener = new Vector();
        this.sendstreamlist = new Vector(1);
        this.peerlist = new Vector();
        this.peerrtplist = new Hashtable(5);
        this.peerrtcplist = new Hashtable(5);
        this.formatinfo = new FormatInfo();
        this.buffercontrol = new BufferControlImpl();
        this.defaultstats = new OverallStats();
        this.transstats = new OverallTransStats();
        this.UpdateEncodings(datasource);
        RTPMediaLocator rtpmedialocator = null;
        try {
            rtpmedialocator = new RTPMediaLocator(datasource.getLocator().toString());
        }
        catch (MalformedURLException malformedurlexception) {
            throw new IOException("RTP URL is Malformed " + malformedurlexception.getMessage());
        }
        net.sf.fmj.media.protocol.rtp.DataSource datasource1 = this.createNewDS(rtpmedialocator);
        RTPControl rtpcontrol = (RTPControl)datasource.getControl("javax.media.rtp.RTPControl");
        datasource1.setControl(rtpcontrol);
        String s = rtpmedialocator.getSessionAddress();
        this.dataport = rtpmedialocator.getSessionPort();
        this.controlport = this.dataport + 1;
        this.ttl = rtpmedialocator.getTTL();
        try {
            this.dataaddress = InetAddress.getByName(s);
        }
        catch (Throwable throwable1) {
            logger.log(Level.WARNING, "error retrieving address " + s + " by name" + throwable1.getMessage(), throwable1);
        }
        this.controladdress = this.dataaddress;
        SessionAddress sessionaddress = new SessionAddress();
        try {
            this.initSession(sessionaddress, this.setSDES(), 0.05, 0.25);
        }
        catch (SessionManagerException sessionmanagerexception) {
            throw new IOException("SessionManager exception " + sessionmanagerexception.getMessage());
        }
    }

    public RTPSessionMgr(RTPPushDataSource rtppushdatasource) {
        this.sessionlistener = new Vector();
        this.remotelistener = new Vector();
        this.streamlistener = new Vector();
        this.sendstreamlistener = new Vector();
        this.sendstreamlist = new Vector(1);
        this.peerlist = new Vector();
        this.peerrtplist = new Hashtable(5);
        this.peerrtcplist = new Hashtable(5);
        this.nosockets = true;
        this.rtpsource = rtppushdatasource;
        if (this.rtpsource instanceof RTPSocket) {
            this.rtcpsource = ((RTPSocket)this.rtpsource).getControlChannel();
        }
        this.formatinfo = new FormatInfo();
        this.buffercontrol = new BufferControlImpl();
        this.defaultstats = new OverallStats();
        this.transstats = new OverallTransStats();
        net.sf.fmj.media.protocol.rtp.DataSource datasource = this.createNewDS(null);
        this.UpdateEncodings(rtppushdatasource);
        RTPControl rtpcontrol = (RTPControl)rtppushdatasource.getControl(RTPControl.class.getName());
        datasource.setControl(rtpcontrol);
        this.initSession(this.setSDES(), 0.05, 0.25);
        this.startSession(this.rtpsource, this.rtcpsource, null);
    }

    @Override
    public void addFormat(Format format, int i) {
        if (this.formatinfo != null) {
            this.formatinfo.add(i, format);
        }
        if (format != null && !addedList.contains(format)) {
            addedList.addElement(format);
        }
    }

    public void addMRL(RTPMediaLocator rtpmedialocator) {
        net.sf.fmj.media.protocol.rtp.DataSource datasource;
        int i = (int)rtpmedialocator.getSSRC();
        if (i != 0 && (datasource = this.dslist.get(i)) == null) {
            this.createNewDS(rtpmedialocator);
        }
    }

    @Override
    public void addPeer(SessionAddress sessionaddress) throws IOException, InvalidSessionAddressException {
        for (int i = 0; i < this.peerlist.size(); ++i) {
            SessionAddress sessionaddress1 = (SessionAddress)this.peerlist.elementAt(i);
            if (!sessionaddress1.equals(sessionaddress)) continue;
            return;
        }
        this.peerlist.addElement(sessionaddress);
        this.CheckRTPPorts(sessionaddress.getDataPort(), sessionaddress.getControlPort());
        RTCPRawReceiver rtcprawreceiver = null;
        RTPRawReceiver rtprawreceiver = null;
        InetAddress inetaddress = sessionaddress.getDataAddress();
        InetAddress inetaddress1 = sessionaddress.getControlAddress();
        int j = sessionaddress.getDataPort();
        int k = sessionaddress.getControlPort();
        this.CheckRTPAddress(inetaddress, inetaddress1);
        InetAddress inetaddress2 = null;
        try {
            inetaddress2 = InetAddress.getLocalHost();
        }
        catch (Throwable throwable1) {
            logger.log(Level.WARNING, "InitSession : UnknownHostExcpetion " + throwable1.getMessage(), throwable1);
        }
        if (!inetaddress.isMulticastAddress() && !inetaddress.equals(inetaddress2)) {
            this.bindtome = !this.isBroadcast(inetaddress) || this.Win32();
        }
        if (this.bindtome) {
            return;
        }
        try {
            rtcprawreceiver = new RTCPRawReceiver(k, inetaddress1.getHostAddress(), this.defaultstats, this.streamSynch);
            if (inetaddress != null) {
                rtprawreceiver = new RTPRawReceiver(j, inetaddress.getHostAddress(), this.defaultstats);
            }
        }
        catch (SocketException socketexception) {
            throw new IOException(socketexception.getMessage());
        }
        finally {
            if (inetaddress != null && rtprawreceiver == null && rtcprawreceiver != null) {
                logger.warning("could not create RTCP/RTP raw receivers");
                rtcprawreceiver.closeSource();
            }
        }
        try {
            rtcprawreceiver = new RTCPRawReceiver(k, inetaddress2.getHostAddress(), this.defaultstats, this.streamSynch);
            if (inetaddress != null) {
                rtprawreceiver = new RTPRawReceiver(j, inetaddress2.getHostAddress(), this.defaultstats);
            }
        }
        catch (SocketException socketexception1) {
            throw new IOException(socketexception1.getMessage());
        }
        finally {
            if (inetaddress != null && rtprawreceiver == null && rtcprawreceiver != null) {
                logger.warning("could not create RTCP/RTP raw receivers");
                rtcprawreceiver.closeSource();
            }
        }
        PacketForwarder packetforwarder = new PacketForwarder(rtcprawreceiver, new RTCPReceiver(this.cache));
        PacketForwarder packetforwarder1 = null;
        if (rtprawreceiver != null) {
            packetforwarder1 = new PacketForwarder(rtprawreceiver, new RTPReceiver(this.cache, this.rtpDemultiplexer));
        }
        packetforwarder.startPF("RTCP Forwarder for address" + inetaddress1.toString() + "port " + k);
        if (packetforwarder1 != null) {
            packetforwarder1.startPF("RTP Forwarder for address " + inetaddress.toString() + "port " + j);
        }
        this.peerrtplist.put(sessionaddress, packetforwarder1);
        this.peerrtcplist.put(sessionaddress, packetforwarder);
        if (this.cache.ourssrc != null) {
            if (this.cache.ourssrc.reporter == null) {
                this.controladdress = inetaddress1;
                this.controlport = k;
                this.cache.ourssrc.reporter = this.startParticipating(k, inetaddress.getHostAddress(), this.cache.ourssrc);
            }
            if (this.cache.ourssrc.reporter.transmit.getSender().peerlist == null) {
                this.cache.ourssrc.reporter.transmit.getSender().peerlist = new Vector();
            }
        }
        this.cache.ourssrc.reporter.transmit.getSender().peerlist.addElement(sessionaddress);
        if (this.cache != null) {
            Enumeration<SSRCInfo> elements = this.cache.cache.elements();
            while (elements.hasMoreElements()) {
                SSRCInfo ssrcinfo = elements.nextElement();
                if (!(ssrcinfo instanceof SendSSRCInfo)) continue;
                ssrcinfo.reporter.transmit.getSender().control = true;
                if (ssrcinfo.reporter.transmit.getSender().peerlist != null) continue;
                ssrcinfo.reporter.transmit.getSender().peerlist = new Vector();
                ssrcinfo.reporter.transmit.getSender().peerlist.addElement(sessionaddress);
            }
        }
        for (int l = 0; l < this.sendstreamlist.size(); ++l) {
            SendSSRCInfo sendssrcinfo = (SendSSRCInfo)this.sendstreamlist.elementAt(l);
            if (sendssrcinfo.sinkstream.transmitter.sender.peerlist != null) continue;
            sendssrcinfo.sinkstream.transmitter.sender.peerlist = new Vector();
            sendssrcinfo.sinkstream.transmitter.sender.peerlist.addElement(sessionaddress);
        }
    }

    @Override
    public void addReceiveStreamListener(ReceiveStreamListener receivestreamlistener) {
        if (!this.streamlistener.contains(receivestreamlistener)) {
            this.streamlistener.addElement(receivestreamlistener);
        }
    }

    @Override
    public void addRemoteListener(RemoteListener remotelistener1) {
        if (!this.remotelistener.contains(remotelistener1)) {
            this.remotelistener.addElement(remotelistener1);
        }
    }

    void addSendStream(SendStream sendstream) {
        this.sendstreamlist.addElement(sendstream);
    }

    @Override
    public void addSendStreamListener(SendStreamListener sendstreamlistener1) {
        if (!this.sendstreamlistener.contains(sendstreamlistener1)) {
            this.sendstreamlistener.addElement(sendstreamlistener1);
        }
    }

    @Override
    public void addSessionListener(SessionListener sessionlistener1) {
        if (!this.sessionlistener.contains(sessionlistener1)) {
            this.sessionlistener.addElement(sessionlistener1);
        }
    }

    @Override
    public void addTarget(SessionAddress sessionaddress) throws IOException {
        this.remoteAddresses.addElement(sessionaddress);
        if (this.remoteAddresses.size() > 1) {
            this.setRemoteAddresses();
            return;
        }
        this.remoteAddress = sessionaddress;
        logger.finest("Added target: " + sessionaddress);
        try {
            this.rtcpRawReceiver = new RTCPRawReceiver(this.localAddress, sessionaddress, this.defaultstats, this.streamSynch, this.controlSocket);
            this.rtpRawReceiver = new RTPRawReceiver(this.localAddress, sessionaddress, this.defaultstats, this.dataSocket);
        }
        catch (SocketException socketexception) {
            throw new IOException(socketexception.getMessage());
        }
        catch (UnknownHostException unknownhostexception) {
            throw new IOException(unknownhostexception.getMessage());
        }
        this.rtpDemultiplexer = new RTPDemultiplexer(this.cache, this.rtpRawReceiver, this.streamSynch);
        this.rtcpForwarder = new PacketForwarder(this.rtcpRawReceiver, new RTCPReceiver(this.cache));
        if (this.rtpRawReceiver != null) {
            this.rtpForwarder = new PacketForwarder(this.rtpRawReceiver, new RTPReceiver(this.cache, this.rtpDemultiplexer));
        }
        this.rtcpForwarder.startPF("RTCP Forwarder for address" + sessionaddress.getControlHostAddress() + " port " + sessionaddress.getControlPort());
        if (this.rtpForwarder != null) {
            this.rtpForwarder.startPF("RTP Forwarder for address " + sessionaddress.getDataHostAddress() + " port " + sessionaddress.getDataPort());
        }
        this.cleaner = new SSRCCacheCleaner(this.cache, this.streamSynch);
        if (this.cache.ourssrc != null && this.participating) {
            this.cache.ourssrc.reporter = this.startParticipating(this.rtcpRawReceiver.socket);
        }
    }

    public void addUnicastAddr(InetAddress inetaddress) {
        if (this.sender != null) {
            this.sender.addDestAddr(inetaddress);
        }
    }

    private void CheckRTPAddress(InetAddress inetaddress, InetAddress inetaddress1) throws InvalidSessionAddressException {
        if (inetaddress == null && inetaddress1 == null) {
            throw new InvalidSessionAddressException("Data and control addresses are null");
        }
        if (inetaddress1 == null && inetaddress != null) {
            inetaddress1 = inetaddress;
        }
        if (inetaddress == null && inetaddress1 != null) {
            inetaddress = inetaddress1;
        }
    }

    private void CheckRTPPorts(int i, int j) throws InvalidSessionAddressException {
        if (i == 0 || i == -1) {
            i = j - 1;
        }
        if (j == 0 || j == -1) {
            j = i + 1;
        }
        if (i != 0 && i % 2 != 0) {
            throw new InvalidSessionAddressException("Data Port must be valid and even");
        }
        if (j != 0 && j % 2 != 1) {
            throw new InvalidSessionAddressException("Control Port must be valid and odd");
        }
        if (j != i + 1) {
            throw new InvalidSessionAddressException("Control Port must be one higher than the Data Port");
        }
    }

    public void closeSession() {
        if (this.dslist.isEmpty() || this.nosockets) {
            this.closeSession("DataSource disconnected");
        }
    }

    @Override
    public void closeSession(String s) {
        this.stopParticipating(s, this.cache.ourssrc);
        if (this.defaultsource != null) {
            this.defaultsource.disconnect();
        }
        if (this.cache != null) {
            Enumeration<SSRCInfo> elements = this.cache.cache.elements();
            while (elements.hasMoreElements()) {
                SSRCInfo ssrcinfo = elements.nextElement();
                if (ssrcinfo.dstream != null) {
                    ssrcinfo.dstream.close();
                }
                if (ssrcinfo instanceof SendSSRCInfo) {
                    ((SendSSRCInfo)ssrcinfo).close();
                }
                this.stopParticipating(s, ssrcinfo);
            }
        }
        for (int i = 0; i < this.sendstreamlist.size(); ++i) {
            this.removeSendStream((SendStream)this.sendstreamlist.elementAt(i));
        }
        if (this.rtpTransmitter != null) {
            this.rtpTransmitter.close();
        }
        if (this.rtcpForwarder != null) {
            RTCPRawReceiver rtcprawreceiver = (RTCPRawReceiver)this.rtcpForwarder.getSource();
            this.rtcpForwarder.close();
            if (rtcprawreceiver != null) {
                rtcprawreceiver.close();
            }
        }
        if (this.cleaner != null) {
            this.cleaner.stop();
        }
        if (this.cache != null) {
            this.cache.destroy();
        }
        if (this.rtpForwarder != null) {
            RTPRawReceiver rtprawreceiver = (RTPRawReceiver)this.rtpForwarder.getSource();
            this.rtpForwarder.close();
            if (rtprawreceiver != null) {
                rtprawreceiver.close();
            }
        }
        if (this.multi_unicast) {
            this.removeAllPeers();
        }
    }

    public net.sf.fmj.media.protocol.rtp.DataSource createNewDS(int i) {
        net.sf.fmj.media.protocol.rtp.DataSource datasource = new net.sf.fmj.media.protocol.rtp.DataSource();
        datasource.setContentType("raw");
        try {
            datasource.connect();
        }
        catch (IOException ioexception) {
            logger.log(Level.WARNING, "Error connecting data source " + ioexception.getMessage(), ioexception);
        }
        RTPSourceStream rtpsourcestream = new RTPSourceStream(datasource);
        ((BufferControlImpl)this.buffercontrol).addSourceStream(rtpsourcestream);
        this.dslist.put(i, datasource);
        datasource.setSSRC(i);
        datasource.setMgr(this);
        return datasource;
    }

    public net.sf.fmj.media.protocol.rtp.DataSource createNewDS(RTPMediaLocator rtpmedialocator) {
        net.sf.fmj.media.protocol.rtp.DataSource datasource = new net.sf.fmj.media.protocol.rtp.DataSource();
        datasource.setContentType("raw");
        try {
            datasource.connect();
        }
        catch (IOException ioexception) {
            logger.log(Level.WARNING, "IOException in createNewDS() " + ioexception.getMessage(), ioexception);
        }
        RTPSourceStream rtpsourcestream = new RTPSourceStream(datasource);
        ((BufferControlImpl)this.buffercontrol).addSourceStream(rtpsourcestream);
        if (rtpmedialocator != null && (int)rtpmedialocator.getSSRC() != 0) {
            this.dslist.put((int)rtpmedialocator.getSSRC(), datasource);
            datasource.setSSRC((int)rtpmedialocator.getSSRC());
            datasource.setMgr(this);
        } else {
            this.defaultsource = datasource;
            this.defaultstream = rtpsourcestream;
        }
        return datasource;
    }

    @Override
    public SendStream createSendStream(int ssrc, DataSource datasource, int j) throws UnsupportedFormatException, IOException, SSRCInUseException {
        SSRCInfo ssrcinfo;
        if (this.sendercount != 0 && (ssrcinfo = this.cache.lookup(ssrc)) != null) {
            throw new SSRCInUseException("SSRC supplied is already in use");
        }
        if (this.cache.rtcp_bw_fraction == 0.0) {
            throw new IOException("Initialized with zero RTP/RTCP outgoing bandwidth. Cannot create a sending stream ");
        }
        PushBufferStream[] apushbufferstream = ((PushBufferDataSource)datasource).getStreams();
        PushBufferStream pushbufferstream = apushbufferstream[j];
        Format format = pushbufferstream.getFormat();
        int l = this.formatinfo.getPayload(format);
        if (l == -1) {
            throw new UnsupportedFormatException("Format of Stream not supported in RTP Session Manager", format);
        }
        SendSSRCInfo obj = null;
        if (this.sendercount == 0) {
            obj = new SendSSRCInfo(this.cache.ourssrc);
            obj.ours = true;
            this.cache.ourssrc = obj;
            this.cache.getMainCache().put(obj.ssrc, obj);
        } else {
            obj = (SendSSRCInfo)this.cache.get(ssrc, this.dataaddress, this.dataport, 3);
            obj.ours = true;
            obj.reporter = !this.nosockets ? this.startParticipating(this.controlport, this.controladdress.getHostAddress(), obj) : this.startParticipating(this.rtcpsource, (SSRCInfo)obj);
        }
        obj.payloadType = l;
        obj.sinkstream.setSSRCInfo(obj);
        obj.setFormat(format);
        if (format instanceof VideoFormat) {
            obj.clockrate = 90000;
        } else if (format instanceof AudioFormat) {
            obj.clockrate = (int)((AudioFormat)format).getSampleRate();
        } else {
            throw new UnsupportedFormatException("Format not supported", format);
        }
        obj.pds = datasource;
        pushbufferstream.setTransferHandler(obj.sinkstream);
        if (this.multi_unicast) {
            if (this.peerlist.size() > 0) {
                SessionAddress sessionaddress = (SessionAddress)this.peerlist.firstElement();
                this.dataport = sessionaddress.getDataPort();
                this.dataaddress = sessionaddress.getDataAddress();
            } else {
                throw new IOException("At least one peer must be added");
            }
        }
        if (this.rtpTransmitter == null) {
            if (this.rtpConnector != null) {
                this.rtpTransmitter = this.startDataTransmission(this.rtpConnector);
            } else if (this.nosockets) {
                this.rtpTransmitter = this.startDataTransmission(this.rtpsource);
            } else {
                if (this.newRtpInterface) {
                    this.dataport = this.remoteAddress.getDataPort();
                    this.dataaddress = this.remoteAddress.getDataAddress();
                }
                this.rtpTransmitter = this.startDataTransmission(this.dataport, this.dataaddress.getHostAddress());
            }
            if (this.rtpTransmitter == null) {
                throw new IOException("Cannot create a transmitter");
            }
        }
        obj.sinkstream.setTransmitter(this.rtpTransmitter);
        this.addSendStream(obj);
        if (this.multi_unicast) {
            for (int i1 = 0; i1 < this.peerlist.size(); ++i1) {
                SessionAddress sessionaddress1 = (SessionAddress)this.peerlist.elementAt(i1);
                if (obj.sinkstream.transmitter.sender.peerlist == null) {
                    obj.sinkstream.transmitter.sender.peerlist = new Vector();
                }
                obj.sinkstream.transmitter.sender.peerlist.addElement(sessionaddress1);
                if (this.cache == null) continue;
                Enumeration<SSRCInfo> elements = this.cache.cache.elements();
                while (elements.hasMoreElements()) {
                    SSRCInfo ssrcinfo1 = elements.nextElement();
                    if (!(ssrcinfo1 instanceof SendSSRCInfo)) continue;
                    ssrcinfo1.reporter.transmit.getSender().control = true;
                    if (ssrcinfo1.reporter.transmit.getSender().peerlist == null) {
                        ssrcinfo1.reporter.transmit.getSender().peerlist = new Vector();
                    }
                    ssrcinfo1.reporter.transmit.getSender().peerlist.addElement(sessionaddress1);
                }
            }
        }
        obj.sinkstream.startStream();
        NewSendStreamEvent newsendstreamevent = new NewSendStreamEvent(this, obj);
        this.cache.eventhandler.postEvent(newsendstreamevent);
        return obj;
    }

    @Override
    public SendStream createSendStream(DataSource datasource, int i) throws IOException, UnsupportedFormatException {
        int ssrc;
        if (this.sendercount == 0 && this.cache.ourssrc != null) {
            ssrc = this.cache.ourssrc.ssrc;
        } else {
            while (this.cache.lookup(ssrc = (int)this.generateSSRC(GenerateSSRCCause.CREATE_SEND_STREAM)) != null) {
            }
        }
        SendStream sendstream = null;
        try {
            sendstream = this.createSendStream(ssrc, datasource, i);
            if (this.newRtpInterface) {
                this.setRemoteAddresses();
            }
        }
        catch (SSRCInUseException sSRCInUseException) {
            // empty catch block
        }
        return sendstream;
    }

    @Override
    public void dispose() {
        if (this.rtpConnector != null) {
            this.rtpConnector.close();
            this.rtpConnector = null;
        }
        if (this.defaultsource != null) {
            this.defaultsource.disconnect();
        }
        if (this.cache != null) {
            Enumeration<SSRCInfo> elements = this.cache.cache.elements();
            while (elements.hasMoreElements()) {
                SSRCInfo ssrcinfo = elements.nextElement();
                if (ssrcinfo.dstream != null) {
                    ssrcinfo.dstream.close();
                }
                if (ssrcinfo instanceof SendSSRCInfo) {
                    ((SendSSRCInfo)ssrcinfo).close();
                }
                this.stopParticipating("dispose", ssrcinfo);
            }
        }
        for (int i = 0; i < this.sendstreamlist.size(); ++i) {
            this.removeSendStream((SendStream)this.sendstreamlist.elementAt(i));
        }
        if (this.rtpTransmitter != null) {
            this.rtpTransmitter.close();
        }
        if (this.rtcpTransmitter != null) {
            this.rtcpTransmitter.close();
        }
        if (this.rtcpForwarder != null) {
            RTCPRawReceiver rtcprawreceiver = (RTCPRawReceiver)this.rtcpForwarder.getSource();
            this.rtcpForwarder.close();
            if (rtcprawreceiver != null) {
                rtcprawreceiver.close();
            }
        }
        if (this.cleaner != null) {
            this.cleaner.stop();
        }
        if (this.cache != null) {
            this.cache.destroy();
        }
        if (this.rtpForwarder != null) {
            RTPRawReceiver rtprawreceiver = (RTPRawReceiver)this.rtpForwarder.getSource();
            this.rtpForwarder.close();
            if (rtprawreceiver != null) {
                rtprawreceiver.close();
            }
        }
        if (this.dataSocket != null) {
            this.dataSocket.close();
        }
        if (this.controlSocket != null) {
            this.controlSocket.close();
        }
    }

    private int findLocalPorts() {
        boolean flag = false;
        int i = -1;
        while (!flag) {
            do {
                double d;
                if ((i = (int)((d = Math.random()) * 65535.0)) % 2 == 0) continue;
                ++i;
            } while (i < 1024 || i > 65534);
            try {
                DatagramSocket datagramsocket = new DatagramSocket(i);
                datagramsocket.close();
                datagramsocket = new DatagramSocket(i + 1);
                datagramsocket.close();
                flag = true;
            }
            catch (SocketException socketexception) {
                flag = false;
            }
        }
        return i;
    }

    @Override
    public String generateCNAME() {
        return SourceDescription.generateCNAME();
    }

    @Override
    public long generateSSRC() {
        return TrueRandom.nextInt();
    }

    protected long generateSSRC(GenerateSSRCCause cause) {
        return this.generateSSRC();
    }

    @Override
    public Vector getActiveParticipants() {
        Vector<Participant> vector1 = new Vector<Participant>();
        RTPSourceInfoCache rtpsourceinfocache = this.cache.getRTPSICache();
        Hashtable<String, RTPSourceInfo> hashtable = rtpsourceinfocache.getCacheTable();
        Enumeration<RTPSourceInfo> enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector;
            Participant participant = enumeration.nextElement();
            if (participant != null && participant instanceof LocalParticipant && this.nonparticipating || (vector = participant.getStreams()).size() <= 0) continue;
            vector1.addElement(participant);
        }
        return vector1;
    }

    @Override
    public Vector getAllParticipants() {
        Vector<Participant> vector = new Vector<Participant>();
        RTPSourceInfoCache rtpsourceinfocache = this.cache.getRTPSICache();
        Hashtable<String, RTPSourceInfo> hashtable = rtpsourceinfocache.getCacheTable();
        Enumeration<RTPSourceInfo> enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Participant participant = enumeration.nextElement();
            if (participant == null || participant instanceof LocalParticipant && this.nonparticipating) continue;
            vector.addElement(participant);
        }
        return vector;
    }

    @Override
    public Object getControl(String s) {
        if (s.equals("javax.media.control.BufferControl")) {
            return this.buffercontrol;
        }
        return null;
    }

    @Override
    public Object[] getControls() {
        Object[] aobj = new Object[]{this.buffercontrol};
        return aobj;
    }

    public net.sf.fmj.media.protocol.rtp.DataSource getDataSource(RTPMediaLocator rtpmedialocator) {
        if (rtpmedialocator == null) {
            return this.defaultsource;
        }
        int i = (int)rtpmedialocator.getSSRC();
        return i == 0 ? this.defaultsource : this.dslist.get(i);
    }

    @Override
    public long getDefaultSSRC() {
        return this.defaultSSRC;
    }

    public Format getFormat(int i) {
        return this.formatinfo.get(i);
    }

    @Override
    public GlobalReceptionStats getGlobalReceptionStats() {
        return this.defaultstats;
    }

    @Override
    public GlobalTransmissionStats getGlobalTransmissionStats() {
        return this.transstats;
    }

    @Override
    public LocalParticipant getLocalParticipant() {
        RTPSourceInfoCache rtpsourceinfocache = this.cache.getRTPSICache();
        Hashtable<String, RTPSourceInfo> hashtable = rtpsourceinfocache.getCacheTable();
        Enumeration<RTPSourceInfo> enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Participant participant = enumeration.nextElement();
            if (participant == null || this.nonparticipating || !(participant instanceof LocalParticipant)) continue;
            return (LocalParticipant)participant;
        }
        return null;
    }

    public SessionAddress getLocalReceiverAddress() {
        return this.localReceiverAddress;
    }

    @Override
    public SessionAddress getLocalSessionAddress() {
        if (this.newRtpInterface) {
            return this.localAddress;
        }
        SessionAddress sessionaddress = new SessionAddress(this.localDataAddress, this.localDataPort, this.localControlAddress, this.localControlPort);
        return sessionaddress;
    }

    public long getLocalSSRC() {
        return this.cache == null || this.cache.ourssrc == null ? Long.MAX_VALUE : (long)this.cache.ourssrc.ssrc;
    }

    @Override
    public int getMulticastScope() {
        return this.ttl;
    }

    @Override
    public Vector getPassiveParticipants() {
        Vector<Participant> vector1 = new Vector<Participant>();
        RTPSourceInfoCache rtpsourceinfocache = this.cache.getRTPSICache();
        Hashtable<String, RTPSourceInfo> hashtable = rtpsourceinfocache.getCacheTable();
        Enumeration<RTPSourceInfo> enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector;
            Participant participant = enumeration.nextElement();
            if (participant != null && participant instanceof LocalParticipant && this.nonparticipating || (vector = participant.getStreams()).size() != 0) continue;
            vector1.addElement(participant);
        }
        return vector1;
    }

    @Override
    public Vector getPeers() {
        return this.peerlist;
    }

    private String getProperty(String s) {
        String s1 = null;
        try {
            s1 = System.getProperty(s);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return s1;
    }

    @Override
    public Vector getReceiveStreams() {
        Vector<RTPStream> vector = new Vector<RTPStream>();
        Vector vector1 = this.getAllParticipants();
        for (int i = 0; i < vector1.size(); ++i) {
            Participant participant = (Participant)vector1.elementAt(i);
            Vector vector2 = participant.getStreams();
            for (int j = 0; j < vector2.size(); ++j) {
                RTPStream rtpstream = (RTPStream)vector2.elementAt(j);
                if (!(rtpstream instanceof ReceiveStream)) continue;
                vector.addElement(rtpstream);
            }
        }
        vector.trimToSize();
        return vector;
    }

    @Override
    public Vector getRemoteParticipants() {
        Vector<Participant> vector = new Vector<Participant>();
        RTPSourceInfoCache rtpsourceinfocache = this.cache.getRTPSICache();
        Hashtable<String, RTPSourceInfo> hashtable = rtpsourceinfocache.getCacheTable();
        Enumeration<RTPSourceInfo> enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Participant participant = enumeration.nextElement();
            if (participant == null || !(participant instanceof RemoteParticipant)) continue;
            vector.addElement(participant);
        }
        return vector;
    }

    public SessionAddress getRemoteSessionAddress() {
        return this.remoteAddress;
    }

    @Override
    public Vector getSendStreams() {
        return new Vector(this.sendstreamlist);
    }

    @Override
    public SessionAddress getSessionAddress() {
        SessionAddress sessionaddress = new SessionAddress(this.dataaddress, this.dataport, this.controladdress, this.controlport);
        return sessionaddress;
    }

    public int getSSRC() {
        return 0;
    }

    public SSRCCache getSSRCCache() {
        return this.cache;
    }

    public SSRCInfo getSSRCInfo(int i) {
        return this.cache.lookup(i);
    }

    @Override
    public RTPStream getStream(long l) {
        Vector vector = null;
        vector = this.getAllParticipants();
        if (vector == null) {
            return null;
        }
        for (int i = 0; i < vector.size(); ++i) {
            RTPSourceInfo rtpsourceinfo = (RTPSourceInfo)vector.elementAt(i);
            RTPStream rtpstream = rtpsourceinfo.getSSRCStream(l);
            if (rtpstream == null) continue;
            return rtpstream;
        }
        return null;
    }

    @Override
    public void initialize(RTPConnector rtpconnector) {
        this.rtpConnector = rtpconnector;
        this.newRtpInterface = true;
        String cname = SourceDescription.generateCNAME();
        SourceDescription[] asourcedescription = new SourceDescription[]{new SourceDescription(3, SOURCE_DESC_EMAIL, 1, false), new SourceDescription(1, cname, 1, false), new SourceDescription(6, SOURCE_DESC_TOOL, 1, false)};
        int ssrc = (int)this.generateSSRC(GenerateSSRCCause.INITIALIZE);
        this.ttl = 1;
        double rtcpBandwidthFraction = this.rtpConnector.getRTCPBandwidthFraction();
        this.participating = rtcpBandwidthFraction != 0.0;
        this.cache = new SSRCCache(this);
        this.cache.sessionbandwidth = 384000;
        this.formatinfo.setCache(this.cache);
        if (rtcpBandwidthFraction <= 0.0) {
            rtcpBandwidthFraction = 0.05;
        }
        this.cache.rtcp_bw_fraction = rtcpBandwidthFraction;
        double rtcpSenderBandwidthFraction = this.rtpConnector.getRTCPSenderBandwidthFraction();
        if (rtcpSenderBandwidthFraction <= 0.0) {
            rtcpSenderBandwidthFraction = 0.25;
        }
        this.cache.rtcp_sender_bw_fraction = rtcpSenderBandwidthFraction;
        this.cache.ourssrc = this.cache.get(ssrc, null, 0, 2);
        this.cache.ourssrc.setAlive(true);
        if (!this.isCNAME(asourcedescription)) {
            asourcedescription = this.setCNAME(asourcedescription);
        }
        this.cache.ourssrc.setSourceDescription(asourcedescription);
        this.cache.ourssrc.ssrc = ssrc;
        this.cache.ourssrc.setOurs(true);
        this.initialized = true;
        this.rtpRawReceiver = new RTPRawReceiver(this.rtpConnector, this.defaultstats);
        this.rtcpRawReceiver = new RTCPRawReceiver(this.rtpConnector, this.defaultstats, this.streamSynch);
        this.rtpDemultiplexer = new RTPDemultiplexer(this.cache, this.rtpRawReceiver, this.streamSynch);
        this.rtpForwarder = new PacketForwarder(this.rtpRawReceiver, new RTPReceiver(this.cache, this.rtpDemultiplexer));
        if (this.rtpForwarder != null) {
            this.rtpForwarder.startPF("RTP Forwarder: " + this.rtpConnector);
        }
        this.rtcpForwarder = new PacketForwarder(this.rtcpRawReceiver, new RTCPReceiver(this.cache));
        if (this.rtcpForwarder != null) {
            this.rtcpForwarder.startPF("RTCP Forwarder: " + this.rtpConnector);
        }
        this.cleaner = new SSRCCacheCleaner(this.cache, this.streamSynch);
        if (this.participating && this.cache.ourssrc != null) {
            this.cache.ourssrc.reporter = this.startParticipating(this.rtpConnector, this.cache.ourssrc);
        }
    }

    @Override
    public void initialize(SessionAddress sessionaddress) throws InvalidSessionAddressException {
        String s = SourceDescription.generateCNAME();
        SourceDescription[] asourcedescription = new SourceDescription[]{new SourceDescription(3, SOURCE_DESC_EMAIL, 1, false), new SourceDescription(1, s, 1, false), new SourceDescription(6, SOURCE_DESC_TOOL, 1, false)};
        double d = 0.05;
        double d1 = 0.25;
        SessionAddress[] asessionaddress = new SessionAddress[]{sessionaddress};
        this.initialize(asessionaddress, asourcedescription, d, d1, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void initialize(SessionAddress[] asessionaddress, SourceDescription[] asourcedescription, double d, double d1, EncryptionInfo encryptioninfo) throws InvalidSessionAddressException {
        InetAddress inetaddress;
        if (this.initialized) {
            return;
        }
        this.newRtpInterface = true;
        this.remoteAddresses = new Vector();
        int i = (int)this.generateSSRC(GenerateSSRCCause.INITIALIZE);
        this.ttl = 1;
        boolean bl = this.participating = d != 0.0;
        if (asessionaddress.length == 0) {
            throw new InvalidSessionAddressException("At least one local address is required!");
        }
        this.localAddress = asessionaddress[0];
        if (this.localAddress == null) {
            throw new InvalidSessionAddressException("Invalid local address: null");
        }
        InetAddress[] ainetaddress = null;
        try {
            inetaddress = this.localAddress.getDataAddress();
            String s1 = null;
            s1 = inetaddress.getHostAddress().equals("0.0.0.0") ? "0.0.0.0" : inetaddress.getHostName();
            ainetaddress = InetAddress.getAllByName(s1);
        }
        catch (Throwable throwable1) {
            logger.log(Level.WARNING, "Error during initialization: " + throwable1.getMessage(), throwable1);
            return;
        }
        if (this.localAddress.getDataAddress() == null) {
            this.localAddress.setDataHostAddress(inetaddress);
        }
        if (this.localAddress.getControlAddress() == null) {
            this.localAddress.setControlHostAddress(inetaddress);
        }
        if (this.localAddress.getDataAddress().isMulticastAddress()) {
            if (!this.localAddress.getControlAddress().isMulticastAddress()) throw new InvalidSessionAddressException("Invalid multicast address");
            this.ttl = this.localAddress.getTimeToLive();
        } else {
            boolean flag = true;
            boolean flag1 = true;
            try {
                logger.fine("Looking for local data address: " + this.localAddress.getDataAddress() + " and control address" + this.localAddress.getControlAddress());
                if (this.localAddress.getDataHostAddress().equals("0.0.0.0") || this.localAddress.getDataHostAddress().equals("::0")) {
                    flag = true;
                }
                if (this.localAddress.getControlHostAddress().equals("0.0.0.0") || this.localAddress.getControlHostAddress().equals("::0")) {
                    flag1 = true;
                }
                Enumeration<NetworkInterface> intfs = NetworkInterface.getNetworkInterfaces();
                while (!(!intfs.hasMoreElements() || flag && flag1)) {
                    NetworkInterface intf = intfs.nextElement();
                    Enumeration<InetAddress> addrs = intf.getInetAddresses();
                    while (addrs.hasMoreElements()) {
                        try {
                            InetAddress addr = addrs.nextElement();
                            logger.fine("Testing iface address " + this.localAddress.getDataAddress());
                            if (addr.equals(this.localAddress.getDataAddress())) {
                                flag = true;
                            }
                            if (!addr.equals(this.localAddress.getControlAddress())) continue;
                            flag1 = true;
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            catch (Exception exc) {
                logger.log(Level.WARNING, "Error while enumerating local interfaces.", exc);
            }
            if (!flag) {
                String s2 = "Does not belong to any of this hosts local interfaces";
                throw new InvalidSessionAddressException("Local Data Address " + s2);
            }
            if (!flag1) {
                String s3 = "Does not belong to any of this hosts local interfaces";
                throw new InvalidSessionAddressException("Local Control Address " + s3);
            }
            if (this.localAddress.getDataPort() == -1) {
                int k = this.findLocalPorts();
                this.localAddress.setDataPort(k);
                this.localAddress.setControlPort(k + 1);
            }
            if (!this.localAddress.getDataAddress().isMulticastAddress()) {
                try {
                    this.dataSocket = new DatagramSocket(this.localAddress.getDataPort(), this.localAddress.getDataAddress());
                }
                catch (SocketException socketexception) {
                    throw new InvalidSessionAddressException("Can't open local data port: " + this.localAddress.getDataPort());
                }
            }
            if (!this.localAddress.getControlAddress().isMulticastAddress()) {
                try {
                    this.controlSocket = new DatagramSocket(this.localAddress.getControlPort(), this.localAddress.getControlAddress());
                }
                catch (SocketException socketexception1) {
                    if (this.dataSocket == null) throw new InvalidSessionAddressException("Can't open local control port: " + this.localAddress.getControlPort());
                    this.dataSocket.close();
                    throw new InvalidSessionAddressException("Can't open local control port: " + this.localAddress.getControlPort());
                }
            }
        }
        this.cache = new SSRCCache(this);
        this.cache.sessionbandwidth = this.ttl <= 16 ? 384000 : (this.ttl <= 64 ? 128000 : (this.ttl <= 128 ? 16000 : (this.ttl <= 192 ? 6625 : 4000)));
        this.formatinfo.setCache(this.cache);
        this.cache.rtcp_bw_fraction = d;
        this.cache.rtcp_sender_bw_fraction = d1;
        this.cache.ourssrc = this.cache.get(i, inetaddress, 0, 2);
        this.cache.ourssrc.setAlive(true);
        if (!this.isCNAME(asourcedescription)) {
            SourceDescription[] asourcedescription1 = this.setCNAME(asourcedescription);
            this.cache.ourssrc.setSourceDescription(asourcedescription1);
        } else {
            this.cache.ourssrc.setSourceDescription(asourcedescription);
        }
        this.cache.ourssrc.ssrc = i;
        this.cache.ourssrc.setOurs(true);
        this.initialized = true;
    }

    @Override
    public int initSession(SessionAddress sessionaddress, long l, SourceDescription[] asourcedescription, double d, double d1) throws InvalidSessionAddressException {
        InetAddress inetaddress;
        if (this.initialized) {
            return -1;
        }
        if (d == 0.0) {
            this.nonparticipating = true;
        }
        this.defaultSSRC = l;
        this.localDataAddress = sessionaddress.getDataAddress();
        this.localControlAddress = sessionaddress.getControlAddress();
        this.localDataPort = sessionaddress.getDataPort();
        this.localControlPort = sessionaddress.getControlPort();
        InetAddress[] ainetaddress = null;
        try {
            inetaddress = this.localAddress.getDataAddress();
            String s1 = inetaddress.getHostName();
            ainetaddress = InetAddress.getAllByName(s1);
        }
        catch (Throwable throwable1) {
            logger.log(Level.WARNING, "InitSession  RTPSessionMgr :" + throwable1.getMessage(), throwable1);
            return -1;
        }
        if (this.localDataAddress == null) {
            this.localDataAddress = inetaddress;
        }
        if (this.localControlAddress == null) {
            this.localControlAddress = inetaddress;
        }
        boolean flag = false;
        boolean flag1 = false;
        try {
            Enumeration<NetworkInterface> intfs = NetworkInterface.getNetworkInterfaces();
            while (intfs.hasMoreElements()) {
                NetworkInterface intf = intfs.nextElement();
                Enumeration<InetAddress> addrs = intf.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    try {
                        InetAddress addr = addrs.nextElement();
                        if (addr.equals(this.localAddress.getDataAddress())) {
                            flag = true;
                        }
                        if (!addr.equals(this.localAddress.getControlAddress())) continue;
                        flag1 = true;
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception exc) {
            logger.log(Level.SEVERE, "Error while enumerating interfaces", exc);
        }
        String s2 = "Does not belong to any of this hosts local interfaces";
        if (!flag) {
            throw new InvalidSessionAddressException("Local Data Address " + s2);
        }
        if (!flag1) {
            throw new InvalidSessionAddressException("Local Control Address" + s2);
        }
        this.cache = new SSRCCache(this);
        this.formatinfo.setCache(this.cache);
        this.cache.rtcp_bw_fraction = d;
        this.cache.rtcp_sender_bw_fraction = d1;
        this.cache.ourssrc = this.cache.get((int)l, inetaddress, 0, 2);
        this.cache.ourssrc.setAlive(true);
        if (!this.isCNAME(asourcedescription)) {
            SourceDescription[] asourcedescription1 = this.setCNAME(asourcedescription);
            this.cache.ourssrc.setSourceDescription(asourcedescription1);
        } else {
            this.cache.ourssrc.setSourceDescription(asourcedescription);
        }
        this.cache.ourssrc.ssrc = (int)l;
        this.cache.ourssrc.setOurs(true);
        this.initialized = true;
        return 0;
    }

    @Override
    public int initSession(SessionAddress sessionaddress, SourceDescription[] asourcedescription, double d, double d1) throws InvalidSessionAddressException {
        long l = this.generateSSRC(GenerateSSRCCause.INIT_SESSION);
        return this.initSession(sessionaddress, l, asourcedescription, d, d1);
    }

    private int initSession(SourceDescription[] asourcedescription, double d, double d1) {
        if (this.initialized) {
            return -1;
        }
        InetAddress inetaddress = null;
        if (d == 0.0) {
            this.nonparticipating = true;
        }
        this.defaultSSRC = this.generateSSRC(GenerateSSRCCause.INIT_SESSION);
        this.cache = new SSRCCache(this);
        this.formatinfo.setCache(this.cache);
        this.cache.rtcp_bw_fraction = d;
        this.cache.rtcp_sender_bw_fraction = d1;
        try {
            inetaddress = InetAddress.getLocalHost();
        }
        catch (Throwable throwable1) {
            logger.log(Level.WARNING, "InitSession UnknownHostExcpetion " + throwable1.getMessage(), throwable1);
            return -1;
        }
        this.cache.ourssrc = this.cache.get((int)this.defaultSSRC, null, 0, 2);
        this.cache.ourssrc.setAlive(true);
        if (!this.isCNAME(asourcedescription)) {
            SourceDescription[] asourcedescription1 = this.setCNAME(asourcedescription);
            this.cache.ourssrc.setSourceDescription(asourcedescription1);
        } else {
            this.cache.ourssrc.setSourceDescription(asourcedescription);
        }
        this.cache.ourssrc.ssrc = (int)this.defaultSSRC;
        this.cache.ourssrc.setOurs(true);
        this.initialized = true;
        return 0;
    }

    boolean isBroadcast(InetAddress inetaddress) {
        Object obj = null;
        try {
            InetAddress inetaddress1 = InetAddress.getLocalHost();
            byte[] abyte0 = inetaddress1.getAddress();
            int i = abyte0[3] & 0xFF;
            i |= abyte0[2] << 8 & 0xFF00;
            i |= abyte0[1] << 16 & 0xFF0000;
            byte[] abyte1 = inetaddress.getAddress();
            int j = abyte1[3] & 0xFF;
            j |= abyte1[2] << 8 & 0xFF00;
            j |= abyte1[1] << 16 & 0xFF0000;
            if (((i |= abyte0[0] << 24 & 0xFF000000) | 0xFF) == (j |= abyte1[0] << 24 & 0xFF000000)) {
                return true;
            }
        }
        catch (UnknownHostException unknownhostexception) {
            logger.warning(unknownhostexception.getMessage());
        }
        return false;
    }

    private boolean isCNAME(SourceDescription[] asourcedescription) {
        Object obj = null;
        boolean flag = false;
        if (asourcedescription == null) {
            return flag;
        }
        for (int j = 0; j < asourcedescription.length; ++j) {
            try {
                int i = asourcedescription[j].getType();
                String s = asourcedescription[j].getDescription();
                if (i != 1 || s == null) continue;
                flag = true;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return flag;
    }

    public boolean isDefaultDSassigned() {
        return this.bds;
    }

    public boolean IsNonParticipating() {
        return this.nonparticipating;
    }

    public boolean isSenderDefaultAddr(InetAddress inetaddress) {
        if (this.sender == null) {
            return false;
        }
        InetAddress inetaddress1 = this.sender.getRemoteAddr();
        return inetaddress1.equals(inetaddress);
    }

    boolean isUnicast() {
        return this.unicast;
    }

    @Override
    public void removeAllPeers() {
        for (int i = 0; i < this.peerlist.size(); ++i) {
            this.removePeer((SessionAddress)this.peerlist.elementAt(i));
        }
    }

    public void removeDataSource(net.sf.fmj.media.protocol.rtp.DataSource datasource) {
        block5: {
            if (datasource == this.defaultsource) {
                this.defaultsource = null;
                this.defaultstream = null;
                this.defaultsourceid = 0;
                this.bds = false;
            }
            this.dslist.removeObj(datasource);
            if (datasource != null) {
                try {
                    datasource.disconnect();
                }
                catch (Throwable t) {
                    if (t instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (!(t instanceof ThreadDeath)) break block5;
                    throw (ThreadDeath)t;
                }
            }
        }
    }

    @Override
    public void removePeer(SessionAddress sessionaddress) {
        PacketForwarder packetforwarder = (PacketForwarder)this.peerrtplist.get(sessionaddress);
        PacketForwarder packetforwarder1 = (PacketForwarder)this.peerrtplist.get(sessionaddress);
        if (packetforwarder != null) {
            packetforwarder.close();
        }
        if (packetforwarder1 != null) {
            packetforwarder1.close();
        }
        for (int i = 0; i < this.peerlist.size(); ++i) {
            SessionAddress sessionaddress1 = (SessionAddress)this.peerlist.elementAt(i);
            if (!sessionaddress1.equals(sessionaddress)) continue;
            this.peerlist.removeElementAt(i);
        }
    }

    @Override
    public void removeReceiveStreamListener(ReceiveStreamListener receivestreamlistener) {
        this.streamlistener.removeElement(receivestreamlistener);
    }

    @Override
    public void removeRemoteListener(RemoteListener remotelistener1) {
        this.remotelistener.removeElement(remotelistener1);
    }

    void removeSendStream(SendStream sendstream) {
        this.sendstreamlist.removeElement(sendstream);
        SendSSRCInfo sendstreamAsSendSSRCInfo = (SendSSRCInfo)sendstream;
        if (sendstreamAsSendSSRCInfo.sinkstream != null) {
            sendstreamAsSendSSRCInfo.sinkstream.close();
            StreamClosedEvent streamclosedevent = new StreamClosedEvent(this, sendstream);
            this.cache.eventhandler.postEvent(streamclosedevent);
            this.stopParticipating("Closed Stream", sendstreamAsSendSSRCInfo);
        }
        if (this.sendstreamlist.size() == 0 && this.cache.ourssrc != null) {
            SSRCInfo passivessrcinfo;
            if (this.cache.ourssrc.ssrc == sendstreamAsSendSSRCInfo.ssrc && sendstreamAsSendSSRCInfo.reporter == null) {
                long lNewSSRC = Long.MAX_VALUE;
                int iNewSSRC = 0;
                while ((lNewSSRC = this.generateSSRC(GenerateSSRCCause.REMOVE_SEND_STREAM)) != Long.MAX_VALUE && this.cache.lookup(iNewSSRC = (int)lNewSSRC) != null) {
                }
                if (lNewSSRC == Long.MAX_VALUE) {
                    passivessrcinfo = new PassiveSSRCInfo(this.cache.ourssrc);
                } else {
                    passivessrcinfo = this.cache.get(iNewSSRC, null, 0, 2);
                    passivessrcinfo.setAlive(true);
                    SourceDescription[] asourcedescription = new SourceDescription[]{new SourceDescription(3, SOURCE_DESC_EMAIL, 1, false), new SourceDescription(1, this.generateCNAME(), 1, false), new SourceDescription(6, SOURCE_DESC_TOOL, 1, false)};
                    passivessrcinfo.setSourceDescription(this.isCNAME(asourcedescription) ? asourcedescription : this.setCNAME(asourcedescription));
                    passivessrcinfo.ssrc = iNewSSRC;
                }
            } else {
                passivessrcinfo = new PassiveSSRCInfo(this.cache.ourssrc);
            }
            passivessrcinfo.setOurs(true);
            this.cache.ourssrc = passivessrcinfo;
            this.cache.getMainCache().put(passivessrcinfo.ssrc, passivessrcinfo);
            if (this.rtpConnector != null) {
                this.cache.ourssrc.reporter = this.startParticipating(this.rtpConnector, this.cache.ourssrc);
            }
        }
    }

    @Override
    public void removeSendStreamListener(SendStreamListener sendstreamlistener2) {
    }

    @Override
    public void removeSessionListener(SessionListener sessionlistener1) {
        this.sessionlistener.removeElement(sessionlistener1);
    }

    @Override
    public void removeTarget(SessionAddress sessionaddress, String s) {
        this.remoteAddresses.removeElement(sessionaddress);
        this.setRemoteAddresses();
        if (this.remoteAddresses.size() == 0 && this.cache != null) {
            this.stopParticipating(s, this.cache.ourssrc);
        }
    }

    @Override
    public void removeTargets(String s) {
        if (this.cache != null) {
            this.stopParticipating(s, this.cache.ourssrc);
        }
        if (this.remoteAddresses != null) {
            this.remoteAddresses.removeAllElements();
        }
        this.setRemoteAddresses();
    }

    private SourceDescription[] setCNAME(SourceDescription[] asourcedescription) {
        Object obj = null;
        boolean flag = false;
        if (asourcedescription == null) {
            asourcedescription = new SourceDescription[1];
            String s = SourceDescription.generateCNAME();
            asourcedescription[0] = new SourceDescription(1, s, 1, false);
            return asourcedescription;
        }
        for (int j = 0; j < asourcedescription.length; ++j) {
            int i = asourcedescription[j].getType();
            String s1 = asourcedescription[j].getDescription();
            if (i != 1 || s1 != null) continue;
            s1 = SourceDescription.generateCNAME();
            flag = true;
            break;
        }
        if (flag) {
            return asourcedescription;
        }
        SourceDescription[] asourcedescription1 = new SourceDescription[asourcedescription.length + 1];
        asourcedescription1[0] = new SourceDescription(1, SourceDescription.generateCNAME(), 1, false);
        int k = 1;
        for (int l = 0; l < asourcedescription.length; ++l) {
            asourcedescription1[k] = new SourceDescription(asourcedescription[l].getType(), asourcedescription[l].getDescription(), 1, false);
            ++k;
        }
        return asourcedescription1;
    }

    public void setDefaultDSassigned(int i) {
        this.bds = true;
        this.defaultsourceid = i;
        this.dslist.put(i, this.defaultsource);
        this.defaultsource.setSSRC(i);
        this.defaultsource.setMgr(this);
    }

    @Override
    public void setMulticastScope(int i) {
        if (i < 1) {
            i = 1;
        }
        this.ttl = i;
        this.cache.sessionbandwidth = this.ttl <= 16 ? 384000 : (this.ttl <= 64 ? 128000 : (this.ttl <= 128 ? 16000 : (this.ttl <= 192 ? 6625 : 4000)));
        if (this.udpsender != null) {
            try {
                this.udpsender.setttl(this.ttl);
            }
            catch (IOException ioexception) {
                logger.log(Level.WARNING, "setMulticastScope Exception ", ioexception);
            }
        }
    }

    private void setRemoteAddresses() {
        if (this.rtpTransmitter != null) {
            RTPRawSender rtprawsender = this.rtpTransmitter.getSender();
            rtprawsender.setDestAddresses(this.remoteAddresses);
        }
        if (this.rtcpTransmitter != null) {
            RTCPRawSender rtcprawsender = this.rtcpTransmitter.getSender();
            rtcprawsender.setDestAddresses(this.remoteAddresses);
        }
    }

    private SourceDescription[] setSDES() {
        SourceDescription[] asourcedescription = new SourceDescription[]{new SourceDescription(2, this.getProperty("user.name"), 1, false), new SourceDescription(1, SourceDescription.generateCNAME(), 1, false), new SourceDescription(6, SOURCE_DESC_TOOL, 1, false)};
        return asourcedescription;
    }

    void setSessionBandwidth(int i) {
        this.cache.sessionbandwidth = i;
    }

    private RTPTransmitter startDataTransmission(int i, String s) throws IOException {
        RTPTransmitter rtptransmitter = null;
        RTPRawSender rtprawsender = null;
        if (this.localDataPort == -1) {
            this.udpsender = new UDPPacketSender(this.dataaddress, this.dataport);
        } else if (this.newRtpInterface) {
            this.udpsender = new UDPPacketSender(this.rtpRawReceiver.socket);
        } else {
            int j = this.localSenderAddress.getDataPort();
            InetAddress inetaddress = this.localSenderAddress.getDataAddress();
            this.udpsender = new UDPPacketSender(j, inetaddress, this.dataaddress, this.dataport);
        }
        if (this.ttl != 1) {
            this.udpsender.setttl(this.ttl);
        }
        rtprawsender = new RTPRawSender(this.dataport, s, this.udpsender);
        rtptransmitter = new RTPTransmitter(this.cache, rtprawsender);
        return rtptransmitter;
    }

    private RTPTransmitter startDataTransmission(RTPConnector rtpconnector) {
        try {
            RTPRawSender rtprawsender = null;
            RTPTransmitter rtptransmitter = null;
            this.rtpsender = new RTPPacketSender(rtpconnector);
            rtprawsender = new RTPRawSender(this.rtpsender);
            rtptransmitter = new RTPTransmitter(this.cache, rtprawsender);
            return rtptransmitter;
        }
        catch (IOException ioexception) {
            return null;
        }
    }

    private RTPTransmitter startDataTransmission(RTPPushDataSource rtppushdatasource) {
        RTPRawSender rtprawsender = null;
        RTPTransmitter rtptransmitter = null;
        this.rtpsender = new RTPPacketSender(rtppushdatasource);
        rtprawsender = new RTPRawSender(this.rtpsender);
        rtptransmitter = new RTPTransmitter(this.cache, rtprawsender);
        return rtptransmitter;
    }

    private synchronized RTCPReporter startParticipating(DatagramSocket datagramsocket) throws IOException {
        UDPPacketSender udppacketsender;
        this.udpPacketSender = udppacketsender = new UDPPacketSender(datagramsocket);
        if (this.ttl != 1) {
            udppacketsender.setttl(this.ttl);
        }
        RTCPRawSender rtcprawsender = new RTCPRawSender(this.remoteAddress.getControlPort(), this.remoteAddress.getControlAddress().getHostAddress(), udppacketsender);
        this.rtcpTransmitter = this.getOrCreateRTCPTransmitterFactory().newRTCPTransmitter(this.cache, rtcprawsender);
        this.rtcpTransmitter.setSSRCInfo(this.cache.ourssrc);
        RTCPReporter rtcpreporter = new RTCPReporter(this.cache, this.rtcpTransmitter);
        this.startedparticipating = true;
        return rtcpreporter;
    }

    private synchronized RTCPReporter startParticipating(int i, String s, SSRCInfo ssrcinfo) throws IOException {
        this.startedparticipating = true;
        UDPPacketSender udppacketsender = null;
        if (this.localControlPort == -1) {
            udppacketsender = new UDPPacketSender(this.controladdress, this.controlport);
            this.localControlPort = udppacketsender.getLocalPort();
            this.localControlAddress = udppacketsender.getLocalAddress();
        } else {
            udppacketsender = new UDPPacketSender(this.localControlPort, this.localControlAddress, this.controladdress, this.controlport);
        }
        if (this.ttl != 1) {
            udppacketsender.setttl(this.ttl);
        }
        RTCPRawSender rtcprawsender = new RTCPRawSender(i, s, udppacketsender);
        RTCPTransmitter rtcptransmitter = this.getOrCreateRTCPTransmitterFactory().newRTCPTransmitter(this.cache, rtcprawsender);
        rtcptransmitter.setSSRCInfo(ssrcinfo);
        return new RTCPReporter(this.cache, rtcptransmitter);
    }

    private synchronized RTCPReporter startParticipating(RTPConnector rtpconnector, SSRCInfo ssrcinfo) {
        this.startedparticipating = true;
        try {
            this.rtpsender = new RTPPacketSender(rtpconnector.getControlOutputStream());
        }
        catch (IOException ioexception) {
            logger.log(Level.WARNING, "error initializing rtp sender  " + ioexception.getMessage(), ioexception);
        }
        RTCPRawSender rtcprawsender = new RTCPRawSender(this.rtpsender);
        RTCPTransmitter rtcptransmitter = this.getOrCreateRTCPTransmitterFactory().newRTCPTransmitter(this.cache, rtcprawsender);
        rtcptransmitter.setSSRCInfo(ssrcinfo);
        return new RTCPReporter(this.cache, rtcptransmitter);
    }

    private synchronized RTCPReporter startParticipating(RTPPushDataSource rtppushdatasource, SSRCInfo ssrcinfo) {
        this.startedparticipating = true;
        this.rtpsender = new RTPPacketSender(rtppushdatasource);
        RTCPRawSender rtcprawsender = new RTCPRawSender(this.rtpsender);
        RTCPTransmitter rtcptransmitter = this.getOrCreateRTCPTransmitterFactory().newRTCPTransmitter(this.cache, rtcprawsender);
        rtcptransmitter.setSSRCInfo(ssrcinfo);
        return new RTCPReporter(this.cache, rtcptransmitter);
    }

    private synchronized RTCPReporter startParticipating(SessionAddress sessionaddress, SessionAddress sessionaddress1, SSRCInfo ssrcinfo, DatagramSocket datagramsocket) throws IOException {
        this.localReceiverAddress = sessionaddress;
        this.startedparticipating = true;
        UDPPacketSender udppacketsender = null;
        int i = sessionaddress1.getControlPort();
        InetAddress inetaddress = sessionaddress1.getControlAddress();
        int j = sessionaddress.getControlPort();
        InetAddress inetaddress1 = sessionaddress.getControlAddress();
        udppacketsender = i == -1 ? new UDPPacketSender(inetaddress, i) : (i == j ? new UDPPacketSender(datagramsocket) : new UDPPacketSender(i, inetaddress, this.controladdress, this.controlport));
        if (this.ttl != 1) {
            udppacketsender.setttl(this.ttl);
        }
        RTCPRawSender rtcprawsender = new RTCPRawSender(this.controlport, this.controladdress.getHostAddress(), udppacketsender);
        RTCPTransmitter rtcptransmitter = this.getOrCreateRTCPTransmitterFactory().newRTCPTransmitter(this.cache, rtcprawsender);
        rtcptransmitter.setSSRCInfo(ssrcinfo);
        return new RTCPReporter(this.cache, rtcptransmitter);
    }

    void startRTCPReports(InetAddress inetaddress) {
        if (!this.nonparticipating && !this.startedparticipating) {
            try {
                if (this.cache.ourssrc != null) {
                    this.cache.ourssrc.reporter = this.startParticipating(this.controlport, inetaddress.getHostAddress(), this.cache.ourssrc);
                }
            }
            catch (IOException ioexception) {
                logger.log(Level.WARNING, "start rtcp reports  " + ioexception.getMessage(), ioexception);
            }
        }
    }

    public void startSession() throws IOException {
        SessionAddress sessionaddress = new SessionAddress(this.dataaddress, this.dataport, this.controladdress, this.controlport);
        try {
            this.startSession(sessionaddress, this.ttl, null);
        }
        catch (SessionManagerException sessionmanagerexception) {
            throw new IOException("SessionManager exception " + sessionmanagerexception.getMessage());
        }
    }

    @Override
    public int startSession(int i, EncryptionInfo encryptioninfo) throws IOException {
        this.multi_unicast = true;
        if (i < 1) {
            i = 1;
        }
        this.ttl = i;
        this.cache.sessionbandwidth = this.ttl <= 16 ? 384000 : (this.ttl <= 64 ? 128000 : (this.ttl <= 128 ? 16000 : (this.ttl <= 192 ? 6625 : 4000)));
        this.cleaner = new SSRCCacheCleaner(this.cache, this.streamSynch);
        return 0;
    }

    private int startSession(RTPPushDataSource rtppushdatasource, RTPPushDataSource rtppushdatasource1, EncryptionInfo encryptioninfo) {
        if (!this.initialized) {
            return -1;
        }
        if (this.started) {
            return -1;
        }
        this.cache.sessionbandwidth = 384000;
        RTPRawReceiver rtprawreceiver = new RTPRawReceiver(rtppushdatasource, this.defaultstats);
        RTCPRawReceiver rtcprawreceiver = new RTCPRawReceiver(rtppushdatasource1, this.defaultstats, this.streamSynch);
        this.rtpDemultiplexer = new RTPDemultiplexer(this.cache, rtprawreceiver, this.streamSynch);
        this.rtpForwarder = new PacketForwarder(rtprawreceiver, new RTPReceiver(this.cache, this.rtpDemultiplexer));
        if (this.rtpForwarder != null) {
            this.rtpForwarder.startPF("RTP Forwarder " + rtppushdatasource);
        }
        this.rtcpForwarder = new PacketForwarder(rtcprawreceiver, new RTCPReceiver(this.cache));
        if (this.rtcpForwarder != null) {
            this.rtcpForwarder.startPF("RTCP Forwarder " + rtppushdatasource);
        }
        this.cleaner = new SSRCCacheCleaner(this.cache, this.streamSynch);
        if (!this.nonparticipating && this.cache.ourssrc != null) {
            this.cache.ourssrc.reporter = this.startParticipating(rtppushdatasource1, this.cache.ourssrc);
        }
        this.started = true;
        return 0;
    }

    @Override
    public int startSession(SessionAddress sessionaddress, int i, EncryptionInfo encryptioninfo) throws IOException, InvalidSessionAddressException {
        if (this.started) {
            return -1;
        }
        if (i < 1) {
            i = 1;
        }
        this.ttl = i;
        this.cache.sessionbandwidth = this.ttl <= 16 ? 384000 : (this.ttl <= 64 ? 128000 : (this.ttl <= 128 ? 16000 : (this.ttl <= 192 ? 6625 : 4000)));
        this.controlport = sessionaddress.getControlPort();
        this.dataport = sessionaddress.getDataPort();
        this.CheckRTPPorts(this.dataport, this.controlport);
        this.dataaddress = sessionaddress.getDataAddress();
        this.controladdress = sessionaddress.getControlAddress();
        this.CheckRTPAddress(this.dataaddress, this.controladdress);
        RTCPRawReceiver rtcprawreceiver = null;
        RTPRawReceiver rtprawreceiver = null;
        InetAddress inetaddress = null;
        try {
            inetaddress = InetAddress.getLocalHost();
        }
        catch (Throwable throwable1) {
            logger.log(Level.WARNING, "InitSession  RTPSessionMgr : " + throwable1.getMessage(), throwable1);
            return -1;
        }
        if (this.dataaddress.equals(inetaddress)) {
            this.unicast = true;
        }
        if (!this.dataaddress.isMulticastAddress() && !this.dataaddress.equals(inetaddress)) {
            boolean bl = this.bindtome = !this.isBroadcast(this.dataaddress) || this.Win32();
        }
        if (this.bindtome) {
            return -1;
        }
        try {
            rtcprawreceiver = new RTCPRawReceiver(this.controlport, this.controladdress.getHostAddress(), this.defaultstats, this.streamSynch);
            if (this.dataaddress != null) {
                rtprawreceiver = new RTPRawReceiver(this.dataport, this.dataaddress.getHostAddress(), this.defaultstats);
            }
        }
        catch (SocketException socketexception) {
            throw new IOException(socketexception.getMessage());
        }
        finally {
            if (this.dataaddress != null && rtprawreceiver == null && rtcprawreceiver != null) {
                logger.warning("could not create RTCP/RTP raw receivers");
                rtcprawreceiver.closeSource();
            }
        }
        try {
            rtcprawreceiver = new RTCPRawReceiver(this.controlport, inetaddress.getHostAddress(), this.defaultstats, this.streamSynch);
            if (this.dataaddress != null) {
                rtprawreceiver = new RTPRawReceiver(this.dataport, inetaddress.getHostAddress(), this.defaultstats);
            }
        }
        catch (SocketException socketexception1) {
            throw new IOException(socketexception1.getMessage());
        }
        finally {
            if (this.dataaddress != null && rtprawreceiver == null && rtcprawreceiver != null) {
                logger.warning("could not create RTCP/RTP raw receivers");
                rtcprawreceiver.closeSource();
            }
        }
        this.rtpDemultiplexer = new RTPDemultiplexer(this.cache, rtprawreceiver, this.streamSynch);
        this.rtcpForwarder = new PacketForwarder(rtcprawreceiver, new RTCPReceiver(this.cache));
        if (rtprawreceiver != null) {
            this.rtpForwarder = new PacketForwarder(rtprawreceiver, new RTPReceiver(this.cache, this.rtpDemultiplexer));
        }
        this.rtcpForwarder.startPF("RTCP Forwarder for address" + this.controladdress.toString() + "port " + this.controlport);
        if (this.rtpForwarder != null) {
            this.rtpForwarder.startPF("RTP Forwarder for address " + this.dataaddress.toString() + "port " + this.dataport);
        }
        this.cleaner = new SSRCCacheCleaner(this.cache, this.streamSynch);
        if (!this.nonparticipating && !this.unicast && this.cache.ourssrc != null) {
            this.cache.ourssrc.reporter = this.startParticipating(this.controlport, this.dataaddress.getHostAddress(), this.cache.ourssrc);
        }
        this.started = true;
        return 0;
    }

    @Override
    public int startSession(SessionAddress sessionaddress, SessionAddress sessionaddress1, SessionAddress sessionaddress2, EncryptionInfo encryptioninfo) throws IOException, InvalidSessionAddressException {
        if (this.started) {
            return -1;
        }
        this.localSenderAddress = sessionaddress1;
        this.cache.sessionbandwidth = 384000;
        this.controlport = sessionaddress.getControlPort();
        this.dataport = sessionaddress.getDataPort();
        this.CheckRTPPorts(this.dataport, this.controlport);
        this.dataaddress = sessionaddress.getDataAddress();
        this.controladdress = sessionaddress.getControlAddress();
        if (this.dataaddress.isMulticastAddress() || this.controladdress.isMulticastAddress() || this.isBroadcast(this.dataaddress) || this.isBroadcast(this.controladdress)) {
            throw new InvalidSessionAddressException("Local Address must be UNICAST IP addresses");
        }
        this.CheckRTPAddress(this.dataaddress, this.controladdress);
        RTCPRawReceiver rtcprawreceiver = null;
        RTPRawReceiver rtprawreceiver = null;
        InetAddress inetaddress = null;
        try {
            inetaddress = InetAddress.getLocalHost();
        }
        catch (Throwable throwable) {
            logger.log(Level.SEVERE, "InitSession : UnknownHostExcpetion " + throwable.getMessage(), throwable);
            return -1;
        }
        try {
            rtcprawreceiver = new RTCPRawReceiver(this.controlport, this.controladdress.getHostAddress(), this.defaultstats, this.streamSynch);
            if (this.dataaddress != null) {
                rtprawreceiver = new RTPRawReceiver(this.dataport, this.dataaddress.getHostAddress(), this.defaultstats);
            }
        }
        catch (SocketException socketexception) {
            throw new IOException(socketexception.getMessage());
        }
        finally {
            if (this.dataaddress != null && rtprawreceiver == null && rtcprawreceiver != null) {
                logger.warning("could not create RTCP/RTP raw receivers");
                rtcprawreceiver.closeSource();
            }
        }
        this.rtpDemultiplexer = new RTPDemultiplexer(this.cache, rtprawreceiver, this.streamSynch);
        this.rtcpForwarder = new PacketForwarder(rtcprawreceiver, new RTCPReceiver(this.cache));
        if (rtprawreceiver != null) {
            this.rtpForwarder = new PacketForwarder(rtprawreceiver, new RTPReceiver(this.cache, this.rtpDemultiplexer));
        }
        this.rtcpForwarder.startPF("RTCP Forwarder for address" + this.controladdress.toString() + "port " + this.controlport);
        if (this.rtpForwarder != null) {
            this.rtpForwarder.startPF("RTP Forwarder for address " + this.dataaddress.toString() + "port " + this.dataport);
        }
        this.controlport = sessionaddress2.getControlPort();
        this.dataport = sessionaddress2.getDataPort();
        this.CheckRTPPorts(this.dataport, this.controlport);
        this.dataaddress = sessionaddress2.getDataAddress();
        this.controladdress = sessionaddress2.getControlAddress();
        if (this.dataaddress.isMulticastAddress() || this.controladdress.isMulticastAddress() || this.isBroadcast(this.dataaddress) || this.isBroadcast(this.controladdress)) {
            throw new InvalidSessionAddressException("Remote Address must be UNICAST IP addresses");
        }
        this.CheckRTPAddress(this.dataaddress, this.controladdress);
        this.cleaner = new SSRCCacheCleaner(this.cache, this.streamSynch);
        if (!this.nonparticipating && !this.unicast && this.cache.ourssrc != null) {
            this.cache.ourssrc.reporter = this.startParticipating(sessionaddress, sessionaddress1, this.cache.ourssrc, rtcprawreceiver.socket);
        }
        this.started = true;
        return 0;
    }

    private synchronized void stopParticipating(String s, SSRCInfo ssrcinfo) {
        if (ssrcinfo.reporter != null) {
            ssrcinfo.reporter.close(s);
            ssrcinfo.reporter = null;
        }
    }

    public String toString() {
        String s;
        if (this.newRtpInterface) {
            int i = 0;
            int j = 0;
            String s1 = "";
            if (this.localAddress != null) {
                i = this.localAddress.getControlPort();
                j = this.localAddress.getDataPort();
                s1 = this.localAddress.getDataHostAddress();
            }
            s = "RTPManager \n\tSSRCCache  " + this.cache + "\n\tDataport  " + j + "\n\tControlport  " + i + "\n\tAddress  " + s1 + "\n\tRTPForwarder  " + this.rtpForwarder + "\n\tRTPDemux  " + this.rtpDemultiplexer;
        } else {
            s = "RTPSession Manager  \n\tSSRCCache  " + this.cache + "\n\tDataport  " + this.dataport + "\n\tControlport  " + this.controlport + "\n\tAddress  " + this.dataaddress + "\n\tRTPForwarder  " + this.rtpForwarder + "\n\tRTPDEmux  " + this.rtpDemultiplexer;
        }
        return s;
    }

    public void UpdateEncodings(DataSource datasource) {
        RTPControlImpl rtpcontrolimpl = (RTPControlImpl)datasource.getControl(RTPControl.class.getName());
        if (rtpcontrolimpl != null && rtpcontrolimpl.codeclist != null) {
            Enumeration<Integer> enumeration = rtpcontrolimpl.codeclist.keys();
            while (enumeration.hasMoreElements()) {
                Integer integer = enumeration.nextElement();
                this.formatinfo.add(integer, rtpcontrolimpl.codeclist.get(integer));
            }
        }
    }

    private boolean Win32() {
        return System.getProperty("os.name").startsWith("Windows");
    }
}

