/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import com.sun.media.controls.BitRateAdapter;
import com.sun.media.controls.FrameRateAdapter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.io.IOException;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Clock;
import javax.media.ClockStoppedException;
import javax.media.Codec;
import javax.media.Control;
import javax.media.ControllerClosedEvent;
import javax.media.Demultiplexer;
import javax.media.EndOfMediaEvent;
import javax.media.Format;
import javax.media.GainControl;
import javax.media.IncompatibleSourceException;
import javax.media.IncompatibleTimeBaseException;
import javax.media.InternalErrorEvent;
import javax.media.Manager;
import javax.media.MediaTimeSetEvent;
import javax.media.NotRealizedError;
import javax.media.Owned;
import javax.media.PlugIn;
import javax.media.Renderer;
import javax.media.RestartingEvent;
import javax.media.SizeChangeEvent;
import javax.media.StartEvent;
import javax.media.StopAtTimeEvent;
import javax.media.StopByRequestEvent;
import javax.media.StopTimeChangeEvent;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.Track;
import javax.media.control.BitRateControl;
import javax.media.control.BufferControl;
import javax.media.control.FramePositioningControl;
import javax.media.control.FrameRateControl;
import javax.media.format.AudioFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.DataSource;
import javax.media.renderer.VideoRenderer;
import javax.media.renderer.VisualContainer;
import net.sf.fmj.filtergraph.GraphNode;
import net.sf.fmj.filtergraph.SimpleGraphBuilder;
import net.sf.fmj.media.BasicClock;
import net.sf.fmj.media.BasicController;
import net.sf.fmj.media.BasicFilterModule;
import net.sf.fmj.media.BasicModule;
import net.sf.fmj.media.BasicPlayer;
import net.sf.fmj.media.BasicRendererModule;
import net.sf.fmj.media.BasicSinkModule;
import net.sf.fmj.media.BasicSourceModule;
import net.sf.fmj.media.BasicTrackControl;
import net.sf.fmj.media.InputConnector;
import net.sf.fmj.media.Log;
import net.sf.fmj.media.Module;
import net.sf.fmj.media.ModuleListener;
import net.sf.fmj.media.OutputConnector;
import net.sf.fmj.media.StateTransistor;
import net.sf.fmj.media.control.FramePositioningAdapter;
import net.sf.fmj.media.control.ProgressControl;
import net.sf.fmj.media.control.ProgressControlAdapter;
import net.sf.fmj.media.control.StringControlAdapter;
import net.sf.fmj.media.protocol.Streamable;
import net.sf.fmj.media.renderer.audio.AudioRenderer;
import net.sf.fmj.media.util.RTPInfo;
import net.sf.fmj.media.util.Resource;

public class PlaybackEngine
extends BasicController
implements ModuleListener {
    protected BasicPlayer player;
    protected DataSource dsource;
    protected Vector modules;
    protected Vector filters;
    protected Vector sinks;
    protected Vector waitPrefetched;
    protected Vector waitStopped;
    protected Vector waitEnded;
    protected Vector waitResetted;
    protected Track[] tracks;
    protected Demultiplexer parser;
    protected BasicSinkModule masterSink = null;
    protected BasicSourceModule source;
    protected SlaveClock slaveClock;
    private boolean internalErrorOccurred = false;
    protected boolean prefetched = false;
    protected boolean started = false;
    private boolean dataPathBlocked = false;
    private boolean useMoreRenderBuffer = false;
    private boolean deallocated = false;
    public boolean prefetchEnabled = true;
    protected static boolean needSavingDB = false;
    private Time timeBeforeAbortPrefetch = null;
    private float rate = 1.0f;
    protected BitRateControl bitRateControl;
    protected FrameRateControl frameRateControl;
    protected FramePositioningControl framePositioningControl = null;
    private long latency = 0L;
    protected Container container = null;
    public static boolean TRACE_ON = false;
    protected BasicTrackControl[] trackControls = new BasicTrackControl[0];
    protected ProgressControl progressControl;
    private long realizeTime;
    private long prefetchTime;
    static String NOT_CONFIGURED_ERROR = "cannot be called before configured";
    static String NOT_REALIZED_ERROR = "cannot be called before realized";
    static String STARTED_ERROR = "cannot be called after started";
    String configError = "Failed to configure: " + this;
    String configIntError = "  The configure process is being interrupted.\n";
    String configInt2Error = "interrupted while the Processor is being configured.";
    String parseError = "failed to parse the input media.";
    protected String realizeError = "Failed to realize: " + this;
    protected String timeBaseError = "  Cannot manage the different time bases.\n";
    protected String genericProcessorError = "cannot handle the customized options set on the Processor.\nCheck the logs for full details.";
    String prefetchError = "Failed to prefetch: " + this;
    RTPInfo rtpInfo = null;
    boolean testedRTP = false;
    boolean prefetchLogged = false;
    long markedDataStartTime = 0L;
    boolean reportOnce = false;
    long lastBitRate = 0L;
    long lastStatsTime = 0L;
    static boolean USE_MASTER = true;
    static boolean USE_BACKUP = false;

    public static void setMemoryTrace(boolean on) {
        TRACE_ON = on;
    }

    static boolean isRawVideo(Format fmt) {
        return fmt instanceof RGBFormat || fmt instanceof YUVFormat;
    }

    static void profile(String msg, long time) {
        Log.profile("Profile: " + msg + ": " + (System.currentTimeMillis() - time) + " ms\n");
    }

    public PlaybackEngine(BasicPlayer p) {
        long initTime = System.currentTimeMillis();
        this.player = p;
        this.createProgressControl();
        this.slaveClock = new SlaveClock();
        this.setClock(this.slaveClock);
        this.stopThreadEnabled = false;
        PlaybackEngine.profile("instantiation", initTime);
    }

    @Override
    protected synchronized void abortConfigure() {
        if (this.source != null) {
            this.source.abortRealize();
        }
    }

    @Override
    protected synchronized void abortPrefetch() {
        this.timeBeforeAbortPrefetch = this.getMediaTime();
        this.doReset();
        int size = this.modules.size();
        for (int i = 0; i < size; ++i) {
            StateTransistor m = (StateTransistor)this.modules.elementAt(i);
            m.abortPrefetch();
        }
        this.deallocated = true;
    }

    @Override
    protected synchronized void abortRealize() {
        int size = this.modules.size();
        for (int i = 0; i < size; ++i) {
            StateTransistor m = (StateTransistor)this.modules.elementAt(i);
            m.abortRealize();
        }
    }

    public boolean audioEnabled() {
        for (int i = 0; i < this.trackControls.length; ++i) {
            if (!this.trackControls[i].isEnabled() || !(this.trackControls[i].getOriginalFormat() instanceof AudioFormat)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bufferPrefetched(Module src) {
        if (!this.prefetchEnabled) {
            return;
        }
        if (src instanceof BasicSinkModule) {
            Vector vector = this.waitPrefetched;
            synchronized (vector) {
                if (this.waitPrefetched.contains(src)) {
                    this.waitPrefetched.removeElement(src);
                }
                if (this.waitPrefetched.isEmpty()) {
                    this.waitPrefetched.notifyAll();
                    if (!this.prefetchLogged) {
                        PlaybackEngine.profile("prefetch", this.prefetchTime);
                        this.prefetchLogged = true;
                    }
                    if (this.getState() != 600 && this.getTargetState() != 600) {
                        this.source.pause();
                    }
                    this.prefetched = true;
                }
            }
        }
    }

    protected GraphNode buildTrackFromGraph(BasicTrackControl tc, GraphNode node) {
        BasicModule src = null;
        BasicModule dst = null;
        InputConnector ic = null;
        OutputConnector oc = null;
        boolean lastNode = true;
        Vector used = new Vector(5);
        int indent = 0;
        if (node.plugin == null) {
            return null;
        }
        Log.setIndent(indent++);
        while (node != null && node.plugin != null) {
            src = this.createModule(node, used);
            if (src == null) {
                Log.error("Internal error: buildTrackFromGraph");
                node.failed = true;
                return node;
            }
            if (lastNode) {
                if (src instanceof BasicRendererModule) {
                    tc.rendererModule = (BasicRendererModule)src;
                    if (this.useMoreRenderBuffer && tc.rendererModule.getRenderer() instanceof AudioRenderer) {
                        this.setRenderBufferSize(tc.rendererModule.getRenderer());
                    }
                } else if (src instanceof BasicFilterModule) {
                    tc.lastOC = src.getOutputConnector(null);
                    tc.lastOC.setFormat(node.output);
                }
                lastNode = false;
            }
            ic = src.getInputConnector(null);
            ic.setFormat(node.input);
            if (dst != null) {
                oc = src.getOutputConnector(null);
                ic = dst.getInputConnector(null);
                oc.setFormat(ic.getFormat());
            }
            src.setController(this);
            if (!src.doRealize()) {
                Log.setIndent(indent--);
                node.failed = true;
                return node;
            }
            if (oc != null && ic != null) {
                this.connectModules(oc, ic, dst);
            }
            dst = src;
            node = node.prev;
        }
        dst = src;
        do {
            dst.setModuleListener(this);
            this.modules.addElement(dst);
            tc.modules.addElement(dst);
            if (dst instanceof BasicFilterModule) {
                this.filters.addElement(dst);
                continue;
            }
            if (!(dst instanceof BasicSinkModule)) continue;
            this.sinks.addElement(dst);
        } while ((oc = dst.getOutputConnector(null)) != null && (ic = oc.getInputConnector()) != null && (dst = (BasicModule)ic.getModule()) != null);
        tc.firstOC.setFormat(tc.getOriginalFormat());
        ic = src.getInputConnector(null);
        Format fmt = ic.getFormat();
        if (fmt == null || !fmt.equals(tc.getOriginalFormat())) {
            ic.setFormat(tc.getOriginalFormat());
        }
        this.connectModules(tc.firstOC, ic, src);
        Log.setIndent(indent--);
        return null;
    }

    protected void connectModules(OutputConnector oc, InputConnector ic, BasicModule dst) {
        if (dst instanceof BasicRendererModule) {
            oc.setProtocol(ic.getProtocol());
        } else {
            ic.setProtocol(oc.getProtocol());
        }
        oc.connectTo(ic, ic.getFormat());
    }

    protected BasicModule createModule(GraphNode n, Vector used) {
        PlugIn p;
        BasicModule m = null;
        if (n.plugin == null) {
            return null;
        }
        if (used.contains(n.plugin)) {
            if (n.cname == null || (p = SimpleGraphBuilder.createPlugIn(n.cname, -1)) == null) {
                Log.write("Failed to instantiate " + n.cname);
                return null;
            }
        } else {
            p = n.plugin;
            used.addElement(p);
        }
        if ((n.type == -1 || n.type == 4) && p instanceof Renderer) {
            m = new BasicRendererModule((Renderer)p);
        } else if ((n.type == -1 || n.type == 2) && p instanceof Codec) {
            m = new BasicFilterModule((Codec)p);
        }
        return m;
    }

    public void createProgressControl() {
        StringControlAdapter frameRate = new StringControlAdapter();
        frameRate.setValue(" N/A");
        StringControlAdapter bitRate = new StringControlAdapter();
        bitRate.setValue(" N/A");
        StringControlAdapter videoProps = new StringControlAdapter();
        videoProps.setValue(" N/A");
        StringControlAdapter audioProps = new StringControlAdapter();
        audioProps.setValue(" N/A");
        StringControlAdapter audioCodec = new StringControlAdapter();
        audioCodec.setValue(" N/A");
        StringControlAdapter videoCodec = new StringControlAdapter();
        videoCodec.setValue(" N/A");
        this.progressControl = new ProgressControlAdapter(frameRate, bitRate, videoProps, audioProps, videoCodec, audioCodec);
    }

    protected Component createVisualContainer(Vector visuals) {
        Boolean hint = (Boolean)Manager.getHint(3);
        if (this.container == null) {
            this.container = hint == null || hint == false ? new HeavyPanel(visuals) : new LightPanel(visuals);
            this.container.setLayout(new FlowLayout());
            this.container.setBackground(Color.black);
            for (int i = 0; i < visuals.size(); ++i) {
                Component c = (Component)visuals.elementAt(i);
                this.container.add(c);
                c.setSize(c.getPreferredSize());
            }
        }
        return this.container;
    }

    @Override
    public void dataBlocked(Module src, boolean blocked) {
        this.dataPathBlocked = blocked;
        if (blocked) {
            this.resetPrefetchedList();
            this.resetResettedList();
        }
        if (this.getTargetState() != 600) {
            return;
        }
        if (blocked) {
            this.localStop();
            this.setTargetState(600);
            this.sendEvent(new RestartingEvent(this, 600, 400, 600, this.getMediaTime()));
        } else {
            this.sendEvent(new StartEvent(this, 500, 600, 600, this.getMediaTime(), this.getTimeBase().getTime()));
        }
    }

    @Override
    protected synchronized void doClose() {
        if (this.modules == null) {
            if (this.source != null) {
                this.source.doClose();
            }
            return;
        }
        if (this.getState() == 600) {
            this.localStop();
        }
        if (this.getState() == 500) {
            this.doReset();
        }
        int size = this.modules.size();
        for (int i = 0; i < size; ++i) {
            StateTransistor m = (StateTransistor)this.modules.elementAt(i);
            m.doClose();
        }
        if (needSavingDB) {
            Resource.saveDB();
            needSavingDB = false;
        }
    }

    @Override
    protected boolean doConfigure() {
        if (!this.doConfigure1()) {
            return false;
        }
        String[] names = this.source.getOutputConnectorNames();
        this.trackControls = new BasicTrackControl[this.tracks.length];
        for (int i = 0; i < this.tracks.length; ++i) {
            this.trackControls[i] = new PlayerTControl(this, this.tracks[i], this.source.getOutputConnector(names[i]));
        }
        return this.doConfigure2();
    }

    protected boolean doConfigure1() {
        long parsingTime = System.currentTimeMillis();
        this.modules = new Vector();
        this.filters = new Vector();
        this.sinks = new Vector();
        this.waitPrefetched = new Vector();
        this.waitStopped = new Vector();
        this.waitEnded = new Vector();
        this.waitResetted = new Vector();
        this.source.setModuleListener(this);
        this.source.setController(this);
        this.modules.addElement(this.source);
        if (!this.source.doRealize()) {
            Log.error(this.configError);
            if (this.source.errMsg != null) {
                Log.error("  " + this.source.errMsg + "\n");
            }
            this.player.processError = this.parseError;
            return false;
        }
        if (this.isInterrupted()) {
            Log.error(this.configError);
            Log.error(this.configIntError);
            this.player.processError = this.configInt2Error;
            return false;
        }
        this.parser = this.source.getDemultiplexer();
        if (this.parser == null) {
            Log.error(this.configError);
            Log.error("  Cannot obtain demultiplexer for the source.\n");
            this.player.processError = this.parseError;
            return false;
        }
        try {
            this.tracks = this.parser.getTracks();
        }
        catch (Exception e) {
            Log.error(this.configError);
            Log.error("  Cannot obtain tracks from the demultiplexer: " + e + "\n");
            this.player.processError = this.parseError;
            return false;
        }
        if (this.isInterrupted()) {
            Log.error(this.configError);
            Log.error(this.configIntError);
            this.player.processError = this.configInt2Error;
            return false;
        }
        PlaybackEngine.profile("parsing", parsingTime);
        return true;
    }

    protected boolean doConfigure2() {
        Track master;
        if (this.parser.isPositionable() && this.parser.isRandomAccess() && (master = FramePositioningAdapter.getMasterTrack(this.tracks)) != null) {
            this.framePositioningControl = new FramePositioningAdapter(this.player, master);
        }
        return true;
    }

    @Override
    protected void doDeallocate() {
    }

    @Override
    protected synchronized void doFailedPrefetch() {
        int size = this.modules.size();
        for (int i = 0; i < size; ++i) {
            StateTransistor m = (StateTransistor)this.modules.elementAt(i);
            m.doFailedPrefetch();
        }
        super.doFailedPrefetch();
    }

    @Override
    protected synchronized void doFailedRealize() {
        int size = this.modules.size();
        for (int i = 0; i < size; ++i) {
            StateTransistor m = (StateTransistor)this.modules.elementAt(i);
            m.doFailedRealize();
        }
        super.doFailedRealize();
    }

    @Override
    protected synchronized boolean doPrefetch() {
        if (this.prefetched) {
            return true;
        }
        return this.doPrefetch1() && this.doPrefetch2();
    }

    protected boolean doPrefetch1() {
        if (this.timeBeforeAbortPrefetch != null) {
            this.doSetMediaTime(this.timeBeforeAbortPrefetch);
            this.timeBeforeAbortPrefetch = null;
        }
        this.prefetchTime = System.currentTimeMillis();
        this.resetPrefetchedList();
        if (!this.source.doPrefetch()) {
            Log.error(this.prefetchError);
            if (this.dsource != null) {
                Log.error("  Cannot prefetch the source: " + this.dsource.getLocator() + "\n");
            }
            return false;
        }
        boolean atLeastOneTrack = false;
        for (int i = 0; i < this.trackControls.length; ++i) {
            boolean usedToFailed = this.trackControls[i].prefetchFailed;
            if (usedToFailed && this.getState() > 400) continue;
            if (this.trackControls[i].prefetchTrack()) {
                atLeastOneTrack = true;
                if (!usedToFailed) continue;
                if (!this.manageTimeBases()) {
                    Log.error(this.prefetchError);
                    Log.error(this.timeBaseError);
                    return false;
                }
                this.doSetMediaTime(this.getMediaTime());
                continue;
            }
            this.trackControls[i].prError();
            if (this.trackControls[i].isTimeBase() && !this.manageTimeBases()) {
                Log.error(this.prefetchError);
                Log.error(this.timeBaseError);
                this.player.processError = this.timeBaseError;
                return false;
            }
            if (!(this.trackControls[i].getFormat() instanceof AudioFormat) || !this.trackControls[i].rendererFailed) continue;
            this.player.processError = "cannot open the audio device.";
        }
        if (!atLeastOneTrack) {
            Log.error(this.prefetchError);
            return false;
        }
        this.player.processError = null;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doPrefetch2() {
        if (this.prefetchEnabled) {
            Vector vector = this.waitPrefetched;
            synchronized (vector) {
                this.source.doStart();
                try {
                    if (!this.waitPrefetched.isEmpty()) {
                        this.waitPrefetched.wait(3000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.prefetched = true;
        this.deallocated = false;
        return true;
    }

    @Override
    protected synchronized boolean doRealize() {
        return this.doRealize1() && this.doRealize2();
    }

    protected boolean doRealize1() {
        Log.comment("Building flow graph for: " + this.dsource + this.dsource.getLocator() + "\n");
        this.realizeTime = System.currentTimeMillis();
        boolean atLeastOneTrack = false;
        int trackID = 0;
        int numTracks = this.getNumTracks();
        for (int i = 0; i < this.trackControls.length; ++i) {
            if (!this.trackControls[i].isEnabled()) continue;
            Log.setIndent(0);
            Log.comment("Building Track: " + i);
            if (this.trackControls[i].buildTrack(trackID, numTracks)) {
                atLeastOneTrack = true;
                this.trackControls[i].setEnabled(true);
            } else {
                if (this.trackControls[i].isCustomized()) {
                    Log.error(this.realizeError);
                    this.trackControls[i].prError();
                    this.player.processError = this.genericProcessorError;
                    return false;
                }
                this.trackControls[i].setEnabled(false);
                Log.warning("Failed to handle track " + i);
                this.trackControls[i].prError();
            }
            if (this.isInterrupted()) {
                Log.error(this.realizeError);
                Log.error("  The graph building process is being interrupted.\n");
                this.player.processError = "interrupted while the player is being constructed.";
                return false;
            }
            ++trackID;
            Log.write("\n");
        }
        if (!atLeastOneTrack) {
            Log.error(this.realizeError);
            this.player.processError = "input media not supported: " + this.getCodecList();
            return false;
        }
        return true;
    }

    protected boolean doRealize2() {
        if (!this.manageTimeBases()) {
            Log.error(this.realizeError);
            Log.error(this.timeBaseError);
            this.player.processError = this.timeBaseError;
            return false;
        }
        Log.comment("Here's the completed flow graph:");
        this.traceGraph(this.source);
        Log.write("\n");
        PlaybackEngine.profile("graph building", this.realizeTime);
        this.realizeTime = System.currentTimeMillis();
        this.updateFormats();
        PlaybackEngine.profile("realize, post graph building", this.realizeTime);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void doReset() {
        Vector vector = this.waitResetted;
        synchronized (vector) {
            int i3;
            this.resetResettedList();
            int size = this.modules.size();
            for (int i2 = size - 1; i2 >= 0; --i2) {
                BasicModule m = (BasicModule)this.modules.elementAt(i2);
                if (m.prefetchFailed()) continue;
                m.reset();
            }
            size = this.sinks.size();
            for (i3 = 0; i3 < size; ++i3) {
                BasicSinkModule bsm = (BasicSinkModule)this.sinks.elementAt(i3);
                if (bsm.prefetchFailed()) continue;
                bsm.triggerReset();
            }
            if (!this.waitResetted.isEmpty()) {
                try {
                    this.waitResetted.wait(3000L);
                }
                catch (Exception i3) {
                    // empty catch block
                }
            }
            size = this.sinks.size();
            for (i3 = 0; i3 < size; ++i3) {
                BasicSinkModule bsm = (BasicSinkModule)this.sinks.elementAt(i3);
                if (bsm.prefetchFailed()) continue;
                bsm.doneReset();
            }
        }
        this.prefetched = false;
    }

    @Override
    protected void doSetMediaTime(Time when) {
        this.slaveClock.setMediaTime(when);
        Time t = this.source.setPosition(when, 0);
        if (t == null) {
            t = when;
        }
        int size = this.sinks.size();
        for (int i = 0; i < size; ++i) {
            BasicSinkModule bsm = (BasicSinkModule)this.sinks.elementAt(i);
            bsm.doSetMediaTime(when);
            bsm.setPreroll(when.getNanoseconds(), t.getNanoseconds());
        }
    }

    @Override
    public synchronized float doSetRate(float r) {
        if (r <= 0.0f) {
            r = 1.0f;
        }
        if (r == this.rate) {
            return r;
        }
        r = this.masterSink == null ? this.getClock().setRate(r) : this.masterSink.doSetRate(r);
        int size = this.modules.size();
        for (int i = 0; i < size; ++i) {
            BasicModule m = (BasicModule)this.modules.elementAt(i);
            if (m == this.masterSink) continue;
            m.doSetRate(r);
        }
        this.rate = r;
        return r;
    }

    @Override
    protected synchronized void doStart() {
        if (this.started) {
            return;
        }
        this.doStart1();
        this.doStart2();
    }

    protected void doStart1() {
        if (this.dsource instanceof CaptureDevice && !this.isRTP()) {
            this.reset();
        }
        this.resetPrefetchedList();
        this.resetStoppedList();
        this.resetEndedList();
        for (int i = 0; i < this.trackControls.length; ++i) {
            if (!this.trackControls[i].isEnabled()) continue;
            this.trackControls[i].startTrack();
        }
    }

    protected void doStart2() {
        this.source.doStart();
        this.started = true;
        this.prefetched = true;
    }

    @Override
    protected synchronized void doStop() {
        if (!this.started) {
            return;
        }
        this.doStop1();
        this.doStop2();
    }

    protected void doStop1() {
        this.resetPrefetchedList();
        this.source.doStop();
        for (int i = 0; i < this.trackControls.length; ++i) {
            if (!this.trackControls[i].isEnabled()) continue;
            this.trackControls[i].stopTrack();
        }
    }

    protected void doStop2() {
        if (!this.prefetchEnabled) {
            this.source.pause();
        }
        this.started = false;
    }

    protected BasicSinkModule findMasterSink() {
        for (int i = 0; i < this.trackControls.length; ++i) {
            if (!this.trackControls[i].isEnabled() || this.trackControls[i].rendererModule == null || this.trackControls[i].rendererModule.getClock() == null) continue;
            return this.trackControls[i].rendererModule;
        }
        return null;
    }

    @Override
    public void formatChanged(Module src, Format oldFormat, Format newFormat) {
        Log.comment(src + ": input format changed: " + newFormat);
        if (src instanceof BasicRendererModule && oldFormat instanceof VideoFormat && newFormat instanceof VideoFormat) {
            Dimension s1 = ((VideoFormat)oldFormat).getSize();
            Dimension s2 = ((VideoFormat)newFormat).getSize();
            if (!(s2 == null || s1 != null && s1.equals(s2))) {
                this.sendEvent(new SizeChangeEvent(this, s2.width, s2.height, 1.0f));
            }
        }
    }

    @Override
    public void formatChangedFailure(Module src, Format oldFormat, Format newFormat) {
        if (!this.internalErrorOccurred) {
            this.sendEvent(new InternalErrorEvent(this, "Internal module " + src + ": failed to handle a data format change!"));
            this.internalErrorOccurred = true;
            this.close();
        }
    }

    @Override
    public void framesBehind(Module src, float frames, InputConnector ic) {
        OutputConnector oc;
        while (ic != null && (oc = ic.getOutputConnector()) != null && (src = oc.getModule()) != null && src instanceof BasicFilterModule) {
            BasicFilterModule bfm = (BasicFilterModule)src;
            bfm.setFramesBehind(frames);
            ic = src.getInputConnector(null);
        }
    }

    protected long getBitRate() {
        return this.source.getBitsRead();
    }

    public String getCNAME() {
        if (this.rtpInfo == null && (this.rtpInfo = (RTPInfo)this.dsource.getControl(RTPInfo.class.getName())) == null) {
            return null;
        }
        return this.rtpInfo.getCNAME();
    }

    String getCodecList() {
        String list = "";
        for (int i = 0; i < this.trackControls.length; ++i) {
            Format fmt = this.trackControls[i].getOriginalFormat();
            if (fmt == null || fmt.getEncoding() == null) continue;
            list = list + fmt.getEncoding();
            if (fmt instanceof VideoFormat) {
                list = list + " video";
            } else if (fmt instanceof AudioFormat) {
                list = list + " audio";
            }
            if (i + 1 >= this.trackControls.length) continue;
            list = list + ", ";
        }
        return list;
    }

    @Override
    public Control[] getControls() {
        int i;
        Vector<Object> cv = new Vector<Object>();
        int size = this.modules == null ? 0 : this.modules.size();
        int otherSize = 0;
        for (i = 0; i < size; ++i) {
            Module m = (Module)this.modules.elementAt(i);
            Object[] cs = m.getControls();
            if (cs == null) continue;
            for (int j = 0; j < cs.length; ++j) {
                cv.addElement(cs[j]);
            }
        }
        size = cv.size();
        if (this.videoEnabled() && this.frameRateControl == null) {
            this.frameRateControl = new FrameRateAdapter(this.player, 0.0f, 0.0f, 30.0f, false){

                @Override
                public Component getControlComponent() {
                    return null;
                }

                @Override
                public Object getOwner() {
                    return PlaybackEngine.this.player;
                }

                @Override
                public float setFrameRate(float rate) {
                    this.value = rate;
                    return -1.0f;
                }
            };
        }
        if (this.bitRateControl == null) {
            this.bitRateControl = new BitRateA(0, -1, -1, false);
        }
        if (this.frameRateControl != null) {
            ++otherSize;
        }
        if (this.bitRateControl != null) {
            ++otherSize;
        }
        if (this.framePositioningControl != null) {
            ++otherSize;
        }
        Control[] controls = new Control[size + otherSize + this.trackControls.length];
        for (i = 0; i < size; ++i) {
            controls[i] = (Control)cv.elementAt(i);
        }
        if (this.bitRateControl != null) {
            controls[size++] = this.bitRateControl;
        }
        if (this.frameRateControl != null) {
            controls[size++] = this.frameRateControl;
        }
        if (this.framePositioningControl != null) {
            controls[size++] = this.framePositioningControl;
        }
        for (i = 0; i < this.trackControls.length; ++i) {
            controls[size + i] = this.trackControls[i];
        }
        return controls;
    }

    @Override
    public Time getDuration() {
        return this.source.getDuration();
    }

    public GainControl getGainControl() {
        return (GainControl)this.getControl("javax.media.GainControl");
    }

    public long getLatency() {
        return this.latency;
    }

    int getNumTracks() {
        int num = 0;
        for (int i = 0; i < this.trackControls.length; ++i) {
            if (!this.trackControls[i].isEnabled()) continue;
            ++num;
        }
        return num;
    }

    protected PlugIn getPlugIn(BasicModule m) {
        if (m instanceof BasicSourceModule) {
            return ((BasicSourceModule)m).getDemultiplexer();
        }
        if (m instanceof BasicFilterModule) {
            return ((BasicFilterModule)m).getCodec();
        }
        if (m instanceof BasicRendererModule) {
            return ((BasicRendererModule)m).getRenderer();
        }
        return null;
    }

    @Override
    public Time getStartLatency() {
        if (this.state == 100 || this.state == 200) {
            this.throwError(new NotRealizedError("Cannot get start latency from an unrealized controller"));
        }
        return LATENCY_UNKNOWN;
    }

    @Override
    public TimeBase getTimeBase() {
        return this.getClock().getTimeBase();
    }

    public Component getVisualComponent() {
        Vector<Component> visuals = new Vector<Component>(1);
        if (this.modules == null) {
            return null;
        }
        for (int i = 0; i < this.modules.size(); ++i) {
            Component comp;
            BasicModule bm = (BasicModule)this.modules.elementAt(i);
            PlugIn pi = this.getPlugIn(bm);
            if (!(pi instanceof VideoRenderer) || (comp = ((VideoRenderer)pi).getComponent()) == null) continue;
            visuals.addElement(comp);
        }
        if (visuals.size() == 0) {
            return null;
        }
        if (visuals.size() == 1) {
            return (Component)visuals.elementAt(0);
        }
        return this.createVisualContainer(visuals);
    }

    @Override
    public void internalErrorOccurred(Module src) {
        if (!this.internalErrorOccurred) {
            this.sendEvent(new InternalErrorEvent(this, "Internal module " + src + " failed!"));
            this.internalErrorOccurred = true;
            this.close();
        }
    }

    @Override
    protected boolean isConfigurable() {
        return true;
    }

    public boolean isRTP() {
        if (this.testedRTP) {
            return this.rtpInfo != null;
        }
        this.rtpInfo = (RTPInfo)this.dsource.getControl(RTPInfo.class.getName());
        this.testedRTP = true;
        return this.rtpInfo != null;
    }

    protected BasicModule lastModule(BasicModule bm) {
        InputConnector ic;
        OutputConnector oc = bm.getOutputConnector(null);
        while (oc != null && (ic = oc.getInputConnector()) != null) {
            bm = (BasicModule)ic.getModule();
            oc = bm.getOutputConnector(null);
        }
        return bm;
    }

    protected synchronized void localStop() {
        super.stop();
    }

    boolean manageTimeBases() {
        this.masterSink = this.findMasterSink();
        return this.updateMasterTimeBase();
    }

    @Override
    public void markedDataArrived(Module src, Buffer buffer) {
        if (src instanceof BasicSourceModule) {
            this.markedDataStartTime = this.getMediaNanoseconds();
        } else {
            long t = this.getMediaNanoseconds() - this.markedDataStartTime;
            if (t > 0L && t < 1000000000L) {
                if (!this.reportOnce) {
                    Log.comment("Computed latency for video: " + t / 1000000L + " ms\n");
                    this.reportOnce = true;
                }
                this.latency = (t + this.latency) / 2L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mediaEnded(Module src) {
        if (src instanceof BasicSinkModule) {
            Vector vector = this.waitEnded;
            synchronized (vector) {
                if (this.waitEnded.contains(src)) {
                    this.waitEnded.removeElement(src);
                }
                if (this.waitEnded.isEmpty()) {
                    this.started = false;
                    this.stopControllerOnly();
                    this.sendEvent(new EndOfMediaEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
                    this.slaveClock.reset(USE_MASTER);
                } else if (src == this.masterSink) {
                    this.slaveClock.reset(USE_BACKUP);
                }
            }
        }
    }

    @Override
    public void pluginTerminated(Module src) {
        if (!this.internalErrorOccurred) {
            this.sendEvent(new ControllerClosedEvent(this));
            this.internalErrorOccurred = true;
            this.close();
        }
    }

    protected synchronized void reset() {
        if (this.started || !this.prefetched || this.dataPathBlocked) {
            return;
        }
        this.doReset();
    }

    protected void resetBitRate() {
        this.source.resetBitsRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetEndedList() {
        Vector vector = this.waitEnded;
        synchronized (vector) {
            this.waitEnded.removeAllElements();
            int size = this.sinks.size();
            for (int i = 0; i < size; ++i) {
                BasicSinkModule bsm = (BasicSinkModule)this.sinks.elementAt(i);
                if (bsm.prefetchFailed()) continue;
                this.waitEnded.addElement(bsm);
            }
            this.waitEnded.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetPrefetchedList() {
        Vector vector = this.waitPrefetched;
        synchronized (vector) {
            this.waitPrefetched.removeAllElements();
            int size = this.sinks.size();
            for (int i = 0; i < size; ++i) {
                BasicSinkModule bsm = (BasicSinkModule)this.sinks.elementAt(i);
                if (bsm.prefetchFailed()) continue;
                this.waitPrefetched.addElement(bsm);
            }
            this.waitPrefetched.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetResettedList() {
        Vector vector = this.waitResetted;
        synchronized (vector) {
            this.waitResetted.removeAllElements();
            int size = this.sinks.size();
            for (int i = 0; i < size; ++i) {
                BasicSinkModule bsm = (BasicSinkModule)this.sinks.elementAt(i);
                if (bsm.prefetchFailed()) continue;
                this.waitResetted.addElement(bsm);
            }
            this.waitResetted.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetStoppedList() {
        Vector vector = this.waitStopped;
        synchronized (vector) {
            this.waitStopped.removeAllElements();
            int size = this.sinks.size();
            for (int i = 0; i < size; ++i) {
                BasicSinkModule bsm = (BasicSinkModule)this.sinks.elementAt(i);
                if (bsm.prefetchFailed()) continue;
                this.waitStopped.addElement(bsm);
            }
            this.waitStopped.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetted(Module src) {
        Vector vector = this.waitResetted;
        synchronized (vector) {
            if (this.waitResetted.contains(src)) {
                this.waitResetted.removeElement(src);
            }
            if (this.waitResetted.isEmpty()) {
                this.waitResetted.notifyAll();
            }
        }
    }

    @Override
    public synchronized void setMediaTime(Time when) {
        if (this.state < 300) {
            this.throwError(new NotRealizedError("Cannot set media time on a unrealized controller"));
        }
        if (when.getNanoseconds() == this.getMediaNanoseconds()) {
            return;
        }
        this.reset();
        this.timeBeforeAbortPrefetch = null;
        this.doSetMediaTime(when);
        this.doPrefetch();
        this.sendEvent(new MediaTimeSetEvent(this, when));
    }

    public void setProgressControl(ProgressControl p) {
        this.progressControl = p;
    }

    protected void setRenderBufferSize(Renderer r) {
        BufferControl bc = (BufferControl)r.getControl(BufferControl.class.getName());
        if (bc != null) {
            bc.setBufferLength(2000L);
        }
    }

    public void setSource(DataSource ds) throws IOException, IncompatibleSourceException {
        try {
            this.source = BasicSourceModule.createModule(ds);
        }
        catch (IOException ioe) {
            Log.warning("Input DataSource: " + ds);
            Log.warning("  Failed with IO exception: " + ioe.getMessage());
            throw ioe;
        }
        catch (IncompatibleSourceException ise) {
            Log.warning("Input DataSource: " + ds);
            Log.warning("  is not compatible with the MediaEngine.");
            Log.warning("  It's likely that the DataSource is required to extend PullDataSource;");
            Log.warning("  and that its source streams implement the Seekable interface ");
            Log.warning("  and with random access capability.");
            throw ise;
        }
        if (this.source == null) {
            throw new IncompatibleSourceException();
        }
        this.source.setController(this);
        this.dsource = ds;
        if (this.dsource instanceof Streamable && !((Streamable)((Object)this.dsource)).isPrefetchable()) {
            this.prefetchEnabled = false;
            this.dataPathBlocked = true;
        }
        if (this.dsource instanceof CaptureDevice) {
            this.prefetchEnabled = false;
        }
    }

    @Override
    public void setStopTime(Time t) {
        if (this.getState() < 300) {
            this.throwError(new NotRealizedError("Cannot set stop time on an unrealized controller."));
        }
        if (this.getStopTime() != null && this.getStopTime().getNanoseconds() != t.getNanoseconds()) {
            this.sendEvent(new StopTimeChangeEvent(this, t));
        }
        if (this.getState() == 600 && t != Clock.RESET && t.getNanoseconds() < this.getMediaNanoseconds()) {
            this.localStop();
            this.setStopTime(Clock.RESET);
            this.sendEvent(new StopAtTimeEvent(this, this.getState(), 500, this.getTargetState(), this.getMediaTime()));
        } else {
            this.getClock().setStopTime(t);
            int size = this.sinks.size();
            for (int i = 0; i < size; ++i) {
                BasicSinkModule bsm = (BasicSinkModule)this.sinks.elementAt(i);
                bsm.setStopTime(t);
            }
        }
    }

    @Override
    public void setTimeBase(TimeBase tb) throws IncompatibleTimeBaseException {
        this.getClock().setTimeBase(tb);
        if (this.sinks == null) {
            return;
        }
        int size = this.sinks.size();
        for (int i = 0; i < size; ++i) {
            BasicSinkModule bsm = (BasicSinkModule)this.sinks.elementAt(i);
            bsm.setTimeBase(tb);
        }
    }

    @Override
    public synchronized void stop() {
        super.stop();
        this.sendEvent(new StopByRequestEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopAtTime(Module src) {
        if (src instanceof BasicSinkModule) {
            Vector vector = this.waitStopped;
            synchronized (vector) {
                if (this.waitStopped.contains(src)) {
                    this.waitStopped.removeElement(src);
                }
                if (this.waitStopped.isEmpty() || this.waitEnded.size() == 1 && this.waitEnded.contains(src)) {
                    this.started = false;
                    this.stopControllerOnly();
                    this.setStopTime(Clock.RESET);
                    this.sendEvent(new StopAtTimeEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
                    this.slaveClock.reset(USE_MASTER);
                } else if (src == this.masterSink) {
                    this.slaveClock.reset(USE_BACKUP);
                }
            }
        }
    }

    void traceGraph(BasicModule source) {
        String[] names = source.getOutputConnectorNames();
        for (int i = 0; i < names.length; ++i) {
            Module m;
            OutputConnector oc = source.getOutputConnector(names[i]);
            InputConnector ic = oc.getInputConnector();
            if (ic == null || (m = ic.getModule()) == null) continue;
            Log.write("  " + this.getPlugIn(source));
            Log.write("     connects to: " + this.getPlugIn((BasicModule)m));
            Log.write("     format: " + oc.getFormat());
            this.traceGraph((BasicModule)m);
        }
    }

    public void updateFormats() {
        for (int i = 0; i < this.trackControls.length; ++i) {
            this.trackControls[i].updateFormat();
        }
    }

    boolean updateMasterTimeBase() {
        int size = this.sinks.size();
        if (this.masterSink != null) {
            this.slaveClock.setMaster(this.masterSink.getClock());
        } else {
            this.slaveClock.setMaster(null);
        }
        for (int i = 0; i < size; ++i) {
            BasicSinkModule bsm = (BasicSinkModule)this.sinks.elementAt(i);
            if (bsm == this.masterSink || bsm.prefetchFailed()) continue;
            try {
                bsm.setTimeBase(this.slaveClock.getTimeBase());
                continue;
            }
            catch (IncompatibleTimeBaseException e) {
                return false;
            }
        }
        return true;
    }

    public void updateRates() {
        if (this.getState() < 300) {
            return;
        }
        long now = System.currentTimeMillis();
        long rate = now == this.lastStatsTime ? this.lastBitRate : (long)((double)this.getBitRate() * 8.0 / (double)(now - this.lastStatsTime) * 1000.0);
        long avg = (this.lastBitRate + rate) / 2L;
        if (this.bitRateControl != null) {
            this.bitRateControl.setBitRate((int)avg);
        }
        this.lastBitRate = rate;
        this.lastStatsTime = now;
        this.resetBitRate();
        for (int i = 0; i < this.trackControls.length; ++i) {
            this.trackControls[i].updateRates(now);
        }
        this.source.checkLatency();
    }

    public boolean videoEnabled() {
        for (int i = 0; i < this.trackControls.length; ++i) {
            if (!this.trackControls[i].isEnabled() || !(this.trackControls[i].getOriginalFormat() instanceof VideoFormat)) continue;
            return true;
        }
        return false;
    }

    class SlaveClock
    implements Clock {
        Clock master;
        Clock current;
        BasicClock backup = new BasicClock();

        SlaveClock() {
            this.current = this.backup;
        }

        @Override
        public long getMediaNanoseconds() {
            return this.current.getMediaNanoseconds();
        }

        @Override
        public Time getMediaTime() {
            return this.current.getMediaTime();
        }

        @Override
        public float getRate() {
            return this.current.getRate();
        }

        @Override
        public Time getStopTime() {
            return this.backup.getStopTime();
        }

        @Override
        public Time getSyncTime() {
            return this.current.getSyncTime();
        }

        @Override
        public TimeBase getTimeBase() {
            return this.current.getTimeBase();
        }

        @Override
        public Time mapToTimeBase(Time t) throws ClockStoppedException {
            return this.current.mapToTimeBase(t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void reset(boolean useMaster) {
            if (this.master != null && useMaster) {
                this.current = this.master;
            } else {
                if (this.master != null) {
                    BasicClock basicClock = this.backup;
                    synchronized (basicClock) {
                        boolean started = false;
                        if (this.backup.getState() == 1) {
                            this.backup.stop();
                            started = true;
                        }
                        this.backup.setMediaTime(this.master.getMediaTime());
                        if (started) {
                            this.backup.syncStart(this.backup.getTimeBase().getTime());
                        }
                    }
                }
                this.current = this.backup;
            }
        }

        public void setMaster(Clock master) {
            this.master = master;
            Clock clock = this.current = master == null ? this.backup : master;
            if (master != null) {
                try {
                    this.backup.setTimeBase(master.getTimeBase());
                }
                catch (IncompatibleTimeBaseException incompatibleTimeBaseException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setMediaTime(Time now) {
            BasicClock basicClock = this.backup;
            synchronized (basicClock) {
                if (this.backup.getState() == 1) {
                    this.backup.stop();
                    this.backup.setMediaTime(now);
                    this.backup.syncStart(this.backup.getTimeBase().getTime());
                } else {
                    this.backup.setMediaTime(now);
                }
            }
        }

        @Override
        public float setRate(float factor) {
            return this.backup.setRate(factor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setStopTime(Time t) {
            BasicClock basicClock = this.backup;
            synchronized (basicClock) {
                this.backup.setStopTime(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setTimeBase(TimeBase tb) throws IncompatibleTimeBaseException {
            BasicClock basicClock = this.backup;
            synchronized (basicClock) {
                this.backup.setTimeBase(tb);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stop() {
            BasicClock basicClock = this.backup;
            synchronized (basicClock) {
                this.backup.stop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void syncStart(Time tbt) {
            BasicClock basicClock = this.backup;
            synchronized (basicClock) {
                if (this.backup.getState() != 1) {
                    this.backup.syncStart(tbt);
                }
            }
        }
    }

    class PlayerTControl
    extends BasicTrackControl
    implements Owned {
        protected PlayerGraphBuilder gb;

        public PlayerTControl(PlaybackEngine engine, Track track, OutputConnector oc) {
            super(engine, track, oc);
        }

        @Override
        public boolean buildTrack(int trackID, int numTracks) {
            if (this.gb == null) {
                this.gb = new PlayerGraphBuilder(this.engine);
            } else {
                this.gb.reset();
            }
            boolean rtn = this.gb.buildGraph(this);
            this.gb = null;
            return rtn;
        }

        @Override
        protected FrameRateControl frameRateControl() {
            return PlaybackEngine.this.frameRateControl;
        }

        @Override
        public Object getOwner() {
            return PlaybackEngine.this.player;
        }

        @Override
        public boolean isTimeBase() {
            for (int j = 0; j < this.modules.size(); ++j) {
                if (this.modules.elementAt(j) != PlaybackEngine.this.masterSink) continue;
                return true;
            }
            return false;
        }

        @Override
        protected ProgressControl progressControl() {
            return PlaybackEngine.this.progressControl;
        }
    }

    class PlayerGraphBuilder
    extends SimpleGraphBuilder {
        protected PlaybackEngine engine;

        PlayerGraphBuilder(PlaybackEngine engine) {
            this.engine = engine;
        }

        @Override
        protected GraphNode buildTrackFromGraph(BasicTrackControl tc, GraphNode node) {
            return this.engine.buildTrackFromGraph(tc, node);
        }
    }

    class LightPanel
    extends Container
    implements VisualContainer {
        public LightPanel(Vector visuals) {
        }
    }

    class HeavyPanel
    extends Panel
    implements VisualContainer {
        public HeavyPanel(Vector visuals) {
        }
    }

    class BitRateA
    extends BitRateAdapter
    implements Owned {
        public BitRateA(int initialBitRate, int minBitRate, int maxBitRate, boolean settable) {
            super(initialBitRate, minBitRate, maxBitRate, settable);
        }

        @Override
        public Component getControlComponent() {
            return null;
        }

        @Override
        public Object getOwner() {
            return PlaybackEngine.this.player;
        }

        @Override
        public int setBitRate(int rate) {
            this.value = rate;
            return this.value;
        }
    }
}

