/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.filtergraph;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.media.Codec;
import javax.media.Format;
import javax.media.Multiplexer;
import javax.media.PlugIn;
import javax.media.PlugInManager;
import javax.media.Renderer;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import net.sf.fmj.filtergraph.GraphInspector;
import net.sf.fmj.filtergraph.GraphNode;
import net.sf.fmj.media.BasicPlugIn;
import net.sf.fmj.media.BasicTrackControl;
import net.sf.fmj.media.Log;

public class SimpleGraphBuilder {
    protected int STAGES = 5;
    protected Hashtable<String, GraphNode> plugIns = new Hashtable(40);
    protected GraphNode[] targetPlugins = null;
    protected Vector targetPluginNames = null;
    protected int targetType = -1;
    protected int indent = 0;
    public static GraphInspector inspector;

    public static PlugIn createPlugIn(String name, int type) {
        Object obj;
        try {
            Class<?> cls = BasicPlugIn.getClassForName(name);
            obj = cls.newInstance();
        }
        catch (Exception e) {
            return null;
        }
        catch (Error e) {
            return null;
        }
        if (SimpleGraphBuilder.verifyClass(obj, type)) {
            return (PlugIn)obj;
        }
        return null;
    }

    public static Codec findCodec(Format in, Format out, Format[] selectedIn, Format[] selectedOut) {
        Vector cnames = PlugInManager.getPlugInList(in, out, 2);
        if (cnames == null) {
            return null;
        }
        Codec c = null;
        for (int i = 0; i < cnames.size(); ++i) {
            Format[] fmts;
            Format matched;
            c = (Codec)SimpleGraphBuilder.createPlugIn((String)cnames.elementAt(i), 2);
            if (c == null || (matched = SimpleGraphBuilder.matches(in, fmts = c.getSupportedInputFormats(), null, (PlugIn)c)) == null) continue;
            if (selectedIn != null && selectedIn.length > 0) {
                selectedIn[0] = matched;
            }
            if ((fmts = c.getSupportedOutputFormats(matched)) == null || fmts.length == 0) continue;
            boolean success = false;
            for (int j = 0; j < fmts.length; ++j) {
                if (out != null) {
                    if (!out.matches(fmts[j]) || (matched = out.intersects(fmts[j])) == null) {
                        continue;
                    }
                } else {
                    matched = fmts[j];
                }
                if (c.setOutputFormat(matched) == null) continue;
                success = true;
                break;
            }
            if (!success) continue;
            try {
                c.open();
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                // empty catch block
            }
            if (selectedOut != null && selectedOut.length > 0) {
                selectedOut[0] = matched;
            }
            return c;
        }
        return null;
    }

    public static Renderer findRenderer(Format in) {
        Vector names = PlugInManager.getPlugInList(in, null, 4);
        if (names == null) {
            return null;
        }
        Renderer r = null;
        for (int i = 0; i < names.size(); ++i) {
            Format[] fmts;
            Format matched;
            r = (Renderer)SimpleGraphBuilder.createPlugIn((String)names.elementAt(i), 4);
            if (r == null || (matched = SimpleGraphBuilder.matches(in, fmts = r.getSupportedInputFormats(), null, (PlugIn)r)) == null) continue;
            try {
                r.open();
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                // empty catch block
            }
            return r;
        }
        return null;
    }

    public static Vector findRenderingChain(Format in, Vector formats) {
        SimpleGraphBuilder gb = new SimpleGraphBuilder();
        GraphNode n = gb.buildGraph(in);
        if (n == null) {
            return null;
        }
        Vector<PlugIn> list = new Vector<PlugIn>(10);
        while (n != null && n.plugin != null) {
            list.addElement(n.plugin);
            if (formats != null) {
                formats.addElement(n.input);
            }
            n = n.prev;
        }
        return list;
    }

    public static GraphNode getPlugInNode(String name, int type, Map<String, GraphNode> plugIns) {
        GraphNode gn = null;
        if (plugIns == null || (gn = plugIns.get(name)) == null) {
            PlugIn p = SimpleGraphBuilder.createPlugIn(name, type);
            gn = new GraphNode(name, p, null, null, 0);
            if (plugIns != null) {
                plugIns.put(name, gn);
            }
            if (p == null) {
                gn.failed = true;
                return null;
            }
            return gn;
        }
        if (gn.failed) {
            return null;
        }
        if (SimpleGraphBuilder.verifyClass(gn.plugin, type)) {
            return gn;
        }
        return null;
    }

    public static Format matches(Format[] outs, Format[] ins, PlugIn up, PlugIn down) {
        if (outs == null) {
            return null;
        }
        for (int i = 0; i < outs.length; ++i) {
            Format fmt = SimpleGraphBuilder.matches(outs[i], ins, up, down);
            if (fmt == null) continue;
            return fmt;
        }
        return null;
    }

    public static Format matches(Format out, Format[] ins, PlugIn up, PlugIn down) {
        if (out == null || ins == null) {
            return null;
        }
        for (int i = 0; i < ins.length; ++i) {
            Format fmt;
            if (ins[i] == null || !ins[i].getClass().isAssignableFrom(out.getClass()) || !out.matches(ins[i]) || (fmt = out.intersects(ins[i])) == null || down != null && (fmt = SimpleGraphBuilder.verifyInput(down, fmt)) == null) continue;
            Format refined = fmt;
            if (up != null && (refined = SimpleGraphBuilder.verifyOutput(up, fmt)) == null || down != null && refined != fmt && SimpleGraphBuilder.verifyInput(down, refined) == null) continue;
            return refined;
        }
        return null;
    }

    public static Format matches(Format[] outs, Format in, PlugIn up, PlugIn down) {
        Format[] ins = new Format[]{in};
        return SimpleGraphBuilder.matches(outs, ins, up, down);
    }

    public static boolean verifyClass(Object obj, int type) {
        Class cls;
        switch (type) {
            case 2: {
                cls = Codec.class;
                break;
            }
            case 4: {
                cls = Renderer.class;
                break;
            }
            case 5: {
                cls = Multiplexer.class;
                break;
            }
            default: {
                cls = PlugIn.class;
            }
        }
        return cls.isInstance(obj);
    }

    public static Format verifyInput(PlugIn p, Format in) {
        if (p instanceof Codec) {
            return ((Codec)p).setInputFormat(in);
        }
        if (p instanceof Renderer) {
            return ((Renderer)p).setInputFormat(in);
        }
        return null;
    }

    public static Format verifyOutput(PlugIn p, Format out) {
        if (p instanceof Codec) {
            return ((Codec)p).setOutputFormat(out);
        }
        return null;
    }

    public static void setGraphInspector(GraphInspector insp) {
        inspector = insp;
    }

    public boolean buildGraph(BasicTrackControl tc) {
        Log.comment("Input: " + tc.getOriginalFormat());
        Vector<GraphNode> candidates = new Vector<GraphNode>();
        GraphNode node = new GraphNode(null, null, tc.getOriginalFormat(), null, 0);
        this.indent = 1;
        Log.setIndent(this.indent);
        if (!this.setDefaultTargets(tc.getOriginalFormat())) {
            return false;
        }
        candidates.addElement(node);
        while ((node = this.buildGraph(candidates)) != null) {
            GraphNode failed = this.buildTrackFromGraph(tc, node);
            if (failed == null) {
                this.indent = 0;
                Log.setIndent(this.indent);
                return true;
            }
            this.removeFailure(candidates, failed, tc.getOriginalFormat());
        }
        this.indent = 0;
        Log.setIndent(this.indent);
        return false;
    }

    GraphNode buildGraph(Format input) {
        Log.comment("Input: " + input);
        Vector<GraphNode> candidates = new Vector<GraphNode>();
        GraphNode node = new GraphNode(null, null, input, null, 0);
        this.indent = 1;
        Log.setIndent(this.indent);
        if (!this.setDefaultTargets(input)) {
            return null;
        }
        candidates.addElement(node);
        while ((node = this.buildGraph(candidates)) != null) {
            GraphNode failed = this.verifyGraph(node);
            if (failed == null) {
                this.indent = 0;
                Log.setIndent(this.indent);
                return node;
            }
            this.removeFailure(candidates, failed, input);
        }
        this.indent = 0;
        Log.setIndent(this.indent);
        return node;
    }

    protected GraphNode buildGraph(Vector<GraphNode> candidates) {
        GraphNode node;
        while ((node = this.doBuildGraph(candidates)) == null && !candidates.isEmpty()) {
        }
        return node;
    }

    protected GraphNode buildTrackFromGraph(BasicTrackControl tc, GraphNode node) {
        return null;
    }

    GraphNode doBuildGraph(Vector candidates) {
        Format input;
        Format[] outs;
        if (candidates.isEmpty()) {
            return null;
        }
        GraphNode node = (GraphNode)candidates.firstElement();
        candidates.removeElementAt(0);
        if (!(node.input != null || node.plugin != null && node.plugin instanceof Codec)) {
            Log.error("Internal error: doBuildGraph");
            return null;
        }
        int oldIndent = this.indent;
        Log.setIndent(node.level + 1);
        if (node.plugin != null && SimpleGraphBuilder.verifyInput(node.plugin, node.input) == null) {
            return null;
        }
        GraphNode n = this.findTarget(node);
        if (n != null) {
            this.indent = oldIndent;
            Log.setIndent(this.indent);
            return n;
        }
        if (node.level >= this.STAGES) {
            this.indent = oldIndent;
            Log.setIndent(this.indent);
            return null;
        }
        boolean mp3Pkt = false;
        if (node.plugin != null) {
            if (node.output != null) {
                outs = new Format[]{node.output};
            } else {
                outs = node.getSupportedOutputs(node.input);
                if (outs == null || outs.length == 0) {
                    this.indent = oldIndent;
                    Log.setIndent(this.indent);
                    return null;
                }
            }
            input = node.input;
        } else {
            outs = new Format[]{node.input};
            input = null;
        }
        boolean foundSomething = false;
        for (int i = 0; i < outs.length; ++i) {
            Vector cnames;
            if (!node.custom && input != null && input.equals(outs[i])) continue;
            if (node.plugin != null) {
                if (SimpleGraphBuilder.verifyOutput(node.plugin, outs[i]) == null) {
                    if (inspector == null || !inspector.detailMode()) continue;
                    inspector.verifyOutputFailed(node.plugin, outs[i]);
                    continue;
                }
                if (inspector != null && !inspector.verify((Codec)node.plugin, node.input, outs[i])) continue;
            }
            if ((cnames = PlugInManager.getPlugInList(outs[i], null, 2)) == null || cnames.size() == 0) continue;
            for (int j = 0; j < cnames.size(); ++j) {
                GraphNode gn = SimpleGraphBuilder.getPlugInNode((String)cnames.elementAt(j), 2, this.plugIns);
                if (gn == null || gn.checkAttempted(outs[i])) continue;
                Format[] ins = gn.getSupportedInputs();
                Format fmt = SimpleGraphBuilder.matches(outs[i], ins, null, gn.plugin);
                if (fmt == null) {
                    if (inspector == null || !inspector.detailMode()) continue;
                    inspector.verifyInputFailed(gn.plugin, outs[i]);
                    continue;
                }
                if (inspector != null && inspector.detailMode() && !inspector.verify((Codec)gn.plugin, fmt, null)) continue;
                n = new GraphNode(gn, fmt, node, node.level + 1);
                candidates.addElement(n);
                foundSomething = true;
            }
        }
        this.indent = oldIndent;
        Log.setIndent(this.indent);
        return null;
    }

    protected GraphNode findTarget(GraphNode node) {
        GraphNode n;
        Format[] outs;
        if (node.plugin == null) {
            outs = new Format[]{node.input};
        } else if (node.output != null) {
            outs = new Format[]{node.output};
        } else {
            outs = node.getSupportedOutputs(node.input);
            if (outs == null || outs.length == 0) {
                return null;
            }
        }
        if (this.targetPlugins != null && (n = this.verifyTargetPlugins(node, outs)) != null) {
            return n;
        }
        return null;
    }

    void removeFailure(Vector candidates, GraphNode failed, Format input) {
        if (failed.plugin == null) {
            return;
        }
        Log.comment("Failed to open plugin " + failed.plugin + ". Will re-build the graph allover again");
        candidates.removeAllElements();
        GraphNode hsyn = new GraphNode(null, null, input, null, 0);
        this.indent = 1;
        Log.setIndent(this.indent);
        candidates.addElement(hsyn);
        failed.failed = true;
        this.plugIns.put(failed.plugin.getClass().getName(), failed);
        Enumeration<String> e = this.plugIns.keys();
        while (e.hasMoreElements()) {
            String ss = e.nextElement();
            GraphNode nn = this.plugIns.get(ss);
            if (nn.failed) continue;
            this.plugIns.remove(ss);
        }
    }

    public void reset() {
        Enumeration<GraphNode> enum1 = this.plugIns.elements();
        while (enum1.hasMoreElements()) {
            GraphNode n = enum1.nextElement();
            n.resetAttempted();
        }
    }

    protected boolean setDefaultTargetRenderer(Format in) {
        this.targetPluginNames = in instanceof AudioFormat ? PlugInManager.getPlugInList(new AudioFormat(null, -1.0, -1, -1, -1, -1, -1, -1.0, null), null, 4) : (in instanceof VideoFormat ? PlugInManager.getPlugInList(new VideoFormat(null, null, -1, null, -1.0f), null, 4) : PlugInManager.getPlugInList(null, null, 4));
        if (this.targetPluginNames == null || this.targetPluginNames.size() == 0) {
            return false;
        }
        this.targetPlugins = new GraphNode[this.targetPluginNames.size()];
        this.targetType = 4;
        return true;
    }

    protected boolean setDefaultTargets(Format in) {
        return this.setDefaultTargetRenderer(in);
    }

    protected GraphNode verifyGraph(GraphNode node) {
        Format prevFormat = null;
        Vector<PlugIn> used = new Vector<PlugIn>(5);
        if (node.plugin == null) {
            return null;
        }
        Log.setIndent(this.indent++);
        while (node != null && node.plugin != null) {
            if (used.contains(node.plugin)) {
                PlugIn p;
                if (node.cname == null || (p = SimpleGraphBuilder.createPlugIn(node.cname, -1)) == null) {
                    Log.write("Failed to instantiate " + node.cname);
                    return node;
                }
                node.plugin = p;
            } else {
                used.addElement(node.plugin);
            }
            if ((node.type == -1 || node.type == 4) && node.plugin instanceof Renderer) {
                ((Renderer)node.plugin).setInputFormat(node.input);
            } else if ((node.type == -1 || node.type == 2) && node.plugin instanceof Codec) {
                ((Codec)node.plugin).setInputFormat(node.input);
                if (prevFormat != null) {
                    ((Codec)node.plugin).setOutputFormat(prevFormat);
                } else if (node.output != null) {
                    ((Codec)node.plugin).setOutputFormat(node.output);
                }
            }
            if (node.type != -1 && node.type != 4 || !(node.plugin instanceof Renderer)) {
                try {
                    node.plugin.open();
                }
                catch (Exception e) {
                    Log.warning("Failed to open: " + node.plugin);
                    node.failed = true;
                    return node;
                }
            }
            prevFormat = node.input;
            node = node.prev;
        }
        Log.setIndent(this.indent--);
        return null;
    }

    protected GraphNode verifyTargetPlugins(GraphNode node, Format[] outs) {
        for (int i = 0; i < this.targetPlugins.length; ++i) {
            Format fmt;
            GraphNode gn = this.targetPlugins[i];
            if (gn == null) {
                Format[] base;
                String name = (String)this.targetPluginNames.elementAt(i);
                if (name == null || SimpleGraphBuilder.matches(outs, base = PlugInManager.getSupportedInputFormats(name, this.targetType), null, null) == null) continue;
                gn = SimpleGraphBuilder.getPlugInNode(name, this.targetType, this.plugIns);
                if (gn == null) {
                    this.targetPluginNames.setElementAt(null, i);
                    continue;
                }
                this.targetPlugins[i] = gn;
            }
            if ((fmt = SimpleGraphBuilder.matches(outs, gn.getSupportedInputs(), node.plugin, gn.plugin)) == null || inspector != null && (node.plugin != null && !inspector.verify((Codec)node.plugin, node.input, fmt) || ((gn.type == -1 || gn.type == 2) && gn.plugin instanceof Codec ? !inspector.verify((Codec)gn.plugin, fmt, null) : (gn.type == -1 || gn.type == 4) && gn.plugin instanceof Renderer && !inspector.verify((Renderer)gn.plugin, fmt)))) continue;
            return new GraphNode(gn, fmt, node, node.level + 1);
        }
        return null;
    }
}

