/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema.codegen;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshaller;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IXMLWriter;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.QName;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.schema.INamed;
import org.jibx.schema.ISchemaListener;
import org.jibx.schema.SchemaContextTracker;
import org.jibx.schema.SchemaVisitor;
import org.jibx.schema.TreeWalker;
import org.jibx.schema.codegen.DefinitionItem;
import org.jibx.schema.codegen.GroupItem;
import org.jibx.schema.codegen.IClassHolder;
import org.jibx.schema.codegen.Item;
import org.jibx.schema.codegen.ReferenceItem;
import org.jibx.schema.codegen.TypeData;
import org.jibx.schema.codegen.custom.ComponentExtension;
import org.jibx.schema.elements.AnnotatedBase;
import org.jibx.schema.elements.AnnotationElement;
import org.jibx.schema.elements.AttributeElement;
import org.jibx.schema.elements.ElementElement;
import org.jibx.schema.elements.KeyBase;
import org.jibx.schema.elements.SchemaBase;
import org.jibx.util.InsertionOrderedSet;
import org.jibx.util.UniqueNameSet;

public class SchemaDocumentationGenerator {
    public static final String COMMENT_LEAD_TEXT = "\n * ";
    private static final String SCHEMA_DEFINITIONS_NS = "http://www.w3.org/2001/XMLSchema";
    private static final Logger s_logger = Logger.getLogger((String)(class$org$jibx$schema$codegen$SchemaDocumentationGenerator == null ? (class$org$jibx$schema$codegen$SchemaDocumentationGenerator = SchemaDocumentationGenerator.class$("org.jibx.schema.codegen.SchemaDocumentationGenerator")) : class$org$jibx$schema$codegen$SchemaDocumentationGenerator).getName());
    private final IBindingFactory m_factory = BindingDirectory.getFactory((String)"schema_extract_binding", (String)"org.jibx.schema.codegen");
    private final int m_schemaIndex;
    private final String m_schemaPrefix;
    private final Set m_namespaceSet;
    private final MarshallingContext m_context;
    static /* synthetic */ Class class$org$jibx$schema$codegen$SchemaDocumentationGenerator;

    public SchemaDocumentationGenerator() throws JiBXException {
        int index = 0;
        String[] uris = this.m_factory.getNamespaces();
        this.m_namespaceSet = new HashSet();
        for (int i = 1; i < uris.length; ++i) {
            this.m_namespaceSet.add(uris[i]);
            if (!SCHEMA_DEFINITIONS_NS.equals(uris[i])) continue;
            index = i;
        }
        if (index < 0) {
            throw new JiBXException("Schema namespace definition not found");
        }
        this.m_schemaIndex = index;
        this.m_schemaPrefix = this.m_factory.getPrefixes()[index];
        this.m_context = (MarshallingContext)this.m_factory.createMarshallingContext();
        this.m_context.setIndent(2, COMMENT_LEAD_TEXT, ' ');
    }

    private void scanItemTree(GroupItem group, Map comptoclas, Set refcomps, Map uritoprefix) {
        AnnotatedBase topcomp = group.getSchemaComponent();
        for (Item item = group.getFirstChild(); item != null; item = item.getNext()) {
            TypeData genclas;
            QName qname;
            AnnotatedBase comp;
            if (item.isIgnored()) continue;
            for (comp = item.getSchemaComponent(); comp != topcomp; comp = comp.getParent()) {
                QName qname2;
                if (!comp.isGlobal()) continue;
                if (!(item instanceof ReferenceItem)) {
                    refcomps.add(comp);
                }
                if ((qname2 = ((INamed)comp).getQName()) == null) {
                    throw new IllegalStateException("Internal error - no name on global definition");
                }
                uritoprefix.put(qname2.getUri(), qname2.getPrefix());
                break;
            }
            if (item instanceof GroupItem) {
                GroupItem childgroup = (GroupItem)item;
                if (childgroup.isIgnored()) continue;
                if (childgroup.isInline()) {
                    this.scanItemTree(childgroup, comptoclas, refcomps, uritoprefix);
                    continue;
                }
                TypeData genclas2 = childgroup.getGenerateClass();
                if (genclas2 == null) {
                    throw new IllegalStateException("Internal error - no generate class");
                }
                comptoclas.put(childgroup.getSchemaComponent(), genclas2);
                QName tname = null;
                comp = item.getSchemaComponent();
                switch (comp.type()) {
                    case 5: {
                        tname = ((AttributeElement)comp).getType();
                        break;
                    }
                    case 11: {
                        tname = ((ElementElement)comp).getType();
                    }
                }
                if (tname == null) continue;
                uritoprefix.put(tname.getUri(), tname.getPrefix());
                continue;
            }
            if (!(item instanceof ReferenceItem)) continue;
            DefinitionItem def = ((ReferenceItem)item).getDefinition();
            AnnotatedBase defcomp = def.getSchemaComponent();
            if (defcomp instanceof INamed && (qname = ((INamed)defcomp).getQName()) != null) {
                uritoprefix.put(qname.getUri(), qname.getPrefix());
            }
            if ((genclas = def.getGenerateClass()) == null) continue;
            comptoclas.put(defcomp, genclas);
        }
    }

    private void escapeText(char chr, String escape, String text, StringBuffer buff) {
        int scan;
        int base = 0;
        while ((scan = text.indexOf(chr, base)) >= 0) {
            buff.append(text.substring(base, scan));
            buff.append(escape);
            base = scan + 1;
        }
        buff.append(text.substring(base));
    }

    public String generate(GroupItem group, boolean dropanno) {
        QName qname;
        if (group.isIgnored()) {
            return null;
        }
        HashMap comptoclas = new HashMap();
        InsertionOrderedSet refcomps = new InsertionOrderedSet();
        AnnotatedBase grpcomp = group.getSchemaComponent();
        refcomps.add((Object)grpcomp);
        HashMap<String, String> uritoprefix = new HashMap<String, String>();
        if (grpcomp instanceof INamed && (qname = ((INamed)grpcomp).getQName()) != null && qname.getUri() != null) {
            uritoprefix.put(qname.getUri(), qname.getPrefix());
        }
        this.scanItemTree(group, comptoclas, (Set)refcomps, uritoprefix);
        UniqueNameSet prefset = new UniqueNameSet();
        prefset.add(this.m_schemaPrefix);
        Iterator iter = uritoprefix.keySet().iterator();
        while (iter.hasNext()) {
            String uri = (String)iter.next();
            if (SCHEMA_DEFINITIONS_NS.equals(uri)) continue;
            String prefix = (String)uritoprefix.get(uri);
            if (prefix == null) {
                prefix = "ns";
            }
            prefix = prefset.add(prefix);
            uritoprefix.put(uri, prefix);
        }
        StringWriter strwriter = new StringWriter();
        this.m_context.setOutput((Writer)strwriter);
        int count = uritoprefix.size();
        String[] uris = uritoprefix.keySet().toArray(new String[count]);
        IXMLWriter xmlwriter = this.m_context.getXmlWriter();
        int base = xmlwriter.getNamespaceCount();
        xmlwriter.pushExtensionNamespaces(uris);
        int length = count;
        if (!uritoprefix.containsKey(null)) {
            ++length;
        }
        String[] prefixes = new String[length];
        int[] indexes = new int[length];
        int fill = 0;
        for (int i = 0; i < count; ++i) {
            String uri = uris[i];
            if (uri == null) continue;
            prefixes[fill] = (String)uritoprefix.get(uris[i]);
            indexes[fill] = base + fill;
            ++fill;
        }
        prefixes[fill] = this.m_schemaPrefix;
        indexes[fill] = this.m_schemaIndex;
        String clasname = group.getGenerateClass().getFullName();
        TreeWalker walker = new TreeWalker(null, (ISchemaListener)new SchemaContextTracker());
        boolean ref = false;
        List list = refcomps.asList();
        Iterator iter2 = list.iterator();
        while (iter2.hasNext()) {
            if (ref) {
                strwriter.write(COMMENT_LEAD_TEXT);
            } else {
                ref = true;
            }
            AnnotatedBase comp = (AnnotatedBase)iter2.next();
            Iterator jter = uritoprefix.keySet().iterator();
            while (jter.hasNext()) {
                String uri = (String)jter.next();
                comp.addNamespaceDeclaration((String)uritoprefix.get(uri), uri);
            }
            DocumentationVisitor visitor = new DocumentationVisitor(comptoclas, clasname, comp, dropanno, ref, indexes, prefixes);
            walker.walkElement((SchemaBase)comp, (SchemaVisitor)visitor);
            strwriter.flush();
        }
        String text = strwriter.toString();
        StringBuffer buff = new StringBuffer(text.length() + text.length() / 4);
        if (text.indexOf(38) >= 0) {
            this.escapeText('&', "&amp;", text, buff);
            text = buff.toString();
            buff = new StringBuffer(text.length() + text.length() / 4);
        }
        buff.append("Schema fragment(s) for this class:");
        buff.append(COMMENT_LEAD_TEXT);
        buff.append("<pre>");
        buff.append(COMMENT_LEAD_TEXT);
        this.escapeText('<', "&lt;", text, buff);
        buff.append(COMMENT_LEAD_TEXT);
        buff.append("</pre>");
        int index = buff.length();
        while ((index = buff.lastIndexOf("*/", index)) >= 0) {
            buff.replace(index, index + 2, "* /");
        }
        return buff.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DocumentationVisitor
    extends SchemaVisitor {
        private final Map m_componentClassMap;
        private final String m_className;
        private final AnnotatedBase m_component;
        private final boolean m_dropAnnotations;
        private final boolean m_reference;
        private final int[] m_nsIndexes;
        private final String[] m_nsPrefixes;

        public DocumentationVisitor(Map comptoclas, String clasname, AnnotatedBase comp, boolean dropanno, boolean ref, int[] indexes, String[] prefixes) {
            this.m_componentClassMap = comptoclas;
            this.m_className = clasname;
            this.m_component = comp;
            this.m_dropAnnotations = dropanno;
            this.m_reference = ref;
            this.m_nsIndexes = indexes;
            this.m_nsPrefixes = prefixes;
        }

        public void exit(SchemaBase node) {
            try {
                SchemaDocumentationGenerator.this.m_context.endTag(SchemaDocumentationGenerator.this.m_schemaIndex, node.name());
            }
            catch (JiBXException e) {
                s_logger.fatal((Object)"Binding failed", (Throwable)e);
                throw new IllegalStateException("Internal error - binding failed: " + e.getMessage());
            }
        }

        public void exit(AnnotationElement node) {
            if (!this.m_dropAnnotations) {
                super.exit(node);
            }
        }

        public void exit(ElementElement node) {
            Object extension = node.getExtension();
            if (!(extension instanceof ComponentExtension) || !((ComponentExtension)extension).isIgnored()) {
                super.exit(node);
            }
        }

        public void exit(KeyBase node) {
        }

        public boolean visit(SchemaBase node) {
            boolean expand = false;
            try {
                if (node == this.m_component) {
                    int[] copy = new int[this.m_nsIndexes.length];
                    System.arraycopy(this.m_nsIndexes, 0, copy, 0, this.m_nsIndexes.length);
                    SchemaDocumentationGenerator.this.m_context.startTagNamespaces(SchemaDocumentationGenerator.this.m_schemaIndex, node.name(), copy, this.m_nsPrefixes);
                } else {
                    SchemaDocumentationGenerator.this.m_context.startTagAttributes(SchemaDocumentationGenerator.this.m_schemaIndex, node.name());
                }
                IMarshaller marshaller = SchemaDocumentationGenerator.this.m_context.getMarshaller(node.getClass().getName());
                marshaller.marshal((Object)node, (IMarshallingContext)SchemaDocumentationGenerator.this.m_context);
                SchemaDocumentationGenerator.this.m_context.closeStartContent();
                IClassHolder clas = (IClassHolder)this.m_componentClassMap.get(node);
                if (clas != null && (this.m_reference || node != this.m_component)) {
                    String name = clas.getFullName();
                    StringBuffer text = new StringBuffer();
                    int length = this.m_className.length();
                    if (name.startsWith(this.m_className) && name.length() > length && name.charAt(length) == '.') {
                        text.append(" Reference to inner class ");
                        text.append(name.substring(length + 1));
                    } else {
                        text.append(" Reference to class ");
                        text.append(name);
                    }
                    text.append(' ');
                    IXMLWriter writer = SchemaDocumentationGenerator.this.m_context.getXmlWriter();
                    writer.indent();
                    writer.writeComment(text.toString());
                } else {
                    expand = true;
                }
            }
            catch (IOException e) {
                s_logger.fatal((Object)"Write failed", (Throwable)e);
                throw new IllegalStateException("Internal error - write failed: " + e.getMessage());
            }
            catch (JiBXException e) {
                s_logger.fatal((Object)"Error writing schema XML representation", (Throwable)e);
                throw new IllegalStateException("Internal error - error writing schema XML representation: " + e.getMessage());
            }
            return expand;
        }

        public boolean visit(AnnotationElement node) {
            if (this.m_dropAnnotations) {
                return false;
            }
            return super.visit(node);
        }

        public boolean visit(ElementElement node) {
            Object extension = node.getExtension();
            if (extension instanceof ComponentExtension && ((ComponentExtension)extension).isIgnored()) {
                return false;
            }
            return super.visit(node);
        }

        public boolean visit(KeyBase node) {
            return false;
        }
    }
}

