/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema.codegen;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jibx.binding.model.BindingOrganizer;
import org.jibx.extras.DocumentComparator;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.QName;
import org.jibx.runtime.impl.UnmarshallingContext;
import org.jibx.schema.INamed;
import org.jibx.schema.ISchemaListener;
import org.jibx.schema.ISchemaResolver;
import org.jibx.schema.ISkipElements;
import org.jibx.schema.SchemaContextTracker;
import org.jibx.schema.SchemaUtils;
import org.jibx.schema.SchemaVisitor;
import org.jibx.schema.TreeWalker;
import org.jibx.schema.UrlResolver;
import org.jibx.schema.codegen.RefactoryCommandLine;
import org.jibx.schema.codegen.custom.ComponentExtension;
import org.jibx.schema.codegen.custom.GlobalExtension;
import org.jibx.schema.codegen.custom.SchemaCustom;
import org.jibx.schema.codegen.custom.SchemasetCustom;
import org.jibx.schema.elements.FilteredSegmentList;
import org.jibx.schema.elements.OpenAttrBase;
import org.jibx.schema.elements.SchemaBase;
import org.jibx.schema.elements.SchemaElement;
import org.jibx.schema.elements.SchemaLocationBase;
import org.jibx.schema.elements.SimpleRestrictionElement;
import org.jibx.schema.elements.UnionElement;
import org.jibx.schema.support.SchemaTypes;
import org.jibx.schema.validation.NameMergeVisitor;
import org.jibx.schema.validation.NameRegistrationVisitor;
import org.jibx.schema.validation.PrevalidationVisitor;
import org.jibx.schema.validation.ValidationContext;
import org.jibx.schema.validation.ValidationProblem;
import org.jibx.schema.validation.ValidationVisitor;
import org.jibx.util.InsertionOrderedSet;
import org.jibx.util.LazyList;
import org.jibx.util.NameUtilities;
import org.xmlpull.v1.XmlPullParserException;

public class Refactory {
    private static final Logger s_logger = Logger.getLogger((String)(class$org$jibx$schema$codegen$Refactory == null ? (class$org$jibx$schema$codegen$Refactory = Refactory.class$("org.jibx.schema.codegen.Refactory")) : class$org$jibx$schema$codegen$Refactory).getName());
    private static final QName[] DEFAULT_REPLACEMENTS = new QName[]{SchemaTypes.ANY_URI.getQName(), SchemaTypes.STRING.getQName(), SchemaTypes.DURATION.getQName(), SchemaTypes.STRING.getQName(), SchemaTypes.ENTITIES.getQName(), SchemaTypes.STRING.getQName(), SchemaTypes.ENTITY.getQName(), SchemaTypes.STRING.getQName(), SchemaTypes.GDAY.getQName(), SchemaTypes.STRING.getQName(), SchemaTypes.GMONTH.getQName(), SchemaTypes.STRING.getQName(), SchemaTypes.GMONTHDAY.getQName(), SchemaTypes.STRING.getQName(), SchemaTypes.GYEAR.getQName(), SchemaTypes.STRING.getQName(), SchemaTypes.GYEARMONTH.getQName(), SchemaTypes.STRING.getQName(), SchemaTypes.ID.getQName(), SchemaTypes.STRING.getQName(), SchemaTypes.IDREF.getQName(), SchemaTypes.STRING.getQName(), SchemaTypes.IDREFS.getQName(), SchemaTypes.STRING.getQName(), SchemaTypes.LANGUAGE.getQName(), SchemaTypes.STRING.getQName(), SchemaTypes.NAME.getQName(), SchemaTypes.STRING.getQName(), SchemaTypes.NEGATIVE_INTEGER.getQName(), SchemaTypes.INTEGER.getQName(), SchemaTypes.NON_NEGATIVE_INTEGER.getQName(), SchemaTypes.INTEGER.getQName(), SchemaTypes.NON_POSITIVE_INTEGER.getQName(), SchemaTypes.INTEGER.getQName(), SchemaTypes.NORMALIZED_STRING.getQName(), SchemaTypes.STRING.getQName(), SchemaTypes.NCNAME.getQName(), SchemaTypes.STRING.getQName(), SchemaTypes.NMTOKEN.getQName(), SchemaTypes.STRING.getQName(), SchemaTypes.NMTOKENS.getQName(), SchemaTypes.STRING.getQName(), SchemaTypes.NOTATION.getQName(), SchemaTypes.STRING.getQName(), SchemaTypes.POSITIVE_INTEGER.getQName(), SchemaTypes.STRING.getQName(), SchemaTypes.TOKEN.getQName(), SchemaTypes.STRING.getQName(), SchemaTypes.UNSIGNED_BYTE.getQName(), SchemaTypes.BYTE.getQName(), SchemaTypes.UNSIGNED_INT.getQName(), SchemaTypes.INT.getQName(), SchemaTypes.UNSIGNED_LONG.getQName(), SchemaTypes.LONG.getQName(), SchemaTypes.UNSIGNED_SHORT.getQName(), SchemaTypes.SHORT.getQName()};
    private static final long TYPE_DERIVE_MASK = SchemaBase.ELEMENT_MASKS[13] | SchemaBase.ELEMENT_MASKS[32];
    private static final long TYPE_DEFINE_MASK = SchemaBase.ELEMENT_MASKS[9] | SchemaBase.ELEMENT_MASKS[37];
    private static final long BLOCK_NAME_INHERIT_MASK = TYPE_DERIVE_MASK | SchemaBase.ELEMENT_MASKS[39];
    private final SchemasetCustom m_global;
    private final URL m_schemaRoot;
    private final File m_schemaDir;
    private final File m_targetDir;
    private final ValidationContext m_validationContext;
    private ArrayList m_definitions;
    private BindingOrganizer m_bindingDirectory;
    static /* synthetic */ Class class$org$jibx$schema$codegen$Refactory;
    static /* synthetic */ Class class$org$jibx$schema$elements$SchemaElement;

    public Refactory(RefactoryCommandLine parms) {
        this.m_global = parms.getCustomRoot();
        this.m_global.setSubstitutions(DEFAULT_REPLACEMENTS);
        this.m_schemaRoot = parms.getSchemaRoot();
        this.m_schemaDir = parms.getSchemaDir();
        this.m_targetDir = parms.getGeneratePath();
        this.m_validationContext = new ValidationContext();
    }

    public Refactory(SchemasetCustom custom, ValidationContext vctx) {
        this.m_global = custom;
        this.m_global.setSubstitutions(DEFAULT_REPLACEMENTS);
        this.m_schemaRoot = null;
        this.m_schemaDir = null;
        this.m_targetDir = null;
        this.m_validationContext = vctx;
    }

    private SchemasetCustom findSchemaset(SchemaElement schema, SchemasetCustom custom) {
        LazyList childs = custom.getChildren();
        SchemasetCustom owner = null;
        String name = schema.getResolver().getName();
        for (int i = 0; i < childs.size(); ++i) {
            SchemasetCustom match;
            SchemasetCustom schemaset;
            Object child = childs.get(i);
            if (!(child instanceof SchemasetCustom) || !(schemaset = (SchemasetCustom)child).isInSet(name, schema) || (match = this.findSchemaset(schema, schemaset)) == null) continue;
            if (owner == null) {
                owner = match;
                continue;
            }
            this.m_validationContext.addError("schema-set overlap on schema " + name + " (first match " + ValidationProblem.componentDescription((Object)owner) + ')', (Object)match);
        }
        return owner == null ? custom : owner;
    }

    public void validateSchemas(SchemaElement[] schemas) {
        int i;
        TreeWalker wlkr = new TreeWalker((ISkipElements)this.m_validationContext, (ISchemaListener)this.m_validationContext);
        s_logger.debug((Object)"Beginning schema prevalidation pass");
        this.m_validationContext.clearTraversed();
        s_logger.debug((Object)"Beginning schema prevalidation pass");
        for (i = 0; i < schemas.length; ++i) {
            wlkr.walkSchema(schemas[i], (SchemaVisitor)new PrevalidationVisitor(this.m_validationContext));
            s_logger.debug((Object)("After prevalidation schema " + schemas[i].getResolver().getName() + " has effective namespace " + schemas[i].getEffectiveNamespace()));
        }
        s_logger.debug((Object)"Beginning name registration pass");
        this.m_validationContext.clearTraversed();
        for (i = 0; i < schemas.length; ++i) {
            wlkr.walkSchema(schemas[i], (SchemaVisitor)new NameRegistrationVisitor(this.m_validationContext));
        }
        s_logger.debug((Object)"Beginning name merge pass");
        this.m_validationContext.clearTraversed();
        for (i = 0; i < schemas.length; ++i) {
            wlkr.walkSchema(schemas[i], (SchemaVisitor)new NameMergeVisitor(this.m_validationContext));
        }
        s_logger.debug((Object)"Beginning validation pass");
        this.m_validationContext.clearTraversed();
        for (i = 0; i < schemas.length; ++i) {
            wlkr.walkSchema(schemas[i], (SchemaVisitor)new ValidationVisitor(this.m_validationContext));
            s_logger.debug((Object)("After validation schema " + schemas[i].getResolver().getName() + " has effective namespace " + schemas[i].getEffectiveNamespace()));
        }
    }

    private SchemaElement[] load(List list) throws JiBXException, IOException {
        int i;
        SchemaElement schema;
        IBindingFactory factory = BindingDirectory.getFactory((String)"schema_xsprefix_binding", (Class)(class$org$jibx$schema$elements$SchemaElement == null ? (class$org$jibx$schema$elements$SchemaElement = Refactory.class$("org.jibx.schema.elements.SchemaElement")) : class$org$jibx$schema$elements$SchemaElement));
        IUnmarshallingContext ictx = factory.createUnmarshallingContext();
        int count = list.size();
        SchemaElement[] schemas = new SchemaElement[count];
        int fill = 0;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            UrlResolver resolver = (UrlResolver)iter.next();
            ictx.setDocument(resolver.getContent(), resolver.getName(), null);
            ictx.setUserContext((Object)this.m_validationContext);
            Object obj = ictx.unmarshalElement();
            schema = (SchemaElement)obj;
            schemas[fill++] = schema;
            schema.setResolver((ISchemaResolver)resolver);
            String id = resolver.getId();
            this.m_validationContext.setSchema(id, schema);
            if (!s_logger.isDebugEnabled()) continue;
            try {
                String enc = ((UnmarshallingContext)ictx).getInputEncoding();
                if (enc == null) {
                    enc = "UTF-8";
                }
                IMarshallingContext mctx = factory.createMarshallingContext();
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                mctx.setIndent(2);
                mctx.marshalDocument(obj, "UTF-8", null, (OutputStream)bos);
                InputStreamReader brdr = new InputStreamReader((InputStream)new ByteArrayInputStream(bos.toByteArray()), "UTF-8");
                InputStreamReader frdr = new InputStreamReader(resolver.getContent(), enc);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintStream pstream = new PrintStream(baos);
                DocumentComparator comp = new DocumentComparator(pstream);
                if (comp.compare((Reader)frdr, (Reader)brdr)) {
                    s_logger.debug((Object)("Successfully roundtripped schema " + id));
                    continue;
                }
                s_logger.debug((Object)("Errors in roundtripping schema " + id));
                pstream.flush();
                s_logger.debug((Object)baos.toString());
            }
            catch (XmlPullParserException e) {
                s_logger.debug((Object)"Error during schema roundtripping", (Throwable)e);
            }
        }
        HashSet<SchemaElement> schemaset = new HashSet<SchemaElement>(count);
        ArrayList<SchemaElement> ordereds = new ArrayList<SchemaElement>();
        this.m_validationContext.clearTraversed();
        for (i = 0; i < count; ++i) {
            schema = schemas[i];
            if (schema.getTargetNamespace() == null) continue;
            ordereds.add(schema);
            schemaset.add(schema);
            FilteredSegmentList childs = schema.getSchemaChildren();
            for (int j = 0; j < childs.size(); ++j) {
                Object child = childs.get(j);
                if (!(child instanceof SchemaLocationBase)) continue;
                schemaset.add(((SchemaLocationBase)child).getReferencedSchema());
            }
        }
        for (i = 0; i < count; ++i) {
            schema = schemas[i];
            if (schemaset.contains(schema)) continue;
            ordereds.add(schema);
        }
        SchemaElement[] ordschemas = ordereds.toArray(new SchemaElement[ordereds.size()]);
        this.validateSchemas(ordschemas);
        return ordschemas;
    }

    public boolean customizeSchemas() {
        SchemaVisitor visitor = new SchemaVisitor(){

            public void exit(UnionElement node) {
                OpenAttrBase parent = node.getParent();
                int count = parent.getChildCount();
                for (int i = 0; i < count; ++i) {
                    if (parent.getChild(i) != node) continue;
                    SimpleRestrictionElement empty = new SimpleRestrictionElement();
                    empty.setBase(SchemaTypes.STRING.getQName());
                    parent.replaceChild(i, (SchemaBase)empty);
                    break;
                }
            }
        };
        TreeWalker wlkr = new TreeWalker(null, (ISchemaListener)new SchemaContextTracker());
        Iterator iter = this.m_validationContext.iterateSchemas();
        while (iter.hasNext()) {
            wlkr.walkElement((SchemaBase)((SchemaElement)iter.next()), visitor);
        }
        this.m_global.validate(this.m_validationContext);
        String dfltpack = this.m_global.getPackage();
        if (dfltpack == null) {
            dfltpack = "";
        }
        int count = 0;
        Iterator iter2 = this.m_validationContext.iterateSchemas();
        while (iter2.hasNext()) {
            SchemaElement schema = (SchemaElement)iter2.next();
            ISchemaResolver resolver = schema.getResolver();
            s_logger.debug((Object)("Assigning customization for schema " + ++count + ": " + resolver.getName()));
            SchemasetCustom owner = this.findSchemaset(schema, this.m_global);
            SchemaCustom custom = owner.forceCustomization(resolver.getName(), resolver.getId(), schema, this.m_validationContext);
            custom.validate(this.m_validationContext);
            custom.extend(null, this.m_validationContext);
        }
        this.m_global.checkSchemas(this.m_validationContext);
        return !Refactory.reportProblems(this.m_validationContext);
    }

    private boolean processExtensions() {
        Iterator iter = this.m_validationContext.iterateSchemas();
        while (iter.hasNext()) {
            SchemaElement schema = (SchemaElement)iter.next();
            int count = schema.getChildCount();
            for (int i = 0; i < count; ++i) {
                SchemaBase child = schema.getChild(i);
                Object obj = child.getExtension();
                if (!(obj instanceof GlobalExtension)) continue;
                ((GlobalExtension)obj).resetDependencies();
            }
        }
        int index = 0;
        this.m_validationContext.clearTraversed();
        boolean modified = false;
        Iterator iter2 = this.m_validationContext.iterateSchemas();
        while (iter2.hasNext()) {
            SchemaElement schema = (SchemaElement)iter2.next();
            this.m_validationContext.enterSchema(schema);
            s_logger.debug((Object)("Applying extensions to schema " + ++index + ": " + schema.getResolver().getName()));
            int count = schema.getChildCount();
            boolean instmod = false;
            for (int i = 0; i < count; ++i) {
                SchemaBase child = schema.getChild(i);
                Object obj = child.getExtension();
                if (!(obj instanceof GlobalExtension)) continue;
                ComponentExtension exten = (ComponentExtension)obj;
                if (exten.isRemoved()) {
                    schema.detachChild(i);
                    instmod = true;
                    continue;
                }
                exten.applyAndCountUsage(this.m_validationContext);
            }
            if (instmod) {
                schema.compactChildren();
                modified = true;
            }
            this.m_validationContext.exitSchema();
        }
        return modified;
    }

    public void applyAndNormalize() {
        Object obj;
        int i;
        SchemaElement schema;
        Iterator iter;
        boolean modified = true;
        while (this.processExtensions() || modified) {
            modified = false;
            iter = this.m_validationContext.iterateSchemas();
            while (iter.hasNext()) {
                schema = (SchemaElement)iter.next();
                int count = schema.getChildCount();
                boolean instmod = false;
                for (i = 0; i < count; ++i) {
                    SchemaBase child = schema.getChild(i);
                    obj = child.getExtension();
                    if (!(obj instanceof GlobalExtension)) continue;
                    GlobalExtension global = (GlobalExtension)obj;
                    global.normalize();
                    if (!global.isRemoved()) continue;
                    schema.detachChild(i);
                    instmod = true;
                }
                if (!instmod) continue;
                schema.compactChildren();
                modified = true;
            }
        }
        iter = this.m_validationContext.iterateSchemas();
        while (iter.hasNext()) {
            schema = (SchemaElement)iter.next();
            SchemaCustom custom = this.findSchemaset(schema, this.m_global).getCustomization(schema.getResolver().getId());
            if (!custom.isGenerateAll()) continue;
            int count = schema.getChildCount();
            for (i = 0; i < count; ++i) {
                SchemaBase comp = schema.getChild(i);
                if (comp.type() != 11 && comp.type() != 9 || !((obj = comp.getExtension()) instanceof GlobalExtension)) continue;
                ((GlobalExtension)obj).setIncluded(true);
                if (!s_logger.isDebugEnabled()) continue;
                s_logger.debug((Object)("Set include for definition " + SchemaUtils.describeComponent((SchemaBase)comp)));
            }
        }
    }

    public void pruneDefinitions() {
        int count;
        SchemaElement schema;
        int index = 0;
        Iterator iter = this.m_validationContext.iterateSchemas();
        while (iter.hasNext()) {
            schema = (SchemaElement)iter.next();
            s_logger.debug((Object)("Checking for unused definitions in schema " + ++index + ": " + schema.getResolver().getName()));
            count = schema.getChildCount();
            for (int i = 0; i < count; ++i) {
                SchemaBase child = schema.getChild(i);
                Object exten = child.getExtension();
                if (!(exten instanceof GlobalExtension)) continue;
                ((GlobalExtension)exten).checkRemovable();
            }
        }
        index = 0;
        iter = this.m_validationContext.iterateSchemas();
        while (iter.hasNext()) {
            schema = (SchemaElement)iter.next();
            s_logger.debug((Object)("Deleting unused definitions in schema " + ++index + ": " + schema.getResolver().getName()));
            count = schema.getChildCount();
            boolean modified = false;
            for (int i = 0; i < count; ++i) {
                SchemaBase child = schema.getChild(i);
                Object exten = child.getExtension();
                if (!(exten instanceof GlobalExtension) || !((ComponentExtension)exten).isRemoved()) continue;
                schema.detachChild(i);
                modified = true;
                if (!s_logger.isDebugEnabled()) continue;
                s_logger.debug((Object)(" Removed definition " + ((INamed)child).getQName()));
            }
            if (!modified) continue;
            schema.compactChildren();
        }
    }

    private void writeSchemas(File destdir) throws JiBXException, IOException {
        Iterator iter = this.m_validationContext.iterateSchemas();
        while (iter.hasNext()) {
            SchemaElement schema = (SchemaElement)iter.next();
            File file = new File(destdir, schema.getResolver().getName());
            FileOutputStream stream = new FileOutputStream(file);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, "utf-8");
            IBindingFactory factory = BindingDirectory.getFactory((String)"schema_xsprefix_binding", (Class)(class$org$jibx$schema$elements$SchemaElement == null ? Refactory.class$("org.jibx.schema.elements.SchemaElement") : class$org$jibx$schema$elements$SchemaElement));
            IMarshallingContext ictx = factory.createMarshallingContext();
            ictx.setOutput((Writer)writer);
            ictx.setIndent(2);
            ictx.marshalDocument((Object)schema);
            ((Writer)writer).close();
        }
    }

    private static boolean reportProblems(ValidationContext vctx) {
        ArrayList probs = vctx.getProblems();
        boolean error = false;
        if (probs.size() > 0) {
            for (int j = 0; j < probs.size(); ++j) {
                String text;
                ValidationProblem prob = (ValidationProblem)probs.get(j);
                if (prob.getSeverity() >= 2) {
                    error = true;
                    text = "Error: " + prob.getDescription();
                    s_logger.error((Object)text);
                } else {
                    text = "Warning: " + prob.getDescription();
                    s_logger.info((Object)text);
                }
                System.out.println(text);
            }
        }
        probs.clear();
        return error;
    }

    private static void addCustomizedSchemas(URL base, File dir, SchemasetCustom custom, InsertionOrderedSet fileset) throws MalformedURLException {
        String[] names = custom.getNames();
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                SchemaNameFilter filter = new SchemaNameFilter();
                String name = names[i];
                filter.setPattern(name);
                s_logger.debug((Object)("Matching file names to schemaset pattern '" + name + '\''));
                String[] matches = dir.list(filter);
                for (int j = 0; j < matches.length; ++j) {
                    String match = matches[j];
                    fileset.add((Object)new UrlResolver(match, new URL(base, match)));
                    s_logger.debug((Object)("Added schema from schemaset pattern match: " + match));
                }
            }
        }
        LazyList childs = custom.getChildren();
        for (int i = 0; i < childs.size(); ++i) {
            Object child = childs.get(i);
            if (child instanceof SchemaCustom) {
                String name = ((SchemaCustom)child).getName();
                if (name == null) continue;
                try {
                    fileset.add((Object)new UrlResolver(name, new URL(base, name)));
                    s_logger.debug((Object)("Added schema from customizations: " + name));
                }
                catch (MalformedURLException e) {
                    System.out.println("Error adding schema from customizations: " + name);
                }
                continue;
            }
            if (!(child instanceof SchemasetCustom)) continue;
            Refactory.addCustomizedSchemas(base, dir, (SchemasetCustom)child, fileset);
        }
    }

    public static void main(String[] args) throws Exception {
        TreeWalker.setLogging((Level)Level.ERROR);
        RefactoryCommandLine parms = new RefactoryCommandLine();
        if (args.length > 0 && parms.processArgs(args)) {
            InsertionOrderedSet fileset = new InsertionOrderedSet();
            URL base = parms.getSchemaRoot();
            File basedir = parms.getSchemaDir();
            SchemaNameFilter filter = new SchemaNameFilter();
            boolean err = false;
            Iterator iter = parms.getExtraArgs().iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                if (name.indexOf(42) >= 0) {
                    if (basedir == null) {
                        System.err.println("File name pattern argument not allowed for non-file base: '" + name + '\'');
                        continue;
                    }
                    filter.setPattern(name);
                    s_logger.debug((Object)("Matching file names to command line pattern '" + name + '\''));
                    String[] matches = basedir.list(filter);
                    for (int i = 0; i < matches.length; ++i) {
                        String match = matches[i];
                        fileset.add((Object)new UrlResolver(match, new URL(base, match)));
                    }
                    continue;
                }
                if (basedir == null) {
                    URL url = new URL(base, name);
                    s_logger.debug((Object)("Adding schema URL from command line: " + url.toExternalForm()));
                    fileset.add((Object)new UrlResolver(name, url));
                    continue;
                }
                File sfile = new File(basedir, name);
                if (sfile.exists()) {
                    s_logger.debug((Object)("Adding schema file from command line: " + sfile.getCanonicalPath()));
                    fileset.add((Object)new UrlResolver(name, new URL(base, name)));
                    continue;
                }
                System.err.println("Schema file from command line not found: " + sfile.getAbsolutePath());
                err = true;
            }
            if (!err) {
                Refactory.addCustomizedSchemas(base, basedir, parms.getCustomRoot(), fileset);
                Refactory inst = new Refactory(parms);
                SchemaElement[] schemas = inst.load(fileset.asList());
                if (!Refactory.reportProblems(inst.m_validationContext) && inst.customizeSchemas()) {
                    System.out.println("Loaded and validated " + fileset.size() + " schemas");
                    inst.applyAndNormalize();
                    inst.pruneDefinitions();
                    inst.validateSchemas(schemas);
                    inst.writeSchemas(parms.getGeneratePath());
                }
            }
        } else {
            if (args.length > 0) {
                System.err.println("Terminating due to command line errors");
            } else {
                parms.printUsage();
            }
            System.exit(1);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class SchemaNameFilter
    implements FilenameFilter {
        private String m_pattern;

        private SchemaNameFilter() {
        }

        public void setPattern(String pattern) {
            this.m_pattern = pattern;
        }

        public boolean accept(File dir, String name) {
            boolean match = NameUtilities.isPatternMatch((String)name, (String)this.m_pattern);
            if (match) {
                s_logger.debug((Object)(" matched file name '" + name + '\''));
            }
            return match;
        }
    }
}

