/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema.codegen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class ImportsTracker {
    private final String m_packageName;
    private final TreeSet m_importedTypes;
    private final Map m_unqualifiedNameType;
    private final Map m_localTypeName;
    private Map m_nameMap;
    private boolean m_frozen;

    public ImportsTracker(String pkgname) {
        this.m_packageName = pkgname;
        this.m_importedTypes = new TreeSet();
        this.m_unqualifiedNameType = new HashMap();
        this.m_localTypeName = new HashMap();
    }

    public void addLocalType(String name, String fqname) {
        String prior = (String)this.m_unqualifiedNameType.get(name);
        if (prior != null && !fqname.equals(prior)) {
            this.m_importedTypes.remove(prior);
        }
        this.m_unqualifiedNameType.put(name, fqname);
        this.m_localTypeName.put(fqname, name);
    }

    protected boolean addImport(String fqname, boolean force) {
        if (this.m_importedTypes.contains(fqname) || this.m_localTypeName.containsKey(fqname)) {
            return true;
        }
        boolean auto = false;
        String sname = fqname;
        int split = sname.lastIndexOf(46);
        if (split >= 0) {
            sname = sname.substring(split + 1);
            auto = "java.lang".equals(fqname.substring(0, split));
        }
        if (this.m_unqualifiedNameType.containsKey(sname) && split >= 0 && !auto && !force) {
            return false;
        }
        this.m_unqualifiedNameType.put(sname, fqname);
        if (split >= 0) {
            if (this.m_frozen) {
                throw new IllegalStateException("Internal error - attempt to add import after imports frozen");
            }
            this.m_importedTypes.add(fqname);
        }
        return true;
    }

    public boolean isQualified(String fqname) {
        return !this.m_importedTypes.contains(fqname) && !this.m_localTypeName.containsKey(fqname);
    }

    public Map getNameMap() {
        if (this.m_nameMap == null) {
            this.m_nameMap = new HashMap(this.m_localTypeName);
            Iterator iter = this.m_importedTypes.iterator();
            while (iter.hasNext()) {
                String impname = (String)iter.next();
                if (impname.startsWith("java.lang.") && impname.lastIndexOf(46) <= "java.lang.".length()) {
                    this.m_nameMap.put(impname, impname.substring("java.lang.".length()));
                    continue;
                }
                int split = impname.lastIndexOf(46) + 1;
                this.m_nameMap.put(impname, impname.substring(split));
            }
        }
        return this.m_nameMap;
    }

    public String getName(String type) {
        Map map = this.getNameMap();
        String name = (String)map.get(type);
        if (name == null) {
            name = type;
        }
        return name;
    }

    public List freeze(String cname) {
        ArrayList<String> list = new ArrayList<String>();
        Iterator iter = this.m_importedTypes.iterator();
        while (iter.hasNext()) {
            String impname = (String)iter.next();
            int length = this.m_packageName.length();
            if (length > 0 && impname.length() > length && impname.startsWith(this.m_packageName)) {
                int split = impname.indexOf(46, length + 1);
                if (split <= 0 || impname.substring(length + 1, split).equals(cname)) continue;
                list.add(impname);
                continue;
            }
            if (impname.startsWith("java.lang.") && impname.lastIndexOf(46) <= "java.lang.".length()) continue;
            list.add(impname);
        }
        return list;
    }
}

