/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema.codegen;

import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.jibx.schema.codegen.ClassBuilder;
import org.jibx.schema.codegen.ExpressionBuilderBase;
import org.jibx.schema.codegen.InvocationBuilder;
import org.jibx.schema.codegen.StatementBuilderBase;
import org.jibx.schema.codegen.SwitchBuilder;

public class BlockBuilder
extends StatementBuilderBase {
    private final Block m_block;

    public BlockBuilder(ClassBuilder source, Block block) {
        super(source);
        this.m_block = block;
    }

    Statement getStatement() {
        return this.m_block;
    }

    public void addAssignToName(Expression expr, String name) {
        Assignment asgn = this.m_ast.newAssignment();
        asgn.setLeftHandSide((Expression)this.m_ast.newSimpleName(name));
        asgn.setRightHandSide(expr);
        this.m_block.statements().add(this.m_ast.newExpressionStatement((Expression)asgn));
    }

    public void addAssignVariableToField(String vname, String fname) {
        Assignment asgn = this.m_ast.newAssignment();
        if (fname.equals(vname)) {
            FieldAccess access = this.m_ast.newFieldAccess();
            access.setExpression((Expression)this.m_ast.newThisExpression());
            access.setName(this.m_ast.newSimpleName(fname));
            asgn.setLeftHandSide((Expression)access);
        } else {
            asgn.setLeftHandSide((Expression)this.m_ast.newSimpleName(fname));
        }
        asgn.setRightHandSide((Expression)this.m_ast.newSimpleName(vname));
        this.m_block.statements().add(this.m_ast.newExpressionStatement((Expression)asgn));
    }

    public void addLocalVariableDeclaration(String type, String vname) {
        VariableDeclarationFragment vfrag = this.m_ast.newVariableDeclarationFragment();
        vfrag.setName(this.m_ast.newSimpleName(vname));
        VariableDeclarationStatement stmt = this.m_ast.newVariableDeclarationStatement(vfrag);
        stmt.setType(this.m_source.createType(type));
        this.m_block.statements().add(stmt);
    }

    public void addLocalVariableDeclaration(Type type, String vname, ExpressionBuilderBase expr) {
        VariableDeclarationFragment vfrag = this.m_ast.newVariableDeclarationFragment();
        vfrag.setName(this.m_ast.newSimpleName(vname));
        vfrag.setInitializer(expr.getExpression());
        VariableDeclarationStatement stmt = this.m_ast.newVariableDeclarationStatement(vfrag);
        stmt.setType(type);
        this.m_block.statements().add(stmt);
    }

    public void addLocalVariableDeclaration(String tname, String vname, ExpressionBuilderBase expr) {
        this.addLocalVariableDeclaration(this.m_source.createType(tname), vname, expr);
    }

    public void addIfStatement(ExpressionBuilderBase expr, BlockBuilder ifblock) {
        IfStatement ifstmt = this.m_ast.newIfStatement();
        ifstmt.setExpression(expr.getExpression());
        ifstmt.setThenStatement((Statement)ifblock.m_block);
        this.m_block.statements().add(ifstmt);
    }

    public void addIfElseStatement(ExpressionBuilderBase expr, BlockBuilder ifblock, BlockBuilder elseblock) {
        IfStatement ifstmt = this.m_ast.newIfStatement();
        ifstmt.setExpression(expr.getExpression());
        ifstmt.setThenStatement((Statement)ifblock.m_block);
        ifstmt.setElseStatement((Statement)elseblock.m_block);
        this.m_block.statements().add(ifstmt);
    }

    public void addIfElseIfStatement(ExpressionBuilderBase ifexpr, ExpressionBuilderBase elsexpr, BlockBuilder ifblock, BlockBuilder elseblock) {
        IfStatement ifstmt = this.m_ast.newIfStatement();
        ifstmt.setExpression(ifexpr.getExpression());
        ifstmt.setThenStatement((Statement)ifblock.m_block);
        IfStatement elseifstmt = this.m_ast.newIfStatement();
        elseifstmt.setExpression(elsexpr.getExpression());
        elseifstmt.setThenStatement((Statement)elseblock.m_block);
        ifstmt.setElseStatement((Statement)elseifstmt);
        this.m_block.statements().add(ifstmt);
    }

    private void addForStatement(String name, Type type, Expression init, Expression test, Expression post, BlockBuilder block) {
        ForStatement stmt = this.m_ast.newForStatement();
        VariableDeclarationFragment declfrag = this.m_ast.newVariableDeclarationFragment();
        declfrag.setName(this.m_ast.newSimpleName(name));
        declfrag.setInitializer(init);
        VariableDeclarationExpression varexpr = this.m_ast.newVariableDeclarationExpression(declfrag);
        varexpr.setType(type);
        stmt.initializers().add(varexpr);
        stmt.setExpression(test);
        if (post != null) {
            stmt.updaters().add(post);
        }
        stmt.setBody(block.getStatement());
        this.m_block.statements().add(stmt);
    }

    public void addIteratedForStatement(String name, Type type, ExpressionBuilderBase init, BlockBuilder block) {
        MethodInvocation methcall = this.m_ast.newMethodInvocation();
        methcall.setExpression((Expression)this.m_ast.newSimpleName(name));
        methcall.setName(this.m_ast.newSimpleName("hasNext"));
        this.addForStatement(name, type, init.getExpression(), (Expression)methcall, null, block);
    }

    public void addIndexedForStatement(String name, ExpressionBuilderBase limit, BlockBuilder block) {
        InfixExpression test = this.m_ast.newInfixExpression();
        test.setOperator(InfixExpression.Operator.LESS);
        test.setLeftOperand((Expression)this.m_ast.newSimpleName(name));
        test.setRightOperand(limit.getExpression());
        PrefixExpression post = this.m_ast.newPrefixExpression();
        post.setOperator(PrefixExpression.Operator.INCREMENT);
        post.setOperand((Expression)this.m_ast.newSimpleName(name));
        this.addForStatement(name, (Type)this.m_ast.newPrimitiveType(PrimitiveType.INT), (Expression)this.m_ast.newNumberLiteral("0"), (Expression)test, (Expression)post, block);
    }

    public void addSugaredForStatement(String name, String type, ExpressionBuilderBase expr, BlockBuilder block) {
        EnhancedForStatement stmt = this.m_ast.newEnhancedForStatement();
        stmt.setExpression(expr.getExpression());
        SingleVariableDeclaration decl = this.m_ast.newSingleVariableDeclaration();
        decl.setName(this.m_ast.newSimpleName(name));
        decl.setType(this.m_source.createType(type));
        stmt.setParameter(decl);
        stmt.setBody(block.getStatement());
        this.m_block.statements().add(stmt);
    }

    public void addReturnExpression(ExpressionBuilderBase expr) {
        ReturnStatement ret = this.m_ast.newReturnStatement();
        ret.setExpression(expr.getExpression());
        this.m_block.statements().add(ret);
    }

    public void addReturnNamed(String name) {
        ReturnStatement ret = this.m_ast.newReturnStatement();
        ret.setExpression((Expression)this.m_ast.newSimpleName(name));
        this.m_block.statements().add(ret);
    }

    public void addReturnNull() {
        ReturnStatement ret = this.m_ast.newReturnStatement();
        ret.setExpression((Expression)this.m_ast.newNullLiteral());
        this.m_block.statements().add(ret);
    }

    public void addThrowException(String type, String text) {
        ThrowStatement thrwstmt = this.m_ast.newThrowStatement();
        ClassInstanceCreation exexpr = this.m_ast.newClassInstanceCreation();
        exexpr.setType((Type)this.m_ast.newSimpleType((Name)this.m_ast.newSimpleName(type)));
        exexpr.arguments().add(this.stringLiteral(text));
        thrwstmt.setExpression((Expression)exexpr);
        this.m_block.statements().add(thrwstmt);
    }

    public void addThrowException(String type, ExpressionBuilderBase expr) {
        ThrowStatement thrwstmt = this.m_ast.newThrowStatement();
        ClassInstanceCreation exexpr = this.m_ast.newClassInstanceCreation();
        exexpr.setType((Type)this.m_ast.newSimpleType((Name)this.m_ast.newSimpleName(type)));
        exexpr.arguments().add(expr.getExpression());
        thrwstmt.setExpression((Expression)exexpr);
        this.m_block.statements().add(thrwstmt);
    }

    public void addCall(InvocationBuilder call) {
        this.m_block.statements().add(this.m_ast.newExpressionStatement(call.getExpression()));
    }

    public void addBreak() {
        this.m_block.statements().add(this.m_ast.newBreakStatement());
    }

    public SwitchBuilder addSwitch(String name) {
        SwitchBuilder builder = new SwitchBuilder(this.m_source, (Expression)this.m_ast.newSimpleName(name));
        this.m_block.statements().add(builder.getStatement());
        return builder;
    }

    public SwitchBuilder addSwitch(ExpressionBuilderBase expr) {
        SwitchBuilder builder = new SwitchBuilder(this.m_source, expr.getExpression());
        this.m_block.statements().add(builder.getStatement());
        return builder;
    }

    public void addExpressionStatement(ExpressionBuilderBase expr) {
        this.m_block.statements().add(this.m_ast.newExpressionStatement(expr.getExpression()));
    }

    public void addStatement(StatementBuilderBase stmt) {
        this.m_block.statements().add(stmt.getStatement());
    }
}

