/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import org.jibx.binding.classes.BranchWrapper;
import org.jibx.binding.classes.ClassItem;
import org.jibx.binding.classes.ContextMethodBuilder;
import org.jibx.binding.def.BindingDefinition;
import org.jibx.binding.def.IComponent;
import org.jibx.binding.def.PassThroughComponent;
import org.jibx.binding.def.PropertyDefinition;
import org.jibx.binding.util.IntegerCache;
import org.jibx.runtime.JiBXException;

public class ComponentProperty
extends PassThroughComponent {
    private final PropertyDefinition m_property;
    private boolean m_skipMarshal;
    private boolean m_forceUnmarshal;

    public ComponentProperty(PropertyDefinition prop, IComponent impl, boolean skip) {
        super(impl);
        this.m_property = prop;
        this.m_skipMarshal = skip;
    }

    public void setSkipping(boolean skip) {
        this.m_skipMarshal = skip;
    }

    public void setForceUnmarshal(boolean force) {
        this.m_forceUnmarshal = force;
    }

    public PropertyDefinition getProperty() {
        return this.m_property;
    }

    private void genLoadUnmarshalInstance(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_property.isImplicit()) {
            mb.appendACONST_NULL();
            this.m_component.genNewInstance(mb);
        } else if (this.m_property.isThis()) {
            mb.loadObject();
            this.m_component.genNewInstance(mb);
        } else {
            mb.loadObject();
            this.m_property.genLoad(mb);
            mb.appendCreateCast(this.m_property.getGetValueType(), this.m_component.getType());
            this.m_component.genNewInstance(mb);
        }
    }

    private void genStoreUnmarshalInstance(ContextMethodBuilder mb) throws JiBXException {
        mb.appendCreateCast(this.m_component.getType(), this.m_property.getSetValueType());
        if (!this.m_property.isThis() && !this.m_property.isImplicit()) {
            this.m_property.genStore(mb);
        }
    }

    public boolean isOptional() {
        return this.m_property.isOptional();
    }

    public boolean hasContent() {
        return this.m_forceUnmarshal || super.hasContent();
    }

    public void genAttributeUnmarshal(ContextMethodBuilder mb) throws JiBXException {
        boolean thisref = this.m_property.isThis();
        if (!(this.m_property.isImplicit() || thisref || super.hasContent() && !this.m_property.isLoadable())) {
            mb.loadObject();
        }
        BranchWrapper tosave = null;
        if (this.m_property.isOptional() && !thisref) {
            this.m_component.genAttrPresentTest(mb);
            BranchWrapper ifpres = mb.appendIFNE(this);
            mb.appendACONST_NULL();
            tosave = mb.appendUnconditionalBranch(this);
            mb.targetNext(ifpres);
        }
        this.genLoadUnmarshalInstance(mb);
        this.m_component.genAttributeUnmarshal(mb);
        mb.targetNext(tosave);
        if (super.hasContent() && !this.m_property.isLoadable()) {
            if (!this.m_property.isImplicit() && !thisref) {
                int slot = mb.addLocal(null, ClassItem.typeFromName(this.m_component.getType()));
                Integer index = IntegerCache.getInteger(slot);
                mb.setKeyValue(this, index);
            }
        } else {
            this.genStoreUnmarshalInstance(mb);
        }
    }

    public void genAttributeMarshal(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_skipMarshal) {
            mb.appendCreateCast(this.m_component.getType());
            this.m_component.genAttributeMarshal(mb);
        } else {
            if (!this.m_property.isImplicit()) {
                mb.loadObject();
                this.m_property.genLoad(mb);
            }
            BranchWrapper ifpres = null;
            BranchWrapper toend = null;
            if (this.m_property.isOptional()) {
                mb.appendDUP();
                ifpres = mb.appendIFNONNULL(this);
                mb.appendPOP();
                toend = mb.appendUnconditionalBranch(this);
            }
            mb.targetNext(ifpres);
            this.m_component.genAttributeMarshal(mb);
            mb.targetNext(toend);
        }
    }

    public void genContentUnmarshal(ContextMethodBuilder mb) throws JiBXException {
        if (!this.m_forceUnmarshal || super.hasContent()) {
            boolean thisref = this.m_property.isThis();
            if (!this.m_property.isImplicit() && !thisref) {
                mb.loadObject();
            }
            BranchWrapper tostore = null;
            BranchWrapper toloaded = null;
            if (this.m_property.isOptional() && !thisref) {
                if (this.hasAttribute()) {
                    if (!this.m_property.isImplicit()) {
                        if (this.m_property.isLoadable()) {
                            mb.loadObject();
                            this.m_property.genLoad(mb);
                        } else {
                            Integer index = (Integer)mb.getKeyValue(this);
                            mb.appendLoadLocal(index);
                        }
                    }
                    mb.appendCreateCast(this.m_component.getType());
                    mb.appendDUP();
                    toloaded = mb.appendIFNONNULL(this);
                    mb.appendPOP();
                }
                this.m_component.genContentPresentTest(mb);
                BranchWrapper havecont = mb.appendIFNE(this);
                mb.appendACONST_NULL();
                tostore = mb.appendUnconditionalBranch(this);
                mb.targetNext(havecont);
                this.genLoadUnmarshalInstance(mb);
            } else if (this.hasAttribute()) {
                if (!this.m_property.isImplicit() && !thisref) {
                    if (this.m_property.isLoadable()) {
                        mb.loadObject();
                        this.m_property.genLoad(mb);
                    } else {
                        Integer index = (Integer)mb.getKeyValue(this);
                        mb.appendLoadLocal(index);
                    }
                }
                mb.appendCreateCast(this.m_component.getType());
            } else {
                this.genLoadUnmarshalInstance(mb);
            }
            mb.targetNext(toloaded);
            this.m_component.genContentUnmarshal(mb);
            mb.targetNext(tostore);
            this.genStoreUnmarshalInstance(mb);
        }
    }

    public void genContentMarshal(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_forceUnmarshal) {
            if (this.m_property.isImplicit()) {
                mb.appendPOP();
            }
        } else if (this.m_skipMarshal) {
            mb.appendCreateCast(this.m_component.getType());
            this.m_component.genContentMarshal(mb);
        } else {
            if (!this.m_property.isImplicit()) {
                mb.loadObject();
                this.m_property.genLoad(mb);
            }
            BranchWrapper ifpres = null;
            BranchWrapper tonext = null;
            if (this.m_property.isOptional()) {
                mb.appendDUP();
                ifpres = mb.appendIFNONNULL(this);
                mb.appendPOP();
                tonext = mb.appendUnconditionalBranch(this);
            }
            mb.targetNext(ifpres);
            this.m_component.genContentMarshal(mb);
            mb.targetNext(tonext);
        }
    }

    public void print(int depth) {
        BindingDefinition.indent(depth);
        System.out.print("component " + this.m_property.toString());
        if (this.m_skipMarshal) {
            System.out.print(" (pass-through marshal)");
        }
        System.out.println();
        this.m_component.print(depth + 1);
    }
}

