/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.util;

import java.util.AbstractList;
import java.util.Iterator;

public class LazyList
extends AbstractList {
    public static final Iterator EMPTY_ITERATOR = new Iterator(){

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new IllegalStateException("Internal error - no next");
        }

        public void remove() {
            throw new IllegalStateException("Internal error - nothing to remove");
        }
    };
    public static final LazyList EMPTY_LIST = new LazyList(){

        public void add(int index, Object element) {
            throw new UnsupportedOperationException("Internal error: Unmodifiable list");
        }

        public Object remove(int index) {
            throw new UnsupportedOperationException("Internal error: Unmodifiable list");
        }

        protected void removeRange(int from, int to) {
            throw new UnsupportedOperationException("Internal error: Unmodifiable list");
        }
    };
    private int m_size;
    private int m_limit;
    private Object[] m_array;

    private void makeSpace(int count) {
        if (this.m_limit - this.m_size < count) {
            Object[] copy;
            if (this.m_array == null) {
                copy = new Object[count + 4];
            } else {
                copy = new Object[this.m_size * 2 + count];
                System.arraycopy(this.m_array, 0, copy, 0, this.m_size);
            }
            this.m_array = copy;
            this.m_limit = copy.length;
        }
    }

    public Object get(int index) {
        if (index >= 0 && index < this.m_size) {
            return this.m_array[index];
        }
        throw new IndexOutOfBoundsException("Index " + index + " is out of valid range 0-" + (this.m_size - 1));
    }

    public int size() {
        return this.m_size;
    }

    public void add(int index, Object element) {
        if (index >= 0 && index <= this.m_size) {
            this.makeSpace(1);
            if (index < this.m_size) {
                System.arraycopy(this.m_array, index, this.m_array, index + 1, this.m_size - index);
            }
            this.m_array[index] = element;
            ++this.m_size;
            ++this.modCount;
        } else {
            throw new IndexOutOfBoundsException("Index " + index + " is out of valid range 0-" + this.m_size);
        }
    }

    public Iterator iterator() {
        if (this.m_size == 0) {
            return EMPTY_ITERATOR;
        }
        return super.iterator();
    }

    public Object remove(int index) {
        if (index >= 0 && index < this.m_size) {
            Object item = this.m_array[index];
            int start = index + 1;
            System.arraycopy(this.m_array, start, this.m_array, index, this.m_size - start);
            this.m_array[--this.m_size] = null;
            ++this.modCount;
            return item;
        }
        throw new IndexOutOfBoundsException("Index " + index + " is out of valid range 0-" + (this.m_size - 1));
    }

    public Object set(int index, Object element) {
        if (index >= 0 && index < this.m_size) {
            Object item = this.m_array[index];
            this.m_array[index] = element;
            return item;
        }
        throw new IndexOutOfBoundsException("Index " + index + " is out of valid range 0-" + (this.m_size - 1));
    }

    protected void removeRange(int from, int to) {
        if (from >= 0 && to <= this.m_size) {
            int length = this.m_size - to;
            if (length > 0) {
                System.arraycopy(this.m_array, to, this.m_array, from, length);
            }
            int i = this.m_size;
            while (i > to) {
                this.m_array[--i] = null;
            }
            this.m_size -= length;
            ++this.modCount;
        } else {
            throw new IndexOutOfBoundsException("Range of " + from + "-" + to + " exceeds valid range 0-" + this.m_size);
        }
    }

    public int getModCount() {
        return this.modCount;
    }

    public void remove(int from, int to) {
        this.removeRange(from, to);
    }

    public void compact() {
        int offset;
        for (offset = 0; offset < this.m_size && this.m_array[offset] != null; ++offset) {
        }
        if (offset < this.m_size) {
            int fill = offset;
            while (++offset < this.m_size) {
                if (this.m_array[offset] == null) continue;
                this.m_array[fill++] = this.m_array[offset];
            }
            this.m_size = fill;
            ++this.modCount;
        }
    }
}

