/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import org.apache.bcel.generic.Type;
import org.jibx.binding.classes.BoundClass;
import org.jibx.binding.classes.ClassCache;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.ClassItem;
import org.jibx.binding.classes.ContextMethodBuilder;
import org.jibx.binding.classes.ExceptionMethodBuilder;
import org.jibx.binding.classes.MarshalBuilder;
import org.jibx.binding.classes.UnmarshalBuilder;
import org.jibx.binding.def.BindingDefinition;
import org.jibx.binding.def.IComponent;
import org.jibx.binding.def.IContainer;
import org.jibx.binding.def.IContextObj;
import org.jibx.binding.def.PassThroughComponent;
import org.jibx.runtime.JiBXException;

public class ObjectBinding
extends PassThroughComponent
implements IComponent,
IContextObj {
    private static final String[] MARSHAL_HOOK_SIGNATURES = new String[]{"(Lorg/jibx/runtime/IMarshallingContext;)V", "(Ljava/lang/Object;)V", "()V"};
    private static final String[] FACTORY_HOOK_SIGNATURES = new String[]{"(Lorg/jibx/runtime/IUnmarshallingContext;)", "(Ljava/lang/Object;)", "()"};
    private static final String[] UNMARSHAL_HOOK_SIGNATURES = new String[]{"(Lorg/jibx/runtime/IUnmarshallingContext;)V", "(Ljava/lang/Object;)V", "()V"};
    private static final String UNMARSHAL_GETSTACKTOPMETHOD = "org.jibx.runtime.impl.UnmarshallingContext.getStackTop";
    private static final String MARSHAL_GETSTACKTOPMETHOD = "org.jibx.runtime.impl.MarshallingContext.getStackTop";
    private static final String GETSTACKTOP_SIGNATURE = "()Ljava/lang/Object;";
    private static final String MARSHALLING_CONTEXT = "org.jibx.runtime.impl.MarshallingContext";
    private static final String UNMARSHALLING_CONTEXT = "org.jibx.runtime.impl.UnmarshallingContext";
    private static final String UNMARSHAL_PARAMETER_SIGNATURE = "(Lorg/jibx/runtime/impl/UnmarshallingContext;)";
    private static final String UNMARSHAL_PUSHOBJECTMETHOD = "org.jibx.runtime.impl.UnmarshallingContext.pushObject";
    private static final String UNMARSHAL_PUSHTRACKEDOBJECTMETHOD = "org.jibx.runtime.impl.UnmarshallingContext.pushTrackedObject";
    private static final String MARSHAL_PUSHOBJECTMETHOD = "org.jibx.runtime.impl.MarshallingContext.pushObject";
    private static final String PUSHOBJECT_SIGNATURE = "(Ljava/lang/Object;)V";
    private static final String UNMARSHAL_POPOBJECTMETHOD = "org.jibx.runtime.impl.UnmarshallingContext.popObject";
    private static final String MARSHAL_POPOBJECTMETHOD = "org.jibx.runtime.impl.MarshallingContext.popObject";
    private static final String POPOBJECT_SIGNATURE = "()V";
    private static final String NEWINSTANCE_SUFFIX = "_newinstance";
    private static final String UNMARSHAL_ATTR_SUFFIX = "_unmarshalAttr";
    private static final String MARSHAL_ATTR_SUFFIX = "_marshalAttr";
    private static final String UNMARSHAL_SUFFIX = "_unmarshal";
    private static final String MARSHAL_SUFFIX = "_marshal";
    private static final String SOURCE_TRACKING_INTERFACE = "org.jibx.runtime.impl.ITrackSourceImpl";
    private static final String SETSOURCE_METHODNAME = "jibx_setSource";
    private static final Type[] SETSOURCE_ARGS = new Type[]{Type.STRING, Type.INT, Type.INT};
    private static final String SOURCEDOCUMENT_FIELDNAME = "jibx_sourceDocument";
    private static final String SOURCELINE_FIELDNAME = "jibx_sourceLine";
    private static final String SOURCECOLUMN_FIELDNAME = "jibx_sourceColumn";
    private static final String SOURCENAME_METHODNAME = "jibx_getDocumentName";
    private static final String SOURCELINE_METHODNAME = "jibx_getLineNumber";
    private static final String SOURCECOLUMN_METHODNAME = "jibx_getColumnNumber";
    private static final Type[] EMPTY_ARGS = new Type[0];
    private final IContainer m_container;
    private BoundClass m_class;
    private final ClassItem m_factoryMethod;
    private final ClassItem m_preSetMethod;
    private final ClassItem m_postSetMethod;
    private final ClassItem m_preGetMethod;
    private ClassItem m_newInstanceMethod;
    private boolean m_lockAttributeUnmarshal;
    private boolean m_lockAttributeMarshal;
    private boolean m_lockContentUnmarshal;
    private boolean m_lockContentMarshal;
    private String m_unmarshalSignature;
    private String m_unmarshalAttributeName;
    private String m_unmarshalContentName;
    private boolean m_isStaticUnmarshal;
    private boolean m_isStaticMarshal;
    private String m_marshalSignature;
    private String m_marshalAttributeName;
    private String m_marshalContentName;
    private ClassItem m_unmarshalAttributeMethod;
    private ClassItem m_unmarshalContentMethod;
    private ClassItem m_marshalAttributeMethod;
    private ClassItem m_marshalContentMethod;
    private IComponent m_idChild;
    private boolean m_isThisBinding;

    public ObjectBinding(IContainer contain, IContextObj objc, String type, String fact, String pres, String posts, String pget) throws JiBXException {
        this.m_container = contain;
        BoundClass ctxc = objc == null ? null : objc.getBoundClass();
        this.m_class = BoundClass.getInstance(type, ctxc);
        ClassFile cf = this.m_class.getClassFile();
        if (fact == null) {
            this.m_factoryMethod = null;
        } else {
            int split = fact.lastIndexOf(46);
            if (split >= 0) {
                String cname = fact.substring(0, split);
                String mname = fact.substring(split + 1);
                ClassFile mcf = ClassCache.getClassFile(cname);
                this.m_factoryMethod = mcf.getMethod(mname, FACTORY_HOOK_SIGNATURES);
                if (this.m_factoryMethod == null) {
                    throw new JiBXException("Factory method " + fact + " not found");
                }
                this.m_factoryMethod.makeAccessible(cf);
            } else {
                this.m_factoryMethod = null;
            }
            if (this.m_factoryMethod == null) {
                throw new JiBXException("Factory method " + fact + " not found.");
            }
        }
        if (pres == null) {
            this.m_preSetMethod = null;
        } else {
            this.m_preSetMethod = cf.getMethod(pres, UNMARSHAL_HOOK_SIGNATURES);
            if (this.m_preSetMethod == null) {
                throw new JiBXException("User method " + pres + " not found.");
            }
        }
        if (posts == null) {
            this.m_postSetMethod = null;
        } else {
            this.m_postSetMethod = cf.getMethod(posts, UNMARSHAL_HOOK_SIGNATURES);
            if (this.m_postSetMethod == null) {
                throw new JiBXException("User method " + posts + " not found.");
            }
        }
        if (pget == null) {
            this.m_preGetMethod = null;
        } else {
            this.m_preGetMethod = cf.getMethod(pget, MARSHAL_HOOK_SIGNATURES);
            if (this.m_preGetMethod == null) {
                throw new JiBXException("User method " + pget + " not found.");
            }
        }
    }

    public ObjectBinding(ObjectBinding base) {
        this.m_container = base.m_container;
        this.m_class = base.m_class;
        this.m_factoryMethod = null;
        this.m_preSetMethod = base.m_preSetMethod;
        this.m_postSetMethod = base.m_postSetMethod;
        this.m_preGetMethod = base.m_preGetMethod;
        this.m_idChild = base.m_idChild;
        this.m_component = base.m_component;
        this.m_isThisBinding = true;
    }

    public ObjectBinding(IContainer contain, ObjectBinding base) {
        this.m_container = contain;
        this.m_class = base.m_class;
        this.m_factoryMethod = base.m_factoryMethod;
        this.m_preSetMethod = base.m_preSetMethod;
        this.m_postSetMethod = base.m_postSetMethod;
        this.m_preGetMethod = base.m_preGetMethod;
        this.m_newInstanceMethod = base.m_newInstanceMethod;
        this.m_unmarshalSignature = base.m_unmarshalSignature;
        this.m_unmarshalAttributeName = base.m_unmarshalAttributeName;
        this.m_unmarshalContentName = base.m_unmarshalContentName;
        this.m_isStaticUnmarshal = base.m_isStaticUnmarshal;
        this.m_isStaticMarshal = base.m_isStaticMarshal;
        this.m_marshalSignature = base.m_marshalSignature;
        this.m_marshalAttributeName = base.m_marshalAttributeName;
        this.m_marshalContentName = base.m_marshalAttributeName;
        this.m_marshalContentName = base.m_marshalContentName;
        this.m_unmarshalAttributeMethod = base.m_unmarshalAttributeMethod;
        this.m_unmarshalContentMethod = base.m_unmarshalContentMethod;
        this.m_marshalAttributeMethod = base.m_marshalAttributeMethod;
        this.m_marshalContentMethod = base.m_marshalContentMethod;
        this.m_idChild = base.m_idChild;
        this.m_component = base.m_component;
    }

    private void genUserMethodCall(boolean in, ClassItem method, ContextMethodBuilder mb) {
        if (!method.isStatic()) {
            mb.loadObject();
        }
        if (method.getArgumentCount() > 0) {
            mb.loadContext();
            String type = method.getArgumentType(0);
            if ("java.lang.Object".equals(type)) {
                String name = in ? UNMARSHAL_GETSTACKTOPMETHOD : MARSHAL_GETSTACKTOPMETHOD;
                mb.appendCallVirtual(name, GETSTACKTOP_SIGNATURE);
            }
        }
        mb.appendCall(method);
        mb.addMethodExceptions(method);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void genNewInstanceCode(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_factoryMethod == null) {
            if (this.m_class.getClassFile().isArray()) {
                mb.appendLoadConstant(16);
                String type = this.m_class.getClassFile().getName();
                mb.appendCreateArray(type.substring(0, type.length() - 2));
                return;
            } else {
                ClassFile cf = this.m_class.getClassFile();
                if (cf.getInitializerMethod(POPOBJECT_SIGNATURE) == null) throw new JiBXException("Need no-argument constructor or factory for " + cf.getName());
                mb.appendCreateNew(cf.getName());
                mb.appendDUP();
                mb.appendCallInit(cf.getName(), POPOBJECT_SIGNATURE);
            }
            return;
        } else {
            this.genUserMethodCall(true, this.m_factoryMethod, mb);
            mb.appendCreateCast(this.m_factoryMethod.getTypeName(), this.m_class.getClassName());
        }
    }

    private void genNewInstanceCall(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_newInstanceMethod == null) {
            String name = this.m_container.getBindingRoot().getPrefix() + NEWINSTANCE_SUFFIX;
            String sig = UNMARSHAL_PARAMETER_SIGNATURE + this.m_class.getClassFile().getSignature();
            ClassFile cf = this.m_class.getMungedFile();
            ContextMethodBuilder meth = new ContextMethodBuilder(name, sig, cf, 9, -1, this.m_class.getClassName(), 0, UNMARSHALLING_CONTEXT);
            this.genNewInstanceCode(meth);
            meth.appendReturn(this.m_class.getClassName());
            this.m_newInstanceMethod = this.m_class.getUniqueMethod(meth).getItem();
        }
        mb.loadContext(UNMARSHALLING_CONTEXT);
        mb.appendCall(this.m_newInstanceMethod);
    }

    private void genTrackSourceCode() throws JiBXException {
        ClassFile cf = this.m_class.getMungedFile();
        if (!this.m_isThisBinding && this.m_class.isDirectAccess() && !cf.isAbstract() && cf.addInterface(SOURCE_TRACKING_INTERFACE)) {
            ClassItem srcname = cf.addPrivateField("java.lang.String;", SOURCEDOCUMENT_FIELDNAME);
            ClassItem srcline = cf.addPrivateField("int", SOURCELINE_FIELDNAME);
            ClassItem srccol = cf.addPrivateField("int", SOURCECOLUMN_FIELDNAME);
            ExceptionMethodBuilder mb = new ExceptionMethodBuilder(SETSOURCE_METHODNAME, (Type)Type.VOID, SETSOURCE_ARGS, cf, 1);
            mb.appendLoadLocal(0);
            mb.appendLoadLocal(1);
            mb.appendPutField(srcname);
            mb.appendLoadLocal(0);
            mb.appendLoadLocal(2);
            mb.appendPutField(srcline);
            mb.appendLoadLocal(0);
            mb.appendLoadLocal(3);
            mb.appendPutField(srccol);
            mb.appendReturn();
            mb.codeComplete(false);
            mb.addMethod();
            mb = new ExceptionMethodBuilder(SOURCENAME_METHODNAME, (Type)Type.STRING, EMPTY_ARGS, cf, 1);
            mb.appendLoadLocal(0);
            mb.appendGetField(srcname);
            mb.appendReturn((Type)Type.STRING);
            mb.codeComplete(false);
            mb.addMethod();
            mb = new ExceptionMethodBuilder(SOURCELINE_METHODNAME, (Type)Type.INT, EMPTY_ARGS, cf, 1);
            mb.appendLoadLocal(0);
            mb.appendGetField(srcline);
            mb.appendReturn("int");
            mb.codeComplete(false);
            mb.addMethod();
            mb = new ExceptionMethodBuilder(SOURCECOLUMN_METHODNAME, (Type)Type.INT, EMPTY_ARGS, cf, 1);
            mb.appendLoadLocal(0);
            mb.appendGetField(srccol);
            mb.appendReturn("int");
            mb.codeComplete(false);
            mb.addMethod();
        }
    }

    private String fullMethodName(ContextMethodBuilder mb) {
        return mb.getClassFile().getName() + '.' + mb.getName();
    }

    private String fullMethodName(ClassItem item) {
        return item.getClassFile().getName() + '.' + item.getName();
    }

    private void genUnmarshalCall(String name, ContextMethodBuilder mb) {
        if (this.m_isStaticUnmarshal) {
            mb.appendCallStatic(name, this.m_unmarshalSignature);
        } else {
            mb.appendCallVirtual(name, this.m_unmarshalSignature);
        }
    }

    private void genMarshalCall(String name, ContextMethodBuilder mb) {
        if (this.m_isStaticMarshal) {
            mb.appendCallStatic(name, this.m_marshalSignature);
        } else {
            mb.appendCallVirtual(name, this.m_marshalSignature);
        }
    }

    private void genUnmarshalAttributeCall(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_unmarshalAttributeMethod == null) {
            if (this.m_unmarshalAttributeName == null) {
                String name = this.m_container.getBindingRoot().getPrefix() + UNMARSHAL_ATTR_SUFFIX;
                UnmarshalBuilder meth = new UnmarshalBuilder(name, this.m_class.getClassFile(), this.m_class.getMungedFile());
                this.m_unmarshalAttributeName = this.fullMethodName(meth);
                this.m_unmarshalSignature = meth.getSignature();
                this.m_isStaticUnmarshal = meth.isStaticMethod();
                if (this.m_preSetMethod != null) {
                    meth.loadObject();
                    this.genUserMethodCall(true, this.m_preSetMethod, meth);
                }
                if (!this.m_isThisBinding) {
                    meth.loadContext();
                    meth.loadObject();
                    meth.appendCallVirtual(UNMARSHAL_PUSHTRACKEDOBJECTMETHOD, PUSHOBJECT_SIGNATURE);
                }
                meth.loadObject();
                this.m_component.genAttributeUnmarshal(meth);
                if (!this.m_isThisBinding) {
                    meth.loadContext();
                    meth.appendCallVirtual(UNMARSHAL_POPOBJECTMETHOD, POPOBJECT_SIGNATURE);
                }
                if (this.m_postSetMethod != null && !this.hasContent()) {
                    this.genUserMethodCall(true, this.m_postSetMethod, meth);
                }
                meth.loadObject();
                meth.appendReturn(this.m_class.getClassFile().getName());
                if (this.m_lockAttributeUnmarshal) {
                    this.m_unmarshalAttributeMethod = this.m_class.getUniqueNamed(meth).getItem();
                } else {
                    this.m_unmarshalAttributeMethod = this.m_class.getUniqueMethod(meth).getItem();
                    this.m_unmarshalAttributeName = this.fullMethodName(this.m_unmarshalAttributeMethod);
                }
            } else {
                this.m_lockAttributeUnmarshal = true;
            }
        }
        mb.loadContext(UNMARSHALLING_CONTEXT);
        this.genUnmarshalCall(this.m_unmarshalAttributeName, mb);
    }

    private void genMarshalAttributeCall(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_marshalAttributeMethod == null) {
            if (this.m_marshalAttributeName == null) {
                String name = this.m_container.getBindingRoot().getPrefix() + MARSHAL_ATTR_SUFFIX;
                MarshalBuilder meth = new MarshalBuilder(name, this.m_class.getClassFile(), this.m_class.getMungedFile());
                this.m_marshalAttributeName = this.fullMethodName(meth);
                this.m_marshalSignature = meth.getSignature();
                this.m_isStaticMarshal = meth.isStaticMethod();
                if (this.m_preGetMethod != null) {
                    this.genUserMethodCall(false, this.m_preGetMethod, meth);
                }
                if (!this.m_isThisBinding) {
                    meth.loadContext();
                    meth.loadObject();
                    meth.appendCallVirtual(MARSHAL_PUSHOBJECTMETHOD, PUSHOBJECT_SIGNATURE);
                }
                meth.loadContext();
                this.m_component.genAttributeMarshal(meth);
                if (!this.m_isThisBinding) {
                    meth.loadContext();
                    meth.appendCallVirtual(MARSHAL_POPOBJECTMETHOD, POPOBJECT_SIGNATURE);
                }
                meth.appendReturn();
                if (this.m_lockAttributeMarshal) {
                    this.m_marshalAttributeMethod = this.m_class.getUniqueNamed(meth).getItem();
                } else {
                    this.m_marshalAttributeMethod = this.m_class.getUniqueMethod(meth).getItem();
                    this.m_marshalAttributeName = this.fullMethodName(this.m_marshalAttributeMethod);
                }
            } else {
                this.m_lockAttributeMarshal = true;
            }
        }
        mb.loadContext(MARSHALLING_CONTEXT);
        this.genMarshalCall(this.m_marshalAttributeName, mb);
    }

    private void genUnmarshalContentCall(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_unmarshalContentMethod == null) {
            if (this.m_unmarshalContentName == null) {
                String name = this.m_container.getBindingRoot().getPrefix() + UNMARSHAL_SUFFIX;
                UnmarshalBuilder meth = new UnmarshalBuilder(name, this.m_class.getClassFile(), this.m_class.getMungedFile());
                this.m_unmarshalContentName = this.fullMethodName(meth);
                this.m_unmarshalSignature = meth.getSignature();
                this.m_isStaticUnmarshal = meth.isStaticMethod();
                if (!this.hasAttribute() && this.m_preSetMethod != null) {
                    meth.loadObject();
                    this.genUserMethodCall(true, this.m_preSetMethod, meth);
                }
                if (!this.m_isThisBinding) {
                    meth.loadContext();
                    meth.loadObject();
                    String mname = this.hasAttribute() ? UNMARSHAL_PUSHOBJECTMETHOD : UNMARSHAL_PUSHTRACKEDOBJECTMETHOD;
                    meth.appendCallVirtual(mname, PUSHOBJECT_SIGNATURE);
                }
                meth.loadObject();
                this.m_component.genContentUnmarshal(meth);
                if (!this.m_isThisBinding) {
                    meth.loadContext();
                    meth.appendCallVirtual(UNMARSHAL_POPOBJECTMETHOD, POPOBJECT_SIGNATURE);
                }
                if (this.m_postSetMethod != null) {
                    this.genUserMethodCall(true, this.m_postSetMethod, meth);
                }
                meth.loadObject();
                meth.appendReturn(this.m_class.getClassFile().getName());
                if (this.m_lockContentUnmarshal) {
                    this.m_unmarshalContentMethod = this.m_class.getUniqueNamed(meth).getItem();
                } else {
                    this.m_unmarshalContentMethod = this.m_class.getUniqueMethod(meth).getItem();
                    this.m_unmarshalContentName = this.fullMethodName(this.m_unmarshalContentMethod);
                }
            } else {
                this.m_lockContentUnmarshal = true;
            }
        }
        mb.loadContext(UNMARSHALLING_CONTEXT);
        this.genUnmarshalCall(this.m_unmarshalContentName, mb);
    }

    private void genMarshalContentCall(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_marshalContentMethod == null) {
            if (this.m_marshalContentName == null) {
                String name = this.m_container.getBindingRoot().getPrefix() + MARSHAL_SUFFIX;
                MarshalBuilder meth = new MarshalBuilder(name, this.m_class.getClassFile(), this.m_class.getMungedFile());
                this.m_marshalContentName = this.fullMethodName(meth);
                this.m_marshalSignature = meth.getSignature();
                this.m_isStaticMarshal = meth.isStaticMethod();
                if (this.m_preGetMethod != null && !this.hasAttribute()) {
                    this.genUserMethodCall(false, this.m_preGetMethod, meth);
                }
                if (!this.m_isThisBinding) {
                    meth.loadContext();
                    meth.loadObject();
                    meth.appendCallVirtual(MARSHAL_PUSHOBJECTMETHOD, PUSHOBJECT_SIGNATURE);
                }
                meth.loadContext();
                this.m_component.genContentMarshal(meth);
                if (!this.m_isThisBinding) {
                    meth.loadContext();
                    meth.appendCallVirtual(MARSHAL_POPOBJECTMETHOD, POPOBJECT_SIGNATURE);
                }
                meth.appendReturn();
                if (this.m_lockContentMarshal) {
                    this.m_marshalContentMethod = this.m_class.getUniqueNamed(meth).getItem();
                } else {
                    this.m_marshalContentMethod = this.m_class.getUniqueMethod(meth).getItem();
                    this.m_marshalContentName = this.fullMethodName(this.m_marshalContentMethod);
                }
            } else {
                this.m_lockContentMarshal = true;
            }
        }
        mb.loadContext(MARSHALLING_CONTEXT);
        this.genMarshalCall(this.m_marshalContentName, mb);
    }

    public BoundClass getBoundClass() {
        return this.m_class;
    }

    public boolean setIdChild(IComponent child) {
        if (this.m_idChild == null) {
            this.m_idChild = child;
            return true;
        }
        return false;
    }

    public boolean isOptional() {
        return false;
    }

    public void genAttributeUnmarshal(ContextMethodBuilder mb) throws JiBXException {
        this.genUnmarshalAttributeCall(mb);
    }

    public void genAttributeMarshal(ContextMethodBuilder mb) throws JiBXException {
        this.genMarshalAttributeCall(mb);
    }

    public void genContentUnmarshal(ContextMethodBuilder mb) throws JiBXException {
        this.genUnmarshalContentCall(mb);
    }

    public void genContentMarshal(ContextMethodBuilder mb) throws JiBXException {
        this.genMarshalContentCall(mb);
    }

    public void genNewInstance(ContextMethodBuilder mb) throws JiBXException {
        this.genNewInstanceCall(mb);
    }

    public String getType() {
        return this.m_class.getClassName();
    }

    public boolean hasId() {
        return this.m_idChild != null;
    }

    public void genLoadId(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_idChild == null) {
            throw new IllegalStateException("Internal error: no id defined");
        }
        this.m_idChild.genLoadId(mb);
    }

    public void setLinkages() throws JiBXException {
        super.setLinkages();
        if (this.m_container.getBindingRoot().isTrackSource()) {
            this.genTrackSourceCode();
        }
    }

    public void print(int depth) {
        BindingDefinition.indent(depth);
        System.out.print("object binding for " + this.m_class.getClassFile().getName());
        if (this.m_isThisBinding) {
            System.out.print(" (\"this\" reference)");
        }
        System.out.println();
        this.m_component.print(depth + 1);
    }
}

