/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.jhardware.info.processor.unix;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.jutils.jhardware.info.processor.AbstractProcessorInfo;
import org.jutils.jhardware.util.HardwareInfoUtils;
import org.jutils.jhardware.util.TemperatureUtils;

public final class UnixProcessorInfo
extends AbstractProcessorInfo {
    private static final String CPUINFO = "/proc/cpuinfo";

    public static String getProcessorData() {
        StringBuilder buffer = new StringBuilder();
        try (Stream<String> streamProcessorInfo = HardwareInfoUtils.readFile(CPUINFO);){
            streamProcessorInfo.forEach(line -> buffer.append((String)line).append("\r\n"));
        }
        return buffer.toString();
    }

    @Override
    protected Map<String, String> parseInfo() {
        String[] dataStringLines;
        HashMap<String, String> processorDataMap = new HashMap<String, String>();
        for (String dataLine : dataStringLines = UnixProcessorInfo.getProcessorData().split("\\r?\\n")) {
            String[] dataStringInfo = dataLine.split(":");
            processorDataMap.put(dataStringInfo[0].trim(), dataStringInfo.length == 2 ? dataStringInfo[1].trim() : "");
        }
        processorDataMap.put("temperature", TemperatureUtils.getCpuTemperatureForLinux());
        return processorDataMap;
    }
}

