/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.jhardware.info.graphicscard.unix;

import com.profesorfalken.jsensors.JSensors;
import com.profesorfalken.jsensors.model.components.Gpu;
import com.profesorfalken.jsensors.model.sensors.Fan;
import com.profesorfalken.jsensors.model.sensors.Temperature;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jutils.jhardware.info.graphicscard.AbstractGraphicsCardInfo;
import org.jutils.jhardware.util.HardwareInfoUtils;

public class UnixGraphicsCardInfo
extends AbstractGraphicsCardInfo {
    private static final String LSHW_COMMAND = "lshw";
    private static final String LSHW_PARAMS = "-C";

    private static String getGraphicsCardData() {
        return HardwareInfoUtils.executeCommand(LSHW_COMMAND, LSHW_PARAMS, "video");
    }

    @Override
    protected Map<String, String> parseInfo() {
        HashMap<String, String> graphicsCardDataMap = new HashMap<String, String>();
        int count = -1;
        String graphicsCardData = UnixGraphicsCardInfo.getGraphicsCardData();
        if (graphicsCardData != null) {
            String[] dataStringLines;
            for (String dataLine : dataStringLines = UnixGraphicsCardInfo.getGraphicsCardData().split("\\r?\\n")) {
                String line = dataLine.trim();
                if (line.startsWith("*-display")) {
                    ++count;
                    continue;
                }
                if (line.startsWith("product:")) {
                    graphicsCardDataMap.put("name_" + count, line.split(":", 2)[1]);
                    continue;
                }
                if (line.startsWith("vendor:")) {
                    graphicsCardDataMap.put("manufacturer_" + count, line.split(":", 2)[1]);
                    continue;
                }
                if (!line.startsWith("description:")) continue;
                graphicsCardDataMap.put("chip_type_" + count, line.split(":", 2)[1]);
            }
            List gpus = JSensors.get.components().gpus;
            for (int i = 0; i < count; ++i) {
                if (gpus.size() <= i) continue;
                Gpu gpu = (Gpu)gpus.get(i);
                if (gpu.sensors.temperatures != null && !gpu.sensors.temperatures.isEmpty()) {
                    graphicsCardDataMap.put("temperature_" + i, String.valueOf(((Temperature)gpu.sensors.temperatures.get((int)0)).value.intValue()));
                }
                if (gpu.sensors.fans == null || gpu.sensors.fans.isEmpty()) continue;
                graphicsCardDataMap.put("fan_speed_" + i, String.valueOf(((Fan)gpu.sensors.fans.get((int)0)).value.intValue()));
            }
        }
        graphicsCardDataMap.put("numOfGraphicsCards", String.valueOf(count + 1));
        return graphicsCardDataMap;
    }
}

