/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.webgraph;

import it.unimi.dsi.big.webgraph.ImmutableGraph;
import it.unimi.dsi.big.webgraph.LazyLongIterator;
import it.unimi.dsi.big.webgraph.LazyLongIterators;
import it.unimi.dsi.big.webgraph.NodeIterator;
import it.unimi.dsi.fastutil.longs.LongLongSortedPair;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.objects.ObjectIterables;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashBigSet;
import it.unimi.dsi.lang.FlyweightPrototype;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jgrapht.GraphIterables;
import org.jgrapht.GraphType;
import org.jgrapht.graph.DefaultGraphType;
import org.jgrapht.webgraph.AbstractImmutableBigGraphAdapter;

public class ImmutableUndirectedBigGraphAdapter
extends AbstractImmutableBigGraphAdapter<LongLongSortedPair>
implements FlyweightPrototype<ImmutableUndirectedBigGraphAdapter> {
    private final GraphIterables<Long, LongLongSortedPair> iterables = new GraphIterables<Long, LongLongSortedPair>(){

        public ImmutableUndirectedBigGraphAdapter getGraph() {
            return ImmutableUndirectedBigGraphAdapter.this;
        }

        public long vertexCount() {
            return ImmutableUndirectedBigGraphAdapter.this.n;
        }

        public long edgeCount() {
            if (ImmutableUndirectedBigGraphAdapter.this.m != -1L) {
                return ImmutableUndirectedBigGraphAdapter.this.m;
            }
            ImmutableUndirectedBigGraphAdapter.this.m = ObjectIterables.size(this.edges());
            return ImmutableUndirectedBigGraphAdapter.this.m;
        }

        public long degreeOf(Long vertex) {
            return this.inDegreeOf(vertex) + (long)(ImmutableUndirectedBigGraphAdapter.this.containsEdgeFast(vertex, vertex) ? 1 : 0);
        }

        public Iterable<LongLongSortedPair> edgesOf(Long vertex) {
            final long x = vertex;
            return () -> new Iterator<LongLongSortedPair>(){
                final LazyLongIterator successors;
                long y;
                {
                    this.successors = ImmutableUndirectedBigGraphAdapter.this.immutableGraph.successors(x);
                    this.y = -1L;
                }

                @Override
                public boolean hasNext() {
                    if (this.y == -1L) {
                        this.y = this.successors.nextLong();
                    }
                    return this.y != -1L;
                }

                @Override
                public LongLongSortedPair next() {
                    LongLongSortedPair edge = LongLongSortedPair.of((long)this.y, (long)x);
                    this.y = -1L;
                    return edge;
                }
            };
        }

        public long inDegreeOf(Long vertex) {
            return ImmutableUndirectedBigGraphAdapter.this.immutableGraph.outdegree(vertex.longValue());
        }

        public Iterable<LongLongSortedPair> incomingEdgesOf(Long vertex) {
            return this.edgesOf(vertex);
        }

        public long outDegreeOf(Long vertex) {
            return ImmutableUndirectedBigGraphAdapter.this.immutableGraph.outdegree(vertex.longValue());
        }

        public Iterable<LongLongSortedPair> outgoingEdgesOf(Long vertex) {
            return this.edgesOf(vertex);
        }

        public Iterable<LongLongSortedPair> edges() {
            return () -> new Iterator<LongLongSortedPair>(){
                final NodeIterator nodeIterator;
                LazyLongIterator successors;
                long x;
                long y;
                {
                    this.nodeIterator = ImmutableUndirectedBigGraphAdapter.this.immutableGraph.nodeIterator();
                    this.successors = LazyLongIterators.EMPTY_ITERATOR;
                    this.y = -1L;
                }

                @Override
                public boolean hasNext() {
                    if (this.y != -1L) {
                        return true;
                    }
                    while (true) {
                        if ((this.y = this.successors.nextLong()) == -1L) {
                            if (!this.nodeIterator.hasNext()) {
                                return false;
                            }
                            this.x = this.nodeIterator.nextLong();
                            this.successors = this.nodeIterator.successors();
                            continue;
                        }
                        if (this.y >= this.x) break;
                    }
                    return true;
                }

                @Override
                public LongLongSortedPair next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    LongLongSortedPair edge = LongLongSortedPair.of((long)this.x, (long)this.y);
                    this.y = -1L;
                    return edge;
                }
            };
        }
    };

    public ImmutableUndirectedBigGraphAdapter(ImmutableGraph immutableGraph) {
        super(immutableGraph);
    }

    @Override
    protected LongLongSortedPair makeEdge(long x, long y) {
        return LongLongSortedPair.of((long)x, (long)y);
    }

    public boolean containsEdge(LongLongSortedPair e) {
        if (e == null) {
            return false;
        }
        return this.containsEdgeFast(e.leftLong(), e.rightLong());
    }

    public Set<LongLongSortedPair> edgeSet() {
        NodeIterator nodeIterator = this.immutableGraph.nodeIterator();
        long m = this.iterables().edgeCount();
        ObjectOpenHashBigSet edges = new ObjectOpenHashBigSet(m);
        for (long i = 0L; i < this.n; ++i) {
            long y;
            long x = nodeIterator.nextLong();
            LazyLongIterator successors = nodeIterator.successors();
            while ((y = successors.nextLong()) != -1L) {
                if (x > y) continue;
                edges.add((Object)LongLongSortedPair.of((long)x, (long)y));
            }
        }
        return edges;
    }

    public int degreeOf(Long vertex) {
        long d = (long)this.inDegreeOf(vertex) + (this.containsEdgeFast(vertex, vertex) ? 1L : 0L);
        if (d > Integer.MAX_VALUE) {
            throw new ArithmeticException();
        }
        return (int)d;
    }

    public Set<LongLongSortedPair> edgesOf(Long vertex) {
        long target;
        ObjectLinkedOpenHashSet set = new ObjectLinkedOpenHashSet();
        long source = vertex;
        LazyLongIterator predecessors = this.immutableGraph.successors(source);
        while ((target = predecessors.nextLong()) != -1L) {
            set.add((Object)LongLongSortedPair.of((long)source, (long)target));
        }
        return set;
    }

    public int inDegreeOf(Long vertex) {
        long d = this.immutableGraph.outdegree(vertex.longValue());
        if (d > Integer.MAX_VALUE) {
            throw new ArithmeticException();
        }
        return (int)d;
    }

    public Set<LongLongSortedPair> incomingEdgesOf(Long vertex) {
        return this.edgesOf(vertex);
    }

    public int outDegreeOf(Long vertex) {
        long d = this.immutableGraph.outdegree(vertex.longValue());
        if (d > Integer.MAX_VALUE) {
            throw new ArithmeticException();
        }
        return (int)d;
    }

    public Set<LongLongSortedPair> outgoingEdgesOf(Long vertex) {
        return this.edgesOf(vertex);
    }

    @Override
    public LongLongSortedPair removeEdge(Long sourceVertex, Long targetVertex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeEdge(LongLongSortedPair e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeVertex(Long v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Long> vertexSet() {
        return LongSets.fromTo((long)0L, (long)this.n);
    }

    @Override
    public Long getEdgeSource(LongLongSortedPair e) {
        return e.leftLong();
    }

    @Override
    public Long getEdgeTarget(LongLongSortedPair e) {
        return e.rightLong();
    }

    @Override
    public double getEdgeWeight(LongLongSortedPair e) {
        return 1.0;
    }

    @Override
    public void setEdgeWeight(LongLongSortedPair e, double weight) {
        if (weight != 1.0) {
            throw new UnsupportedOperationException();
        }
    }

    public GraphType getType() {
        return new DefaultGraphType.Builder().weighted(false).modifiable(false).allowMultipleEdges(false).allowSelfLoops(true).undirected().build();
    }

    public ImmutableUndirectedBigGraphAdapter copy() {
        return new ImmutableUndirectedBigGraphAdapter(this.immutableGraph.copy());
    }

    public GraphIterables<Long, LongLongSortedPair> iterables() {
        return this.iterables;
    }
}

