/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.sux4j;

import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import it.unimi.dsi.fastutil.longs.LongBigListIterator;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.sux4j.util.EliasFanoIndexedMonotoneLongBigList;
import it.unimi.dsi.sux4j.util.EliasFanoMonotoneLongBigList;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jgrapht.Graph;
import org.jgrapht.GraphIterables;
import org.jgrapht.alg.util.Pair;
import org.jgrapht.opt.graph.sparse.IncomingEdgesSupport;
import org.jgrapht.opt.graph.sparse.SparseIntDirectedGraph;
import org.jgrapht.sux4j.AbstractSuccinctDirectedGraph;

public class SuccinctIntDirectedGraph
extends AbstractSuccinctDirectedGraph<Integer>
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final EliasFanoIndexedMonotoneLongBigList cumulativeOutdegrees;
    private final EliasFanoMonotoneLongBigList cumulativeIndegrees;
    private final EliasFanoIndexedMonotoneLongBigList successors;
    private final EliasFanoMonotoneLongBigList predecessors;
    private final GraphIterables<Integer, Integer> iterables = new SuccinctGraphIterables(this);

    public <E> SuccinctIntDirectedGraph(Graph<Integer, E> graph, boolean incomingEdgesSupport) {
        super((int)graph.iterables().vertexCount(), (int)graph.iterables().edgeCount());
        if (graph.getType().isUndirected()) {
            throw new IllegalArgumentException("This class supports directed graphs only");
        }
        assert (graph.getType().isDirected());
        GraphIterables iterables = graph.iterables();
        if (iterables.vertexCount() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("The number of nodes (" + iterables.vertexCount() + ") is greater than 2147483647");
        }
        if (iterables.edgeCount() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("The number of edges (" + iterables.edgeCount() + ") is greater than 2147483647");
        }
        this.cumulativeOutdegrees = new EliasFanoIndexedMonotoneLongBigList((long)(this.n + 1), (long)this.m, (LongIterator)new AbstractSuccinctDirectedGraph.CumulativeDegrees(this.n, arg_0 -> graph.outDegreeOf(arg_0)));
        assert (this.cumulativeOutdegrees.getLong(this.cumulativeOutdegrees.size64() - 1L) == (long)this.m);
        this.successors = new EliasFanoIndexedMonotoneLongBigList((long)this.m, (long)this.n << this.sourceShift, new AbstractSuccinctDirectedGraph.CumulativeSuccessors<E>(graph, arg_0 -> ((GraphIterables)iterables).outgoingEdgesOf(arg_0), true));
        if (incomingEdgesSupport) {
            this.cumulativeIndegrees = new EliasFanoMonotoneLongBigList((long)(this.n + 1), (long)this.m, (LongIterator)new AbstractSuccinctDirectedGraph.CumulativeDegrees(this.n, arg_0 -> graph.inDegreeOf(arg_0)));
            assert (this.cumulativeIndegrees.getLong(this.cumulativeIndegrees.size64() - 1L) == (long)this.m);
            this.predecessors = new EliasFanoIndexedMonotoneLongBigList((long)this.m, (long)this.n * (long)this.n - (long)this.m, new AbstractSuccinctDirectedGraph.CumulativeSuccessors<E>(graph, arg_0 -> ((GraphIterables)iterables).incomingEdgesOf(arg_0), false));
        } else {
            this.predecessors = null;
            this.cumulativeIndegrees = null;
        }
    }

    public <E> SuccinctIntDirectedGraph(Graph<Integer, E> graph) {
        this(graph, true);
    }

    public SuccinctIntDirectedGraph(int numVertices, List<Pair<Integer, Integer>> edges, boolean incomingEdgesSupport) {
        this((Graph)new SparseIntDirectedGraph(numVertices, edges, incomingEdgesSupport ? IncomingEdgesSupport.FULL_INCOMING_EDGES : IncomingEdgesSupport.NO_INCOMING_EDGES), incomingEdgesSupport);
    }

    public SuccinctIntDirectedGraph(int numVertices, List<Pair<Integer, Integer>> edges) {
        this(numVertices, edges, true);
    }

    public SuccinctIntDirectedGraph(int numVertices, int numEdges, Supplier<Stream<Pair<Integer, Integer>>> edges, boolean incomingEdgesSupport) {
        this((Graph)new SparseIntDirectedGraph(numVertices, numEdges, edges, incomingEdgesSupport ? IncomingEdgesSupport.FULL_INCOMING_EDGES : IncomingEdgesSupport.NO_INCOMING_EDGES));
    }

    public SuccinctIntDirectedGraph(int numVertices, int numEdges, Supplier<Stream<Pair<Integer, Integer>>> edges) {
        this(numVertices, numEdges, edges, true);
    }

    public boolean containsEdge(Integer e) {
        return e >= 0 && e < this.m;
    }

    public Set<Integer> edgeSet() {
        return IntSets.fromTo((int)0, (int)this.m);
    }

    public IntSet edgesOf(Integer vertex) {
        IntSet result = this.outgoingEdgesOf(vertex);
        result.addAll((IntCollection)this.incomingEdgesOf(vertex));
        return result;
    }

    public int inDegreeOf(Integer vertex) {
        this.assertVertexExist(vertex);
        return (int)this.cumulativeIndegrees.getDelta((long)vertex.intValue());
    }

    public IntSet incomingEdgesOf(Integer target) {
        this.assertVertexExist(target);
        int t = target;
        long[] result = new long[2];
        this.cumulativeIndegrees.get((long)t, result);
        int d = (int)(result[1] - result[0]);
        EliasFanoMonotoneLongBigList.EliasFanoMonotoneLongBigListIterator iterator = this.predecessors.listIterator(result[0]);
        IntOpenHashSet s = new IntOpenHashSet();
        long base = (long)this.n * (long)t - result[0];
        int i = d;
        while (i-- != 0) {
            long source = iterator.nextLong() - base--;
            int e = (int)this.successors.successorIndexUnsafe((source << this.sourceShift) + (long)t);
            assert (this.getEdgeSource(e).longValue() == source);
            assert (this.getEdgeTarget(e).longValue() == (long)target.intValue());
            s.add(e);
        }
        return s;
    }

    public int outDegreeOf(Integer vertex) {
        this.assertVertexExist(vertex);
        return (int)this.cumulativeOutdegrees.getDelta((long)vertex.intValue());
    }

    public IntSet outgoingEdgesOf(Integer vertex) {
        this.assertVertexExist(vertex);
        long[] result = new long[2];
        this.cumulativeOutdegrees.get((long)vertex.intValue(), result);
        return IntSets.fromTo((int)((int)result[0]), (int)((int)result[1]));
    }

    public Integer getEdgeSource(Integer e) {
        this.assertEdgeExist(e);
        return (int)(this.successors.getLong((long)e.intValue()) >>> this.sourceShift);
    }

    public Integer getEdgeTarget(Integer e) {
        this.assertEdgeExist(e);
        return (int)(this.successors.getLong((long)e.intValue()) & this.targetMask);
    }

    public Integer getEdge(Integer sourceVertex, Integer targetVertex) {
        long index = this.successors.indexOfUnsafe(((long)sourceVertex.intValue() << this.sourceShift) + (long)targetVertex.intValue());
        return index != -1L ? Integer.valueOf((int)index) : null;
    }

    public boolean containsEdge(Integer sourceVertex, Integer targetVertex) {
        return this.successors.indexOfUnsafe(((long)sourceVertex.intValue() << this.sourceShift) + (long)targetVertex.intValue()) != -1L;
    }

    protected boolean assertEdgeExist(Integer e) {
        if (e < 0 || e >= this.m) {
            throw new IllegalArgumentException();
        }
        return true;
    }

    public GraphIterables<Integer, Integer> iterables() {
        return this.iterables;
    }

    private static final class SuccinctGraphIterables
    implements GraphIterables<Integer, Integer>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final SuccinctIntDirectedGraph graph;

        private SuccinctGraphIterables() {
            this.graph = null;
        }

        private SuccinctGraphIterables(SuccinctIntDirectedGraph graph) {
            this.graph = graph;
        }

        public Graph<Integer, Integer> getGraph() {
            return this.graph;
        }

        public long vertexCount() {
            return this.graph.n;
        }

        public long edgeCount() {
            return this.graph.m;
        }

        public Iterable<Integer> edgesOf(Integer source) {
            return Iterables.concat((Iterable)this.outgoingEdgesOf(source), this.incomingEdgesOf(source, true));
        }

        private Iterable<Integer> incomingEdgesOf(int target, boolean skipLoops) {
            SuccinctIntDirectedGraph graph = this.graph;
            long[] result = new long[2];
            graph.cumulativeIndegrees.get((long)target, result);
            int d = (int)(result[1] - result[0]);
            EliasFanoIndexedMonotoneLongBigList successors = graph.successors;
            EliasFanoMonotoneLongBigList.EliasFanoMonotoneLongBigListIterator iterator = graph.predecessors.listIterator(result[0]);
            int sourceShift = graph.sourceShift;
            return () -> this.lambda$incomingEdgesOf$0(d, graph, target, result, (LongBigListIterator)iterator, skipLoops, sourceShift, successors);
        }

        public Iterable<Integer> incomingEdgesOf(Integer vertex) {
            return this.incomingEdgesOf(vertex, false);
        }

        private /* synthetic */ Iterator lambda$incomingEdgesOf$0(final int d, final SuccinctIntDirectedGraph graph, final int target, final long[] result, final LongBigListIterator iterator, final boolean skipLoops, final int sourceShift, final EliasFanoIndexedMonotoneLongBigList successors) {
            return new IntIterator(){
                int i;
                int edge;
                long n;
                long base;
                {
                    this.i = d;
                    this.edge = -1;
                    this.n = graph.n;
                    this.base = (long)target * this.n - result[0];
                }

                public boolean hasNext() {
                    if (this.edge == -1 && this.i > 0) {
                        --this.i;
                        long source = iterator.nextLong() - this.base--;
                        if (skipLoops && source == (long)target && this.i-- != 0) {
                            return false;
                        }
                        long v = (source << sourceShift) + (long)target;
                        assert (v == successors.successor(v)) : v + " != " + successors.successor(v);
                        this.edge = (int)successors.successorIndexUnsafe(v);
                        assert (graph.getEdgeSource(this.edge).longValue() == source);
                        assert (graph.getEdgeTarget(this.edge).longValue() == (long)target);
                    }
                    return this.edge != -1;
                }

                public int nextInt() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    int result2 = this.edge;
                    this.edge = -1;
                    return result2;
                }
            };
        }
    }
}

