/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.webgraph;

import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import it.unimi.dsi.fastutil.ints.IntIntSortedPair;
import it.unimi.dsi.fastutil.objects.ObjectIterables;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashBigSet;
import it.unimi.dsi.lang.FlyweightPrototype;
import it.unimi.dsi.webgraph.ImmutableGraph;
import it.unimi.dsi.webgraph.LazyIntIterator;
import it.unimi.dsi.webgraph.LazyIntIterators;
import it.unimi.dsi.webgraph.NodeIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jgrapht.GraphIterables;
import org.jgrapht.GraphType;
import org.jgrapht.graph.DefaultGraphType;
import org.jgrapht.webgraph.AbstractImmutableGraphAdapter;

public class ImmutableDirectedGraphAdapter
extends AbstractImmutableGraphAdapter<IntIntPair>
implements FlyweightPrototype<ImmutableDirectedGraphAdapter> {
    private final ImmutableGraph immutableTranspose;
    private final GraphIterables<Integer, IntIntPair> ITERABLES = new GraphIterables<Integer, IntIntPair>(){

        public ImmutableDirectedGraphAdapter getGraph() {
            return ImmutableDirectedGraphAdapter.this;
        }

        public long vertexCount() {
            return ImmutableDirectedGraphAdapter.this.n;
        }

        public long edgeCount() {
            if (ImmutableDirectedGraphAdapter.this.m != -1L) {
                return ImmutableDirectedGraphAdapter.this.m;
            }
            try {
                ImmutableDirectedGraphAdapter.this.m = ImmutableDirectedGraphAdapter.this.immutableGraph.numArcs();
                return ImmutableDirectedGraphAdapter.this.m;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                ImmutableDirectedGraphAdapter.this.m = ObjectIterables.size(this.edges());
                return ImmutableDirectedGraphAdapter.this.m;
            }
        }

        public long degreeOf(Integer vertex) {
            return this.inDegreeOf(vertex) + this.outDegreeOf(vertex);
        }

        public Iterable<IntIntPair> edgesOf(Integer source) {
            return Iterables.concat(this.outgoingEdgesOf(source), this.incomingEdgesOf(source, true));
        }

        public long inDegreeOf(Integer vertex) {
            return ImmutableDirectedGraphAdapter.this.immutableTranspose.outdegree(vertex.intValue());
        }

        private Iterable<IntIntPair> incomingEdgesOf(final int x, final boolean skipLoops) {
            return () -> new Iterator<IntIntPair>(){
                final LazyIntIterator successors;
                int y;
                {
                    this.successors = ImmutableDirectedGraphAdapter.this.immutableTranspose.successors(x);
                    this.y = this.successors.nextInt();
                }

                @Override
                public boolean hasNext() {
                    if (this.y == -1) {
                        this.y = this.successors.nextInt();
                        if (skipLoops && x == this.y) {
                            this.y = this.successors.nextInt();
                        }
                    }
                    return this.y != -1;
                }

                @Override
                public IntIntPair next() {
                    IntIntPair edge = IntIntPair.of((int)this.y, (int)x);
                    this.y = -1;
                    return edge;
                }
            };
        }

        public Iterable<IntIntPair> incomingEdgesOf(Integer vertex) {
            return this.incomingEdgesOf(vertex, false);
        }

        public long outDegreeOf(Integer vertex) {
            return ImmutableDirectedGraphAdapter.this.immutableGraph.outdegree(vertex.intValue());
        }

        public Iterable<IntIntPair> outgoingEdgesOf(final Integer vertex) {
            return () -> new Iterator<IntIntPair>(){
                final int x;
                final LazyIntIterator successors;
                int y;
                {
                    this.x = vertex;
                    this.successors = ImmutableDirectedGraphAdapter.this.immutableGraph.successors(this.x);
                    this.y = this.successors.nextInt();
                }

                @Override
                public boolean hasNext() {
                    if (this.y == -1) {
                        this.y = this.successors.nextInt();
                    }
                    return this.y != -1;
                }

                @Override
                public IntIntPair next() {
                    IntIntPair edge = IntIntPair.of((int)this.x, (int)this.y);
                    this.y = -1;
                    return edge;
                }
            };
        }

        public Iterable<IntIntPair> edges() {
            return () -> new Iterator<IntIntPair>(){
                final NodeIterator nodeIterator;
                LazyIntIterator successors;
                int x;
                int y;
                {
                    this.nodeIterator = ImmutableDirectedGraphAdapter.this.immutableGraph.nodeIterator();
                    this.successors = LazyIntIterators.EMPTY_ITERATOR;
                    this.y = -1;
                }

                @Override
                public boolean hasNext() {
                    if (this.y != -1) {
                        return true;
                    }
                    while ((this.y = this.successors.nextInt()) == -1) {
                        if (!this.nodeIterator.hasNext()) {
                            return false;
                        }
                        this.x = this.nodeIterator.nextInt();
                        this.successors = this.nodeIterator.successors();
                    }
                    return true;
                }

                @Override
                public IntIntPair next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    IntIntPair edge = IntIntPair.of((int)this.x, (int)this.y);
                    this.y = -1;
                    return edge;
                }
            };
        }
    };

    public ImmutableDirectedGraphAdapter(ImmutableGraph immutableGraph, ImmutableGraph immutableTranspose) {
        super(immutableGraph);
        this.immutableTranspose = immutableTranspose;
        if (immutableTranspose != null && this.n != immutableTranspose.numNodes()) {
            throw new IllegalArgumentException("The graph has " + this.n + " nodes, but the transpose has " + immutableTranspose.numNodes());
        }
    }

    public ImmutableDirectedGraphAdapter(ImmutableGraph immutableGraph) {
        this(immutableGraph, null);
    }

    @Override
    protected IntIntPair makeEdge(int x, int y) {
        return IntIntPair.of((int)x, (int)y);
    }

    public boolean containsEdge(IntIntPair e) {
        if (e == null) {
            return false;
        }
        if (e instanceof IntIntSortedPair) {
            return false;
        }
        return this.containsEdgeFast(e.leftInt(), e.rightInt());
    }

    public Set<IntIntPair> edgeSet() {
        NodeIterator nodeIterator = this.immutableGraph.nodeIterator();
        long m = this.iterables().edgeCount();
        ObjectOpenHashBigSet edges = new ObjectOpenHashBigSet(m);
        for (int i = 0; i < this.n; ++i) {
            int y;
            int x = nodeIterator.nextInt();
            LazyIntIterator successors = nodeIterator.successors();
            while ((y = successors.nextInt()) != -1) {
                edges.add((Object)IntIntPair.of((int)x, (int)y));
            }
        }
        return edges;
    }

    public int degreeOf(Integer vertex) {
        long d = (long)this.inDegreeOf(vertex) + (long)this.outDegreeOf(vertex);
        if (d > Integer.MAX_VALUE) {
            throw new ArithmeticException();
        }
        return (int)d;
    }

    public Set<IntIntPair> edgesOf(Integer vertex) {
        int target;
        int target2;
        ObjectLinkedOpenHashSet set = new ObjectLinkedOpenHashSet();
        int source = vertex;
        LazyIntIterator successors = this.immutableGraph.successors(source);
        while ((target2 = successors.nextInt()) != -1) {
            set.add((Object)IntIntPair.of((int)source, (int)target2));
        }
        LazyIntIterator predecessors = this.immutableTranspose.successors(source);
        while ((target = predecessors.nextInt()) != -1) {
            if (source == target) continue;
            set.add((Object)IntIntPair.of((int)target, (int)source));
        }
        return set;
    }

    public int inDegreeOf(Integer vertex) {
        return this.immutableTranspose.outdegree(vertex.intValue());
    }

    public Set<IntIntPair> incomingEdgesOf(Integer vertex) {
        int target;
        ObjectLinkedOpenHashSet set = new ObjectLinkedOpenHashSet();
        int source = vertex;
        LazyIntIterator predecessors = this.immutableTranspose.successors(source);
        while ((target = predecessors.nextInt()) != -1) {
            set.add((Object)IntIntPair.of((int)target, (int)source));
        }
        return set;
    }

    public int outDegreeOf(Integer vertex) {
        return this.immutableGraph.outdegree(vertex.intValue());
    }

    public Set<IntIntPair> outgoingEdgesOf(Integer vertex) {
        int target;
        ObjectLinkedOpenHashSet set = new ObjectLinkedOpenHashSet();
        int source = vertex;
        LazyIntIterator successors = this.immutableGraph.successors(source);
        while ((target = successors.nextInt()) != -1) {
            set.add((Object)IntIntPair.of((int)source, (int)target));
        }
        return set;
    }

    public GraphType getType() {
        return new DefaultGraphType.Builder().weighted(false).modifiable(false).allowMultipleEdges(false).allowSelfLoops(true).directed().build();
    }

    public ImmutableDirectedGraphAdapter copy() {
        return new ImmutableDirectedGraphAdapter(this.immutableGraph.copy(), this.immutableTranspose != null ? this.immutableTranspose.copy() : null);
    }

    public GraphIterables<Integer, IntIntPair> iterables() {
        return this.ITERABLES;
    }
}

