/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.webgraph;

import com.google.common.collect.Iterables;
import it.unimi.dsi.big.webgraph.ImmutableGraph;
import it.unimi.dsi.big.webgraph.LazyLongIterator;
import it.unimi.dsi.big.webgraph.LazyLongIterators;
import it.unimi.dsi.big.webgraph.NodeIterator;
import it.unimi.dsi.fastutil.longs.LongLongPair;
import it.unimi.dsi.fastutil.longs.LongLongSortedPair;
import it.unimi.dsi.fastutil.objects.ObjectIterables;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashBigSet;
import it.unimi.dsi.lang.FlyweightPrototype;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jgrapht.GraphIterables;
import org.jgrapht.GraphType;
import org.jgrapht.graph.DefaultGraphType;
import org.jgrapht.webgraph.AbstractImmutableBigGraphAdapter;

public class ImmutableDirectedBigGraphAdapter
extends AbstractImmutableBigGraphAdapter<LongLongPair>
implements FlyweightPrototype<ImmutableDirectedBigGraphAdapter> {
    private final ImmutableGraph immutableTranspose;
    private final GraphIterables<Long, LongLongPair> ITERABLES = new GraphIterables<Long, LongLongPair>(){

        public ImmutableDirectedBigGraphAdapter getGraph() {
            return ImmutableDirectedBigGraphAdapter.this;
        }

        public long vertexCount() {
            return ImmutableDirectedBigGraphAdapter.this.n;
        }

        public long edgeCount() {
            if (ImmutableDirectedBigGraphAdapter.this.m != -1L) {
                return ImmutableDirectedBigGraphAdapter.this.m;
            }
            try {
                ImmutableDirectedBigGraphAdapter.this.m = ImmutableDirectedBigGraphAdapter.this.immutableGraph.numArcs();
                return ImmutableDirectedBigGraphAdapter.this.m;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                ImmutableDirectedBigGraphAdapter.this.m = ObjectIterables.size(this.edges());
                return ImmutableDirectedBigGraphAdapter.this.m;
            }
        }

        public long degreeOf(Long vertex) {
            return this.inDegreeOf(vertex) + this.outDegreeOf(vertex);
        }

        public Iterable<LongLongPair> edgesOf(Long source) {
            return Iterables.concat(this.outgoingEdgesOf(source), this.incomingEdgesOf(source, true));
        }

        public long inDegreeOf(Long vertex) {
            return ImmutableDirectedBigGraphAdapter.this.immutableTranspose.outdegree(vertex.longValue());
        }

        private Iterable<LongLongPair> incomingEdgesOf(final long x, final boolean skipLoops) {
            return () -> new Iterator<LongLongPair>(){
                final LazyLongIterator successors;
                long y;
                {
                    this.successors = ImmutableDirectedBigGraphAdapter.this.immutableTranspose.successors(x);
                    this.y = -1L;
                }

                @Override
                public boolean hasNext() {
                    if (this.y == -1L) {
                        this.y = this.successors.nextLong();
                        if (skipLoops && x == this.y) {
                            this.y = this.successors.nextLong();
                        }
                    }
                    return this.y != -1L;
                }

                @Override
                public LongLongPair next() {
                    LongLongPair edge = LongLongPair.of((long)this.y, (long)x);
                    this.y = -1L;
                    return edge;
                }
            };
        }

        public Iterable<LongLongPair> incomingEdgesOf(Long vertex) {
            return this.incomingEdgesOf(vertex, false);
        }

        public long outDegreeOf(Long vertex) {
            return ImmutableDirectedBigGraphAdapter.this.immutableGraph.outdegree(vertex.longValue());
        }

        public Iterable<LongLongPair> outgoingEdgesOf(final Long vertex) {
            return () -> new Iterator<LongLongPair>(){
                final long x;
                final LazyLongIterator successors;
                long y;
                {
                    this.x = vertex;
                    this.successors = ImmutableDirectedBigGraphAdapter.this.immutableGraph.successors(this.x);
                    this.y = -1L;
                }

                @Override
                public boolean hasNext() {
                    if (this.y == -1L) {
                        this.y = this.successors.nextLong();
                    }
                    return this.y != -1L;
                }

                @Override
                public LongLongPair next() {
                    LongLongPair edge = LongLongPair.of((long)this.x, (long)this.y);
                    this.y = -1L;
                    return edge;
                }
            };
        }

        public Iterable<LongLongPair> edges() {
            return () -> new Iterator<LongLongPair>(){
                final NodeIterator nodeIterator;
                LazyLongIterator successors;
                long x;
                long y;
                {
                    this.nodeIterator = ImmutableDirectedBigGraphAdapter.this.immutableGraph.nodeIterator();
                    this.successors = LazyLongIterators.EMPTY_ITERATOR;
                    this.y = -1L;
                }

                @Override
                public boolean hasNext() {
                    if (this.y != -1L) {
                        return true;
                    }
                    while ((this.y = this.successors.nextLong()) == -1L) {
                        if (!this.nodeIterator.hasNext()) {
                            return false;
                        }
                        this.x = this.nodeIterator.nextLong();
                        this.successors = this.nodeIterator.successors();
                    }
                    return true;
                }

                @Override
                public LongLongPair next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    LongLongPair edge = LongLongPair.of((long)this.x, (long)this.y);
                    this.y = -1L;
                    return edge;
                }
            };
        }
    };

    public ImmutableDirectedBigGraphAdapter(ImmutableGraph immutableGraph, ImmutableGraph immutableTranspose) {
        super(immutableGraph);
        this.immutableTranspose = immutableTranspose;
        if (immutableTranspose != null && this.n != immutableTranspose.numNodes()) {
            throw new IllegalArgumentException("The graph has " + this.n + " nodes, but the transpose has " + immutableTranspose.numNodes());
        }
    }

    public ImmutableDirectedBigGraphAdapter(ImmutableGraph immutableGraph) {
        this(immutableGraph, null);
    }

    @Override
    protected LongLongPair makeEdge(long x, long y) {
        return LongLongPair.of((long)x, (long)y);
    }

    public boolean containsEdge(LongLongPair e) {
        if (e == null) {
            return false;
        }
        if (e instanceof LongLongSortedPair) {
            return false;
        }
        return this.containsEdgeFast(e.leftLong(), e.rightLong());
    }

    public Set<LongLongPair> edgeSet() {
        NodeIterator nodeIterator = this.immutableGraph.nodeIterator();
        long m = this.iterables().edgeCount();
        ObjectOpenHashBigSet edges = new ObjectOpenHashBigSet(m);
        for (long i = 0L; i < this.n; ++i) {
            long y;
            long x = nodeIterator.nextLong();
            LazyLongIterator successors = nodeIterator.successors();
            while ((y = successors.nextLong()) != -1L) {
                edges.add((Object)LongLongPair.of((long)x, (long)y));
            }
        }
        return edges;
    }

    public int degreeOf(Long vertex) {
        long d = this.inDegreeOf(vertex) + this.outDegreeOf(vertex);
        if (d > Integer.MAX_VALUE) {
            throw new ArithmeticException();
        }
        return (int)d;
    }

    public Set<LongLongPair> edgesOf(Long vertex) {
        long target;
        long target2;
        ObjectLinkedOpenHashSet set = new ObjectLinkedOpenHashSet();
        long source = vertex;
        LazyLongIterator successors = this.immutableGraph.successors(source);
        while ((target2 = successors.nextLong()) != -1L) {
            set.add((Object)LongLongPair.of((long)source, (long)target2));
        }
        LazyLongIterator predecessors = this.immutableTranspose.successors(source);
        while ((target = predecessors.nextLong()) != -1L) {
            if (source == target) continue;
            set.add((Object)LongLongPair.of((long)target, (long)source));
        }
        return set;
    }

    public int inDegreeOf(Long vertex) {
        long d = this.immutableTranspose.outdegree(vertex.longValue());
        if (d > Integer.MAX_VALUE) {
            throw new ArithmeticException();
        }
        return (int)d;
    }

    public Set<LongLongPair> incomingEdgesOf(Long vertex) {
        long target;
        ObjectLinkedOpenHashSet set = new ObjectLinkedOpenHashSet();
        long source = vertex;
        LazyLongIterator predecessors = this.immutableTranspose.successors(source);
        while ((target = predecessors.nextLong()) != -1L) {
            set.add((Object)LongLongPair.of((long)target, (long)source));
        }
        return set;
    }

    public int outDegreeOf(Long vertex) {
        long d = this.immutableGraph.outdegree(vertex.longValue());
        if (d > Integer.MAX_VALUE) {
            throw new ArithmeticException();
        }
        return (int)d;
    }

    public Set<LongLongPair> outgoingEdgesOf(Long vertex) {
        long target;
        ObjectLinkedOpenHashSet set = new ObjectLinkedOpenHashSet();
        long source = vertex;
        LazyLongIterator successors = this.immutableGraph.successors(source);
        while ((target = successors.nextLong()) != -1L) {
            set.add((Object)LongLongPair.of((long)source, (long)target));
        }
        return set;
    }

    public GraphType getType() {
        return new DefaultGraphType.Builder().weighted(false).modifiable(false).allowMultipleEdges(false).allowSelfLoops(true).directed().build();
    }

    public ImmutableDirectedBigGraphAdapter copy() {
        return new ImmutableDirectedBigGraphAdapter(this.immutableGraph.copy(), this.immutableTranspose != null ? this.immutableTranspose.copy() : null);
    }

    public GraphIterables<Long, LongLongPair> iterables() {
        return this.ITERABLES;
    }
}

