/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.sux4j;

import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.ints.IntIntSortedPair;
import it.unimi.dsi.fastutil.longs.LongBigListIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.sux4j.util.EliasFanoIndexedMonotoneLongBigList;
import it.unimi.dsi.sux4j.util.EliasFanoMonotoneLongBigList;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.GraphIterables;
import org.jgrapht.alg.util.Pair;
import org.jgrapht.opt.graph.sparse.SparseIntUndirectedGraph;
import org.jgrapht.sux4j.AbstractSuccinctUndirectedGraph;

public class SuccinctUndirectedGraph
extends AbstractSuccinctUndirectedGraph<IntIntSortedPair>
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final EliasFanoIndexedMonotoneLongBigList cumulativeOutdegrees;
    private final EliasFanoMonotoneLongBigList cumulativeIndegrees;
    private final EliasFanoIndexedMonotoneLongBigList successors;
    private final EliasFanoMonotoneLongBigList predecessors;
    private final SuccinctGraphIterables ITERABLES = new SuccinctGraphIterables(this);

    public <E> SuccinctUndirectedGraph(Graph<Integer, E> graph) {
        super((int)graph.iterables().vertexCount(), (int)graph.iterables().edgeCount());
        if (graph.getType().isDirected()) {
            throw new IllegalArgumentException("This class supports directed graphs only");
        }
        assert (graph.getType().isUndirected());
        GraphIterables iterables = graph.iterables();
        if (iterables.vertexCount() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("The number of nodes (" + iterables.vertexCount() + ") is greater than 2147483647");
        }
        if (iterables.edgeCount() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("The number of edges (" + iterables.edgeCount() + ") is greater than 2147483647");
        }
        this.cumulativeOutdegrees = new EliasFanoIndexedMonotoneLongBigList((long)(this.n + 1), (long)this.m, new AbstractSuccinctUndirectedGraph.CumulativeDegrees<E>(graph, true, arg_0 -> ((GraphIterables)iterables).edgesOf(arg_0)));
        this.cumulativeIndegrees = new EliasFanoMonotoneLongBigList((long)(this.n + 1), (long)this.m, new AbstractSuccinctUndirectedGraph.CumulativeDegrees<E>(graph, false, arg_0 -> ((GraphIterables)iterables).edgesOf(arg_0)));
        assert (this.cumulativeOutdegrees.getLong(this.cumulativeOutdegrees.size64() - 1L) == (long)this.m);
        assert (this.cumulativeIndegrees.getLong(this.cumulativeIndegrees.size64() - 1L) == (long)this.m);
        this.successors = new EliasFanoIndexedMonotoneLongBigList((long)this.m, (long)this.n << this.sourceShift, new AbstractSuccinctUndirectedGraph.CumulativeSuccessors<E>(graph, true, arg_0 -> ((GraphIterables)iterables).outgoingEdgesOf(arg_0)));
        this.predecessors = new EliasFanoIndexedMonotoneLongBigList((long)this.m, (long)this.n * (long)this.n - (long)this.m, new AbstractSuccinctUndirectedGraph.CumulativeSuccessors<E>(graph, false, arg_0 -> ((GraphIterables)iterables).incomingEdgesOf(arg_0)));
    }

    public SuccinctUndirectedGraph(int numVertices, List<Pair<Integer, Integer>> edges) {
        this((Graph)new SparseIntUndirectedGraph(numVertices, edges));
    }

    public boolean containsEdge(IntIntSortedPair e) {
        return this.successors.indexOfUnsafe(((long)e.firstInt() << this.sourceShift) + (long)e.secondInt()) != -1L;
    }

    public Set<IntIntSortedPair> edgeSet() {
        return new ObjectOpenHashSet(this.iterables().edges().iterator());
    }

    public int degreeOf(Integer vertex) {
        return (int)this.cumulativeIndegrees.getDelta((long)vertex.intValue()) + (int)this.cumulativeOutdegrees.getDelta((long)vertex.intValue());
    }

    public Set<IntIntSortedPair> edgesOf(Integer vertex) {
        this.assertVertexExist(vertex);
        int x = vertex;
        long[] result = new long[2];
        this.cumulativeOutdegrees.get((long)x, result);
        ObjectOpenHashSet s = new ObjectOpenHashSet();
        EliasFanoIndexedMonotoneLongBigList.EliasFanoIndexedMonotoneLongBigListIterator iterator = this.successors.listIterator(result[0]);
        long base = (long)x << this.sourceShift;
        int d = (int)(result[1] - result[0]);
        while (d-- != 0) {
            s.add(IntIntSortedPair.of((int)x, (int)((int)(iterator.nextLong() - base))));
        }
        for (IntIntSortedPair e : this.ITERABLES.reverseSortedEdgesOfNoLoops(x)) {
            s.add(e);
        }
        return s;
    }

    public Set<IntIntSortedPair> incomingEdgesOf(Integer vertex) {
        return this.edgesOf(vertex);
    }

    public Set<IntIntSortedPair> outgoingEdgesOf(Integer vertex) {
        return this.edgesOf(vertex);
    }

    public Integer getEdgeSource(IntIntSortedPair e) {
        return e.firstInt();
    }

    public Integer getEdgeTarget(IntIntSortedPair e) {
        return e.secondInt();
    }

    public long getIndexFromEdge(IntIntSortedPair e) {
        int source = e.firstInt();
        int target = e.secondInt();
        if (source < 0 || source >= this.n || target < 0 || target >= this.n) {
            throw new IllegalArgumentException();
        }
        return this.successors.indexOfUnsafe(((long)source << this.sourceShift) + (long)target);
    }

    public IntIntSortedPair getEdgeFromIndex(long i) {
        if (i < 0L || i >= (long)this.m) {
            throw new IllegalArgumentException();
        }
        long t = this.successors.getLong(i);
        return IntIntSortedPair.of((int)((int)(t >>> this.sourceShift)), (int)((int)(t & this.targetMask)));
    }

    public IntIntSortedPair getEdge(Integer sourceVertex, Integer targetVertex) {
        long index;
        int y;
        int x = sourceVertex;
        if (x > (y = targetVertex.intValue())) {
            int t = x;
            x = y;
            y = t;
        }
        return (index = this.successors.indexOfUnsafe(((long)x << this.sourceShift) + (long)y)) != -1L ? IntIntSortedPair.of((int)x, (int)y) : null;
    }

    public boolean containsEdge(Integer sourceVertex, Integer targetVertex) {
        return this.containsEdge(this.successors, sourceVertex, targetVertex);
    }

    public GraphIterables<Integer, IntIntSortedPair> iterables() {
        return this.ITERABLES;
    }

    private static final class SuccinctGraphIterables
    implements GraphIterables<Integer, IntIntSortedPair>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final SuccinctUndirectedGraph graph;

        private SuccinctGraphIterables() {
            this.graph = null;
        }

        private SuccinctGraphIterables(SuccinctUndirectedGraph graph) {
            this.graph = graph;
        }

        public Graph<Integer, IntIntSortedPair> getGraph() {
            return this.graph;
        }

        public long vertexCount() {
            return this.graph.n;
        }

        public long edgeCount() {
            return this.graph.m;
        }

        public Iterable<IntIntSortedPair> edges() {
            final int sourceShift = this.graph.sourceShift;
            final long targetMask = this.graph.targetMask;
            return () -> new Iterator<IntIntSortedPair>(){
                private final EliasFanoIndexedMonotoneLongBigList.EliasFanoIndexedMonotoneLongBigListIterator iterator;
                private final int n;
                {
                    this.iterator = graph.successors.iterator();
                    this.n = graph.n;
                }

                @Override
                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                @Override
                public IntIntSortedPair next() {
                    long t = this.iterator.nextLong();
                    return IntIntSortedPair.of((int)((int)(t >>> sourceShift)), (int)((int)(t & targetMask)));
                }
            };
        }

        public Iterable<IntIntSortedPair> edgesOf(Integer source) {
            return Iterables.concat(this.sortedEdges(source), this.reverseSortedEdgesOfNoLoops(source));
        }

        private Iterable<IntIntSortedPair> sortedEdges(final int source) {
            int sourceShift = this.graph.sourceShift;
            long targetMask = this.graph.targetMask;
            final long[] result = new long[2];
            this.graph.cumulativeOutdegrees.get((long)source, result);
            final EliasFanoIndexedMonotoneLongBigList.EliasFanoIndexedMonotoneLongBigListIterator iterator = this.graph.successors.listIterator(result[0]);
            final long base = (long)source << sourceShift;
            return () -> new Iterator<IntIntSortedPair>(){
                private int d;
                {
                    this.d = (int)(result[1] - result[0]);
                }

                @Override
                public boolean hasNext() {
                    return this.d != 0;
                }

                @Override
                public IntIntSortedPair next() {
                    if (this.d == 0) {
                        throw new NoSuchElementException();
                    }
                    --this.d;
                    return IntIntSortedPair.of((int)source, (int)((int)(iterator.nextLong() - base)));
                }
            };
        }

        private Iterable<IntIntSortedPair> reverseSortedEdgesOfNoLoops(int target) {
            long[] result = new long[2];
            this.graph.cumulativeIndegrees.get((long)target, result);
            int d = (int)(result[1] - result[0]);
            EliasFanoMonotoneLongBigList.EliasFanoMonotoneLongBigListIterator iterator = this.graph.predecessors.listIterator(result[0]);
            return () -> this.lambda$reverseSortedEdgesOfNoLoops$2(d, target, result, (LongBigListIterator)iterator);
        }

        public Iterable<IntIntSortedPair> incomingEdgesOf(Integer vertex) {
            return this.edgesOf(vertex);
        }

        public Iterable<IntIntSortedPair> outgoingEdgesOf(Integer vertex) {
            return this.edgesOf(vertex);
        }

        private /* synthetic */ Iterator lambda$reverseSortedEdgesOfNoLoops$2(final int d, final int target, final long[] result, final LongBigListIterator iterator) {
            return new Iterator<IntIntSortedPair>(){
                int i;
                IntIntSortedPair edge;
                long n;
                long base;
                {
                    this.i = d;
                    this.edge = null;
                    this.n = graph.n;
                    this.base = this.n * (long)target - result[0];
                }

                @Override
                public boolean hasNext() {
                    if (this.edge == null && this.i > 0) {
                        --this.i;
                        long source = iterator.nextLong() - this.base--;
                        if (source == (long)target && this.i-- == 0) {
                            return false;
                        }
                        this.edge = IntIntSortedPair.of((int)((int)source), (int)target);
                    }
                    return this.edge != null;
                }

                @Override
                public IntIntSortedPair next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    IntIntSortedPair result2 = this.edge;
                    this.edge = null;
                    return result2;
                }
            };
        }
    }
}

