/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.sux4j;

import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import it.unimi.dsi.fastutil.longs.LongBigListIterator;
import it.unimi.dsi.sux4j.util.EliasFanoIndexedMonotoneLongBigList;
import it.unimi.dsi.sux4j.util.EliasFanoMonotoneLongBigList;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.GraphIterables;
import org.jgrapht.alg.util.Pair;
import org.jgrapht.opt.graph.sparse.SparseIntUndirectedGraph;
import org.jgrapht.sux4j.AbstractSuccinctUndirectedGraph;

public class SuccinctIntUndirectedGraph
extends AbstractSuccinctUndirectedGraph<Integer>
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final EliasFanoIndexedMonotoneLongBigList cumulativeOutdegrees;
    private final EliasFanoMonotoneLongBigList cumulativeIndegrees;
    private final EliasFanoIndexedMonotoneLongBigList successors;
    private final EliasFanoMonotoneLongBigList predecessors;
    private final SuccinctGraphIterables ITERABLES = new SuccinctGraphIterables(this);

    public <E> SuccinctIntUndirectedGraph(Graph<Integer, E> graph) {
        super((int)graph.iterables().vertexCount(), (int)graph.iterables().edgeCount());
        if (graph.getType().isDirected()) {
            throw new IllegalArgumentException("This class supports directed graphs only");
        }
        assert (graph.getType().isUndirected());
        GraphIterables iterables = graph.iterables();
        if (iterables.vertexCount() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("The number of nodes (" + iterables.vertexCount() + ") is greater than 2147483647");
        }
        if (iterables.edgeCount() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("The number of edges (" + iterables.edgeCount() + ") is greater than 2147483647");
        }
        this.cumulativeOutdegrees = new EliasFanoIndexedMonotoneLongBigList((long)(this.n + 1), (long)this.m, new AbstractSuccinctUndirectedGraph.CumulativeDegrees<E>(graph, true, arg_0 -> ((GraphIterables)iterables).edgesOf(arg_0)));
        this.cumulativeIndegrees = new EliasFanoMonotoneLongBigList((long)(this.n + 1), (long)this.m, new AbstractSuccinctUndirectedGraph.CumulativeDegrees<E>(graph, false, arg_0 -> ((GraphIterables)iterables).edgesOf(arg_0)));
        assert (this.cumulativeOutdegrees.getLong(this.cumulativeOutdegrees.size64() - 1L) == (long)this.m);
        assert (this.cumulativeIndegrees.getLong(this.cumulativeIndegrees.size64() - 1L) == (long)this.m);
        this.successors = new EliasFanoIndexedMonotoneLongBigList((long)this.m, (long)this.n << this.sourceShift, new AbstractSuccinctUndirectedGraph.CumulativeSuccessors<E>(graph, true, arg_0 -> ((GraphIterables)iterables).outgoingEdgesOf(arg_0)));
        this.predecessors = new EliasFanoIndexedMonotoneLongBigList((long)this.m, (long)this.n * (long)this.n - (long)this.m, new AbstractSuccinctUndirectedGraph.CumulativeSuccessors<E>(graph, false, arg_0 -> ((GraphIterables)iterables).incomingEdgesOf(arg_0)));
    }

    public SuccinctIntUndirectedGraph(int numVertices, List<Pair<Integer, Integer>> edges) {
        this((Graph)new SparseIntUndirectedGraph(numVertices, edges));
    }

    public boolean containsEdge(Integer e) {
        return e >= 0 && e < this.m;
    }

    public Set<Integer> edgeSet() {
        return IntSets.fromTo((int)0, (int)this.m);
    }

    public int degreeOf(Integer vertex) {
        return (int)this.cumulativeIndegrees.getDelta((long)vertex.intValue()) + (int)this.cumulativeOutdegrees.getDelta((long)vertex.intValue());
    }

    public IntSet edgesOf(Integer vertex) {
        long[] result = new long[2];
        this.cumulativeOutdegrees.get((long)vertex.intValue(), result);
        IntOpenHashSet s = new IntOpenHashSet((IntCollection)IntSets.fromTo((int)((int)result[0]), (int)((int)result[1])));
        for (int e : this.ITERABLES.reverseSortedEdgesOfNoLoops(vertex)) {
            s.add(e);
        }
        return s;
    }

    public IntSet incomingEdgesOf(Integer vertex) {
        return this.edgesOf(vertex);
    }

    public IntSet outgoingEdgesOf(Integer vertex) {
        return this.edgesOf(vertex);
    }

    public Integer getEdgeSource(Integer e) {
        this.assertEdgeExist(e);
        return (int)(this.successors.getLong((long)e.intValue()) >>> this.sourceShift);
    }

    public Integer getEdgeTarget(Integer e) {
        this.assertEdgeExist(e);
        return (int)(this.successors.getLong((long)e.intValue()) & this.targetMask);
    }

    public Integer getEdge(Integer sourceVertex, Integer targetVertex) {
        long index;
        int y;
        int x = sourceVertex;
        if (x > (y = targetVertex.intValue())) {
            int t = x;
            x = y;
            y = t;
        }
        return (index = this.successors.indexOfUnsafe(((long)x << this.sourceShift) + (long)y)) != -1L ? Integer.valueOf((int)index) : null;
    }

    public boolean containsEdge(Integer sourceVertex, Integer targetVertex) {
        return this.containsEdge(this.successors, sourceVertex, targetVertex);
    }

    protected boolean assertEdgeExist(Integer e) {
        if (e < 0 || e >= this.m) {
            throw new IllegalArgumentException();
        }
        return true;
    }

    public GraphIterables<Integer, Integer> iterables() {
        return this.ITERABLES;
    }

    private static final class SuccinctGraphIterables
    implements GraphIterables<Integer, Integer>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final SuccinctIntUndirectedGraph graph;

        private SuccinctGraphIterables() {
            this.graph = null;
        }

        private SuccinctGraphIterables(SuccinctIntUndirectedGraph graph) {
            this.graph = graph;
        }

        public Graph<Integer, Integer> getGraph() {
            return this.graph;
        }

        public long vertexCount() {
            return this.graph.n;
        }

        public long edgeCount() {
            return this.graph.m;
        }

        public Iterable<Integer> edgesOf(Integer source) {
            long[] result = new long[2];
            this.graph.cumulativeOutdegrees.get((long)source.intValue(), result);
            return Iterables.concat((Iterable)IntSets.fromTo((int)((int)result[0]), (int)((int)result[1])), this.reverseSortedEdgesOfNoLoops(source));
        }

        private Iterable<Integer> reverseSortedEdgesOfNoLoops(int target) {
            long[] result = new long[2];
            this.graph.cumulativeIndegrees.get((long)target, result);
            int d = (int)(result[1] - result[0]);
            int sourceShift = this.graph.sourceShift;
            EliasFanoIndexedMonotoneLongBigList successors = this.graph.successors;
            EliasFanoMonotoneLongBigList.EliasFanoMonotoneLongBigListIterator iterator = this.graph.predecessors.listIterator(result[0]);
            return () -> this.lambda$reverseSortedEdgesOfNoLoops$0(d, target, result, (LongBigListIterator)iterator, sourceShift, successors);
        }

        public Iterable<Integer> incomingEdgesOf(Integer vertex) {
            return this.edgesOf(vertex);
        }

        public Iterable<Integer> outgoingEdgesOf(Integer vertex) {
            return this.edgesOf(vertex);
        }

        private /* synthetic */ Iterator lambda$reverseSortedEdgesOfNoLoops$0(final int d, final int target, final long[] result, final LongBigListIterator iterator, final int sourceShift, final EliasFanoIndexedMonotoneLongBigList successors) {
            return new IntIterator(){
                int i;
                int edge;
                long n;
                long base;
                {
                    this.i = d;
                    this.edge = -1;
                    this.n = graph.n;
                    this.base = this.n * (long)target - result[0];
                }

                public boolean hasNext() {
                    if (this.edge == -1 && this.i > 0) {
                        --this.i;
                        long source = iterator.nextLong() - this.base--;
                        if (source == (long)target && this.i-- == 0) {
                            return false;
                        }
                        long v = (source << sourceShift) + (long)target;
                        assert (v == successors.successor(v)) : v + " != " + successors.successor(v);
                        this.edge = (int)successors.successorIndexUnsafe(v);
                        assert (graph.getEdgeSource(this.edge).longValue() == source);
                        assert (graph.getEdgeTarget(this.edge).longValue() == (long)target);
                    }
                    return this.edge != -1;
                }

                public int nextInt() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    int result2 = this.edge;
                    this.edge = -1;
                    return result2;
                }
            };
        }
    }
}

